'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class QueryErrorTile extends _react2.default.Component {

  componentDidMount() {
    // eslint-disable-next-line no-console
    console.error('Error encountered in subquery', this.props.error);
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-QueryErrorTile' },
      _react2.default.createElement(
        'div',
        { className: 'github-QueryErrorTile-messages' },
        this.renderMessages()
      )
    );
  }

  renderMessages() {
    if (this.props.error.errors) {
      return this.props.error.errors.map((error, index) => {
        return this.renderMessage(error.message, index);
      });
    }

    if (this.props.error.response) {
      return this.renderMessage(this.props.error.responseText, '0');
    }

    return this.renderMessage(this.props.error.toString(), '0');
  }

  renderMessage(body, key) {
    return _react2.default.createElement(
      'p',
      { key: key, className: 'github-QueryErrorTile-message' },
      _react2.default.createElement(_octicon2.default, { icon: 'alert' }),
      body
    );
  }
}
exports.default = QueryErrorTile;
QueryErrorTile.propTypes = {
  error: _propTypes2.default.shape({
    response: _propTypes2.default.shape({
      status: _propTypes2.default.number.isRequired
    }),
    responseText: _propTypes2.default.string,
    errors: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      message: _propTypes2.default.string.isRequired
    }))
  }).isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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