'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareIssueDetailView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _issueTimelineController = require('../controllers/issue-timeline-controller');

var _issueTimelineController2 = _interopRequireDefault(_issueTimelineController);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _issueishBadge = require('../views/issueish-badge');

var _issueishBadge2 = _interopRequireDefault(_issueishBadge);

var _githubDotcomMarkdown = require('../views/github-dotcom-markdown');

var _githubDotcomMarkdown2 = _interopRequireDefault(_githubDotcomMarkdown);

var _emojiReactionsView = require('../views/emoji-reactions-view');

var _emojiReactionsView2 = _interopRequireDefault(_emojiReactionsView);

var _periodicRefresher = require('../periodic-refresher');

var _periodicRefresher2 = _interopRequireDefault(_periodicRefresher);

var _reporterProxy = require('../reporter-proxy');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BareIssueDetailView extends _react2.default.Component {
  constructor(...args) {
    var _temp;

    return _temp = super(...args), this.state = {
      refreshing: false
    }, this.handleRefreshClick = e => {
      e.preventDefault();
      this.refresher.refreshNow(true);
    }, this.recordOpenInBrowserEvent = () => {
      (0, _reporterProxy.addEvent)('open-issue-in-browser', { package: 'github', component: this.constructor.name });
    }, this.refresh = () => {
      if (this.state.refreshing) {
        return;
      }

      this.setState({ refreshing: true });
      this.props.relay.refetch({
        repoId: this.props.repository.id,
        issueishId: this.props.issue.id,
        timelineCount: 100,
        timelineCursor: null
      }, null, () => {
        this.setState({ refreshing: false });
      }, { force: true });
    }, _temp;
  }

  componentDidMount() {
    this.refresher = new _periodicRefresher2.default(BareIssueDetailView, {
      interval: () => 5 * 60 * 1000,
      getCurrentId: () => this.props.issue.id,
      refresh: this.refresh,
      minimumIntervalPerId: 2 * 60 * 1000
    });
    // auto-refresh disabled for now until pagination is handled
    // this.refresher.start();
  }

  componentWillUnmount() {
    this.refresher.destroy();
  }

  renderIssueBody(issue) {
    return _react2.default.createElement(
      'div',
      { className: 'github-IssueishDetailView-issueBody' },
      _react2.default.createElement(_githubDotcomMarkdown2.default, {
        html: issue.bodyHTML || '<em>No description provided.</em>',
        switchToIssueish: this.props.switchToIssueish
      }),
      _react2.default.createElement(_emojiReactionsView2.default, { reactionGroups: issue.reactionGroups }),
      _react2.default.createElement(_issueTimelineController2.default, {
        issue: issue,
        switchToIssueish: this.props.switchToIssueish
      })
    );
  }

  render() {
    const repo = this.props.repository;
    const issue = this.props.issue;
    return _react2.default.createElement(
      'div',
      { className: 'github-IssueishDetailView native-key-bindings' },
      _react2.default.createElement(
        'div',
        { className: 'github-IssueishDetailView-container' },
        _react2.default.createElement(
          'header',
          { className: 'github-IssueishDetailView-header' },
          _react2.default.createElement(
            'div',
            { className: 'github-IssueishDetailView-headerColumn' },
            _react2.default.createElement(
              'a',
              { className: 'github-IssueishDetailView-avatar', href: issue.author.url },
              _react2.default.createElement('img', { className: 'github-IssueishDetailView-avatarImage',
                src: issue.author.avatarUrl,
                title: issue.author.login,
                alt: issue.author.login
              })
            )
          ),
          _react2.default.createElement(
            'div',
            { className: 'github-IssueishDetailView-headerColumn is-flexible' },
            _react2.default.createElement(
              'div',
              { className: 'github-IssueishDetailView-headerRow is-fullwidth' },
              _react2.default.createElement(
                'a',
                { className: 'github-IssueishDetailView-title', href: issue.url },
                issue.title
              )
            ),
            _react2.default.createElement(
              'div',
              { className: 'github-IssueishDetailView-headerRow' },
              _react2.default.createElement(_issueishBadge2.default, { className: 'github-IssueishDetailView-headerBadge',
                type: issue.__typename,
                state: issue.state
              }),
              _react2.default.createElement(_octicon2.default, {
                icon: 'repo-sync',
                className: (0, _classnames2.default)('github-IssueishDetailView-headerRefreshButton', { refreshing: this.state.refreshing }),
                onClick: this.handleRefreshClick
              }),
              _react2.default.createElement(
                'a',
                { className: 'github-IssueishDetailView-headerLink',
                  title: 'open on GitHub.com',
                  href: issue.url, onClick: this.recordOpenInBrowserEvent },
                repo.owner.login,
                '/',
                repo.name,
                '#',
                issue.number
              )
            )
          )
        ),
        this.renderIssueBody(issue),
        _react2.default.createElement(
          'footer',
          { className: 'github-IssueishDetailView-footer' },
          _react2.default.createElement(
            'a',
            { className: 'github-IssueishDetailView-footerLink icon icon-mark-github',
              href: issue.url },
            repo.owner.login,
            '/',
            repo.name,
            '#',
            issue.number
          )
        )
      )
    );
  }

}

exports.BareIssueDetailView = BareIssueDetailView;
BareIssueDetailView.propTypes = {
  relay: _propTypes2.default.shape({
    refetch: _propTypes2.default.func.isRequired
  }),
  switchToIssueish: _propTypes2.default.func.isRequired,
  repository: _propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    name: _propTypes2.default.string.isRequired,
    owner: _propTypes2.default.shape({
      login: _propTypes2.default.string
    })
  }),
  issue: _propTypes2.default.shape({
    __typename: _propTypes2.default.string.isRequired,
    id: _propTypes2.default.string.isRequired,
    title: _propTypes2.default.string,
    url: _propTypes2.default.string.isRequired,
    bodyHTML: _propTypes2.default.string,
    number: _propTypes2.default.number,
    state: _propTypes2.default.oneOf(['OPEN', 'CLOSED']).isRequired,
    author: _propTypes2.default.shape({
      login: _propTypes2.default.string.isRequired,
      avatarUrl: _propTypes2.default.string.isRequired,
      url: _propTypes2.default.string.isRequired
    }).isRequired,
    reactionGroups: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      content: _propTypes2.default.string.isRequired,
      users: _propTypes2.default.shape({
        totalCount: _propTypes2.default.number.isRequired
      }).isRequired
    })).isRequired
  }).isRequired
};
exports.default = (0, _reactRelay.createRefetchContainer)(BareIssueDetailView, {
  repository: function () {
    const node = require('./__generated__/issueDetailView_repository.graphql');

    if (node.hash && node.hash !== '295a60f53b25b6fdb07a1539cda447f2') {
      console.error('The definition of \'issueDetailView_repository\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/issueDetailView_repository.graphql');
  },

  issue: function () {
    const node = require('./__generated__/issueDetailView_issue.graphql');

    if (node.hash && node.hash !== 'e1cf4b71a99cbade6149738c70451892') {
      console.error('The definition of \'issueDetailView_issue\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/issueDetailView_issue.graphql');
  }
}, function () {
  const node = require('./__generated__/issueDetailViewRefetchQuery.graphql');

  if (node.hash && node.hash !== '82666b2748036545eb131b3e34f48e72') {
    console.error('The definition of \'issueDetailViewRefetchQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
  }

  return require('./__generated__/issueDetailViewRefetchQuery.graphql');
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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