'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _tooltip = require('../atom/tooltip');

var _tooltip2 = _interopRequireDefault(_tooltip);

var _keystroke = require('../atom/keystroke');

var _keystroke2 = _interopRequireDefault(_keystroke);

var _commitDetailItem = require('../items/commit-detail-item');

var _commitDetailItem2 = _interopRequireDefault(_commitDetailItem);

var _issueishDetailItem = require('../items/issueish-detail-item');

var _issueishDetailItem2 = _interopRequireDefault(_issueishDetailItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function theBuckStopsHere(event) {
  event.stopPropagation();
}

class HunkHeaderView extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'didMouseDown', 'renderButtons');

    this.refDiscardButton = new _refHolder2.default();
  }

  render() {
    const conditional = {
      'github-HunkHeaderView--isSelected': this.props.isSelected,
      'github-HunkHeaderView--isHunkMode': this.props.selectionMode === 'hunk'
    };

    return _react2.default.createElement(
      'div',
      { className: (0, _classnames2.default)('github-HunkHeaderView', conditional), onMouseDown: this.didMouseDown },
      _react2.default.createElement(
        'span',
        { className: 'github-HunkHeaderView-title' },
        this.props.hunk.getHeader().trim(),
        ' ',
        this.props.hunk.getSectionHeading().trim()
      ),
      this.renderButtons()
    );
  }

  renderButtons() {
    if (this.props.itemType === _commitDetailItem2.default || this.props.itemType === _issueishDetailItem2.default) {
      return null;
    } else {
      return _react2.default.createElement(
        _react.Fragment,
        null,
        _react2.default.createElement(
          'button',
          {
            className: 'github-HunkHeaderView-stageButton',
            onClick: this.props.toggleSelection,
            onMouseDown: theBuckStopsHere },
          _react2.default.createElement(_keystroke2.default, { keymaps: this.props.keymaps, command: 'core:confirm', refTarget: this.props.refTarget }),
          this.props.toggleSelectionLabel
        ),
        this.props.stagingStatus === 'unstaged' && _react2.default.createElement(
          _react.Fragment,
          null,
          _react2.default.createElement('button', {
            ref: this.refDiscardButton.setter,
            className: 'icon-trashcan github-HunkHeaderView-discardButton',
            onClick: this.props.discardSelection,
            onMouseDown: theBuckStopsHere
          }),
          _react2.default.createElement(_tooltip2.default, {
            manager: this.props.tooltips,
            target: this.refDiscardButton,
            title: this.props.discardSelectionLabel
          })
        )
      );
    }
  }

  didMouseDown(event) {
    return this.props.mouseDown(event, this.props.hunk);
  }
}
exports.default = HunkHeaderView;
HunkHeaderView.propTypes = {
  refTarget: _propTypes3.RefHolderPropType.isRequired,
  hunk: _propTypes2.default.object.isRequired,
  isSelected: _propTypes2.default.bool.isRequired,
  stagingStatus: _propTypes2.default.oneOf(['unstaged', 'staged']),
  selectionMode: _propTypes2.default.oneOf(['hunk', 'line']).isRequired,
  toggleSelectionLabel: _propTypes2.default.string,
  discardSelectionLabel: _propTypes2.default.string,

  tooltips: _propTypes2.default.object.isRequired,
  keymaps: _propTypes2.default.object.isRequired,

  toggleSelection: _propTypes2.default.func,
  discardSelection: _propTypes2.default.func,
  mouseDown: _propTypes2.default.func.isRequired,
  itemType: _propTypes3.ItemTypePropType.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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