'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareGithubDotcomMarkdown = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _eventKit = require('event-kit');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _issueishLink = require('./issueish-link');

var _userMentionTooltipItem = require('../items/user-mention-tooltip-item');

var _userMentionTooltipItem2 = _interopRequireDefault(_userMentionTooltipItem);

var _issueishTooltipItem = require('../items/issueish-tooltip-item');

var _issueishTooltipItem2 = _interopRequireDefault(_issueishTooltipItem);

var _relayEnvironment = require('./relay-environment');

var _relayEnvironment2 = _interopRequireDefault(_relayEnvironment);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BareGithubDotcomMarkdown extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'handleClick', 'openLinkInNewTab', 'openLinkInThisTab', 'openLinkInBrowser');
  }

  componentDidMount() {
    this.commandSubscriptions = atom.commands.add(_reactDom2.default.findDOMNode(this), {
      'github:open-link-in-new-tab': this.openLinkInNewTab,
      'github:open-link-in-browser': this.openLinkInBrowser,
      'github:open-link-in-this-tab': this.openLinkInThisTab
    });
    this.setupComponentHandlers();
    this.setupTooltipHandlers();
  }

  componentDidUpdate() {
    this.setupTooltipHandlers();
  }

  setupComponentHandlers() {
    this.component.addEventListener('click', this.handleClick);
    this.componentHandlers = new _eventKit.Disposable(() => {
      this.component.removeEventListener('click', this.handleClick);
    });
  }

  setupTooltipHandlers() {
    if (this.tooltipSubscriptions) {
      this.tooltipSubscriptions.dispose();
    }

    this.tooltipSubscriptions = new _eventKit.CompositeDisposable();
    this.component.querySelectorAll('.user-mention').forEach(node => {
      const item = new _userMentionTooltipItem2.default(node.textContent, this.props.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        class: 'github-Popover',
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
    this.component.querySelectorAll('.issue-link').forEach(node => {
      const item = new _issueishTooltipItem2.default(node.getAttribute('href'), this.props.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        class: 'github-Popover',
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
  }

  componentWillUnmount() {
    this.commandSubscriptions.dispose();
    this.componentHandlers.dispose();
    this.tooltipSubscriptions && this.tooltipSubscriptions.dispose();
  }

  render() {
    return _react2.default.createElement('div', {
      className: 'github-DotComMarkdownHtml',
      ref: c => {
        this.component = c;
      },
      dangerouslySetInnerHTML: { __html: this.props.html }
    });
  }

  handleClick(event) {
    if (event.target.dataset.url) {
      return this.props.handleClickEvent(event, event.target.dataset.url);
    } else {
      return null;
    }
  }

  openLinkInNewTab(event) {
    return this.props.openIssueishLinkInNewTab(event.target.dataset.url);
  }

  openLinkInThisTab(event) {
    const { repoOwner, repoName, issueishNumber } = (0, _issueishLink.getDataFromGithubUrl)(event.target.dataset.url);
    this.props.switchToIssueish(repoOwner, repoName, issueishNumber);
  }

  openLinkInBrowser(event) {
    return this.props.openLinkInBrowser(event.target.getAttribute('href'));
  }
}

exports.BareGithubDotcomMarkdown = BareGithubDotcomMarkdown;
BareGithubDotcomMarkdown.propTypes = {
  relayEnvironment: _propTypes2.default.object.isRequired,
  html: _propTypes2.default.string.isRequired,
  switchToIssueish: _propTypes2.default.func.isRequired,
  handleClickEvent: _propTypes2.default.func,
  openIssueishLinkInNewTab: _propTypes2.default.func,
  openLinkInBrowser: _propTypes2.default.func
};
BareGithubDotcomMarkdown.defaultProps = {
  handleClickEvent: _issueishLink.handleClickEvent,
  openIssueishLinkInNewTab: _issueishLink.openIssueishLinkInNewTab,
  openLinkInBrowser: _issueishLink.openLinkInBrowser
};
class GithubDotcomMarkdown extends _react2.default.Component {
  render() {
    return _react2.default.createElement(
      _relayEnvironment2.default.Consumer,
      null,
      relayEnvironment => _react2.default.createElement(BareGithubDotcomMarkdown, _extends({ relayEnvironment: relayEnvironment }, this.props))
    );
  }
}
exports.default = GithubDotcomMarkdown;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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