'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _issueishDetailItem = require('../items/issueish-detail-item');

var _issueishDetailItem2 = _interopRequireDefault(_issueishDetailItem);

var _changedFileItem = require('../items/changed-file-item');

var _changedFileItem2 = _interopRequireDefault(_changedFileItem);

var _commitDetailItem = require('../items/commit-detail-item');

var _commitDetailItem2 = _interopRequireDefault(_commitDetailItem);

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class FilePatchHeaderView extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.refMirrorButton = new _refHolder2.default();
    this.refOpenFileButton = new _refHolder2.default();
  }

  render() {
    return _react2.default.createElement(
      'header',
      { className: 'github-FilePatchView-header' },
      _react2.default.createElement(
        'span',
        { className: 'github-FilePatchView-title' },
        this.renderTitle()
      ),
      this.renderButtonGroup()
    );
  }

  renderTitle() {
    if (this.props.itemType === _changedFileItem2.default) {
      const status = this.props.stagingStatus;
      return _react2.default.createElement(
        'span',
        null,
        status[0].toUpperCase(),
        status.slice(1),
        ' Changes for ',
        this.renderDisplayPath()
      );
    } else {
      return this.renderDisplayPath();
    }
  }

  renderDisplayPath() {
    if (this.props.newPath && this.props.newPath !== this.props.relPath) {
      const oldPath = this.renderPath(this.props.relPath);
      const newPath = this.renderPath(this.props.newPath);
      return _react2.default.createElement(
        'span',
        null,
        oldPath,
        ' ',
        _react2.default.createElement(
          'span',
          null,
          '\u2192'
        ),
        ' ',
        newPath
      );
    } else {
      return this.renderPath(this.props.relPath);
    }
  }

  renderPath(filePath) {
    const dirname = _path2.default.dirname(filePath);
    const basename = _path2.default.basename(filePath);

    if (dirname === '.') {
      return _react2.default.createElement(
        'span',
        { className: 'gitub-FilePatchHeaderView-basename' },
        basename
      );
    } else {
      return _react2.default.createElement(
        'span',
        null,
        dirname,
        _path2.default.sep,
        _react2.default.createElement(
          'span',
          { className: 'gitub-FilePatchHeaderView-basename' },
          basename
        )
      );
    }
  }

  renderButtonGroup() {
    if (this.props.itemType === _commitDetailItem2.default || this.props.itemType === _issueishDetailItem2.default) {
      return null;
    } else {
      return _react2.default.createElement(
        'span',
        { className: 'btn-group' },
        this.renderUndoDiscardButton(),
        this.renderMirrorPatchButton(),
        this.renderOpenFileButton(),
        this.renderToggleFileButton()
      );
    }
  }

  renderUndoDiscardButton() {
    const unstagedChangedFileItem = this.props.itemType === _changedFileItem2.default && this.props.stagingStatus === 'unstaged';
    if (unstagedChangedFileItem && this.props.hasUndoHistory) {
      return _react2.default.createElement(
        'button',
        { className: 'btn icon icon-history', onClick: this.props.undoLastDiscard },
        'Undo Discard'
      );
    } else {
      return null;
    }
  }

  renderMirrorPatchButton() {
    if (!this.props.isPartiallyStaged && this.props.hasHunks) {
      return null;
    }

    const attrs = this.props.stagingStatus === 'unstaged' ? {
      iconClass: 'icon-tasklist',
      buttonText: 'View Staged'
    } : {
      iconClass: 'icon-list-unordered',
      buttonText: 'View Unstaged'
    };

    return _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement(
        'button',
        {
          ref: this.refMirrorButton.setter,
          className: (0, _classnames2.default)('btn', 'icon', attrs.iconClass),
          onClick: this.props.diveIntoMirrorPatch },
        attrs.buttonText
      )
    );
  }

  renderOpenFileButton() {
    let buttonText = 'Jump To File';
    if (this.props.hasMultipleFileSelections) {
      buttonText += 's';
    }

    return _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement(
        'button',
        {
          ref: this.refOpenFileButton.setter,
          className: 'btn icon icon-code github-FilePatchHeaderView-jumpToFileButton',
          onClick: this.props.openFile },
        buttonText
      )
    );
  }

  renderToggleFileButton() {
    const attrs = this.props.stagingStatus === 'unstaged' ? {
      buttonClass: 'icon-move-down',
      buttonText: 'Stage File'
    } : {
      buttonClass: 'icon-move-up',
      buttonText: 'Unstage File'
    };

    return _react2.default.createElement(
      'button',
      { className: (0, _classnames2.default)('btn', 'icon', attrs.buttonClass), onClick: this.props.toggleFile },
      attrs.buttonText
    );
  }
}
exports.default = FilePatchHeaderView;
FilePatchHeaderView.propTypes = {
  relPath: _propTypes2.default.string.isRequired,
  newPath: _propTypes2.default.string,
  stagingStatus: _propTypes2.default.oneOf(['staged', 'unstaged']),
  isPartiallyStaged: _propTypes2.default.bool,
  hasHunks: _propTypes2.default.bool.isRequired,
  hasUndoHistory: _propTypes2.default.bool,
  hasMultipleFileSelections: _propTypes2.default.bool.isRequired,

  tooltips: _propTypes2.default.object.isRequired,

  undoLastDiscard: _propTypes2.default.func.isRequired,
  diveIntoMirrorPatch: _propTypes2.default.func.isRequired,
  openFile: _propTypes2.default.func.isRequired,
  toggleFile: _propTypes2.default.func.isRequired,

  itemType: _propTypes3.ItemTypePropType.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGUtcGF0Y2gtaGVhZGVyLXZpZXcuanMiXSwibmFtZXMiOlsiRmlsZVBhdGNoSGVhZGVyVmlldyIsIlJlYWN0IiwiQ29tcG9uZW50IiwiY29uc3RydWN0b3IiLCJwcm9wcyIsInJlZk1pcnJvckJ1dHRvbiIsIlJlZkhvbGRlciIsInJlZk9wZW5GaWxlQnV0dG9uIiwicmVuZGVyIiwicmVuZGVyVGl0bGUiLCJyZW5kZXJCdXR0b25Hcm91cCIsIml0ZW1UeXBlIiwiQ2hhbmdlZEZpbGVJdGVtIiwic3RhdHVzIiwic3RhZ2luZ1N0YXR1cyIsInRvVXBwZXJDYXNlIiwic2xpY2UiLCJyZW5kZXJEaXNwbGF5UGF0aCIsIm5ld1BhdGgiLCJyZWxQYXRoIiwib2xkUGF0aCIsInJlbmRlclBhdGgiLCJmaWxlUGF0aCIsImRpcm5hbWUiLCJwYXRoIiwiYmFzZW5hbWUiLCJzZXAiLCJDb21taXREZXRhaWxJdGVtIiwiSXNzdWVpc2hEZXRhaWxJdGVtIiwicmVuZGVyVW5kb0Rpc2NhcmRCdXR0b24iLCJyZW5kZXJNaXJyb3JQYXRjaEJ1dHRvbiIsInJlbmRlck9wZW5GaWxlQnV0dG9uIiwicmVuZGVyVG9nZ2xlRmlsZUJ1dHRvbiIsInVuc3RhZ2VkQ2hhbmdlZEZpbGVJdGVtIiwiaGFzVW5kb0hpc3RvcnkiLCJ1bmRvTGFzdERpc2NhcmQiLCJpc1BhcnRpYWxseVN0YWdlZCIsImhhc0h1bmtzIiwiYXR0cnMiLCJpY29uQ2xhc3MiLCJidXR0b25UZXh0Iiwic2V0dGVyIiwiZGl2ZUludG9NaXJyb3JQYXRjaCIsImhhc011bHRpcGxlRmlsZVNlbGVjdGlvbnMiLCJvcGVuRmlsZSIsImJ1dHRvbkNsYXNzIiwidG9nZ2xlRmlsZSIsInByb3BUeXBlcyIsIlByb3BUeXBlcyIsInN0cmluZyIsImlzUmVxdWlyZWQiLCJvbmVPZiIsImJvb2wiLCJ0b29sdGlwcyIsIm9iamVjdCIsImZ1bmMiLCJJdGVtVHlwZVByb3BUeXBlIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQTs7OztBQUVBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUVBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOzs7O0FBQ0E7Ozs7QUFFZSxNQUFNQSxtQkFBTixTQUFrQ0MsZ0JBQU1DLFNBQXhDLENBQWtEOztBQW9CL0RDLGNBQVlDLEtBQVosRUFBbUI7QUFDakIsVUFBTUEsS0FBTjs7QUFFQSxTQUFLQyxlQUFMLEdBQXVCLElBQUlDLG1CQUFKLEVBQXZCO0FBQ0EsU0FBS0MsaUJBQUwsR0FBeUIsSUFBSUQsbUJBQUosRUFBekI7QUFDRDs7QUFFREUsV0FBUztBQUNQLFdBQ0U7QUFBQTtBQUFBLFFBQVEsV0FBVSw2QkFBbEI7QUFDRTtBQUFBO0FBQUEsVUFBTSxXQUFVLDRCQUFoQjtBQUNHLGFBQUtDLFdBQUw7QUFESCxPQURGO0FBSUcsV0FBS0MsaUJBQUw7QUFKSCxLQURGO0FBUUQ7O0FBRURELGdCQUFjO0FBQ1osUUFBSSxLQUFLTCxLQUFMLENBQVdPLFFBQVgsS0FBd0JDLHlCQUE1QixFQUE2QztBQUMzQyxZQUFNQyxTQUFTLEtBQUtULEtBQUwsQ0FBV1UsYUFBMUI7QUFDQSxhQUNFO0FBQUE7QUFBQTtBQUFPRCxlQUFPLENBQVAsRUFBVUUsV0FBVixFQUFQO0FBQWdDRixlQUFPRyxLQUFQLENBQWEsQ0FBYixDQUFoQztBQUFBO0FBQThELGFBQUtDLGlCQUFMO0FBQTlELE9BREY7QUFHRCxLQUxELE1BS087QUFDTCxhQUFPLEtBQUtBLGlCQUFMLEVBQVA7QUFDRDtBQUNGOztBQUVEQSxzQkFBb0I7QUFDbEIsUUFBSSxLQUFLYixLQUFMLENBQVdjLE9BQVgsSUFBc0IsS0FBS2QsS0FBTCxDQUFXYyxPQUFYLEtBQXVCLEtBQUtkLEtBQUwsQ0FBV2UsT0FBNUQsRUFBcUU7QUFDbkUsWUFBTUMsVUFBVSxLQUFLQyxVQUFMLENBQWdCLEtBQUtqQixLQUFMLENBQVdlLE9BQTNCLENBQWhCO0FBQ0EsWUFBTUQsVUFBVSxLQUFLRyxVQUFMLENBQWdCLEtBQUtqQixLQUFMLENBQVdjLE9BQTNCLENBQWhCO0FBQ0EsYUFBTztBQUFBO0FBQUE7QUFBT0UsZUFBUDtBQUFBO0FBQWdCO0FBQUE7QUFBQTtBQUFBO0FBQUEsU0FBaEI7QUFBQTtBQUFnQ0Y7QUFBaEMsT0FBUDtBQUNELEtBSkQsTUFJTztBQUNMLGFBQU8sS0FBS0csVUFBTCxDQUFnQixLQUFLakIsS0FBTCxDQUFXZSxPQUEzQixDQUFQO0FBQ0Q7QUFDRjs7QUFFREUsYUFBV0MsUUFBWCxFQUFxQjtBQUNuQixVQUFNQyxVQUFVQyxlQUFLRCxPQUFMLENBQWFELFFBQWIsQ0FBaEI7QUFDQSxVQUFNRyxXQUFXRCxlQUFLQyxRQUFMLENBQWNILFFBQWQsQ0FBakI7O0FBRUEsUUFBSUMsWUFBWSxHQUFoQixFQUFxQjtBQUNuQixhQUFPO0FBQUE7QUFBQSxVQUFNLFdBQVUsb0NBQWhCO0FBQXNERTtBQUF0RCxPQUFQO0FBQ0QsS0FGRCxNQUVPO0FBQ0wsYUFDRTtBQUFBO0FBQUE7QUFDR0YsZUFESDtBQUNZQyx1QkFBS0UsR0FEakI7QUFDcUI7QUFBQTtBQUFBLFlBQU0sV0FBVSxvQ0FBaEI7QUFBc0REO0FBQXREO0FBRHJCLE9BREY7QUFLRDtBQUNGOztBQUVEZixzQkFBb0I7QUFDbEIsUUFBSSxLQUFLTixLQUFMLENBQVdPLFFBQVgsS0FBd0JnQiwwQkFBeEIsSUFBNEMsS0FBS3ZCLEtBQUwsQ0FBV08sUUFBWCxLQUF3QmlCLDRCQUF4RSxFQUE0RjtBQUMxRixhQUFPLElBQVA7QUFDRCxLQUZELE1BRU87QUFDTCxhQUNFO0FBQUE7QUFBQSxVQUFNLFdBQVUsV0FBaEI7QUFDRyxhQUFLQyx1QkFBTCxFQURIO0FBRUcsYUFBS0MsdUJBQUwsRUFGSDtBQUdHLGFBQUtDLG9CQUFMLEVBSEg7QUFJRyxhQUFLQyxzQkFBTDtBQUpILE9BREY7QUFRRDtBQUNGOztBQUVESCw0QkFBMEI7QUFDeEIsVUFBTUksMEJBQTBCLEtBQUs3QixLQUFMLENBQVdPLFFBQVgsS0FBd0JDLHlCQUF4QixJQUEyQyxLQUFLUixLQUFMLENBQVdVLGFBQVgsS0FBNkIsVUFBeEc7QUFDQSxRQUFJbUIsMkJBQTJCLEtBQUs3QixLQUFMLENBQVc4QixjQUExQyxFQUEwRDtBQUN4RCxhQUNFO0FBQUE7QUFBQSxVQUFRLFdBQVUsdUJBQWxCLEVBQTBDLFNBQVMsS0FBSzlCLEtBQUwsQ0FBVytCLGVBQTlEO0FBQUE7QUFBQSxPQURGO0FBS0QsS0FORCxNQU1PO0FBQ0wsYUFBTyxJQUFQO0FBQ0Q7QUFDRjs7QUFFREwsNEJBQTBCO0FBQ3hCLFFBQUksQ0FBQyxLQUFLMUIsS0FBTCxDQUFXZ0MsaUJBQVosSUFBaUMsS0FBS2hDLEtBQUwsQ0FBV2lDLFFBQWhELEVBQTBEO0FBQ3hELGFBQU8sSUFBUDtBQUNEOztBQUVELFVBQU1DLFFBQVEsS0FBS2xDLEtBQUwsQ0FBV1UsYUFBWCxLQUE2QixVQUE3QixHQUNWO0FBQ0F5QixpQkFBVyxlQURYO0FBRUFDLGtCQUFZO0FBRlosS0FEVSxHQUtWO0FBQ0FELGlCQUFXLHFCQURYO0FBRUFDLGtCQUFZO0FBRlosS0FMSjs7QUFVQSxXQUNFO0FBQUMscUJBQUQ7QUFBQTtBQUNFO0FBQUE7QUFBQTtBQUNFLGVBQUssS0FBS25DLGVBQUwsQ0FBcUJvQyxNQUQ1QjtBQUVFLHFCQUFXLDBCQUFHLEtBQUgsRUFBVSxNQUFWLEVBQWtCSCxNQUFNQyxTQUF4QixDQUZiO0FBR0UsbUJBQVMsS0FBS25DLEtBQUwsQ0FBV3NDLG1CQUh0QjtBQUlHSixjQUFNRTtBQUpUO0FBREYsS0FERjtBQVVEOztBQUVEVCx5QkFBdUI7QUFDckIsUUFBSVMsYUFBYSxjQUFqQjtBQUNBLFFBQUksS0FBS3BDLEtBQUwsQ0FBV3VDLHlCQUFmLEVBQTBDO0FBQ3hDSCxvQkFBYyxHQUFkO0FBQ0Q7O0FBRUQsV0FDRTtBQUFDLHFCQUFEO0FBQUE7QUFDRTtBQUFBO0FBQUE7QUFDRSxlQUFLLEtBQUtqQyxpQkFBTCxDQUF1QmtDLE1BRDlCO0FBRUUscUJBQVUsZ0VBRlo7QUFHRSxtQkFBUyxLQUFLckMsS0FBTCxDQUFXd0MsUUFIdEI7QUFJR0o7QUFKSDtBQURGLEtBREY7QUFVRDs7QUFFRFIsMkJBQXlCO0FBQ3ZCLFVBQU1NLFFBQVEsS0FBS2xDLEtBQUwsQ0FBV1UsYUFBWCxLQUE2QixVQUE3QixHQUNWO0FBQ0ErQixtQkFBYSxnQkFEYjtBQUVBTCxrQkFBWTtBQUZaLEtBRFUsR0FLVjtBQUNBSyxtQkFBYSxjQURiO0FBRUFMLGtCQUFZO0FBRlosS0FMSjs7QUFVQSxXQUNFO0FBQUE7QUFBQSxRQUFRLFdBQVcsMEJBQUcsS0FBSCxFQUFVLE1BQVYsRUFBa0JGLE1BQU1PLFdBQXhCLENBQW5CLEVBQXlELFNBQVMsS0FBS3pDLEtBQUwsQ0FBVzBDLFVBQTdFO0FBQ0dSLFlBQU1FO0FBRFQsS0FERjtBQUtEO0FBbks4RDtrQkFBNUN4QyxtQjtBQUFBQSxtQixDQUNaK0MsUyxHQUFZO0FBQ2pCNUIsV0FBUzZCLG9CQUFVQyxNQUFWLENBQWlCQyxVQURUO0FBRWpCaEMsV0FBUzhCLG9CQUFVQyxNQUZGO0FBR2pCbkMsaUJBQWVrQyxvQkFBVUcsS0FBVixDQUFnQixDQUFDLFFBQUQsRUFBVyxVQUFYLENBQWhCLENBSEU7QUFJakJmLHFCQUFtQlksb0JBQVVJLElBSlo7QUFLakJmLFlBQVVXLG9CQUFVSSxJQUFWLENBQWVGLFVBTFI7QUFNakJoQixrQkFBZ0JjLG9CQUFVSSxJQU5UO0FBT2pCVCw2QkFBMkJLLG9CQUFVSSxJQUFWLENBQWVGLFVBUHpCOztBQVNqQkcsWUFBVUwsb0JBQVVNLE1BQVYsQ0FBaUJKLFVBVFY7O0FBV2pCZixtQkFBaUJhLG9CQUFVTyxJQUFWLENBQWVMLFVBWGY7QUFZakJSLHVCQUFxQk0sb0JBQVVPLElBQVYsQ0FBZUwsVUFabkI7QUFhakJOLFlBQVVJLG9CQUFVTyxJQUFWLENBQWVMLFVBYlI7QUFjakJKLGNBQVlFLG9CQUFVTyxJQUFWLENBQWVMLFVBZFY7O0FBZ0JqQnZDLFlBQVU2Qyw2QkFBaUJOO0FBaEJWLEMiLCJmaWxlIjoiZmlsZS1wYXRjaC1oZWFkZXItdmlldy5qcyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM1LjEvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViL2xpYi92aWV3cyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBwYXRoIGZyb20gJ3BhdGgnO1xuXG5pbXBvcnQgUmVhY3QsIHtGcmFnbWVudH0gZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCBjeCBmcm9tICdjbGFzc25hbWVzJztcblxuaW1wb3J0IFJlZkhvbGRlciBmcm9tICcuLi9tb2RlbHMvcmVmLWhvbGRlcic7XG5pbXBvcnQgSXNzdWVpc2hEZXRhaWxJdGVtIGZyb20gJy4uL2l0ZW1zL2lzc3VlaXNoLWRldGFpbC1pdGVtJztcbmltcG9ydCBDaGFuZ2VkRmlsZUl0ZW0gZnJvbSAnLi4vaXRlbXMvY2hhbmdlZC1maWxlLWl0ZW0nO1xuaW1wb3J0IENvbW1pdERldGFpbEl0ZW0gZnJvbSAnLi4vaXRlbXMvY29tbWl0LWRldGFpbC1pdGVtJztcbmltcG9ydCB7SXRlbVR5cGVQcm9wVHlwZX0gZnJvbSAnLi4vcHJvcC10eXBlcyc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEZpbGVQYXRjaEhlYWRlclZpZXcgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIHJlbFBhdGg6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICBuZXdQYXRoOiBQcm9wVHlwZXMuc3RyaW5nLFxuICAgIHN0YWdpbmdTdGF0dXM6IFByb3BUeXBlcy5vbmVPZihbJ3N0YWdlZCcsICd1bnN0YWdlZCddKSxcbiAgICBpc1BhcnRpYWxseVN0YWdlZDogUHJvcFR5cGVzLmJvb2wsXG4gICAgaGFzSHVua3M6IFByb3BUeXBlcy5ib29sLmlzUmVxdWlyZWQsXG4gICAgaGFzVW5kb0hpc3Rvcnk6IFByb3BUeXBlcy5ib29sLFxuICAgIGhhc011bHRpcGxlRmlsZVNlbGVjdGlvbnM6IFByb3BUeXBlcy5ib29sLmlzUmVxdWlyZWQsXG5cbiAgICB0b29sdGlwczogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuXG4gICAgdW5kb0xhc3REaXNjYXJkOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIGRpdmVJbnRvTWlycm9yUGF0Y2g6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgb3BlbkZpbGU6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgdG9nZ2xlRmlsZTogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcblxuICAgIGl0ZW1UeXBlOiBJdGVtVHlwZVByb3BUeXBlLmlzUmVxdWlyZWQsXG4gIH07XG5cbiAgY29uc3RydWN0b3IocHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG5cbiAgICB0aGlzLnJlZk1pcnJvckJ1dHRvbiA9IG5ldyBSZWZIb2xkZXIoKTtcbiAgICB0aGlzLnJlZk9wZW5GaWxlQnV0dG9uID0gbmV3IFJlZkhvbGRlcigpO1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8aGVhZGVyIGNsYXNzTmFtZT1cImdpdGh1Yi1GaWxlUGF0Y2hWaWV3LWhlYWRlclwiPlxuICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJnaXRodWItRmlsZVBhdGNoVmlldy10aXRsZVwiPlxuICAgICAgICAgIHt0aGlzLnJlbmRlclRpdGxlKCl9XG4gICAgICAgIDwvc3Bhbj5cbiAgICAgICAge3RoaXMucmVuZGVyQnV0dG9uR3JvdXAoKX1cbiAgICAgIDwvaGVhZGVyPlxuICAgICk7XG4gIH1cblxuICByZW5kZXJUaXRsZSgpIHtcbiAgICBpZiAodGhpcy5wcm9wcy5pdGVtVHlwZSA9PT0gQ2hhbmdlZEZpbGVJdGVtKSB7XG4gICAgICBjb25zdCBzdGF0dXMgPSB0aGlzLnByb3BzLnN0YWdpbmdTdGF0dXM7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8c3Bhbj57c3RhdHVzWzBdLnRvVXBwZXJDYXNlKCl9e3N0YXR1cy5zbGljZSgxKX0gQ2hhbmdlcyBmb3Ige3RoaXMucmVuZGVyRGlzcGxheVBhdGgoKX08L3NwYW4+XG4gICAgICApO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gdGhpcy5yZW5kZXJEaXNwbGF5UGF0aCgpO1xuICAgIH1cbiAgfVxuXG4gIHJlbmRlckRpc3BsYXlQYXRoKCkge1xuICAgIGlmICh0aGlzLnByb3BzLm5ld1BhdGggJiYgdGhpcy5wcm9wcy5uZXdQYXRoICE9PSB0aGlzLnByb3BzLnJlbFBhdGgpIHtcbiAgICAgIGNvbnN0IG9sZFBhdGggPSB0aGlzLnJlbmRlclBhdGgodGhpcy5wcm9wcy5yZWxQYXRoKTtcbiAgICAgIGNvbnN0IG5ld1BhdGggPSB0aGlzLnJlbmRlclBhdGgodGhpcy5wcm9wcy5uZXdQYXRoKTtcbiAgICAgIHJldHVybiA8c3Bhbj57b2xkUGF0aH0gPHNwYW4+4oaSPC9zcGFuPiB7bmV3UGF0aH08L3NwYW4+O1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gdGhpcy5yZW5kZXJQYXRoKHRoaXMucHJvcHMucmVsUGF0aCk7XG4gICAgfVxuICB9XG5cbiAgcmVuZGVyUGF0aChmaWxlUGF0aCkge1xuICAgIGNvbnN0IGRpcm5hbWUgPSBwYXRoLmRpcm5hbWUoZmlsZVBhdGgpO1xuICAgIGNvbnN0IGJhc2VuYW1lID0gcGF0aC5iYXNlbmFtZShmaWxlUGF0aCk7XG5cbiAgICBpZiAoZGlybmFtZSA9PT0gJy4nKSB7XG4gICAgICByZXR1cm4gPHNwYW4gY2xhc3NOYW1lPVwiZ2l0dWItRmlsZVBhdGNoSGVhZGVyVmlldy1iYXNlbmFtZVwiPntiYXNlbmFtZX08L3NwYW4+O1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8c3Bhbj5cbiAgICAgICAgICB7ZGlybmFtZX17cGF0aC5zZXB9PHNwYW4gY2xhc3NOYW1lPVwiZ2l0dWItRmlsZVBhdGNoSGVhZGVyVmlldy1iYXNlbmFtZVwiPntiYXNlbmFtZX08L3NwYW4+XG4gICAgICAgIDwvc3Bhbj5cbiAgICAgICk7XG4gICAgfVxuICB9XG5cbiAgcmVuZGVyQnV0dG9uR3JvdXAoKSB7XG4gICAgaWYgKHRoaXMucHJvcHMuaXRlbVR5cGUgPT09IENvbW1pdERldGFpbEl0ZW0gfHwgdGhpcy5wcm9wcy5pdGVtVHlwZSA9PT0gSXNzdWVpc2hEZXRhaWxJdGVtKSB7XG4gICAgICByZXR1cm4gbnVsbDtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPHNwYW4gY2xhc3NOYW1lPVwiYnRuLWdyb3VwXCI+XG4gICAgICAgICAge3RoaXMucmVuZGVyVW5kb0Rpc2NhcmRCdXR0b24oKX1cbiAgICAgICAgICB7dGhpcy5yZW5kZXJNaXJyb3JQYXRjaEJ1dHRvbigpfVxuICAgICAgICAgIHt0aGlzLnJlbmRlck9wZW5GaWxlQnV0dG9uKCl9XG4gICAgICAgICAge3RoaXMucmVuZGVyVG9nZ2xlRmlsZUJ1dHRvbigpfVxuICAgICAgICA8L3NwYW4+XG4gICAgICApO1xuICAgIH1cbiAgfVxuXG4gIHJlbmRlclVuZG9EaXNjYXJkQnV0dG9uKCkge1xuICAgIGNvbnN0IHVuc3RhZ2VkQ2hhbmdlZEZpbGVJdGVtID0gdGhpcy5wcm9wcy5pdGVtVHlwZSA9PT0gQ2hhbmdlZEZpbGVJdGVtICYmIHRoaXMucHJvcHMuc3RhZ2luZ1N0YXR1cyA9PT0gJ3Vuc3RhZ2VkJztcbiAgICBpZiAodW5zdGFnZWRDaGFuZ2VkRmlsZUl0ZW0gJiYgdGhpcy5wcm9wcy5oYXNVbmRvSGlzdG9yeSkge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPGJ1dHRvbiBjbGFzc05hbWU9XCJidG4gaWNvbiBpY29uLWhpc3RvcnlcIiBvbkNsaWNrPXt0aGlzLnByb3BzLnVuZG9MYXN0RGlzY2FyZH0+XG4gICAgICAgIFVuZG8gRGlzY2FyZFxuICAgICAgICA8L2J1dHRvbj5cbiAgICAgICk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiBudWxsO1xuICAgIH1cbiAgfVxuXG4gIHJlbmRlck1pcnJvclBhdGNoQnV0dG9uKCkge1xuICAgIGlmICghdGhpcy5wcm9wcy5pc1BhcnRpYWxseVN0YWdlZCAmJiB0aGlzLnByb3BzLmhhc0h1bmtzKSB7XG4gICAgICByZXR1cm4gbnVsbDtcbiAgICB9XG5cbiAgICBjb25zdCBhdHRycyA9IHRoaXMucHJvcHMuc3RhZ2luZ1N0YXR1cyA9PT0gJ3Vuc3RhZ2VkJ1xuICAgICAgPyB7XG4gICAgICAgIGljb25DbGFzczogJ2ljb24tdGFza2xpc3QnLFxuICAgICAgICBidXR0b25UZXh0OiAnVmlldyBTdGFnZWQnLFxuICAgICAgfVxuICAgICAgOiB7XG4gICAgICAgIGljb25DbGFzczogJ2ljb24tbGlzdC11bm9yZGVyZWQnLFxuICAgICAgICBidXR0b25UZXh0OiAnVmlldyBVbnN0YWdlZCcsXG4gICAgICB9O1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxGcmFnbWVudD5cbiAgICAgICAgPGJ1dHRvblxuICAgICAgICAgIHJlZj17dGhpcy5yZWZNaXJyb3JCdXR0b24uc2V0dGVyfVxuICAgICAgICAgIGNsYXNzTmFtZT17Y3goJ2J0bicsICdpY29uJywgYXR0cnMuaWNvbkNsYXNzKX1cbiAgICAgICAgICBvbkNsaWNrPXt0aGlzLnByb3BzLmRpdmVJbnRvTWlycm9yUGF0Y2h9PlxuICAgICAgICAgIHthdHRycy5idXR0b25UZXh0fVxuICAgICAgICA8L2J1dHRvbj5cbiAgICAgIDwvRnJhZ21lbnQ+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlck9wZW5GaWxlQnV0dG9uKCkge1xuICAgIGxldCBidXR0b25UZXh0ID0gJ0p1bXAgVG8gRmlsZSc7XG4gICAgaWYgKHRoaXMucHJvcHMuaGFzTXVsdGlwbGVGaWxlU2VsZWN0aW9ucykge1xuICAgICAgYnV0dG9uVGV4dCArPSAncyc7XG4gICAgfVxuXG4gICAgcmV0dXJuIChcbiAgICAgIDxGcmFnbWVudD5cbiAgICAgICAgPGJ1dHRvblxuICAgICAgICAgIHJlZj17dGhpcy5yZWZPcGVuRmlsZUJ1dHRvbi5zZXR0ZXJ9XG4gICAgICAgICAgY2xhc3NOYW1lPVwiYnRuIGljb24gaWNvbi1jb2RlIGdpdGh1Yi1GaWxlUGF0Y2hIZWFkZXJWaWV3LWp1bXBUb0ZpbGVCdXR0b25cIlxuICAgICAgICAgIG9uQ2xpY2s9e3RoaXMucHJvcHMub3BlbkZpbGV9PlxuICAgICAgICAgIHtidXR0b25UZXh0fVxuICAgICAgICA8L2J1dHRvbj5cbiAgICAgIDwvRnJhZ21lbnQ+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlclRvZ2dsZUZpbGVCdXR0b24oKSB7XG4gICAgY29uc3QgYXR0cnMgPSB0aGlzLnByb3BzLnN0YWdpbmdTdGF0dXMgPT09ICd1bnN0YWdlZCdcbiAgICAgID8ge1xuICAgICAgICBidXR0b25DbGFzczogJ2ljb24tbW92ZS1kb3duJyxcbiAgICAgICAgYnV0dG9uVGV4dDogJ1N0YWdlIEZpbGUnLFxuICAgICAgfVxuICAgICAgOiB7XG4gICAgICAgIGJ1dHRvbkNsYXNzOiAnaWNvbi1tb3ZlLXVwJyxcbiAgICAgICAgYnV0dG9uVGV4dDogJ1Vuc3RhZ2UgRmlsZScsXG4gICAgICB9O1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxidXR0b24gY2xhc3NOYW1lPXtjeCgnYnRuJywgJ2ljb24nLCBhdHRycy5idXR0b25DbGFzcyl9IG9uQ2xpY2s9e3RoaXMucHJvcHMudG9nZ2xlRmlsZX0+XG4gICAgICAgIHthdHRycy5idXR0b25UZXh0fVxuICAgICAgPC9idXR0b24+XG4gICAgKTtcbiAgfVxufVxuIl19