'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _commands = require('../atom/commands');

var _commands2 = _interopRequireDefault(_commands);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CloneDialog extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'clone', 'cancel', 'didChangeRemoteUrl', 'didChangeProjectPath', 'editorRefs');

    this.state = {
      cloneDisabled: false
    };

    this.projectHome = this.props.config.get('core.projectHome');
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    if (this.projectPathEditor) {
      this.projectPathEditor.setText(this.props.config.get('core.projectHome'));
      this.projectPathModified = false;
    }

    if (this.remoteUrlElement) {
      setTimeout(() => this.remoteUrlElement.focus());
    }
  }

  render() {
    if (!this.props.inProgress) {
      return this.renderDialog();
    } else {
      return this.renderSpinner();
    }
  }

  renderDialog() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-Clone modal' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-Clone' },
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancel }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.clone })
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-DialogInputs' },
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel github-CloneUrl' },
          'Clone from',
          _react2.default.createElement('atom-text-editor', { mini: true, ref: this.editorRefs('remoteUrl'), tabIndex: '1' })
        ),
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel github-ProjectPath' },
          'To directory',
          _react2.default.createElement('atom-text-editor', { mini: true, ref: this.editorRefs('projectPath'), tabIndex: '2' })
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-DialogButtons' },
        _react2.default.createElement(
          'button',
          { className: 'btn github-CancelButton', onClick: this.cancel, tabIndex: '3' },
          'Cancel'
        ),
        _react2.default.createElement(
          'button',
          {
            className: 'btn btn-primary icon icon-repo-clone',
            onClick: this.clone,
            disabled: this.state.cloneDisabled,
            tabIndex: '4' },
          'Clone'
        )
      )
    );
  }

  renderSpinner() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-Clone modal' },
      _react2.default.createElement(
        'main',
        { className: 'github-DialogSpinner' },
        _react2.default.createElement('span', { className: 'loading loading-spinner-small inline-block' }),
        _react2.default.createElement(
          'span',
          { className: 'github-DialogMessage inline-block' },
          'Cloning ',
          _react2.default.createElement(
            'strong',
            null,
            this.getRemoteUrl()
          )
        )
      )
    );
  }

  clone() {
    if (this.getRemoteUrl().length === 0 || this.getProjectPath().length === 0) {
      return;
    }

    this.props.didAccept(this.getRemoteUrl(), this.getProjectPath());
  }

  cancel() {
    this.props.didCancel();
  }

  didChangeRemoteUrl() {
    if (!this.projectPathModified) {
      const name = _path2.default.basename(_url2.default.parse(this.getRemoteUrl()).pathname, '.git') || '';

      if (name.length > 0) {
        const proposedPath = _path2.default.join(this.projectHome, name);
        this.projectPathEditor.setText(proposedPath);
        this.projectPathModified = false;
      }
    }

    this.setCloneEnablement();
  }

  didChangeProjectPath() {
    this.projectPathModified = true;
    this.setCloneEnablement();
  }

  editorRefs(baseName) {
    const elementName = `${baseName}Element`;
    const modelName = `${baseName}Editor`;
    const subName = `${baseName}Subs`;
    const changeMethodName = `didChange${baseName[0].toUpperCase()}${baseName.substring(1)}`;

    return element => {
      if (!element) {
        return;
      }

      this[elementName] = element;
      const editor = element.getModel();
      if (this[modelName] !== editor) {
        this[modelName] = editor;

        if (this[subName]) {
          this[subName].dispose();
          this.subs.remove(this[subName]);
        }

        this[subName] = editor.onDidChange(this[changeMethodName]);
        this.subs.add(this[subName]);
      }
    };
  }

  getProjectPath() {
    return this.projectPathEditor ? this.projectPathEditor.getText() : '';
  }

  getRemoteUrl() {
    return this.remoteUrlEditor ? this.remoteUrlEditor.getText() : '';
  }

  setCloneEnablement() {
    const disabled = this.getRemoteUrl().length === 0 || this.getProjectPath().length === 0;
    this.setState({ cloneDisabled: disabled });
  }
}
exports.default = CloneDialog;
CloneDialog.propTypes = {
  config: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  inProgress: _propTypes2.default.bool,
  didAccept: _propTypes2.default.func,
  didCancel: _propTypes2.default.func
};
CloneDialog.defaultProps = {
  inProgress: false,
  didAccept: () => {},
  didCancel: () => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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