'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reporterProxy = require('../reporter-proxy');

var _eventKit = require('event-kit');

var _commitDetailItem = require('../items/commit-detail-item');

var _commitDetailItem2 = _interopRequireDefault(_commitDetailItem);

var _uriPattern = require('../atom/uri-pattern');

var _uriPattern2 = _interopRequireDefault(_uriPattern);

var _recentCommitsView = require('../views/recent-commits-view');

var _recentCommitsView2 = _interopRequireDefault(_recentCommitsView);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class RecentCommitsController extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.updateSelectedCommit = () => {
      const activeItem = this.props.workspace.getActivePaneItem();

      const pattern = new _uriPattern2.default(decodeURIComponent(_commitDetailItem2.default.buildURI(this.props.repository.getWorkingDirectoryPath(), '{sha}')));

      if (activeItem && activeItem.getURI) {
        const match = pattern.matches(activeItem.getURI());
        const { sha } = match.getParams();
        if (match.ok() && sha && sha !== this.state.selectedCommitSha) {
          return new Promise(resolve => this.setState({ selectedCommitSha: sha }, resolve));
        }
      }
      return Promise.resolve();
    };

    this.openCommit = async ({ sha, preserveFocus }) => {
      const workdir = this.props.repository.getWorkingDirectoryPath();
      const uri = _commitDetailItem2.default.buildURI(workdir, sha);
      const item = await this.props.workspace.open(uri, { pending: true });
      if (preserveFocus) {
        item.preventFocus();
        this.setFocus(this.constructor.focus.RECENT_COMMIT);
      }
      (0, _reporterProxy.addEvent)('open-commit-in-pane', { package: 'github', from: this.constructor.name });
    };

    this.selectNextCommit = () => this.setSelectedCommitIndex(this.getSelectedCommitIndex() + 1);

    this.selectPreviousCommit = () => this.setSelectedCommitIndex(Math.max(this.getSelectedCommitIndex() - 1, 0));

    this.subscriptions = new _eventKit.CompositeDisposable(this.props.workspace.onDidChangeActivePaneItem(this.updateSelectedCommit));

    this.refView = new _refHolder2.default();

    this.state = { selectedCommitSha: '' };
  }

  render() {
    return _react2.default.createElement(_recentCommitsView2.default, {
      ref: this.refView.setter,
      commits: this.props.commits,
      isLoading: this.props.isLoading,
      undoLastCommit: this.props.undoLastCommit,
      openCommit: this.openCommit,
      selectNextCommit: this.selectNextCommit,
      selectPreviousCommit: this.selectPreviousCommit,
      selectedCommitSha: this.state.selectedCommitSha,
      commandRegistry: this.props.commandRegistry
    });
  }

  // When no commit is selected, `getSelectedCommitIndex` returns -1 & the commit at index 0 (first commit) is selected


  getSelectedCommitIndex() {
    return this.props.commits.findIndex(commit => commit.getSha() === this.state.selectedCommitSha);
  }

  setSelectedCommitIndex(ind) {
    const commit = this.props.commits[ind];
    if (commit) {
      return new Promise(resolve => this.setState({ selectedCommitSha: commit.getSha() }, resolve));
    } else {
      return Promise.resolve();
    }
  }

  getFocus(element) {
    return this.refView.map(view => view.getFocus(element)).getOr(null);
  }

  setFocus(focus) {
    return this.refView.map(view => {
      const wasFocused = view.setFocus(focus);
      if (wasFocused && this.getSelectedCommitIndex() === -1) {
        this.setSelectedCommitIndex(0);
      }
      return wasFocused;
    }).getOr(false);
  }

  advanceFocusFrom(focus) {
    return this.refView.map(view => view.advanceFocusFrom(focus)).getOr(Promise.resolve(null));
  }

  retreatFocusFrom(focus) {
    return this.refView.map(view => view.retreatFocusFrom(focus)).getOr(Promise.resolve(null));
  }
}
exports.default = RecentCommitsController;
RecentCommitsController.propTypes = {
  commits: _propTypes2.default.arrayOf(_propTypes2.default.object).isRequired,
  isLoading: _propTypes2.default.bool.isRequired,
  undoLastCommit: _propTypes2.default.func.isRequired,
  workspace: _propTypes2.default.object.isRequired,
  repository: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired
};
RecentCommitsController.focus = _recentCommitsView2.default.focus;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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