'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _graphql;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _reactRelay = require('react-relay');

var _helpers = require('../helpers');

var _relayNetworkLayerManager = require('../relay-network-layer-manager');

var _relayNetworkLayerManager2 = _interopRequireDefault(_relayNetworkLayerManager);

var _propTypes3 = require('../prop-types');

var _keytarStrategy = require('../shared/keytar-strategy');

var _githubLoginView = require('../views/github-login-view');

var _githubLoginView2 = _interopRequireDefault(_githubLoginView);

var _loadingView = require('../views/loading-view');

var _loadingView2 = _interopRequireDefault(_loadingView);

var _queryErrorView = require('../views/query-error-view');

var _queryErrorView2 = _interopRequireDefault(_queryErrorView);

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _relayEnvironment = require('../views/relay-environment');

var _relayEnvironment2 = _interopRequireDefault(_relayEnvironment);

var _issueishDetailController = require('../controllers/issueish-detail-controller');

var _issueishDetailController2 = _interopRequireDefault(_issueishDetailController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class IssueishDetailContainer extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'fetchToken', 'renderWithToken', 'fetchRepositoryData', 'renderWithRepositoryData', 'renderWithResult', 'handleLogin', 'handleLogout');
  }

  fetchToken(loginModel) {
    return (0, _yubikiri2.default)({
      token: loginModel.getToken(this.props.endpoint.getLoginAccount())
    });
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.loginModel, fetchData: this.fetchToken },
      this.renderWithToken
    );
  }

  fetchRepositoryData(repository) {
    return (0, _yubikiri2.default)({
      branches: repository.getBranches(),
      remotes: repository.getRemotes(),
      isMerging: repository.isMerging(),
      isRebasing: repository.isRebasing(),
      isAbsent: repository.isAbsent(),
      isLoading: repository.isLoading(),
      isPresent: repository.isPresent()
    });
  }

  renderWithToken(tokenData) {
    if (!tokenData) {
      return _react2.default.createElement(_loadingView2.default, null);
    }

    if (tokenData.token === _keytarStrategy.UNAUTHENTICATED) {
      return _react2.default.createElement(_githubLoginView2.default, { onLogin: this.handleLogin });
    }

    if (tokenData.token === _keytarStrategy.INSUFFICIENT) {
      return _react2.default.createElement(
        _githubLoginView2.default,
        { onLogin: this.handleLogin },
        _react2.default.createElement(
          'p',
          null,
          'Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one.'
        )
      );
    }

    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.repository, fetchData: this.fetchRepositoryData },
      repoData => this.renderWithRepositoryData(repoData, tokenData.token)
    );
  }

  renderWithRepositoryData(repoData, token) {
    if (!repoData) {
      return _react2.default.createElement(_loadingView2.default, null);
    }

    const environment = _relayNetworkLayerManager2.default.getEnvironmentForHost(this.props.endpoint, token);
    const query = _graphql || (_graphql = function () {
      const node = require('./__generated__/issueishDetailContainerQuery.graphql');

      if (node.hash && node.hash !== 'a7a95576735d58263820790226b82e2f') {
        console.error('The definition of \'issueishDetailContainerQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
      }

      return require('./__generated__/issueishDetailContainerQuery.graphql');
    });
    const variables = {
      repoOwner: this.props.owner,
      repoName: this.props.repo,
      issueishNumber: this.props.issueishNumber,
      timelineCount: 100,
      timelineCursor: null,
      commitCount: 100,
      commitCursor: null
    };

    return _react2.default.createElement(
      _relayEnvironment2.default.Provider,
      { value: environment },
      _react2.default.createElement(_reactRelay.QueryRenderer, {
        environment: environment,
        query: query,
        variables: variables,
        render: queryResult => this.renderWithResult(queryResult, repoData, token)
      })
    );
  }

  renderWithResult({ error, props, retry }, repoData, token) {
    if (error) {
      return _react2.default.createElement(_queryErrorView2.default, {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (!props) {
      return _react2.default.createElement(_loadingView2.default, null);
    }

    const { repository } = this.props;

    return _react2.default.createElement(_issueishDetailController2.default, _extends({}, props, repoData, {
      localRepository: this.props.repository,
      issueishNumber: this.props.issueishNumber,
      fetch: repository.fetch.bind(repository),
      checkout: repository.checkout.bind(repository),
      pull: repository.pull.bind(repository),
      addRemote: repository.addRemote.bind(repository),
      onTitleChange: this.props.onTitleChange,
      switchToIssueish: this.props.switchToIssueish,
      workdirPath: repository.getWorkingDirectoryPath(),

      endpoint: this.props.endpoint,
      token: token,

      workspace: this.props.workspace,
      commands: this.props.commands,
      keymaps: this.props.keymaps,
      tooltips: this.props.tooltips,
      config: this.props.config,

      itemType: this.props.itemType,
      destroy: this.props.destroy
    }));
  }

  handleLogin(token) {
    return this.props.loginModel.setToken(this.props.endpoint.getLoginAccount(), token);
  }

  handleLogout() {
    return this.props.loginModel.removeToken(this.props.endpoint.getLoginAccount());
  }
}
exports.default = IssueishDetailContainer;
IssueishDetailContainer.propTypes = {
  // Connection
  endpoint: _propTypes3.EndpointPropType.isRequired,

  // Issueish selection criteria
  owner: _propTypes2.default.string.isRequired,
  repo: _propTypes2.default.string.isRequired,
  issueishNumber: _propTypes2.default.number.isRequired,

  // Package models
  repository: _propTypes2.default.object.isRequired,
  loginModel: _propTypes3.GithubLoginModelPropType.isRequired,

  // Atom environment
  workspace: _propTypes2.default.object.isRequired,
  commands: _propTypes2.default.object.isRequired,
  keymaps: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,

  // Action methods
  switchToIssueish: _propTypes2.default.func.isRequired,
  onTitleChange: _propTypes2.default.func.isRequired,
  destroy: _propTypes2.default.func.isRequired,

  // Item context
  itemType: _propTypes3.ItemTypePropType.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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