'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _loadingView = require('../views/loading-view');

var _loadingView2 = _interopRequireDefault(_loadingView);

var _commitDetailController = require('../controllers/commit-detail-controller');

var _commitDetailController2 = _interopRequireDefault(_commitDetailController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CommitDetailContainer extends _react2.default.Component {
  constructor(...args) {
    var _temp;

    return _temp = super(...args), this.fetchData = repository => {
      return (0, _yubikiri2.default)({
        commit: repository.getCommit(this.props.sha),
        currentBranch: repository.getCurrentBranch(),
        currentRemote: async query => repository.getRemoteForBranch((await query.currentBranch).getName()),
        isCommitPushed: repository.isCommitPushed(this.props.sha)
      });
    }, this.renderResult = data => {
      if (this.props.repository.isLoading() || data === null || !data.commit.isPresent()) {
        return _react2.default.createElement(_loadingView2.default, null);
      }

      return _react2.default.createElement(_commitDetailController2.default, _extends({}, data, this.props));
    }, _temp;
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.repository, fetchData: this.fetchData },
      this.renderResult
    );
  }

}
exports.default = CommitDetailContainer;
CommitDetailContainer.propTypes = {
  repository: _propTypes2.default.object.isRequired,
  sha: _propTypes2.default.string.isRequired,
  itemType: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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