/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.Bytecode;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeSipush
extends Bytecode {
    BytecodeSipush(Method method, int bci) {
        super(method, bci);
    }

    public short getValue() {
        return this.javaShortAt(1);
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check sipush");
        }
    }

    public boolean isValid() {
        return this.javaCode() == 17;
    }

    public static BytecodeSipush at(Method method, int bci) {
        BytecodeSipush b = new BytecodeSipush(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodeSipush atCheck(Method method, int bci) {
        BytecodeSipush b = new BytecodeSipush(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeSipush at(BytecodeStream bcs) {
        return new BytecodeSipush(bcs.method(), bcs.bci());
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("sipush");
        buf.append(" ");
        buf.append(Short.toString(this.getValue()));
        return buf.toString();
    }
}

