/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.swt;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.SystemClipboard;
import com.sun.glass.ui.swt.CustomTransfer;
import com.sun.glass.ui.swt.SWTApplication;
import com.sun.glass.ui.swt.SWTView;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class SWTClipboard
extends SystemClipboard {
    Clipboard clipboard;
    static final String CLIPBOARD_KEY = "SWTClipboard";
    static final boolean MULTIPLE_TRANSFERS = SWT.getPlatform().equals("win32");
    static final int DROP_NONE = 0;
    static final int DROP_COPY = 1;
    static final int DROP_MOVE = 2;
    static final int DROP_LINK = 4;
    private static final boolean MUTIPLE_TRANSFERS = false;
    static Transfer[] StandardTransfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance(), HTMLTransfer.getInstance(), URLTransfer.getInstance(), ImageTransfer.getInstance(), FileTransfer.getInstance()};
    static Transfer[] CustomTransfers = new Transfer[0];
    static int operations = 0;
    static TransferData currentTransferData;
    static TransferData[] transferData;
    static Object currentData;

    public SWTClipboard(String name) {
        super(name);
        if (name.equals("SYSTEM")) {
            Display display = Display.getDefault();
            this.clipboard = (Clipboard)display.getData(CLIPBOARD_KEY);
            if (this.clipboard == null) {
                this.clipboard = new Clipboard(display);
                display.setData(CLIPBOARD_KEY, (Object)this.clipboard);
                display.disposeExec(() -> this.clipboard.dispose());
            }
        }
    }

    static Transfer[] getAllTransfers() {
        Transfer[] transfers = new Transfer[StandardTransfers.length + CustomTransfers.length];
        System.arraycopy(StandardTransfers, 0, transfers, 0, StandardTransfers.length);
        System.arraycopy(CustomTransfers, 0, transfers, StandardTransfers.length, CustomTransfers.length);
        return transfers;
    }

    static Transfer getCustomTransfer(String mime) {
        for (int i = 0; i < CustomTransfers.length; ++i) {
            if (!((CustomTransfer)CustomTransfers[i]).getMime().equals(mime)) continue;
            return CustomTransfers[i];
        }
        CustomTransfer transfer = new CustomTransfer(mime, mime);
        Transfer[] newCustom = new Transfer[CustomTransfers.length + 1];
        System.arraycopy(CustomTransfers, 0, newCustom, 0, CustomTransfers.length);
        newCustom[SWTClipboard.CustomTransfers.length] = transfer;
        CustomTransfers = newCustom;
        return transfer;
    }

    static Transfer[] getTransferTypes(String[] mimeTypes) {
        int count = 0;
        Transfer[] transfers = new Transfer[mimeTypes.length];
        for (int i = 0; i < mimeTypes.length; ++i) {
            Transfer transfer = SWTClipboard.getTransferType(mimeTypes[i]);
            if (transfer == null) continue;
            transfers[count++] = transfer;
        }
        if (count != mimeTypes.length) {
            Transfer[] newTransfers = new Transfer[count];
            System.arraycopy(transfers, 0, newTransfers, 0, count);
            transfers = newTransfers;
        }
        return transfers;
    }

    static String getMime(TransferData data) {
        if (TextTransfer.getInstance().isSupportedType(data)) {
            return "text/plain";
        }
        if (RTFTransfer.getInstance().isSupportedType(data)) {
            return "text/rtf";
        }
        if (HTMLTransfer.getInstance().isSupportedType(data)) {
            return "text/html";
        }
        if (URLTransfer.getInstance().isSupportedType(data)) {
            return "text/uri-list";
        }
        if (ImageTransfer.getInstance().isSupportedType(data)) {
            return "application/x-java-rawimage";
        }
        if (FileTransfer.getInstance().isSupportedType(data)) {
            return "application/x-java-file-list";
        }
        for (int i = 0; i < CustomTransfers.length; ++i) {
            if (!CustomTransfers[i].isSupportedType(data)) continue;
            return ((CustomTransfer)CustomTransfers[i]).getMime();
        }
        return null;
    }

    static String getMime(Transfer transfer) {
        if (transfer.equals(TextTransfer.getInstance())) {
            return "text/plain";
        }
        if (transfer.equals(RTFTransfer.getInstance())) {
            return "text/rtf";
        }
        if (transfer.equals(HTMLTransfer.getInstance())) {
            return "text/html";
        }
        if (transfer.equals(URLTransfer.getInstance())) {
            return "text/uri-list";
        }
        if (transfer.equals(ImageTransfer.getInstance())) {
            return "application/x-java-rawimage";
        }
        if (transfer.equals(FileTransfer.getInstance())) {
            return "application/x-java-file-list";
        }
        if (transfer instanceof CustomTransfer) {
            return ((CustomTransfer)transfer).getMime();
        }
        return null;
    }

    static String[] getMimes(TransferData[] transfers) {
        int count = 0;
        String[] result = new String[transfers.length];
        for (int i = 0; i < transfers.length; ++i) {
            result[count++] = SWTClipboard.getMime(transfers[i]);
        }
        if (count != result.length) {
            String[] newResult = new String[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    static String[] getMimes(Transfer[] transfers, TransferData data) {
        int count = 0;
        String[] result = new String[transfers.length];
        for (int i = 0; i < transfers.length; ++i) {
            if (!transfers[i].isSupportedType(data)) continue;
            result[count++] = SWTClipboard.getMime(transfers[i]);
        }
        if (count != result.length) {
            String[] newResult = new String[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    static Transfer getTransferType(String mime) {
        if (mime.equals("text/plain")) {
            return TextTransfer.getInstance();
        }
        if (mime.equals("text/rtf")) {
            return RTFTransfer.getInstance();
        }
        if (mime.equals("text/html")) {
            return HTMLTransfer.getInstance();
        }
        if (mime.equals("text/uri-list")) {
            return URLTransfer.getInstance();
        }
        if (mime.equals("application/x-java-rawimage")) {
            return ImageTransfer.getInstance();
        }
        if (mime.equals("application/x-java-file-list")) {
            return FileTransfer.getInstance();
        }
        return SWTClipboard.getCustomTransfer(mime);
    }

    static Object getData(String mime, TransferData data) {
        if (mime.equals("text/plain")) {
            return TextTransfer.getInstance().nativeToJava(data);
        }
        if (mime.equals("text/rtf")) {
            return RTFTransfer.getInstance().nativeToJava(data);
        }
        if (mime.equals("text/html")) {
            return HTMLTransfer.getInstance().nativeToJava(data);
        }
        if (mime.equals("text/uri-list")) {
            return URLTransfer.getInstance().nativeToJava(data);
        }
        if (mime.equals("application/x-java-rawimage")) {
            return ImageTransfer.getInstance().nativeToJava(data);
        }
        if (mime.equals("application/x-java-file-list")) {
            return FileTransfer.getInstance().nativeToJava(data);
        }
        Transfer transfer = SWTClipboard.getCustomTransfer(mime);
        if (transfer != null) {
            return ((CustomTransfer)transfer).nativeToJava(data);
        }
        return null;
    }

    @Override
    protected boolean isOwner() {
        return false;
    }

    static int getSWTAction(int actions) {
        int result = 0;
        if ((actions & 1) != 0) {
            result |= 1;
        }
        if ((actions & 2) != 0) {
            result |= 2;
        }
        if ((actions & 0x40000000) != 0) {
            result |= 4;
        }
        return result;
    }

    static int getFXAction(int actions) {
        int result = 0;
        if ((actions & 1) != 0) {
            result |= 1;
        }
        if ((actions & 2) != 0) {
            result |= 2;
        }
        if ((actions & 4) != 0) {
            result |= 0x40000000;
        }
        return result;
    }

    @Override
    protected void pushToSystem(HashMap<String, Object> data, int supportedActions) {
        int count = 0;
        ImageData imageData = null;
        Set<String> keys = data.keySet();
        Object[] objects = new Object[keys.size()];
        Transfer[] transfers = new Transfer[keys.size()];
        for (String key : keys) {
            Transfer transfer = SWTClipboard.getTransferType(key);
            if (transfer == null) continue;
            if (transfer instanceof ImageTransfer && data.get(key) instanceof Pixels) {
                Pixels pixels = (Pixels)data.get(key);
                imageData = SWTApplication.createImageData(pixels);
                objects[count] = imageData;
            } else {
                objects[count] = data.get(key);
            }
            transfers[count] = transfer;
            ++count;
        }
        if (count == 0) {
            return;
        }
        if (count != objects.length) {
            Object[] newObjects = new Object[objects.length];
            System.arraycopy(objects, 0, newObjects, 0, objects.length);
            objects = newObjects;
            Transfer[] newTransfers = new Transfer[transfers.length];
            System.arraycopy(transfers, 0, newTransfers, 0, transfers.length);
            transfers = newTransfers;
        }
        if (this.clipboard != null) {
            for (int i = 0; i < transfers.length; ++i) {
                if (!(transfers[i] instanceof TextTransfer) || !(objects[i] instanceof String) || ((String)objects[i]).length() != 0) continue;
                this.clipboard.clearContents();
                return;
            }
            this.clipboard.setContents(objects, transfers);
        } else {
            final Control control = Display.getDefault().getFocusControl();
            if (control != null && control.getData() instanceof SWTView) {
                final SWTView view = (SWTView)control.getData();
                int dragOperation = SWTClipboard.getSWTAction(supportedActions);
                final DragSource dragSource = new DragSource(control, dragOperation);
                dragSource.setTransfer(transfers);
                dragSource.setData("objects", (Object)objects);
                dragSource.setData("imageData", (Object)imageData);
                dragSource.addDragListener(new DragSourceListener(){
                    Image image = null;

                    public void dragFinished(DragSourceEvent event) {
                        if (this.image != null) {
                            this.image.dispose();
                            this.image = null;
                        }
                        dragSource.setData("objects", null);
                        dragSource.setData("imageData", null);
                        dragSource.dispose();
                        view.notifyDragEnd(SWTClipboard.getFXAction(event.detail));
                    }

                    public void dragSetData(DragSourceEvent event) {
                        Object[] objects = (Object[])dragSource.getData("objects");
                        Transfer[] transfers = dragSource.getTransfer();
                        for (int i = 0; i < transfers.length; ++i) {
                            String mime;
                            if (transfers[i].isSupportedType(event.dataType) && (mime = SWTClipboard.getMime(transfers[i])) != null) {
                                event.doit = true;
                                event.data = objects[i];
                                return;
                            }
                            event.doit = false;
                        }
                    }

                    public void dragStart(DragSourceEvent event) {
                        ImageData imageData = (ImageData)dragSource.getData("imageData");
                        if (imageData != null) {
                            event.image = this.image = new Image((Device)event.display, imageData);
                            event.offsetX = imageData.width / 2;
                            event.offsetY = imageData.height / 2;
                        }
                        Point point = control.toDisplay(event.x, event.y);
                        view.notifyDragStart(1, event.x, event.y, point.x, point.y);
                    }
                });
                if (view.dropTarget != null) {
                    view.dropTarget.setTransfer(SWTClipboard.getAllTransfers());
                }
                control.notifyListeners(29, null);
            }
        }
    }

    @Override
    protected void pushTargetActionToSystem(int actionDone) {
    }

    @Override
    protected Object popFromSystem(String mimeType) {
        Transfer transfer = SWTClipboard.getTransferType(mimeType);
        if (transfer != null) {
            Object data = null;
            if (this.clipboard != null) {
                data = this.clipboard.getContents(transfer);
            } else if (MULTIPLE_TRANSFERS) {
                for (int i = 0; i < transferData.length; ++i) {
                    if (!transfer.isSupportedType(transferData[i])) continue;
                    data = SWTClipboard.getData(mimeType, transferData[i]);
                    break;
                }
            } else {
                data = currentData;
            }
            if (data instanceof ImageData) {
                return SWTApplication.createPixels((ImageData)data);
            }
            return data;
        }
        return null;
    }

    @Override
    protected int supportedSourceActionsFromSystem() {
        if (this.clipboard != null) {
            return 1;
        }
        return SWTClipboard.getFXAction(operations);
    }

    static DropTarget createDropTarget(final Control control) {
        final SWTView view = (SWTView)control.getData();
        final DropTarget dropTarget = new DropTarget(control, 7);
        dropTarget.setTransfer(SWTClipboard.getAllTransfers());
        dropTarget.addDropListener(new DropTargetListener(){
            int detail = 0;

            public void dragEnter(DropTargetEvent event) {
                dropTarget.setTransfer(SWTClipboard.getAllTransfers());
                this.detail = event.detail;
                operations = event.operations;
                this.dragOver(event, true, this.detail);
            }

            public void dragLeave(DropTargetEvent event) {
                operations = 0;
                this.detail = 0;
                currentData = null;
                transferData = null;
                currentTransferData = null;
                view.notifyDragLeave();
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.detail = event.detail;
                operations = event.operations;
                this.dragOver(event, false, this.detail);
            }

            public void dragOver(DropTargetEvent event) {
                operations = event.operations;
                this.dragOver(event, false, this.detail);
            }

            public void dragOver(DropTargetEvent event, boolean enter, int detail) {
                transferData = event.dataTypes;
                currentTransferData = event.currentDataType;
                Point pt = control.toControl(event.x, event.y);
                if (detail == 0) {
                    detail = 1;
                }
                int action = SWTClipboard.getFXAction(detail);
                int acceptAction = enter ? view.notifyDragEnter(pt.x, pt.y, event.x, event.y, action) : view.notifyDragOver(pt.x, pt.y, event.x, event.y, action);
                event.detail = SWTClipboard.getSWTAction(acceptAction);
            }

            public void drop(DropTargetEvent event) {
                this.detail = event.detail;
                operations = event.operations;
                currentData = event.data;
                transferData = event.dataTypes;
                currentTransferData = event.currentDataType;
                Point pt = control.toControl(event.x, event.y);
                int action = SWTClipboard.getFXAction(event.detail);
                int acceptAction = view.notifyDragDrop(pt.x, pt.y, event.x, event.y, action);
                event.detail = SWTClipboard.getSWTAction(acceptAction);
                currentData = null;
                transferData = null;
                currentTransferData = null;
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        return dropTarget;
    }

    @Override
    protected String[] mimesFromSystem() {
        if (this.clipboard != null) {
            int count = 0;
            TransferData[] data = this.clipboard.getAvailableTypes();
            String[] result = new String[data.length];
            for (int i = 0; i < data.length; ++i) {
                String mime = SWTClipboard.getMime(data[i]);
                if (mime == null) continue;
                result[count++] = mime;
            }
            if (count == result.length) {
                return result;
            }
            String[] newResult = new String[count];
            System.arraycopy(result, 0, newResult, 0, count);
            return newResult;
        }
        if (MULTIPLE_TRANSFERS) {
            return SWTClipboard.getMimes(transferData);
        }
        if (currentTransferData == null) {
            return new String[0];
        }
        return SWTClipboard.getMimes(SWTClipboard.getAllTransfers(), currentTransferData);
    }
}

