/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.IOException;
import java.net.URL;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadServiceListener;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.ManageJnlpResources;

class XDownloadService
implements DownloadService {
    XDownloadService() {
    }

    JNLPClassLoader getClassLoader() {
        return (JNLPClassLoader)JNLPRuntime.getApplication().getClassLoader();
    }

    @Override
    public DownloadServiceListener getDefaultProgressWindow() {
        return null;
    }

    @Override
    public boolean isExtensionPartCached(URL ref, String version, String part) {
        boolean allCached = true;
        Version resourceVersion = version == null ? null : new Version(version);
        JARDesc[] jars = ManageJnlpResources.findJars(this.getClassLoader(), ref, part, resourceVersion);
        if (jars.length <= 0) {
            return false;
        }
        for (int i = 0; i < jars.length && allCached; ++i) {
            allCached = CacheUtil.isCached(jars[i].getLocation(), resourceVersion);
        }
        return allCached;
    }

    @Override
    public boolean isExtensionPartCached(URL ref, String version, String[] parts) {
        boolean allCached = true;
        if (parts.length <= 0) {
            return false;
        }
        for (String eachPart : parts) {
            allCached = this.isExtensionPartCached(ref, version, eachPart);
        }
        return allCached;
    }

    @Override
    public boolean isPartCached(String part) {
        boolean allCached = true;
        JARDesc[] jars = ManageJnlpResources.findJars(this.getClassLoader(), null, part, null);
        if (jars.length <= 0) {
            return false;
        }
        for (int i = 0; i < jars.length && allCached; ++i) {
            allCached = CacheUtil.isCached(jars[i].getLocation(), null);
        }
        return allCached;
    }

    @Override
    public boolean isPartCached(String[] parts) {
        boolean allCached = true;
        if (parts.length <= 0) {
            return false;
        }
        for (String eachPart : parts) {
            allCached = this.isPartCached(eachPart);
        }
        return allCached;
    }

    @Override
    public boolean isResourceCached(URL ref, String version) {
        return ManageJnlpResources.isExternalResourceCached(this.getClassLoader(), ref, version);
    }

    @Override
    public void loadExtensionPart(URL ref, String version, String[] parts, DownloadServiceListener progress) throws IOException {
        for (String eachPart : parts) {
            this.loadExtensionPart(ref, version, eachPart, progress);
        }
    }

    @Override
    public void loadExtensionPart(URL ref, String version, String part, DownloadServiceListener progress) throws IOException {
        Version resourceVersion = version == null ? null : new Version(version);
        ManageJnlpResources.downloadJars(this.getClassLoader(), ref, part, resourceVersion);
    }

    @Override
    public void loadPart(String[] parts, DownloadServiceListener progress) throws IOException {
        for (String eachPart : parts) {
            this.loadPart(eachPart, progress);
        }
    }

    @Override
    public void loadPart(String part, DownloadServiceListener progress) throws IOException {
        ManageJnlpResources.downloadJars(this.getClassLoader(), null, part, null);
    }

    @Override
    public void loadResource(URL ref, String version, DownloadServiceListener progress) throws IOException {
        ManageJnlpResources.loadExternalResouceToCache(this.getClassLoader(), ref, version);
    }

    @Override
    public void removeExtensionPart(URL ref, String version, String part) throws IOException {
        Version resourceVersion = version == null ? null : new Version(version);
        JARDesc[] jars = ManageJnlpResources.findJars(this.getClassLoader(), ref, part, resourceVersion);
        ManageJnlpResources.removeCachedJars(this.getClassLoader(), ref, jars);
    }

    @Override
    public void removeExtensionPart(URL ref, String version, String[] parts) throws IOException {
        for (String eachPart : parts) {
            this.removeExtensionPart(ref, version, eachPart);
        }
    }

    @Override
    public void removePart(String part) throws IOException {
        JARDesc[] jars = ManageJnlpResources.findJars(this.getClassLoader(), null, part, null);
        ManageJnlpResources.removeCachedJars(this.getClassLoader(), null, jars);
    }

    @Override
    public void removePart(String[] parts) throws IOException {
        for (String eachPart : parts) {
            this.removePart(eachPart);
        }
    }

    @Override
    public void removeResource(URL ref, String version) throws IOException {
        ManageJnlpResources.removeExternalCachedResource(this.getClassLoader(), ref, version);
    }
}

