#ifndef _EFL_UI_FOCUS_LAYER_EO_H_
#define _EFL_UI_FOCUS_LAYER_EO_H_

#ifndef _EFL_UI_FOCUS_LAYER_EO_CLASS_TYPE
#define _EFL_UI_FOCUS_LAYER_EO_CLASS_TYPE

typedef Eo Efl_Ui_Focus_Layer;

#endif

#ifndef _EFL_UI_FOCUS_LAYER_EO_TYPES
#define _EFL_UI_FOCUS_LAYER_EO_TYPES


#endif
/**
 * @brief This defines the inheriting widget as focus layer
 *
 * A focus layer is the uppermost one which received input and handles all
 * focus related events for as long as it exists and is visible. It's NOT
 * possible to escape this layer with focus movement.
 *
 * Once the object is hidden or destroyed the focus will go back to the
 * mainwindow, where it was before.
 *
 * @ingroup Efl_Ui_Focus_Layer
 */
#define EFL_UI_FOCUS_LAYER_MIXIN efl_ui_focus_layer_mixin_get()

EWAPI const Efl_Class *efl_ui_focus_layer_mixin_get(void);

#ifdef EFL_UI_FOCUS_LAYER_PROTECTED
/**
 * @brief Enable property
 *
 * @param[in] obj The object.
 * @param[in] v @c true to set enable the layer @c false to disable it
 *
 * @ingroup Efl_Ui_Focus_Layer
 */
EOAPI void efl_ui_focus_layer_enable_set(Eo *obj, Eina_Bool v);
#endif

#ifdef EFL_UI_FOCUS_LAYER_PROTECTED
/**
 * @brief Enable property
 *
 * @param[in] obj The object.
 *
 * @return @c true to set enable the layer @c false to disable it
 *
 * @ingroup Efl_Ui_Focus_Layer
 */
EOAPI Eina_Bool efl_ui_focus_layer_enable_get(const Eo *obj);
#endif

#ifdef EFL_UI_FOCUS_LAYER_PROTECTED
/**
 * @brief Constructor for setting the behaviour of the layer
 *
 * @param[in] obj The object.
 * @param[in] enable_on_visible @c true means layer will set itself once the
 * inheriting widget becomes visible, @c false means the layer isn't enabled
 * automatically
 * @param[in] cycle If @c true the focus will cycle in the layer, if @c false
 *
 * @ingroup Efl_Ui_Focus_Layer
 */
EOAPI void efl_ui_focus_layer_behaviour_set(Eo *obj, Eina_Bool enable_on_visible, Eina_Bool cycle);
#endif

#ifdef EFL_UI_FOCUS_LAYER_PROTECTED
/**
 * @brief Constructor for setting the behaviour of the layer
 *
 * @param[in] obj The object.
 * @param[out] enable_on_visible @c true means layer will set itself once the
 * inheriting widget becomes visible, @c false means the layer isn't enabled
 * automatically
 * @param[out] cycle If @c true the focus will cycle in the layer, if @c false
 *
 * @ingroup Efl_Ui_Focus_Layer
 */
EOAPI void efl_ui_focus_layer_behaviour_get(const Eo *obj, Eina_Bool *enable_on_visible, Eina_Bool *cycle);
#endif

#endif
