/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ButtonBehavior;
import com.sun.javafx.scene.control.skin.LabeledSkinBase;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class ButtonSkin
extends LabeledSkinBase<Button, ButtonBehavior<Button>> {
    Runnable defaultButtonRunnable = new Runnable(){

        @Override
        public void run() {
            if (!((Button)ButtonSkin.this.getSkinnable()).isDisabled()) {
                ((Button)ButtonSkin.this.getSkinnable()).fire();
            }
        }
    };
    Runnable cancelButtonRunnable = new Runnable(){

        @Override
        public void run() {
            if (!((Button)ButtonSkin.this.getSkinnable()).isDisabled()) {
                ((Button)ButtonSkin.this.getSkinnable()).fire();
            }
        }
    };
    private KeyCodeCombination defaultAcceleratorKeyCodeCombination;
    private KeyCodeCombination cancelAcceleratorKeyCodeCombination;

    public ButtonSkin(Button button) {
        super(button, new ButtonBehavior<Button>(button));
        this.registerChangeListener(button.defaultButtonProperty(), "DEFAULT_BUTTON");
        this.registerChangeListener(button.cancelButtonProperty(), "CANCEL_BUTTON");
        this.registerChangeListener(button.focusedProperty(), "FOCUSED");
        if (((Button)this.getSkinnable()).isDefaultButton()) {
            this.setDefaultButton(true);
        }
        if (((Button)this.getSkinnable()).isCancelButton()) {
            this.setCancelButton(true);
        }
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "DEFAULT_BUTTON") {
            this.setDefaultButton(((Button)this.getSkinnable()).isDefaultButton());
        } else if (string == "CANCEL_BUTTON") {
            this.setCancelButton(((Button)this.getSkinnable()).isCancelButton());
        } else if (string == "FOCUSED") {
            ContextMenu contextMenu;
            if (!((Button)this.getSkinnable()).isFocused() && (contextMenu = ((Button)this.getSkinnable()).getContextMenu()) != null && contextMenu.isShowing()) {
                contextMenu.hide();
                Utils.removeMnemonics(contextMenu, ((Button)this.getSkinnable()).getScene());
            }
        } else if (string == "PARENT" && ((Button)this.getSkinnable()).getParent() == null && this.getScene() != null) {
            if (((Button)this.getSkinnable()).isDefaultButton()) {
                this.getScene().getAccelerators().remove(this.defaultAcceleratorKeyCodeCombination);
            }
            if (((Button)this.getSkinnable()).isCancelButton()) {
                this.getScene().getAccelerators().remove(this.cancelAcceleratorKeyCodeCombination);
            }
        }
    }

    private void setDefaultButton(boolean bl) {
        KeyCode keyCode = KeyCode.ENTER;
        this.defaultAcceleratorKeyCodeCombination = new KeyCodeCombination(keyCode, new KeyCombination.Modifier[0]);
        if (!bl) {
            Runnable runnable = (Runnable)((Button)this.getSkinnable()).getParent().getScene().getAccelerators().get(this.defaultAcceleratorKeyCodeCombination);
            if (!this.defaultButtonRunnable.equals(runnable)) {
                ((Button)this.getSkinnable()).getParent().getScene().getAccelerators().remove(this.defaultAcceleratorKeyCodeCombination);
            }
        } else {
            Runnable runnable = (Runnable)((Button)this.getSkinnable()).getParent().getScene().getAccelerators().get(this.defaultAcceleratorKeyCodeCombination);
        }
        ((Button)this.getSkinnable()).getParent().getScene().getAccelerators().put(this.defaultAcceleratorKeyCodeCombination, this.defaultButtonRunnable);
    }

    private void setCancelButton(boolean bl) {
        KeyCode keyCode = KeyCode.ESCAPE;
        this.cancelAcceleratorKeyCodeCombination = new KeyCodeCombination(keyCode, new KeyCombination.Modifier[0]);
        if (!bl) {
            Runnable runnable = (Runnable)((Button)this.getSkinnable()).getParent().getScene().getAccelerators().get(this.cancelAcceleratorKeyCodeCombination);
            if (!this.defaultButtonRunnable.equals(runnable)) {
                ((Button)this.getSkinnable()).getParent().getScene().getAccelerators().remove(this.cancelAcceleratorKeyCodeCombination);
            }
        } else {
            Runnable runnable = (Runnable)((Button)this.getSkinnable()).getParent().getScene().getAccelerators().get(this.cancelAcceleratorKeyCodeCombination);
        }
        ((Button)this.getSkinnable()).getParent().getScene().getAccelerators().put(this.cancelAcceleratorKeyCodeCombination, this.cancelButtonRunnable);
    }
}

