"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Electron = require("electron");
var url = require("url");
var pointInRect_1 = require("../lib/pointInRect");
var isInView = function (win) {
    var windowBounds = win.getBounds();
    var nearestWorkArea = Electron.screen.getDisplayMatching(windowBounds).workArea;
    var upperLeftVisible = pointInRect_1.pointInRectangle([windowBounds.x, windowBounds.y], nearestWorkArea);
    var lowerRightVisible = pointInRect_1.pointInRectangle([windowBounds.x + windowBounds.width, windowBounds.y + windowBounds.height], nearestWorkArea);
    return upperLeftVisible || lowerRightVisible;
};
exports.isInView = isInView;
var isMatchingHost = function (_url, _baseUrl) { return url.parse(_url).host === url.parse(_baseUrl).host; };
exports.isMatchingHost = isMatchingHost;
//# sourceMappingURL=util.js.map