/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignature;
import org.jetbrains.kotlin.resolve.calls.results.SimpleConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.results.SpecificityComparisonCallbacks;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.NewCapturedTypeKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a<\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"isSignatureNotLessSpecific", "", "T", "Lorg/jetbrains/kotlin/resolve/calls/results/SimpleConstraintSystem;", "specific", "Lorg/jetbrains/kotlin/resolve/calls/results/FlatSignature;", "general", "callbacks", "Lorg/jetbrains/kotlin/resolve/calls/results/SpecificityComparisonCallbacks;", "specificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "resolution"})
public final class FlatSignatureKt {
    public static final <T> boolean isSignatureNotLessSpecific(@NotNull SimpleConstraintSystem $receiver, @NotNull FlatSignature<? extends T> specific, @NotNull FlatSignature<? extends T> general, @NotNull SpecificityComparisonCallbacks callbacks, @NotNull TypeSpecificityComparator specificityComparator) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(specific, "specific");
        Intrinsics.checkParameterIsNotNull(general, "general");
        Intrinsics.checkParameterIsNotNull(callbacks, "callbacks");
        Intrinsics.checkParameterIsNotNull(specificityComparator, "specificityComparator");
        if (specific.getHasExtensionReceiver() != general.getHasExtensionReceiver()) {
            return false;
        }
        if (specific.getValueParameterTypes().size() != general.getValueParameterTypes().size()) {
            return false;
        }
        Collection<TypeParameterDescriptor> typeParameters2 = general.getTypeParameters();
        TypeSubstitutor typeSubstitutor2 = $receiver.registerTypeVariables(typeParameters2);
        for (Pair pair : CollectionsKt.zip((Iterable)specific.getValueParameterTypes(), (Iterable)general.getValueParameterTypes())) {
            KotlinType substitutedGeneralType;
            UnwrappedType unwrappedType;
            UnwrappedType unwrappedType2;
            KotlinType specificType = (KotlinType)pair.component1();
            KotlinType generalType = (KotlinType)pair.component2();
            if (specificType == null || generalType == null) continue;
            if (specificityComparator.isDefinitelyLessSpecific(specificType, generalType)) {
                return false;
            }
            if (typeParameters2.isEmpty() || !TypeUtils.dependsOnTypeParameters(generalType, typeParameters2)) {
                if (KotlinTypeChecker.DEFAULT.isSubtypeOf(specificType, generalType) || callbacks.isNonSubtypeNotLessSpecific(specificType, generalType)) continue;
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull(typeSubstitutor2.safeSubstitute(generalType, Variance.INVARIANT), "typeSubstitutor.safeSubs\u2026Type, Variance.INVARIANT)");
            UnwrappedType it = unwrappedType2 = specificType.unwrap();
            if ($receiver.getCaptureFromArgument()) {
                unwrappedType = NewCapturedTypeKt.captureFromExpression(it);
                if (unwrappedType == null) {
                    unwrappedType = it;
                }
            } else {
                unwrappedType = it;
            }
            UnwrappedType specificCapturedType = unwrappedType;
            $receiver.addSubtypeConstraint(specificCapturedType, substitutedGeneralType.unwrap());
        }
        return !$receiver.hasContradiction();
    }
}

