/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class HyperChemReader
extends AtomSetCollectionReader {
    private int atomIndex;

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.length() == 0 || this.line.charAt(0) == ';') {
            return true;
        }
        if (this.line.startsWith("mol ")) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.processMol();
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith("atom ")) {
            this.processAtom();
            return true;
        }
        if (this.line.startsWith("endmol ")) {
            this.applySymmetryAndSetTrajectory();
            return true;
        }
        return true;
    }

    private void processMol() throws Exception {
        this.asc.newAtomSet();
        String string = this.getMolName();
        this.asc.setAtomSetName(string);
        this.atomIndex = 0;
        this.baseAtomIndex = this.asc.ac;
    }

    private String getMolName() {
        this.parseTokenStr(this.line);
        this.parseToken();
        return this.parseToken();
    }

    private void processAtom() throws Exception {
        int n = this.parseIntAt(this.line, 5);
        if (n - 1 != this.atomIndex) {
            throw new Exception("bad atom number sequence ... expected:" + (this.atomIndex + 1) + " found:" + n);
        }
        Atom atom = this.asc.addNewAtom();
        this.parseToken();
        atom.elementSymbol = this.parseToken();
        this.parseToken();
        this.parseToken();
        atom.partialCharge = this.parseFloat();
        this.setAtomCoordXYZ(atom, this.parseFloat(), this.parseFloat(), this.parseFloat());
        int n2 = this.parseInt();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.parseInt();
            String string = this.parseToken();
            if (n4 <= this.atomIndex) {
                int n5;
                switch (string.charAt(0)) {
                    case 's': {
                        n5 = 1;
                        break;
                    }
                    case 'd': {
                        n5 = 2;
                        break;
                    }
                    case 't': {
                        n5 = 3;
                        break;
                    }
                    case 'a': {
                        n5 = 515;
                        break;
                    }
                    default: {
                        throw new Exception("unrecognized bond type:" + string + " atom #" + n);
                    }
                }
                this.asc.addNewBondWithOrder(this.baseAtomIndex + this.atomIndex, this.baseAtomIndex + n4 - 1, n5);
            }
            ++n3;
        }
        ++this.atomIndex;
    }
}

