/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import javajs.util.M3;
import javajs.util.Matrix;
import javajs.util.PT;
import org.jmol.adapter.readers.cif.Cif2DataParser;
import org.jmol.adapter.readers.cif.CifReader;
import org.jmol.adapter.readers.cif.MSRdr;

public class MSCifParser
extends MSRdr {
    private String field;
    private static final int FWV_ID = 0;
    private static final int WV_ID = 1;
    private static final int WV_X = 2;
    private static final int WV_Y = 3;
    private static final int WV_Z = 4;
    private static final int FWV_X = 5;
    private static final int FWV_Y = 6;
    private static final int FWV_Z = 7;
    private static final int FWV_Q_COEF = 8;
    private static final int JANA_FWV_Q1_COEF = 9;
    private static final int JANA_FWV_Q2_COEF = 10;
    private static final int JANA_FWV_Q3_COEF = 11;
    private static final int FWV_DISP_LABEL = 12;
    private static final int FWV_DISP_AXIS = 13;
    private static final int FWV_DISP_SEQ_ID = 14;
    private static final int FWV_DISP_COS = 15;
    private static final int FWV_DISP_SIN = 16;
    private static final int FWV_DISP_MODULUS = 17;
    private static final int FWV_DISP_PHASE = 18;
    private static final int DISP_SPEC_LABEL = 19;
    private static final int DISP_SAW_AX = 20;
    private static final int DISP_SAW_AY = 21;
    private static final int DISP_SAW_AZ = 22;
    private static final int DISP_SAW_C = 23;
    private static final int DISP_SAW_W = 24;
    private static final int FWV_OCC_LABEL = 25;
    private static final int FWV_OCC_SEQ_ID = 26;
    private static final int FWV_OCC_COS = 27;
    private static final int FWV_OCC_SIN = 28;
    private static final int FWV_OCC_MODULUS = 29;
    private static final int FWV_OCC_PHASE = 30;
    private static final int OCC_SPECIAL_LABEL = 31;
    private static final int OCC_CRENEL_C = 32;
    private static final int OCC_CRENEL_W = 33;
    private static final int FWV_U_LABEL = 34;
    private static final int FWV_U_TENS = 35;
    private static final int FWV_U_SEQ_ID = 36;
    private static final int FWV_U_COS = 37;
    private static final int FWV_U_SIN = 38;
    private static final int FWV_U_MODULUS = 39;
    private static final int FWV_U_PHASE = 40;
    private static final int FD_ID = 41;
    private static final int FO_ID = 42;
    private static final int FU_ID = 43;
    private static final int FDP_ID = 44;
    private static final int FOP_ID = 45;
    private static final int FUP_ID = 46;
    private static final int JANA_OCC_ABS_LABEL = 47;
    private static final int JANA_OCC_ABS_O_0 = 48;
    private static final int FWV_SPIN_LABEL = 49;
    private static final int FWV_SPIN_AXIS = 50;
    private static final int FWV_SPIN_SEQ_ID = 51;
    private static final int FWV_SPIN_COS = 52;
    private static final int FWV_SPIN_SIN = 53;
    private static final int FWV_SPIN_MODULUS = 54;
    private static final int FWV_SPIN_PHASE = 55;
    private static final int SPIN_SPEC_LABEL = 56;
    private static final int SPIN_SAW_AX = 57;
    private static final int SPIN_SAW_AY = 58;
    private static final int SPIN_SAW_AZ = 59;
    private static final int SPIN_SAW_C = 60;
    private static final int SPIN_SAW_W = 61;
    private static final int LEG_DISP_LABEL = 62;
    private static final int LEG_DISP_AXIS = 63;
    private static final int LEG_DISP_ORDER = 64;
    private static final int LEG_DISP_COEF = 65;
    private static final int LEG_U_LABEL = 66;
    private static final int LEG_U_TENS = 67;
    private static final int LEG_U_ORDER = 68;
    private static final int LEG_U_COEF = 69;
    private static final int LEG_OCC_LABEL = 70;
    private static final int LEG_OCC_ORDER = 71;
    private static final int LEG_OCC_COEF = 72;
    private static final int DEPR_FD_COS = 73;
    private static final int DEPR_FD_SIN = 74;
    private static final int DEPR_FO_COS = 75;
    private static final int DEPR_FO_SIN = 76;
    private static final int DEPR_FU_COS = 77;
    private static final int DEPR_FU_SIN = 78;
    private static final String[] modulationFields = new String[]{"*_fourier_wave_vector_seq_id", "_cell_wave_vector_seq_id", "_cell_wave_vector_x", "_cell_wave_vector_y", "_cell_wave_vector_z", "*_fourier_wave_vector_x", "*_fourier_wave_vector_y", "*_fourier_wave_vector_z", "*_fourier_wave_vector_q_coeff", "*_fourier_wave_vector_q1_coeff", "*_fourier_wave_vector_q2_coeff", "*_fourier_wave_vector_q3_coeff", "*_displace_fourier_atom_site_label", "*_displace_fourier_axis", "*_displace_fourier_wave_vector_seq_id", "*_displace_fourier_param_cos", "*_displace_fourier_param_sin", "*_displace_fourier_param_modulus", "*_displace_fourier_param_phase", "*_displace_special_func_atom_site_label", "*_displace_special_func_sawtooth_ax", "*_displace_special_func_sawtooth_ay", "*_displace_special_func_sawtooth_az", "*_displace_special_func_sawtooth_c", "*_displace_special_func_sawtooth_w", "*_occ_fourier_atom_site_label", "*_occ_fourier_wave_vector_seq_id", "*_occ_fourier_param_cos", "*_occ_fourier_param_sin", "*_occ_fourier_param_modulus", "*_occ_fourier_param_phase", "*_occ_special_func_atom_site_label", "*_occ_special_func_crenel_c", "*_occ_special_func_crenel_w", "*_u_fourier_atom_site_label", "*_u_fourier_tens_elem", "*_u_fourier_wave_vector_seq_id", "*_u_fourier_param_cos", "*_u_fourier_param_sin", "*_u_fourier_param_modulus", "*_u_fourier_param_phase", "*_displace_fourier_id", "*_occ_fourier_id", "*_u_fourier_id", "*_displace_fourier_param_id", "*_occ_fourier_param_id", "*_u_fourier_param_id", "*_occ_fourier_absolute_site_label", "*_occ_fourier_absolute", "*_moment_fourier_atom_site_label", "*_moment_fourier_axis", "*_moment_fourier_wave_vector_seq_id", "*_moment_fourier_param_cos", "*_moment_fourier_param_sin", "*_moment_fourier_param_modulus", "*_moment_fourier_param_phase", "*_moment_special_func_atom_site_label", "*_moment_special_func_sawtooth_ax", "*_moment_special_func_sawtooth_ay", "*_moment_special_func_sawtooth_az", "*_moment_special_func_sawtooth_c", "*_moment_special_func_sawtooth_w", "*_displace_legendre_atom_site_label", "*_displace_legendre_axis", "*_displace_legendre_param_order", "*_displace_legendre_param_coeff", "*_u_legendre_atom_site_label", "*_u_legendre_tens_elem", "*_u_legendre_param_order", "*_u_legendre_param_coeff", "*_occ_legendre_atom_site_label", "*_occ_legendre_param_order", "*_occ_legendre_param_coeff", "*_displace_fourier_cos", "*_displace_fourier_sin", "*_occ_fourier_cos", "*_occ_fourier_sin", "*_u_fourier_cos", "*_u_fourier_sin"};
    private static final int NONE = -1;
    private M3 comSSMat;

    public void processEntry() throws Exception {
        CifReader cifReader = (CifReader)this.cr;
        if (cifReader.key.equals("_cell_commen_t_section_1")) {
            this.isCommensurate = true;
            this.commensurateSection1 = cifReader.parseIntStr(cifReader.data);
        }
        if (cifReader.key.startsWith("_cell_commen_supercell_matrix")) {
            this.isCommensurate = true;
            if (this.comSSMat == null) {
                this.comSSMat = M3.newM3(null);
            }
            String[] stringArray = PT.split(cifReader.key, "_");
            int n = cifReader.parseIntStr(stringArray[stringArray.length - 2]);
            int n2 = cifReader.parseIntStr(stringArray[stringArray.length - 1]);
            if (n > 0 && n2 > 0) {
                this.comSSMat.setElement(n - 1, n2 - 1, cifReader.parseFloatStr(cifReader.data));
            }
        }
    }

    public int processLoopBlock() throws Exception {
        CifReader cifReader = (CifReader)this.cr;
        String string = cifReader.key;
        if (string.equals("_cell_subsystem_code")) {
            return this.processSubsystemLoopBlock();
        }
        if (!(string.startsWith("_cell_wave") || string.contains("fourier") || string.contains("legendre") || string.contains("_special_func"))) {
            if (string.contains("crenel_ortho")) {
                cifReader.appendLoadNote("WARNING: Orthogonalized non-Legendre functions not supported.\nThe following block has been ignored. Use Legendre functions instead.\n\n" + cifReader.parser.skipLoop(true) + "=================================\n");
            }
            return 0;
        }
        if (cifReader.asc.iSet < 0) {
            cifReader.asc.newAtomSet();
        }
        cifReader.parseLoopParametersFor("_atom_site", modulationFields);
        block40: while (cifReader.parser.getData()) {
            int n;
            boolean bl = false;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN};
            double[] dArray2 = null;
            double d = Double.NaN;
            double d2 = Double.NaN;
            String string5 = null;
            int n2 = cifReader.parser.getColumnCount();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.fieldProperty(cifReader, n3);
                block0 : switch (n4) {
                    case 1: {
                        cifReader.haveCellWaveVector = true;
                    }
                    case 0: 
                    case 41: 
                    case 42: 
                    case 43: {
                        dArray[2] = 0.0;
                        dArray[1] = 0.0;
                        dArray[0] = 0.0;
                    }
                    case 14: 
                    case 26: 
                    case 36: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 51: {
                        switch (n4) {
                            case 1: {
                                string2 = "W_";
                                break;
                            }
                            case 0: {
                                string2 = "F_";
                                string5 = this.field;
                                break;
                            }
                            case 41: 
                            case 42: 
                            case 43: {
                                string5 = "?" + this.field;
                                dArray[2] = 1.0;
                                break block0;
                            }
                            case 44: 
                            case 45: 
                            case 46: {
                                string4 = "*";
                                string3 = "*";
                            }
                            case 14: 
                            case 26: 
                            case 36: 
                            case 51: {
                                string2 = String.valueOf(Character.toUpperCase(modulationFields[n4].charAt(11))) + "_";
                            }
                        }
                        string2 = String.valueOf(string2) + this.field;
                        break;
                    }
                    case 47: {
                        string2 = "J_O";
                        dArray[2] = 1.0;
                        dArray[0] = 1.0;
                        string4 = "0";
                        string3 = this.field;
                        break;
                    }
                    case 31: {
                        string2 = "O_0";
                        string4 = "0";
                        string3 = this.field;
                        break;
                    }
                    case 19: {
                        string2 = "D_S";
                        string4 = "0";
                        string3 = this.field;
                        break;
                    }
                    case 56: {
                        string2 = "M_T";
                        string4 = "0";
                        string3 = this.field;
                        break;
                    }
                    case 62: {
                        string2 = "D_L";
                        string3 = this.field;
                        break;
                    }
                    case 66: {
                        string2 = "U_L";
                        string3 = this.field;
                        break;
                    }
                    case 70: {
                        string2 = "O_L";
                        string3 = this.field;
                        break;
                    }
                    case 12: 
                    case 25: 
                    case 34: 
                    case 49: {
                        string3 = this.field;
                        break;
                    }
                    case 13: 
                    case 50: 
                    case 63: {
                        string4 = this.field;
                        if (this.modAxes == null || this.modAxes.indexOf(string4.toUpperCase()) >= 0) break;
                        bl = true;
                        break;
                    }
                    case 35: 
                    case 67: {
                        string4 = this.field.toUpperCase();
                        break;
                    }
                    case 8: {
                        dArray2 = Cif2DataParser.getArrayFromStringList(this.field, this.modDim);
                        break;
                    }
                    default: {
                        float f = cifReader.parseFloatStr(this.field);
                        switch (n4) {
                            case 65: 
                            case 69: 
                            case 72: {
                                dArray[0] = f;
                                if (f == 0.0f) break block0;
                                dArray[2] = 0.0;
                                break block0;
                            }
                            case 16: 
                            case 28: 
                            case 32: 
                            case 38: 
                            case 53: 
                            case 74: 
                            case 76: 
                            case 78: {
                                dArray[2] = 0.0;
                            }
                            case 2: 
                            case 5: 
                            case 20: 
                            case 57: {
                                dArray[0] = f;
                                break block0;
                            }
                            case 9: {
                                if (dArray2 == null) {
                                    dArray2 = new double[this.modDim];
                                }
                                dArray2[0] = f;
                                break block0;
                            }
                            case 10: {
                                if (dArray2 == null) {
                                    dArray2 = new double[this.modDim];
                                }
                                dArray2[1] = f;
                                break block0;
                            }
                            case 11: {
                                if (dArray2 == null) {
                                    dArray2 = new double[this.modDim];
                                }
                                dArray2[2] = f;
                                break block0;
                            }
                            case 17: 
                            case 29: 
                            case 39: 
                            case 54: {
                                dArray[0] = f;
                                dArray[2] = 1.0;
                                break block0;
                            }
                            case 27: 
                            case 71: 
                            case 75: {
                                string4 = "0";
                            }
                            case 3: 
                            case 6: 
                            case 15: 
                            case 18: 
                            case 21: 
                            case 30: 
                            case 33: 
                            case 37: 
                            case 40: 
                            case 48: 
                            case 52: 
                            case 55: 
                            case 58: 
                            case 64: 
                            case 68: 
                            case 73: 
                            case 77: {
                                dArray[1] = f;
                                break block0;
                            }
                            case 4: 
                            case 7: 
                            case 22: 
                            case 59: {
                                dArray[2] = f;
                                break block0;
                            }
                            case 23: 
                            case 60: {
                                d = f;
                                break block0;
                            }
                            case 24: 
                            case 61: {
                                d2 = f;
                            }
                        }
                    }
                }
                ++n3;
            }
            if (bl || string2 == null && dArray2 == null || string3 != null && !string3.equals("*") && cifReader.rejectAtomName(string3)) continue;
            n3 = 1;
            if (dArray2 != null) {
                int n5 = 0;
                n = dArray2.length;
                while (n5 < dArray2.length) {
                    if (Double.isNaN(dArray2[n5]) || dArray2[n5] > 1.0E100 || dArray2[n5] == 0.0 && --n == 0) {
                        n3 = 0;
                    }
                    ++n5;
                }
                if (n3 == 0) continue;
                this.addMod("F_coefs_", string5, dArray2);
                dArray[0] = Double.NaN;
            }
            int n6 = 0;
            n = dArray.length;
            while (n6 < dArray.length) {
                if (Double.isNaN(dArray[n6]) || dArray[n6] > 1.0E100 || dArray[n6] == 0.0 && --n == 0) {
                    n3 = 0;
                    break;
                }
                ++n6;
            }
            if (n3 == 0) continue;
            switch (string2.charAt(0)) {
                case 'C': 
                case 'D': 
                case 'J': 
                case 'M': 
                case 'O': 
                case 'U': {
                    if (string3 == null || string4 == null) continue block40;
                    if (string2.equals("D_S") || string2.equals("M_T")) {
                        if (Double.isNaN(d) || Double.isNaN(d2)) continue block40;
                        if (dArray[0] != 0.0) {
                            this.addMod(String.valueOf(string2) + "#x;" + string3, string5, new double[]{d, d2, dArray[0]});
                        }
                        if (dArray[1] != 0.0) {
                            this.addMod(String.valueOf(string2) + "#y;" + string3, string5, new double[]{d, d2, dArray[1]});
                        }
                        if (dArray[2] == 0.0) continue block40;
                        this.addMod(String.valueOf(string2) + "#z;" + string3, string5, new double[]{d, d2, dArray[2]});
                        break;
                    }
                    if (string2.indexOf("_L") == 1) {
                        if (string2.startsWith("U")) {
                            string2 = String.valueOf(string2) + (int)dArray[1];
                        } else {
                            string4 = String.valueOf(string4) + (int)dArray[1];
                        }
                    }
                    string2 = String.valueOf(string2) + "#" + string4 + ";" + string3;
                }
                default: {
                    this.addMod(string2, string5, dArray);
                }
            }
        }
        return 1;
    }

    private void addMod(String string, String string2, double[] dArray) {
        if (string2 != null) {
            string = String.valueOf(string) + string2;
        }
        this.addModulation(null, string, dArray, -1);
    }

    private int processSubsystemLoopBlock() throws Exception {
        CifReader cifReader = (CifReader)this.cr;
        cifReader.parseLoopParameters(null);
        while (cifReader.parser.getData()) {
            this.fieldProperty(cifReader, 0);
            String string = this.field;
            this.addSubsystem(string, this.getSparseMatrix(cifReader, "_w_", 1, 3 + this.modDim));
        }
        return 1;
    }

    private Matrix getSparseMatrix(CifReader cifReader, String string, int n, int n2) {
        Matrix matrix = new Matrix(null, n2, n2);
        double[][] dArray = matrix.getArray();
        int n3 = cifReader.parser.getColumnCount();
        while (n < n3) {
            String string2;
            int n4 = this.fieldProperty(cifReader, n);
            if (n4 >= 0 && (string2 = cifReader.parser.getColumnName(n4)).contains(string)) {
                String[] stringArray = PT.split(string2, "_");
                int n5 = cifReader.parseIntStr(stringArray[stringArray.length - 2]);
                int n6 = cifReader.parseIntStr(stringArray[stringArray.length - 1]);
                if (n5 > 0 && n6 > 0) {
                    dArray[n5 - 1][n6 - 1] = cifReader.parseFloatStr(this.field);
                }
            }
            ++n;
        }
        return matrix;
    }

    private int fieldProperty(CifReader cifReader, int n) {
        this.field = (String)cifReader.parser.getColumnData(n);
        return this.field.length() > 0 && this.field.charAt(0) != '\u0000' ? cifReader.col2key[n] : -1;
    }
}

