**Note:** This file is automatically generated. Please see the [developer
documentation](doc/development/changelog.md) for instructions on adding your own
entry.

## 11.8.2 (2019-03-13)

### Security (1 change)

- Fixed ability to see private groups by users not belonging to given group.

### Fixed (5 changes)

- Fix import_jid error on project import. !25239
- Properly handle multiple X-Forwarded-For addresses in runner IP. !25511
- Fix error when viewing group issue boards when user doesn't have explicit group permissions. !25524
- Fix method to mark a project repository as writable. !25546
- Allow project members to see private group if the project is in the group namespace.


## 11.8.1 (2019-02-28)

### Security (21 changes)

- Stop linking to unrecognized package sources. !55518
- Don't allow non-members to see private related MRs.
- Do not display impersonated sessions under active sessions and remove ability to revoke session.
- Display only information visible to current user on the Milestone page.
- Show only merge requests visible to user on milestone detail page.
- Disable issue boards API when issues are disabled.
- Don't show new issue link after move when a user does not have permissions.
- Fix git clone revealing private repo's presence.
- Fix blind SSRF in Prometheus integration by checking URL before querying.
- Check snippet attached file to be moved is within designated directory.
- Check if desired milestone for an issue is available.
- Fix arbitrary file read via diffs during import.
- Display the correct number of MRs a user has access to.
- Forbid creating discussions for users with restricted access.
- Do not disclose milestone titles for unauthorized users.
- Validate session key when authorizing with GCP to create a cluster.
- Block local URLs for Kubernetes integration.
- Limit mermaid rendering to 5K characters.
- Remove the possibility to share a project with a group that a user is not a member of.
- Fix leaking private repository information in API.
- Prevent releases links API to leak tag existance.


## 11.8.0 (2019-02-22)

### Security (7 changes, 1 of them is from the community)

- Sanitize user full name to clean up any URL to prevent mail clients from auto-linking URLs. !2793
- Update Helm to 2.12.2 to address Helm client vulnerability. !24418 (Takuya Noguchi)
- Use sanitized user status message for user popover.
- Validate bundle files before unpacking them.
- Alias GitHub and BitBucket OAuth2 callback URLs.
- Fixed XSS content in KaTex links.
- Disallows unauthorized users from accessing the pipelines section.

### Removed (2 changes, 1 of them is from the community)

- Removed deprecated Redcarpet markdown engine.
- Remove Cancel all jobs button in general jobs list view. (Jordi Llull)

### Fixed (84 changes, 20 of them are from the community)

- Fix ambiguous brackets in task lists. !18514 (Jared Deckard <jared.deckard@gmail.com>)
- Fix lost line number when navigating to a specific line in a protected file before authenticating. !19165 (Scott Escue)
- Fix suboptimal handling of checkbox and radio input events causing group general settings submit button to stay disabled after changing its visibility. !23022
- Fix upcoming milestones filter not including group milestones. !23098 (Heinrich Lee Yu)
- Update runner admin page to make description field larger. !23593 (Sascha Reynolds)
- Fix Bitbucket Server import not allowing personal projects. !23601
- Fix bug causing repository mirror settings UI to break. !23712
- Fix foreground color for labels to ensure consistency of label appearance. !23873 (Nathan Friend)
- Resolve In Merge Request diff screen, master is not a hyperlink. !23874
- Show the correct error page when access is denied. !23932
- Increase reliability and performance of toggling task items. !23938
- Modify file restore to rectify tar issue. !24000
- Fix default visibility_level for new projects. !24120 (Fabian Schneider @fabsrc)
- Footnotes now render properly in markdown. !24168
- Emoji and cancel button are taller than input in set user status modal. !24173 (Dhiraj Bodicherla)
- Adjusts duplicated line when commenting on unfolded diff lines (in the bottom). !24201
- Adjust height of "Add list" dropdown in issue boards. !24227
- Improves restriction of multiple Kubernetes clusters through API. !24251
- Fix files/blob api endpoints content disposition. !24267
- Cleanup stale +deleted repo paths on project removal (adjusts project removal bug). !24269
- Handle regular job dependencies next to parallelized job dependencies. !24273
- Proper align Projects dropdown on issue boards page. !24277 (Johann Hubert Sonntagbauer)
- Resolve When merging an MR, the squash checkbox isnt always supported. !24296
- Fix Bitbucket Server importer error handling. !24343
- Fix syntax highlighting for suggested changes preview. !24358
- API: Support dots in wiki slugs. !24383 (Robert Schilling)
- Show CI artifact file size with 3 significant digits on 'browse job artifacts' page. !24387
- API: Support username with dots. !24395 (Robert Schilling)
- API: Fix default_branch_protection admin setting. !24398 (Robert Schilling)
- Remove unwanted margin above suggested changes. !24419
- Prevent checking protected_ref? for ambiguous refs. !24437
- Update metrics environment dropdown to show complete option set. !24441
- Fix empty labels of CI builds for gitlab-pages on pipeline page. !24451
- Do not run spam checks on confidential issues. !24453
- Upgrade KaTeX to version 0.10.0. !24478 (Andrew Harmon)
- Avoid overwriting default jaeger values with nil. !24482
- Display SAML failure messages instead of expecting CSRF token. !24509
- Adjust vertical alignment for project visibility icons. !24511 (Martin Hobert)
- Load initUserInternalRegexPlaceholder only when required. !24522
- Hashed Storage: `AfterRenameService` was receiving the wrong `old_path` under some circunstances. !24526
- Resolve Runners IPv6 address overlaps other values. !24531
- Fix 404s with snippet uploads in object storage. !24550
- Fixed oversized custom project notification selector dropdown. !24557
- Allow users with full private access to read private personal snippets. !24560
- Resolve Pipeline stages job action button icon is not aligned. !24577
- Fix cluster page non-interactive on form validation error. !24583
- Fix 404s for snippet uploads when relative URL root used. !24588
- Fix markdown table border. !24601
- Fix CSS grid on a new Project/Group Milestone. !24614 (Takuya Noguchi)
- Prevent unload when Recaptcha is open. !24625
- Clean up unicorn sampler metric labels. !24626 (bjk-gitlab)
- Support bamboo api polymorphism. !24680 (Alex Lossent)
- Ensure Cert Manager works with Auto DevOps URLs greater than 64 bytes. !24683
- Fix failed LDAP logins when nil user_id present. !24749
- fix display comment avatars issue in IE 11. !24777 (Gokhan Apaydin)
- Fix template labels not being created on new projects. !24803
- Fix cluster installation processing spinner. !24814
- Append prioritized label before pagination. !24815
- Resolve UI bug adding group members with lower permissions. !24820
- Make `ActionController::Parameters` serializable for sidekiq jobs. !24864
- Fix Jira Service password validation on project integration services. !24896 (Daniel Juarez)
- Fix potential Addressable::URI::InvalidURIError. !24908
- Update Workhorse to v8.2.0. !24909
- Encode Content-Disposition filenames. !24919
- Avoid race conditions when creating GpgSignature. !24939
- Create the source branch for a GitHub import. !25064
- Fix suggested changes syntax highlighting. !25116
- Fix counts in milestones dashboard. !25230
- Fixes incorrect TLD validation errors for Kubernetes cluster domain. !25262
- Fix 403 errors when adding an assignee list in project boards. !25263
- Prevent Auto DevOps from trying to deploy without a domain name. !25308
- Fix uninitialized constant with GitLab Pages.
- Increase line height of project summaries. (gfyoung)
- Remove extra space between MR tab bar and sticky file headers.
- Correct spacing for comparison page.
- Update CI YAML param table with include.
- Return bottom border on MR Tabs.
- Fixes z-index and margins of archived alert in job page.
- Fixes archived sticky top bar without perfomance bar.
- Fixed rebase button not showing in merge request widget.
- Fixed double tooltips on note awards buttons.
- Allow suggestions to be copied and pasted as GFM.
- Fix bug that caused Suggestion Markdown toolbar button to insert snippet with leading +/-/<space>.
- Moved primary button for labels to follow the design patterns used on rest of the site. (Martin Hobert)

### Changed (37 changes, 11 of them are from the community)

- Change spawning of tooltips to be top by default. !21223
- Standardize filter value capitlization in filter bar in both issues and boards pages. !23846 (obahareth)
- Refresh group overview to match project overview. !23866
- Build number does not need to be tweaked anymore for the TeamCity integration to work properly. !23898
- Added empty project illustration and updated text to user profile overview. !23973 (Fernando Arias)
- Modified Knative list view to provide more details. !24072 (Chris Baumbauer)
- Move cancel & new issue button on job page. !24074
- Make issuable empty states actionable. !24077
- Fix code search when text is larger than max gRPC message size. !24111
- Update string structure for available group runners. !24187 (George Tsiolis)
- Remove multilingual translation from the word "in" in the job details sidebar. !24192 (Nathan Friend)
- Fix duplicate project disk path in BackfillLegacyProjectRepositories. !24213
- Ensured links to a comment or system note anchor resolves to the right note if a user has a discussion filter. !24228
- Remove expansion hover animation from pipeline status icon buttons. !24268 (Nathan Friend)
- Redesigned related merge requests in issue page. !24270
- Return the maximum group access level in the projects API. !24403
- Update project topics styling to use badges design. !24415
- Display "commented" only for commit discussions on merge requests. !24427
- Upgrade js-regex gem to version 3.1. !24433 (rroger)
- Prevent Sidekiq arguments over 10 KB in size from being logged to JSON. !24493
- Added Avatar in the settings sidebar. !24515 (Yoginth)
- Refresh empty states for profile page tabs. !24549
- remove red/green colors from diff view of no-color syntax theme. !24582 (khm)
- Get remote IP address of runner. !24624
- Update last_activity_on for Users on some main GET endpoints. !24642
- Update metrics dashboard graph design. !24653
- Update to GitLab SVG icon from Font Awesome in profile for location and work. !24671 (Yoginth)
- Add template for Android with Fastlane. !24722
- Display timestamps to messages printed by gitlab:backup:restore rake tasks. (Will Chandler)
- Show MR statistics in diff comparisons.
- Make possible to toggle file tree while scrolling through diffs.
- Use delete instead of remove when referring to `git branch -D`.
- Add folder header to files in merge request tree list.
- Added fuzzy file finder to merge requests.
- Collapse directory structure in merge request file tree.
- Adds skeleton loading to releases page.
- Support multiple outputs in jupyter notebooks.

### Performance (8 changes, 1 of them is from the community)

- Remove unused button classes `btn-create` and `comment-btn`. !23232 (George Tsiolis)
- [API] Omit `X-Total` and `X-Total-Pages` headers when items count is more than 10,000. !23931
- Improve efficiency of GitHub importer by reducing amount of locks needed. !24102
- Improve milestone queries using subqueries instead of separate queries for ids. !24325
- Efficiently remove expired artifacts in `ExpireBuildArtifactsWorker`. !24450
- Eliminate N+1 queries in /api/groups/:id. !24513
- Use deployment relation to get an environment name. !24890
- Do not reload daemon if configuration file of pages does not change.

### Added (35 changes, 18 of them are from the community)

- Add badge count to projects. !18425 (George Tsiolis)
- API: Add support for group labels. !21368 (Robert Schilling)
- Add setting for first day of the week. !22755 (Fabian Schneider @fabsrc)
- Pages for subgroups. !23505
- Add support for customer provided encryption keys for Amazon S3 remote backups. !23797 (Pepijn Van Eeckhoudt)
- Add Knative detailed view. !23863 (Chris Baumbauer)
- Add group full path to project's shared_with_groups. !24052 (Mathieu Parent)
- Added feature to specify a custom Auto DevOps chart repository. !24162 (walkafwalka)
- Add flat-square badge style. !24172 (Fabian Schneider @fabsrc)
- Display last activity and created at datetimes for users. !24181
- Allow setting of feature gates per project. !24184
- Save issues/merge request sorting options to backend. !24198
- Added support for custom hosts/domains to Auto DevOps. !24248 (walkafwalka)
- Adds milestone search. !24265 (Jacopo Beschi @jacopo-beschi)
- Allow merge request diffs to be placed into an object store. !24276
- Add Container Registry API with cleanup function. !24303
- GitLab now supports the profile and email scopes from OpenID Connect. !24335 (Goten Xiao)
- Add 'in' filter that modifies scope of 'search' filter to issues and merge requests API. !24350 (Hiroyuki Sato)
- Add `with_programming_language` filter for projects to API. !24377 (Dylan MacKenzie)
- API: Support searching for tags. !24385 (Robert Schilling)
- Document graphicsmagick installation for source installation. !24404 (Alexis Reigel)
- Redirect GET projects/:id to project page. !24467
- Indicate on Issue Status if an Issue was Moved. !24470
- Redeploy Auto DevOps deployment on variable updates. !24498 (walkafwalka)
- Don't create new merge request pipeline without commits. !24503 (Hiroyuki Sato)
- Add GitLab Pages predefined CI variables 'CI_PAGES_DOMAIN' and 'CI_PAGES_URL'. !24504 (Adrian Moisey)
- Moves domain setting from Auto DevOps to Cluster's page. !24580
- API allows setting the squash commit message when squashing a merge request. !24784
- Added ability to upgrade cluster applications. !24789
- Add argument iids for issues in GraphQL. !24802
- Add repositories count to usage ping data. !24823
- Add support for extensionless pages URLs. !24876
- Add templates for most popular Pages templates. !24906
- Introduce Internal API for searching environment names. !24923
- Allow admins to invalidate markdown texts by setting local markdown version.

### Other (50 changes, 18 of them are from the community)

- Externalize strings from `/app/views/projects/project_members`. !23227 (Tao Wang)
- Add CSS & JS global flags to represent browser and platform. !24017
- Fix deprecation: Passing an argument to force an association to reload is now deprecated. !24136 (Jasper Maes)
- Cleanup legacy artifact background migration. !24144
- Bump kubectl in Auto DevOps to 1.11.6. !24176
- Conditionally initialize the global opentracing tracer. !24186
- Remove horizontal whitespace on user profile overview on small breakpoints. !24189
- Bump nginx-ingress chart to 1.1.2. !24203
- Use monospace font for registry table tag id and tag name. !24205
- Rename project tags to project topics. !24219
- Add uniqueness validation to url column in Releases::Link model. !24223
- Update sidekiq-cron to 1.0.4 and use fugit to replace rufus-scheduler to parse cron syntax. !24235
- Adds inter-service OpenTracing propagation. !24239
- Fixes Auto DevOps title on CI/CD admin settings. !24249
- Upgrade kubeclient to 4.2.2 and swap out monkey-patch to disallow redirects. !24284
- i18n: externalize strings from 'app/views/search'. !24297 (Tao Wang)
- Fix several ActionController::Parameters deprecations. !24332 (Jasper Maes)
- Remove all `$theme-gray-{weight}` variables in favor of `$gray-{weight}`. !24333 (George Tsiolis)
- Update gitlab-styles to 2.5.1. !24336 (Jasper Maes)
- Modifies environment scope UI on cluster page. !24376
- Extract process_name from GitLab::Sentry. !24422
- Upgrade Gitaly to 1.13.0. !24429
- Actually set raise_on_unfiltered_parameters to true. !24443 (Jasper Maes)
- Refactored NoteableDiscussion by extracting ResolveDiscussionButton. !24505 (Martin Hobert)
- Extracted JumpToNextDiscussionButton to its own component. !24506 (Martin Hobert)
- Extracted ReplyPlaceholder to its own component. !24507 (Martin Hobert)
- Block emojis and symbol characters from users full names. !24523
- Update GitLab Runner Helm Chart to 0.1.45. !24564
- Updated docs for fields in pushing mirror from GitLab to GitHub. !24566 (Joseph Yu)
- Upgrade gitlab-workhorse to 8.1.0. !24571
- Externalize strings from `/app/views/sent_notifications`. !24576 (George Tsiolis)
- Adds tracing support for ActiveRecord notifications. !24604
- Externalize strings from `/app/views/projects/ci`. !24617 (George Tsiolis)
- Move permission check of manual actions of deployments. !24660
- Externalize strings from `/app/views/clusters`. !24666 (George Tsiolis)
- Update UI for admin appearance settings. !24685
- Externalize strings from `/app/views/projects/pages_domains`. !24723 (George Tsiolis)
- Externalize strings from `/app/views/projects/milestones`. !24726 (George Tsiolis)
- Add OpenTracing instrumentation for Action View Render events. !24728
- Expose version for each application in cluster_status JSON endpoint. !24791
- Externalize strings from `/app/views/instance_statistics`. !24809 (George Tsiolis)
- Update cluster application version on updated and installed status. !24810
- Project list UI improvements. !24855
- Externalize strings from `/app/views/email_rejection_mailer`. !24869 (George Tsiolis)
- Update Gitaly to v1.17.0. !24873
- Update Workhorse to v8.3.0. !24959
- Upgrade gitaly to 1.18.0. !24981
- Update Workhorse to v8.3.1.
- Upgraded Codesandbox smooshpack package.
- Creates mixin to reduce code duplication between CE and EE in graph component.


## 11.7.5 (2019-02-06)

### Fixed (8 changes)

- Fix import handling errors in Bitbucket Server importer. !24499
- Adjusts suggestions unable to be applied. !24603
- Fix 500 errors with legacy appearance logos. !24615
- Fix form functionality for edit tag page. !24645
- Update Workhorse to v8.0.2. !24870
- Downcase aliased OAuth2 callback providers. !24877
- Fix Detect Host Keys not working. !24884
- Changed external wiki query method to prevent attribute caching. !24907


## 11.7.2 (2019-01-29)

### Fixed (1 change)

- Fix uninitialized constant with GitLab Pages.


## 11.7.1 (2019-01-28)

### Security (24 changes)

- Make potentially malicious links more visible in the UI and scrub RTLO chars from links. !2770
- Don't process MR refs for guests in the notes. !2771
- Sanitize user full name to clean up any URL to prevent mail clients from auto-linking URLs. !2828
- Fixed XSS content in KaTex links.
- Disallows unauthorized users from accessing the pipelines section.
- Verify that LFS upload requests are genuine.
- Extract GitLab Pages using RubyZip.
- Prevent awarding emojis to notes whose parent is not visible to user.
- Prevent unauthorized replies when discussion is locked or confidential.
- Disable git v2 protocol temporarily.
- Fix showing ci status for guest users when public pipline are not set.
- Fix contributed projects info still visible when user enable private profile.
- Add subresources removal to member destroy service.
- Add more LFS validations to prevent forgery.
- Use common error for unauthenticated users when creating issues.
- Fix slow regex in project reference pattern.
- Fix private user email being visible in push (and tag push) webhooks.
- Fix wiki access rights when external wiki is enabled.
- Group guests are no longer able to see merge requests they don't have access to at group level.
- Fix path disclosure on project import error.
- Restrict project import visibility based on its group.
- Expose CI/CD trigger token only to the trigger owner.
- Notify only users who can access the project on project move.
- Alias GitHub and BitBucket OAuth2 callback URLs.


## 11.7.0 (2019-01-22)

### Security (14 changes, 1 of them is from the community)

- Escape label and milestone titles to prevent XSS in GFM autocomplete. !2693
- Bump Ruby on Rails to 5.0.7.1. !23396 (@blackst0ne)
- Delete confidential todos for user when downgraded to Guest.
- Project guests no longer are able to see refs page.
- Set URL rel attribute for broken URLs.
- Prevent leaking protected variables for ambiguous refs.
- Authorize before reading job information via API.
- Allow changing group CI/CD settings only for owners.
- Fix SSRF with import_url and remote mirror url.
- Don't expose cross project repositories through diffs when creating merge reqeusts.
- Validate bundle files before unpacking them.
- Issuable no longer is visible to users when project can't be viewed.
- Escape html entities in LabelReferenceFilter when no label found.
- Prevent private snippets from being embeddable.

### Removed (3 changes, 1 of them is from the community)

- Removes all instances of deprecated Gitlab Upgrader calls. !23603 (@jwolen)
- Removed discard draft comment button form notes. !24185
- Remove migration to backfill project_repositories for legacy storage projects. !24299

### Fixed (42 changes, 7 of them are from the community)

- Prevent awards emoji being updated when updating status. !23470
- Allow merge after rebase without page refresh on FF repositories. !23572
- Prevent admins from attempting hashed storage migration on read only DB. !23597
- Correct the ordering of metrics on the performance dashboard. !23630
- Display empty files properly on MR diffs. !23671 (Sean Nichols)
- Allow GitHub imports via token even if OAuth2 provider not configured. !23703
- Update header navigation theme colors. !23734 (George Tsiolis)
- Fix login box bottom margins on signin page. !23739 (@gear54)
- Return an ApplicationSetting in CurrentSettings. !23766
- Fix bug commenting on LFS images. !23812
- Only prompt user once when navigating away from file editor. !23820 (Sam Bigelow)
- Display commit ID for discussions made on merge request commits. !23837
- Stop autofocusing on diff comment after initial mount. !23849
- Fix object storage not working properly with Google S3 compatibility. !23858
- Fix project calendar feed when sorted by priority. !23870
- Fix edit button disappearing in issue title. !23948 (Ruben Moya)
- Aligns build loader animation with the job log. !23959
- Allow 'rake gitlab:cleanup:remote_upload_files' to read bucket files without having permissions to see all buckets. !23981
- Correctly externalize pipeline tags. !24028
- Fix error when creating labels in a new issue in the boards page. !24039 (Ruben Moya)
- Use 'parsePikadayDate' to parse due date string. !24045
- Fix commit SHA not showing in merge request compare dropdown. !24084
- Remove top margin in modal header titles. !24108
- Drop Webhooks from project import/export config. !24121
- Only validate project visibility when it has changed. !24142
- Resolve About this feature link should open in new window. !24149
- Add syntax highlighting to suggestion diff. !24156
- Fix Bitbucket Server import only including first 25 pull requests. !24178
- Enable caching for records which primary key is not `id`. !24245
- Adjust applied suggestion reverting previous changes. !24250
- Fix unexpected exception by failure of finding an actual head pipeline. !24257
- Fix broken templated "Too many changes to show" text. !24282
- Fix requests profiler in admin page not rendering HTML properly. !24291
- Fix no avatar not showing in user selection box. !24346
- Upgrade to gitaly 1.12.1. !24361
- Fix runner eternal loop when update job result. !24481
- Fix notification email for image diff notes.
- Fixed merge request diffs empty states.
- Fixed diff suggestions removing dashes.
- Don't hide CI dropdown behind diff summary. (gfyoung)
- Fix spacing on discussions.
- Fixes missing margin in releases block.

### Changed (22 changes, 8 of them are from the community)

- Show clusters of ancestors in cluster list page. !22996
- Remove unnecessary line before reply holder. !23092 (George Tsiolis)
- Make the Pages permission setting more clear. !23146
- Disable merging of labels with same names. !23265
- Allow basic authentication on go get middleware. !23497 (Morty Choi @mortyccp)
- No longer require email subaddressing for issue creation by email. !23523
- Adjust padding of .dropdown-title to comply with design specs. !23546
- Make commit IDs in merge request discussion header monospace. !23562
- Update environments breadcrumb. !23751 (George Tsiolis)
- Add date range in milestone change email notifications. !23762
- Require Knative to be installed only on an RBAC kubernetes cluster. !23807 (Chris Baumbauer)
- Fix label and header styles in the job details sidebar. !23816 (Nathan Friend)
- Add % prefix to milestone reference links. !23928
- Reorder sidebar menu item for group clusters. !24001 (George Tsiolis)
- Support CURD operation for Links as one of the Release assets. !24056
- Upgrade Omniauth and JWT gems to switch away from Google+ API. !24068
- Renames Milestone sort into Milestone due date. !24080 (Jacopo Beschi @jacopo-beschi)
- Discussion filter only displayed in discussions tab for merge requests. !24082
- Make RBAC enabled default for new clusters. !24119
- Hashed Storage: Only set as `read_only` when starting the per-project migration. !24128
- Knative version bump 0.1.3 -> 0.2.2. (Chris Baumbauer)
- Show message on non-diff discussions.

### Performance (7 changes)

- Fix some N+1 queries related to Admin Dashboard, User Dashboards and Activity Stream. !23034
- Add indexes to speed up CI query. !23188
- Improve the loading time on merge request's discussion page by caching diff highlight. !23857
- Cache avatar URLs and paths within a request. !23950
- Improve snippet search performance by removing duplicate counts. !23952
- Skip per-commit validations already evaluated. !23984
- Fix timeout issues retrieving branches via API. !24034

### Added (29 changes, 6 of them are from the community)

- Handle ci.skip push option. !15643 (Jonathon Reinhart)
- Add NGINX 0.16.0 and above metrics. !22133
- Add project milestone link. !22552
- Support tls communication in gitaly. !22602
- Add option to make ci variables protected by default. !22744 (Alexis Reigel)
- Add project identifier as List-Id email Header to ease filtering. !22817 (Olivier Crête)
- Add markdown helper buttons to file editor. !23480
- Allow to include templates in gitlab-ci.yml. !23495
- Extend override check to also check arity. !23498 (Jacopo Beschi @jacopo-beschi)
- Add importing of issues from CSV file. !23532
- Add submit feedback link to help dropdown. !23547
- Send a notification email to project maintainers when a mirror update fails. !23595
- Restore Object Pools when restoring an object pool. !23682
- Creates component for release block. !23697
- Configure Auto DevOps deployed applications with secrets from prefixed CI variables. !23719
- Add name, author_id, and sha to releases table. !23763
- Display a list of Sentry Issues in GitLab. !23770
- Releases API. !23795
- Creates frontend app for releases. !23796
- Add new pipeline variable CI_COMMIT_SHORT_SHA. !23822
- Create system notes on issue / MR creation when labels, milestone, or due date is set. !23859
- Adds API documentation for releases. !23901
- Add API Support for Kubernetes integration. !23922
- Expose CI/CD predefined variable `CI_API_V4_URL`. !23936
- Add Knative metrics to Prometheus. !23972 (Chris Baumbauer)
- Use reports syntax for Dependency scanning in Auto DevOps. !24081
- Allow to include files from another projects in gitlab-ci.yml. !24101
- User Popovers for Commit Infos, Member Lists and Snippets. !24132
- Add no-color theme for syntax highlighting. (khm)

### Other (45 changes, 30 of them are from the community)

- Redesign project lists UI. !22682
- [Rails5.1] Update functional specs to use new keyword format. !23095 (@blackst0ne)
- Update a condition to visibility a merge request collaboration message. !23104 (Harry Kiselev)
- Remove framework/mobile.scss. !23301 (Takuya Noguchi)
- Passing the separator argument as a positional parameter is deprecated. !23334 (Jasper Maes)
- Clarifies docs about CI `allow_failure`. !23367 (C.J. Jameson)
- Refactor issuable sidebar to use serializer. !23379
- Refactor the logic of updating head pipelines for merge requests. !23502
- Allow user to add Kubernetes cluster for clusterable when there are ancestor clusters. !23569
- Adds explanatory text to input fields on user profile settings page. !23673
- Externalize strings from `/app/views/shared/notes`. !23696 (Tao Wang)
- Remove rails 4 support in CI, Gemfiles, bin/ and config/. !23717 (Jasper Maes)
- Fix calendar events fetching error on private profile page. !23718 (Harry Kiselev)
- Update GitLab Workhorse to v8.0.0. !23740
- Hide confidential events in the API. !23746
- Changed Userpopover Fixtures and shadow color. !23768
- Fix deprecation: Passing conditions to delete_all is deprecated. !23817 (Jasper Maes)
- Fix deprecation: Passing ActiveRecord::Base objects to sanitize_sql_hash_for_assignment. !23818 (Jasper Maes)
- Remove rails4 specific code. !23847 (Jasper Maes)
- Remove deprecated ActionDispatch::ParamsParser. !23848 (Jasper Maes)
- Fix deprecation: Comparing equality between ActionController::Parameters and a Hash is deprecated. !23855 (Jasper Maes)
- Fix deprecation: Directly inheriting from ActiveRecord::Migration is deprecated. !23884 (Jasper Maes)
- Fix deprecation: alias_method_chain is deprecated. Please, use Module#prepend instead. !23887 (Jasper Maes)
- Update specs to exclude possible false positive pass. !23893 (@blackst0ne)
- Passing an argument to force an association to reload is now deprecated. !23894 (Jasper Maes)
- ActiveRecord::Migration -> ActiveRecord::Migration[5.0]. !23910 (Jasper Maes)
- Split bio into individual line in extended user tooltips. !23940
- Fix deprecation: redirect_to :back is deprecated. !23943 (Jasper Maes)
- Fix deprecation: insert_sql is deprecated and will be removed. !23944 (Jasper Maes)
- Upgrade @gitlab/ui to 1.16.2. !23946
- convert specs in javascripts/ and support/ to new syntax. !23947 (Jasper Maes)
- Remove deprecated xhr from specs. !23949 (Jasper Maes)
- Remove app/views/shared/issuable/_filter.html.haml. !24008 (Takuya Noguchi)
- Fix deprecation: Using positional arguments in integration tests. !24009 (Jasper Maes)
- UI improvements for redesigned project lists. !24011
- Update cert-manager chart from v0.5.0 to v0.5.2. !24025 (Takuya Noguchi)
- Hide spinner on empty activites list on user profile overview. !24063
- Don't show Auto DevOps enabled banner for projects with CI file or CI disabled. !24067
- Update GitLab Runner Helm Chart to 0.1.43. !24083
- Fix navigation style in docs. !24090 (Takuya Noguchi)
- Remove gem install bundler from Docker-based Ruby environments. !24093 (Takuya Noguchi)
- Fix deprecation: Using positional arguments in integration tests. !24110 (Jasper Maes)
- Fix deprecation: returning false in Active Record and Active Model callbacks will not implicitly halt a callback chain. !24134 (Jasper Maes)
- ActiveRecord::Migration -> ActiveRecord::Migration[5.0] for AddIndexesToCiBuildsAndPipelines. !24167 (Jasper Maes)
- Update url placeholder for the sentry configuration page. !24338


## 11.6.8 (2019-01-30)

- No changes.

## 11.6.5 (2019-01-17)

### Fixed (5 changes)

- Add syntax highlighting to suggestion diff. !24156
- Fix broken templated "Too many changes to show" text. !24282
- Fix requests profiler in admin page not rendering HTML properly. !24291
- Fix no avatar not showing in user selection box. !24346
- Fixed diff suggestions removing dashes.


## 11.6.4 (2019-01-15)

### Security (1 change)

- Validate bundle files before unpacking them.


## 11.6.3 (2019-01-04)

### Fixed (1 change)

- Fix clone URL not showing if protocol is HTTPS. !24131


## 11.6.2 (2019-01-02)

### Fixed (7 changes)

- Hide cluster features that don't work yet with Group Clusters. !23935
- Fix a 500 error that could occur until all migrations are done. !23939
- Fix missing Git clone button when protocol restriction setting enabled. !24015
- Fix clone dropdown parent inheritance issues in HAML. !24029
- Fix content-disposition in blobs and files API endpoint. !24078
- Fixed markdown toolbar buttons.
- Adjust line-height of blame view line numbers.


## 11.6.1 (2018-12-28)

### Security (15 changes)

- Escape label and milestone titles to prevent XSS in GFM autocomplete. !2740
- Prevent private snippets from being embeddable.
- Add subresources removal to member destroy service.
- Escape html entities in LabelReferenceFilter when no label found.
- Allow changing group CI/CD settings only for owners.
- Authorize before reading job information via API.
- Prevent leaking protected variables for ambiguous refs.
- Ensure that build token is only used when running.
- Issuable no longer is visible to users when project can't be viewed.
- Don't expose cross project repositories through diffs when creating merge reqeusts.
- Fix SSRF with import_url and remote mirror url.
- Fix persistent symlink in project import.
- Set URL rel attribute for broken URLs.
- Project guests no longer are able to see refs page.
- Delete confidential todos for user when downgraded to Guest.

### Other (1 change)

- Fix due date test. !23845


## 11.6.0 (2018-12-22)

### Security (24 changes, 1 of them is from the community)

- Fix possible XSS attack in Markdown urls with spaces. !2599
- Update rack to 2.0.6 (for QA environments). !23171 (Takuya Noguchi)
- Bump nokogiri, loofah, and rack gems for security updates. !23204
- Encrypt runners tokens. !23412
- Encrypt CI/CD builds authentication tokens. !23436
- Configure mermaid to not render HTML content in diagrams.
- Fix a possible symlink time of check to time of use race condition in GitLab Pages.
- Removed ability to see private group names when the group id is entered in the url.
- Fix stored XSS for Environments.
- Fix persistent symlink in project import.
- Fixed ability of guest users to edit/delete comments on locked or confidential issues.
- Fixed ability to comment on locked/confidential issues.
- Fix CRLF vulnerability in Project hooks.
- Fix SSRF in project integrations.
- Resolve reflected XSS in Ouath authorize window.
- Restrict Personal Access Tokens to API scope on web requests.
- Provide email notification when a user changes their email address.
- Don't expose confidential information in commit message list.
- Validate LFS hrefs before downloading them.
- Do not follow redirects in Prometheus service when making http requests to the configured api url.
- Escape user fullname while rendering autocomplete template to prevent XSS.
- Redact sensitive information on gitlab-workhorse log.
- Fix milestone promotion authorization check.
- Prevent a path traversal attack on global file templates.

### Removed (1 change)

- Remove obsolete gitlab_shell rake tasks. !22417

### Fixed (86 changes, 13 of them are from the community)

- Remove limit of 100 when searching repository code. !8671
- Show error message when attempting to reopen an MR and there is an open MR for the same branch. !16447 (Akos Gyimesi)
- Fix a bug where internal email pattern wasn't respected. !22516
- Fix project selector consistency in groups issues / MRs / boards pages. !22612 (Heinrich Lee Yu)
- Add empty state for graphs with no values. !22630
- Fix navigating by unresolved discussions on Merge Request page. !22789
- Fix "merged with [commit]" info for merge requests being merged automatically by other actions. !22794
- Fixing regression issues on pages settings and details. !22821
- Remove duplicate primary button in dashboard snippets on small viewports. !22902 (George Tsiolis)
- Fix API::Namespaces routing to accept namepaces with dots. !22912
- Switch kubernetes:active with checking in Auto-DevOps.gitlab-ci.yml. !22929
- Avoid Gitaly RPC errors when fetching diff stats. !22995
- Removes promote to group label for anonymous user. !23042 (Jacopo Beschi @jacopo-beschi)
- Fix enabling project deploy key for admins. !23043
- Align issue status label and confidential icon. !23046 (George Tsiolis)
- Fix default sorting for subgroups and projects list. !23058 (Jacopo Beschi @jacopo-beschi)
- Hashed Storage: allow migration to be retried in partially migrated projects. !23087
- Fix line height of numbers in file blame view. !23090 (Johann Hubert Sonntagbauer)
- Fixes an issue where default values from models would override values set in the interface (e.g. users would be set to external even though their emails matches the internal email address pattern). !23114
- Remove display of local Sidekiq process in /admin/sidekiq. !23118
- Fix unrelated deployment status in MR widget. !23175
- Respect confirmed flag on secondary emails. !23181
- Restrict member access level to be higher than that of any parent group. !23226
- Return real deployment status to frontend. !23270
- Handle force_remove_source_branch when creating merge request. !23281
- Avoid creating invalid refs using rugged, shelling out for writing refs. !23286
- Remove needless auto-capitalization on Wiki page titles. !23288
- Modify the wording for the knative cluster application to match upstream. !23289 (Chris Baumbauer)
- Change container width for project import. !23318 (George Tsiolis)
- Validate chunk size when persist. !23341
- Resolve Main navbar is broken in certain viewport widths. !23348
- Gracefully handle references with null bytes. !23365
- Display commit ID for commit diff discussion on merge request. !23370
- Pass commit when posting diff discussions. !23371
- Fix flash notice styling for fluid layout. !23382
- Add monkey patch to unicorn to fix eof? problem. !23385
- Commits API: Preserve file content in move operations if unspecified. !23387
- Disable password autocomplete in mirror form fill. !23402
- Fix "protected branches only" checkbox not set properly at init. !23409
- Support RSA and ECDSA algorithms in Omniauth JWT provider. !23411 (Michael Tsyganov)
- Make KUBECONFIG nil if KUBE_TOKEN is nil. !23414
- Allow search and sort users at same time on admin users page. !23439
- Fix: Unstar icon button is misaligned. !23444
- Fix error when searching for group issues with priority or popularity sort. !23445
- Fix Order By dropdown menu styling in tablet and mobile screens. !23446
- Fix collapsing discussion replies. !23462
- Gracefully handle unknown/invalid GPG keys. !23492
- Fix multiple commits shade overlapping vertical discussion line. !23515
- Use read_repository scope on read-only files API. !23534
- Avoid 500's when serializing legacy diff notes. !23544
- Fix web hook functionality when the database encryption key is too short. !23573
- Hide Knative from group cluster applications until supported. !23577
- Add top padding for nested environment items loading icon. !23580 (George Tsiolis)
- Improve help and validation sections of maximum build timeout inputs. !23586
- Fix milestone select in issue sidebar of issue boards. !23625
- Fix gitlab:web_hook tasks. !23635
- Avoid caching BroadcastMessage as an ActiveRecord object. !23662
- Only allow strings in URL::Sanitizer.valid?. !23675
- Fix a frozen string error in app/mailers/notify.rb. !23683
- Fix a frozen string error in lib/gitlab/utils.rb. !23690
- Fix MR resolved discussion counts being too low. !23710
- Fix a potential frozen string error in app/mailers/notify.rb. !23728
- Remove unnecessary div from MarkdownField to apply list styles correctly. !23733
- Display reply field if resolved discussion has no replies. !23801
- Restore kubernetes:active in Auto-DevOps.gitlab-ci.yml (reverts 22929). !23826
- Fix mergeUrlParams with fragment URL. !54218 (Thomas Holder)
- Fixed multiple diff line discussions not expanding.
- Fixed diff files expanding not loading commit content.
- Fixed styling of image comment badges on commits.
- Resolve possible cherry pick API race condition.
- When user clicks linenumber in MR changes, highlight that line.
- Remove old webhook logs after 90 days, as documented, instead of after 2.
- Add an external IP address to the knative cluster application page. (Chris Baumbauer)
- Fixed duplicate discussions getting added to diff lines.
- Fix deadlock on ChunkedIO.
- Show tree collapse button for merge request commit diffs.
- Use approximate count for big tables for usage statistics.
- Lock writes to trace stream.
- Ensure that SVG sprite icons are properly rendered in IE11.
- Make new branch form fields' fonts consistent.
- Open first 10 merge request files in IDE.
- Prevent user from navigating away from file edit without commit.
- Prevent empty button being rendered in empty state.
- Adds margins between tags when a job is stuck.
- Fix Image Lazy Loader for some older browsers.
- Correctly styles tags in sidebar for job page.

### Changed (34 changes, 9 of them are from the community)

- Include new link in breadcrumb for issues, merge requests, milestones, and labels. !18515 (George Tsiolis)
- Allow sorting issues and MRs in reverse order. !21438
- Design improvements to project overview page. !22196
- Remove auto deactivation when failed to create a pipeline via pipeline schedules. !22243
- Use group clusters when deploying (DeploymentPlatform). !22308
- Improve initial discussion rendering performance. !22607
- removes partially matching of No Label filter and makes it case-insensitive. !22622 (Jacopo Beschi @jacopo-beschi)
- Use search bar for filtering in dashboard issues / MRs. !22641 (Heinrich Lee Yu)
- Show different empty state for filtered issues and MRs. !22775 (Heinrich Lee Yu)
- Relocate JSONWebToken::HMACToken from EE. !22906
- Resolve Add border around the repository file tree. !23018
- Change breadcrumb title for contribution charts. !23071 (George Tsiolis)
- Update environments metrics empty state. !23074 (George Tsiolis)
- Refine cursor positioning in Markdown Editor for wrap tags. !23085 (Johann Hubert Sonntagbauer)
- Use reports syntax for SAST in Auto DevOps. !23163
- SystemCheck: Use a more reliable way to detect current Ruby version. !23291
- Changed frontmatter filtering to support YAML, JSON, TOML, and arbitrary languages. !23331 (Travis Miller)
- Don't remove failed install pods after installing GitLab managed applications. !23350
- Expose merge request pipeline variables. !23398
- Scope default MR search in WebIDE dropdown to current project. !23400
- Show user contributions in correct timezone within user profile. !23419
- Redesign of MR header sections (CE). !23465
- Auto DevOps: Add echo for each branch of the deploy() function where we run helm upgrade. !23499
- Updates service to update Kubernetes project namespaces and restricted service account if present. !23525
- Adjust divider margin to comply with design specs. !23548
- Adjust dropdown item and header padding to comply with design specs. !23552
- Truncate merge request titles with periods instead of ellipsis. !23558
- Remove close icon from projects dropdown in issue boards. !23567
- Change dropdown divider color to gray-200 (#dfdfdf). !23592
- Define the default value for only/except policies. !23765
- Don't show Memory Usage for unmerged MRs.
- reorder notification settings by noisy-ness. (C.J. Jameson)
- Changed merge request filtering to be by path instead of name.
- Make diff file headers sticky.

### Performance (22 changes, 6 of them are from the community)

- Upgrade to Ruby 2.5.3. !2806
- Removes all the irrelevant code and columns that were migrated from the Project table over to the ProjectImportState table. !21497
- Approximate counting strategy with TABLESAMPLE. !22650
- Replace tooltip directive with gl-tooltip diretive in badges, cycle analytics, and diffs. !22770 (George Tsiolis)
- Validate foreign keys being created and indexed for column with _id. !22808
- Remove monospace extend. !23089 (George Tsiolis)
- Use Nokogiri as the ActiveSupport XML backend. !23136
- Improve memory performance by reducing dirty pages after fork(). !23169
- Add partial index for ci_builds on project_id and status. !23268
- Reduce Gitaly calls in projects dashboard. !23307
- Batch load only data from same repository when lazy object is accessed. !23309
- Add index for events on project_id and created_at. !23354
- Remove index for notes on updated_at. !23356
- Improves performance of Project#readme_url by caching the README path. !23357
- Populate MR metrics with events table information (migration). !23564
- Remove unused data from discussions endpoint. !23570
- Speed up issue board lists in groups with many projects.
- Use cached size when passing artifacts to Runner.
- Enable even more frozen string for lib/gitlab. (gfyoung)
- Enable even more frozen string in lib/gitlab/**/*.rb. (gfyoung)
- Enable even more frozen string in lib/gitlab/**/*.rb. (gfyoung)
- Enable even more frozen string for lib/gitlab. (gfyoung)

### Added (32 changes, 13 of them are from the community)

- Add ability to create group level clusters and install gitlab managed applications. !22450
- Creates /create_merge_request quickaction. !22485 (Jacopo Beschi @jacopo-beschi)
- Filter by None/Any for labels in issues/mrs API. !22622 (Jacopo Beschi @jacopo-beschi)
- Chat message push notifications now include links back to GitLab branches. !22651 (Tony Castrogiovanni)
- Added feature flag to signal content headers detection by Workhorse. !22667
- Add Discord integration. !22684 (@blackst0ne)
- Upgrade helm to 2.11.0 and upgrade on every install. !22693
- Add knative client to kubeclient library. !22968 (cab105)
- Allow SSH public-key authentication for push mirroring. !22982
- Allow deleting a Pipeline via the API. !22988
- #40635: Adds support for cert-manager. !23036 (Amit Rathi)
- WebIDE: Pressing Ctrl-Enter while typing on the commit message now performs the commit action. !23049 (Thomas Pathier)
- Adds Any option to label filters. !23111 (Jacopo Beschi @jacopo-beschi)
- Added glob for CI changes detection. !23128 (Kirill Zaitsev)
- Add model and relation to store repo full path in database. !23143
- Add ability to render suggestions. !23147
- Introduce Knative and Serverless Components. !23174 (Chris Baumbauer)
- Use BFG object maps to clean projects. !23189
- Merge request pipelines. !23217
- Extended user centric tooltips on issue and MR page. !23231
- Add a rebase API endpoint for merge requests. !23296
- Add config to prohibit impersonation. !23338
- Merge request pipeline tag, and adds tags to pipeline view. !23364
- #52753: HTTPS for JupyterHub installation. !23479 (Amit Rathi)
- Fill project_repositories for hashed storage projects. !23482
- Ability to override email for cert-manager. !23503 (Amit Rathi)
- Allow public forks to be deduplicated. !23508
- Pipeline trigger variable values are hidden in the UI by default. Maintainers have the option to reveal them. !23518 (jhampton)
- Add new endpoint to download single artifact file for a ref. !23538
- Log and pass correlation-id between Unicorn, Sidekiq and Gitaly.
- Allow user to scroll to top of tab on MR page.
- Adds states to the deployment widget.

### Other (54 changes, 30 of them are from the community)

- Switch to Rails 5. !21492
- Migration to write fullpath in all repository configs. !22322
- Rails5: env is deprecated and will be removed from Rails 5.1. !22626 (Jasper Maes)
- Update haml_lint to 0.28.0. !22660 (Takuya Noguchi)
- Update ffaker to 2.10.0. !22661 (Takuya Noguchi)
- Drop gcp_clusters table. !22713
- Upgrade minimum required Git version to 2.18.0. !22803
- Adds new icon size to Vue icon component. !22899
- Make sure there's only one slash as path separator. !22954
- Show HTTP response code for Kubernetes errors. !22964
- Update config map for gitlab managed application if already present on install. !22969
- Drop default value on status column in deployments table. !22971
- UI improvements to user's profile. !22977
- Update asana to 0.8.1. !23039 (Takuya Noguchi)
- Update asciidoctor to 1.5.8. !23047 (Takuya Noguchi)
- Make auto-generated icons for subgroups in the breadcrumb dropdown display as a circle. !23062 (Thomas Pathier)
- Make reply shortcut only quote selected discussion text. !23096 (Thomas Pathier)
- Fix typo in notebook props. !23103 (George Tsiolis)
- Fix typos in lib. !23106 (George Tsiolis)
- Rename diffs store variable. !23123 (George Tsiolis)
- Fix overlapping navbar separator and overflowing navbar dropdown on small displays. !23126 (Thomas Pathier)
- Show what RPC is called in the performance bar. !23140
- Updated Gitaly to v0.133.0. !23148
- Rails5: Passing a class as a value in an Active Record query is deprecated. !23164 (Jasper Maes)
- Fix project identicon aligning Harry Kiselev. !23166 (Harry Kiselev)
- Fix horizontal scrollbar overlapping on horizontal scrolling-tabs. !23167 (Harry Kiselev)
- Fix bottom paddings of profile header and some markup updates of profile. !23168 (Harry Kiselev)
- Fixes to AWS documentation spelling and grammar. !23198 (Brendan O'Leary)
- Adds a PHILOSOPHY.md which references GitLab Product Handbook. !23200
- Externalize strings from `/app/views/invites`. !23205 (Tao Wang)
- Externalize strings from `/app/views/project/runners`. !23208 (Tao Wang)
- Fix typo for scheduled pipeline. !23218 (Davy Defaud)
- Force content disposition attachment to several endpoints. !23223
- Upgrade kubeclient to 4.0.0. !23261 (Praveen Arimbrathodiyil @pravi)
- Update used version of Runner Helm Chart to 0.1.38. !23304
- render :nothing option is deprecated, Use head method to respond with empty response body. !23311 (Jasper Maes)
- Passing an argument to force an association to reload is now deprecated. !23334 (Jasper Maes)
- Externalize strings from `/app/views/snippets`. !23351 (Tao Wang)
- Fix deprecation: You are passing an instance of ActiveRecord::Base to. !23369 (Jasper Maes)
- Resolve status emoji being replaced by avatar on mobile. !23408
- Fix deprecation: render :text is deprecated because it does not actually render a text/plain response. !23425 (Jasper Maes)
- Fix lack of documentation on how to fetch a snippet's content using API. !23448 (Colin Leroy)
- Upgrade GitLab Workhorse to v7.3.0. !23489
- Fallback to admin KUBE_TOKEN for project clusters only. !23527
- Update used version of Runner Helm Chart to 0.1.39. !23633
- Show primary button when all labels are prioritized. !23648 (George Tsiolis)
- Upgrade workhorse to 7.6.0. !23694
- Upgrade Gitaly to v1.7.1 for correlation-id logging. !23732
- Fix due date test. !23845
- Remove unused project method. !54103 (George Tsiolis)
- Uses new gitlab-ui components in Jobs and Pipelines components.
- Replaces tooltip directive with the new gl-tooltip directive for consistency in some ci/cd code.
- Bump gpgme gem version from 2.0.13 to 2.0.18. (asaparov)
- Enable Rubocop on lib/gitlab. (gfyoung)


## 11.5.8 (2019-01-28)

### Security (21 changes)

- Make potentially malicious links more visible in the UI and scrub RTLO chars from links. !2770
- Don't process MR refs for guests in the notes. !2771
- Fixed XSS content in KaTex links.
- Verify that LFS upload requests are genuine.
- Extract GitLab Pages using RubyZip.
- Prevent awarding emojis to notes whose parent is not visible to user.
- Prevent unauthorized replies when discussion is locked or confidential.
- Disable git v2 protocol temporarily.
- Fix showing ci status for guest users when public pipline are not set.
- Fix contributed projects info still visible when user enable private profile.
- Disallows unauthorized users from accessing the pipelines section.
- Add more LFS validations to prevent forgery.
- Use common error for unauthenticated users when creating issues.
- Fix slow regex in project reference pattern.
- Fix private user email being visible in push (and tag push) webhooks.
- Fix wiki access rights when external wiki is enabled.
- Fix path disclosure on project import error.
- Restrict project import visibility based on its group.
- Expose CI/CD trigger token only to the trigger owner.
- Notify only users who can access the project on project move.
- Alias GitHub and BitBucket OAuth2 callback URLs.


## 11.5.5 (2018-12-20)

### Security (1 change)

- Fix persistent symlink in project import.


## 11.5.3 (2018-12-06)

### Security (1 change)

- Prevent a path traversal attack on global file templates.


## 11.5.2 (2018-12-03)

### Removed (1 change)

- Removed Site Statistics optimization as it was causing problems. !23314

### Fixed (6 changes, 1 of them is from the community)

- Display impersonation token value only after creation. !22916
- Fix not render emoji in filter dropdown. !23112 (Hiroyuki Sato)
- Fixes stuck tooltip on stop env button. !23244
- Correctly handle data-loss scenarios when encrypting columns. !23306
- Clear BatchLoader context between Sidekiq jobs. !23308
- Fix handling of filenames with hash characters in tree view. !23368


## 11.5.1 (2018-11-26)

### Security (17 changes)

- Escape user fullname while rendering autocomplete template to prevent XSS.
- Fix CRLF vulnerability in Project hooks.
- Fix possible XSS attack in Markdown urls with spaces.
- Redact sensitive information on gitlab-workhorse log.
- Do not follow redirects in Prometheus service when making http requests to the configured api url.
- Don't expose confidential information in commit message list.
- Provide email notification when a user changes their email address.
- Restrict Personal Access Tokens to API scope on web requests.
- Resolve reflected XSS in Ouath authorize window.
- Fix SSRF in project integrations.
- Fixed ability to comment on locked/confidential issues.
- Fixed ability of guest users to edit/delete comments on locked or confidential issues.
- Fix milestone promotion authorization check.
- Configure mermaid to not render HTML content in diagrams.
- Fix a possible symlink time of check to time of use race condition in GitLab Pages.
- Removed ability to see private group names when the group id is entered in the url.
- Fix stored XSS for Environments.


## 11.5.0 (2018-11-22)

### Security (10 changes, 1 of them is from the community)

- Escape entity title while autocomplete template rendering to prevent XSS. !2556
- Update moment to 2.22.2. !22648 (Takuya Noguchi)
- Redact personal tokens in unsubscribe links.
- Escape user fullname while rendering autocomplete template to prevent XSS.
- Persist only SHA digest of PersonalAccessToken#token.
- Monkey kubeclient to not follow any redirects.
- Prevent SSRF attacks in HipChat integration.
- Prevent templated services from being imported.
- Validate Wiki attachments are valid temporary files.
- Fix XSS in merge request source branch name.

### Removed (2 changes)

- Remove Git circuit breaker. !22212
- Remove Koding integration and documentation. !22334

### Fixed (74 changes, 15 of them are from the community)

- Hide all tables on Pipeline when no Jobs for the Pipeline. !18540 (Takuya Noguchi)
- Fixing count on Milestones. !21446
- Use case insensitve username lookups. !21728 (William George)
- Correctly process Bamboo API result array. !21970 (Alex Lossent)
- Fix 'merged with' UI being displayed when merge request has no merge commit. !22022
- Fix broken file name navigation on MRs. !22109
- Fix incorrect spacing between buttons when commenting on a MR. !22135
- Vertical align Pipeline Graph in Commit Page. !22173 (Johann Hubert Sonntagbauer)
- Reject invalid branch names in repository compare controller. !22186
- Fix size of emojis of user status in user menu. !22194
- Use the standard PIP_CACHE_DIR for Python dependency caching template. !22211 (Takuya Noguchi)
- Fix bug with wiki attachments content disposition. !22220
- Does not allow a SSH URI when importing new projects. !22309
- fix duplicated key in license management job auto devops gitlab ci template. !22311 (Adam Lemanski)
- Fix commit signature error when project is disabled. !22344
- Show available clusters when installed or updated. !22356
- Fix auto-corrected upload URLs in webhooks. !22361
- Fix a bug displaying certain wiki pages. !22377
- Fix prometheus graphs in firefox. !22400
- Resolve assign-me quick action doesn't work if there is extra white space. !22402
- Remove base64 encoding from files that contain plain text. !22425
- Strip whitespace around GitHub personal access tokens. !22432
- Fix 500 error when testing webhooks with redirect loops. !22447 (Heinrich Lee Yu)
- Fix rendering of 'Protected' value on Runner details page. !22459
- Fix bug stopping non-admin users from changing visibility level on group creation. !22468
- Make Issue Board sidebar show project-specific labels based on selected Issue. !22475
- Fix EOF detection with CI artifacts metadata. !22479
- Fix transient spec error in the bar_chart component. !22495
- Resolve LFS not correctly showing enabled. !22501
- If user was not found, service hooks won't run on post receive background job. !22519
- Fix broken "Show whitespace changes" button on MRs. !22539
- Always show new issue button in boards' Open list. !22557 (Heinrich Lee Yu)
- Add transparent background to markdown header tabs. !22565 (George Tsiolis)
- Use gitlab_environment for ldap rake task. !22582
- Add commit message to commit tree anchor title. !22585
- Cache pipeline status per SHA. !22589
- Change HELM_HOST in Auto-DevOps template to work behind proxy. !22596 (Sergej Nikolaev <kinolaev@gmail.com>)
- Show user status for label events in system notes. !22609
- Fix extra merge request versions created from forked merge requests. !22611
- Remove PersonalAccessTokensFinder#find_by method. !22617
- Fix search "all in GitLab" not working with relative URLs. !22644
- Fix quick links button styles. !22657 (George Tsiolis)
- Fix #53298: JupyterHub restarts should work without errors. !22671 (Amit Rathi)
- Fix incompatibility with IE11 due to non-transpiled gitlab-ui components. !22695
- Fix bug when links in tabs of the labels index pages ends with .html. !22716
- Fixed label removal from issue. !22762
- Align toggle sidebar button across all browsers and OSs. !22771
- Disable replication lag check for Aurora PostgreSQL databases. !22786
- Render unescaped link for failed pipeline status. !22807
- Fix misaligned approvers dropdown. !22832
- Fix bug with wiki page create message. !22849
- Fix rendering of filter bar tokens for special values. !22865 (Heinrich Lee Yu)
- Align sign in button. !22888 (George Tsiolis)
- Fix error handling bugs in kubernetes integration. !22922
- Fix deployment jobs using nil KUBE_TOKEN due to migration issue. !23009
- Avoid returning deployment metrics url to MR widget when the deployment is not successful. !23010
- Fix a race condition intermittently breaking GitLab startup. !23028
- Adds margin after a deleted branch name in the activity feed. !23038
- Ignore environment validation failure. !23100
- Fixes broken borders for reports section in MR widget.
- Adds CI favicon back to jobs page.
- Redirect to the pipeline builds page when a build is canceled. (Eva Kadlecova)
- Fixed diff stats not showing when performance bar is enabled.
- Show expand all diffs button when a single diff file is collapsed.
- Clear fetched file templates when changing template type in Web IDE.
- Fix bug causing not all emails to show up in commit email selectbox.
- Remove duplicate escape in job sidebar.
- Fixing styling issues on the scheduled pipelines page.
- Renders stuck block when runners are stuck.
- Removes extra border from test reports in the merge request widget.
- Only render link to branch when branch still exists in pipeline page.
- Fixed source project not filtering in merge request creation compare form.
- Do not reload self on hooks when creating deployment.
- Fixes broken test in master.

### Changed (38 changes, 12 of them are from the community)

- Link button in markdown editor recognize URLs. !1983 (Johann Hubert Sonntagbauer)
- Replace i to icons in vue components. !20748 (George Tsiolis)
- Remove Linguist gem, reducing Rails memory usage by 128MB per process. !21008
- Issue board card design. !21229
- On deletion of a file in sub directory in web IDE redirect to the sub directory instead of project root. !21465 (George Thomas @thegeorgeous)
- Change single-item breadcrumbs to page titles. !22155
- Improving branch filter sorting by listing exact matches first and added support for begins_with (^) and ends_with ($) matching. !22166 (Jason Rutherford)
- Remove legacy unencrypted webhook columns from the database. !22199
- Show canary status in the performance bar. !22222
- Add failure reason for execution timeout. !22224
- Rename "scheduled" label/badge of delayed jobs to "delayed". !22245
- Update the empty state on wiki-only projects to display an empty state that is more consistent with the rest of the system. !22262
- Add IID headers to E-Mail notifications. !22263
- Allow finding the common ancestor for multiple revisions through the API. !22295
- Add status to Deployment. !22380
- Add dynamic timer to delayed jobs. !22382
- No longer require a deploy to start Prometheus monitoring. !22401
- Secret Variables renamed to CI Variables in the codebase, to match UX. !22414 (Marcel Amirault @ravlen)
- Automatically navigate to last board visited. !22430
- Use merge request prefix symbol in event feed title. !22449 (George Tsiolis)
- Update Ruby version in README. !22466 (J.D. Bean)
- Reword error message for internal CI unknown pipeline status. !22474
- Bump mermaid to 8.0.0-rc.8. !22509 (@blackst0ne)
- Update Todo icons in collapsed sidebar for Issues and MRs. !22534
- Support backward compatibility when introduce new failure reason. !22566
- Add dynamic timer for delayed jobs in pipelines list. !22621
- Truncate milestone title on collapsed sidebar. !22624 (George Tsiolis)
- Standardize milestones filter in APIs to None / Any. !22637 (Heinrich Lee Yu)
- Add dynamic timer for delayed jobs in job list. !22656
- Allowing issues with single letter identifiers to be linked to external issue tracker (f.ex T-123). !22717 (Dídac Rodríguez Arbonès)
- Update project and group labels empty state. !22745 (George Tsiolis)
- Fix environment status in merge request widget. !22799
- Paginate Bitbucket Server importer projects. !22825
- Drop `allow_overflow` option in `TimeHelper.duration_in_numbers`. !52284
- Add 'only history' option to notes filter.
- Adds filtered dropdown with changed files in review.
- Expose {closed,merged}_{at,by} in merge requests API index.
- Make all legacy security reports to use raw format.

### Performance (27 changes, 6 of them are from the community)

- Add preload for routes and namespaces for issues controller. !21651
- Enhance performance of counting local LFS objects. !22143
- Use cached readme contents when available. !22325
- Experimental support for running Puma multithreaded web-server. !22372
- Enhance performance of counting local Uploads. !22522
- Reduce SQL queries needed to load open merge requests. !22709
- Significantly cut memory usage and SQL queries when reloading diffs. !22725
- Optimize merge request refresh by using the database to check commit SHAs. !22731
- Remove dind from license_management auto-devops job definition. !22732
- Add index to find stuck merge requests. !22749
- Allow Rails concurrency when running in Puma. !22751
- Improve performance of rendering large reports. !22835
- Improves performance of stuck import jobs detection. !22879
- Rewrite SnippetsFinder to improve performance by a factor of 1500.
- Enable more frozen string in lib/**/*.rb. (gfyoung)
- Enable some frozen string in lib/gitlab. (gfyoung)
- Enable even more frozen string in lib/**/*.rb. (gfyoung)
- Improve performance of tree rendering in repositories with lots of items.
- Remove gitlab-ui's tooltip from global.
- Remove gitlab-ui's progress bar from global.
- Remove gitlab-ui's pagination from global.
- Remove gitlab-ui's modal from global.
- Remove gitlab-ui's loading icon from global.
- Enable frozen string for lib/gitlab/*.rb. (gfyoung)
- Enable frozen string for lib/gitlab/ci. (gfyoung)
- Enable frozen string for remaining lib/gitlab/ci/**/*.rb. (gfyoung)
- Adds pagination to pipelines table in merge request page.

### Added (33 changes, 11 of them are from the community)

- Add endpoint to update a git submodule reference. !20949
- Add license data to projects endpoint. !21606 (J.D. Bean (@jdbean))
- Allow to configure when to retry failed CI jobs. !21758 (Markus Doits)
- Add API endpoint to list issue related merge requests. !21806 (Helmut Januschka)
- Add the Play button for delayed jobs in environment page. !22106
- Switch between tree list & file list in diffs file browser. !22191
- Re-arrange help-related user menu items into new Help menu. !22195
- Adds trace of each access check when git push times out. !22265
- Add email for milestone change. !22279
- Show post-merge pipeline in merge request page. !22292
- Add Applications API endpoints for listing and deleting entries. !22296 (Jean-Baptiste Vasseur)
- Added `Any` option to milestones filter. !22351 (Heinrich Lee Yu)
- Improve validation errors for external CI/CD configuration. !22394
- Introduce new model to persist specific cluster information. !22404
- Add background migration to populate Kubernetes namespaces. !22433
- Add support for JSON logging for audit events. !22471
- Adds option to override commit email with a noreply private email. !22560
- Add None/Any option for assignee_id in Issues and Merge Requests API. !22598 (Heinrich Lee Yu)
- Add None/Any option for assignee_id in search bar. !22599 (Heinrich Lee Yu)
- Implement parallel job keyword. !22631
- Add None / Any options to reactions filter. !22638 (Heinrich Lee Yu)
- Make index.* render like README.* when it's present in a repository. !22639 (Jakub Jirutka)
- Allow adding patches when creating a merge request via email. !22723 (Serdar Dogruyol)
- Bump Gitaly to 0.129.0. !22868
- Allow commenting on any diff line in Merge Requests. !22914
- Add revert to commits API. !22919
- Introduce Knative support. !43959 (Chris Baumbauer)
- Reimplemented image commenting in merge request diffs.
- Soft-archive old jobs.
- Renders warning info when job is archieved.
- Support licenses and performance.
- Filter notes by comments or activity for issues and merge requests.
- Bump Gitaly to 0.128.0.

### Other (54 changes, 18 of them are from the community)

- Remove .card-title from .card-header for BS4 migration. !19335 (Takuya Noguchi)
- Update group settings/edit page to new design. !21115
- Change markdown header tab anchor links to buttons. !21988 (George Tsiolis)
- Replace tooltip in markdown component with gl-tooltip. !21989 (George Tsiolis)
- Extend RBAC by having a service account restricted to project's namespace. !22011
- Update images in group docs. !22031 (Marc Schwede)
- Add gitlab:gitaly:check task for Gitaly health check. !22063
- Add new sort option "most_stars" to "Group > Children" pages. !22121 (Rene Hennig)
- Fix inaccessible dropdown for code-less projects. !22137
- Rails5: fix user edit profile clear status spec. !22169 (Jasper Maes)
- Rails 5: fix mysql milliseconds problems in scheduled build specs. !22170 (Jasper Maes)
- Focus project slug on tab navigation. !22198
- Redesign activity feed. !22217
- Update used version of Runner Helm Chart to 0.1.34. !22274
- Update environments empty state. !22297 (George Tsiolis)
- Adds model and migrations to enable group level clusters. !22307
- Use literal instead of constructor for creating regex. !22367
- Remove prometheus configuration help text. !22413 (George Tsiolis)
- Rails5: fix deployment model spec. !22428 (Jasper Maes)
- Change to top level controller for clusters so that we can use it for project clusters (now) and group clusters (later). !22438
- Remove empty spec describe blocks. !22451 (George Tsiolis)
- Change branch font type in tag creation. !22454 (George Tsiolis)
- Rails5: fix delete blob. !22456 (Jasper Maes)
- Start tracking shards and pool repositories in the database. !22482
- Allow kubeclient to call RoleBinding methods. !22524
- Introduce new kubernetes helpers. !22525
- Adds container to pager to enable scoping. !22529
- Update used version of Runner Helm Chart to 0.1.35. !22541
- Removes experimental labels from cluster views. !22550
- Combine all datetime library functions into 'datetime_utility.js'. !22570
- Upgrade Prometheus to 2.4.3 and Alertmanager to 0.15.2. !22600
- Fix stage dropdown not rendering in different languages. !22604
- Remove asset_sync gem from Gemfile and related code from codebase. !22610
- Use key-value pair arrays for API query parameter logging instead of hashes. !22623
- Replace deprecated uniq on a Relation with distinct. !22625 (Jasper Maes)
- Remove mousetrap-rails gem. !22647 (Takuya Noguchi)
- Fix IDE typos in props. !22685 (George Tsiolis)
- Add scheduled flag to job entity. !22710
- Remove `ci_enable_scheduled_build` feature flag. !22742
- Add endpoints for simulating certain failure modes in the application. !22746
- Bump KUBERNETES_VERSION for Auto DevOps to latest 1.10 series. !22757
- Fix statement timeouts in RemoveRestrictedTodos migration. !22795
- Rails5: fix mysql milliseconds issue in deployment model specs. !22850 (Jasper Maes)
- Update GitLab-Workhorse to v7.1.0. !22883
- Update JIRA service UI to accept email and API token.
- Update wiki empty state. (George Tsiolis)
- Only renders dropdown for review app changes when we have a list of files to show. Otherwise will render the regular review app button.
- Associate Rakefile with Ruby icon in diffs.
- Uses gitlab-ui components in jobs components.
- Create new group: Rename form fields and update UI.
- Transform job page into a single Vue+Vuex application.
- Updates svg dependency.
- Adds missing i18n to pipelines table.
- Disables stop environment button while the deploy is in progress.


## 11.4.9 (2018-12-03)

### Fixed (2 changes)

- Display impersonation token value only after creation. !22916
- Correctly handle data-loss scenarios when encrypting columns. !23306


## 11.4.8 (2018-11-27)

### Security (24 changes)

- Escape entity title while autocomplete template rendering to prevent XSS. !2571
- Resolve reflected XSS in Ouath authorize window.
- Fix XSS in merge request source branch name.
- Escape user fullname while rendering autocomplete template to prevent XSS.
- Fix CRLF vulnerability in Project hooks.
- Fix possible XSS attack in Markdown urls with spaces.
- Redact sensitive information on gitlab-workhorse log.
- Do not follow redirects in Prometheus service when making http requests to the configured api url.
- Persist only SHA digest of PersonalAccessToken#token.
- Don't expose confidential information in commit message list.
- Provide email notification when a user changes their email address.
- Restrict Personal Access Tokens to API scope on web requests.
- Redact personal tokens in unsubscribe links.
- Fix SSRF in project integrations.
- Fixed ability to comment on locked/confidential issues.
- Fixed ability of guest users to edit/delete comments on locked or confidential issues.
- Fix milestone promotion authorization check.
- Monkey kubeclient to not follow any redirects.
- Configure mermaid to not render HTML content in diagrams.
- Fix a possible symlink time of check to time of use race condition in GitLab Pages.
- Removed ability to see private group names when the group id is entered in the url.
- Fix stored XSS for Environments.
- Prevent SSRF attacks in HipChat integration.
- Validate Wiki attachments are valid temporary files.


## 11.4.7 (2018-11-20)

- No changes.

## 11.4.6 (2018-11-18)

### Security (1 change)

- Escape user fullname while rendering autocomplete template to prevent XSS.


## 11.4.5 (2018-11-04)

### Fixed (4 changes, 1 of them is from the community)

- fix link to enable usage ping from convdev index. !22545 (Anand Capur)
- Update gitlab-ui dependency to 1.8.0-hotfix.1 to fix IE11 bug.
- Remove duplicate escape in job sidebar.
- Fixed merge request fill tree toggling not respecting fluid width preference.

### Other (1 change)

- Fix stage dropdown not rendering in different languages.


## 11.4.4 (2018-10-30)

### Security (1 change)

- Monkey kubeclient to not follow any redirects.


## 11.4.3 (2018-10-26)

- No changes.

## 11.4.2 (2018-10-25)

### Security (5 changes)

- Escape entity title while autocomplete template rendering to prevent XSS. !2571
- Persist only SHA digest of PersonalAccessToken#token.
- Redact personal tokens in unsubscribe links.
- Block loopback addresses in UrlBlocker.
- Validate Wiki attachments are valid temporary files.


## 11.4.1 (2018-10-23)

### Security (2 changes)

- Fix XSS in merge request source branch name.
- Prevent SSRF attacks in HipChat integration.


## 11.4.0 (2018-10-22)

### Security (9 changes)

- Filter user sensitive data from discussions JSON. !2536
- Encrypt webhook tokens and URLs in the database. !21645
- Redact confidential events in the API.
- Set timeout for syntax highlighting.
- Sanitize JSON data properly to fix XSS on Issue details page.
- Markdown API no longer displays confidential title references unless authorized.
- Properly filter private references from system notes.
- Fix stored XSS in merge requests from imported repository.
- Fix xss vulnerability sourced from package.json.

### Removed (2 changes)

- Remove background job throttling feature. !21748
- Remove sidekiq info from performance bar.

### Fixed (68 changes, 18 of them are from the community)

- Fixes 500 for cherry pick API with empty branch name. !21501 (Jacopo Beschi @jacopo-beschi)
- Fix sorting by priority or popularity on group issues page, when also searching issue content. !21521
- Fix vertical alignment of text in diffs. !21573
- Fix performance bar modal position. !21577
- Bump KaTeX version to 0.9.0. !21625
- Correctly show legacy diff notes in the merge request changes tab. !21652
- Synchronize the default branch when updating a remote mirror. !21653
- Filter group milestones based on user membership. !21660
- Fix double title in merge request chat messages. !21670 (Kukovskii Vladimir)
- Delete container repository tags outside of transaction. !21679
- Images are no longer displayed in Todo descriptions. !21704
- Fixed merge request widget discussion state not updating after resolving discussions. !21705
- Vendor Auto-DevOps.gitlab-ci.yml to fix bug where the deploy job does not wait for Deployment to complete. !21713
- Use Reliable Sidekiq fetch. !21715
- No longer show open issues from archived projects in group issue board. !21721
- Issue and MR count now ignores archived projects. !21721
- Fix resizing of monitoring dashboard. !21730
- Fix object storage uploads not working with AWS v2. !21731
- Don't ignore first action when assign and unassign quick actions are used in the same comment. !21749
- Align form labels following Bootstrap 4 docs. !21752
- Respect the user commit email in more places. !21773
- Use stats RPC when comparing diffs. !21778
- Show commit details for selected commit in MR diffs. !21784
- Resolve "Geo: Does not mark repositories as missing on primary due to stale cache". !21789
- Fix leading slash in redirects and add rubocop cop. !21828 (Sanad Liaquat)
- Fix activity titles for MRs in chat notification services. !21834
- Hides Close Merge request btn on merged Merge request. !21840 (Jacopo Beschi @jacopo-beschi)
- Doesn't synchronize the default branch for push mirrors. !21861
- Fix broken styling when issue board is collapsed. !21868 (Andrea Leone)
- Set a header for custom error pages to prevent them from being intercepted by gitlab-workhorse. !21870 (David Piegza)
- Fix resolved discussions being unresolved when commented on. !21881
- Fix timeout when running the RemoveRestrictedTodos background migration. !21893
- Enable the ability to use the force env for rebuilding authorized_keys during a restore. !21896
- Fix link handling for issue cards to avoid too sensitive drag events. !21910 (Johann Hubert Sonntagbauer)
- Guard against a login attempt with invalid CSRF token. !21934
- Allow setting user's organization and location attributes through the API by adding them to the list of allowed parameters. !21938 (Alexis Reigel)
- Includes commit stats in POST project commits API. !21968 (Jacopo Beschi @jacopo-beschi)
- Fix loading issue on some merge request discussion. !21982
- Prevent Error 500s with invalid relative links. !22001
- Fix stale issue boards after browser back. !22006 (Johann Hubert Sonntagbauer)
- Filter issues without an Assignee via the API. !22009 (Eva Kadlecová)
- Fixes modal button alignment. !22024 (Jacopo Beschi @jacopo-beschi)
- Fix rendering placeholder notes. !22078
- Instance Configuration page now displays correct SSH fingerprints. !22081
- Fix showing diff file header for renamed files. !22089
- Fix LFS uploaded images not being rendered. !22092
- Fix the issue where long environment names aren't being truncated, causing the environment name to overlap into the column next to it. !22104
- Trim whitespace when inviting a new user by email. !22119 (Jacopo Beschi @jacopo-beschi)
- Fix incorrect parent path on group settings page. !22142
- Update copy to clipboard button data for application secret. !22268 (George Tsiolis)
- Improve MR file tree in smaller screens. !22273
- Fix project deletion when there is a export available. !22276
- Fixes stuck block URL linking to documentation instead of settings page. !22286
- Fix caching issue with pipelines URL. !22293
- Fix erased block not being rendered when job was erased. !22294
- Load correct stage in the stages dropdown. !22317
- Fixes close/reopen quick actions preview for issues and merge_requests. !22343 (Jacopo Beschi @jacopo-beschi)
- Allow Issue and Merge Request sidebar to be toggled from collapsed state. !22353
- Fix filter bar height bug when a tag is added.
- Fix the state of the Done button when there is an error in the GitLab Todos section. (marcos8896)
- Fix wrong text color of help text in merge request creation. (Gerard Montemayor)
- Add borders and white background to markdown tables.
- Fixed mention autocomplete in edit merge request.
- Fix long webhook URL overflow for custom integration. (Kukovskii Vladimir)
- Fixed file templates not fully being fetched in Web IDE.
- Fixes performance bar looking for a key in a undefined prop.
- Hides sidebar for job page in mobile.
- Fixes triggered/created labeled in job header.

### Changed (26 changes, 4 of them are from the community)

- Enable unauthenticated access to public SSH keys via the API. !20118 (Ronald Claveau)
- Support Kubernetes RBAC for GitLab Managed Apps when creating new clusters. !21401
- Highlight current user in comments. !21406
- Excludes project marked from deletion to projects API. !21542 (Jacopo Beschi @jacopo-beschi)
- Improve install flow of Kubernetes cluster apps. !21567
- Move including external files in .gitlab-ci.yml from Starter to Libre. !21603
- Simplify runner registration token resetting. !21658
- Filter any parameters ending with "key" in logs. !21688
- Ensure the schema is loaded with post_migrations included. !21689
- Updated icons used in filtered search dropdowns. !21694
- Enable omniauth by default. !21700
- Vendor Auto-DevOps.gitlab-ci.yml to refactor registry_login. !21714 (Laurent Goderre @LaurentGoderre)
- Add Gitaly diff stats RPC client. !21732
- Allow user to revoke an authorized application even if User OAuth applications setting is disabled in admin settings. !21835
- Change vertical margin of page titles to 16px. !21888
- Preserve order of project tags list. !21897
- Avoid close icon leaving the modal header. !21904
- Allow /copy_metadata for new issues and MRs. !21953
- Link to the tag for a version on the help page instead of to the commit. !22015
- Show SHA for pre-release versions on the help page. !22026
- Use local tiller for Auto DevOps. !22036
- Remove 'rbac_clusters' feature flag. !22096
- Increased retained event data by extending events pruner timeframe to 2 years. !22145
- Add installation type to backup information file. !22150
- Remove duplicate button from the markdown header toolbar. !22192 (George Tsiolis)
- Update to Rouge 3.3.0 including frozen string literals for improved memory usage.

### Performance (17 changes, 6 of them are from the community)

- Enable frozen string in app/controllers/**/*.rb.
- Improve lazy image loading performance by using IntersectionObserver where available. !21565
- Adds support for Gitaly ListLastCommitsForTree RPC in order to make bulk-fetch of commits more performant. !21921
- Dont create license_management build when not included in license. !21958
- Skip creating auto devops jobs for sast, container_scanning, dast, dependency_scanning when not licensed. !21959
- Reduce queries needed to compute notification recipients. !22050
- Banzai label ref finder - minimize SQL calls by sharing context more aggresively. !22070
- Removes expensive dead code on main MR page request. !22153
- Lazy load xterm custom colors css.
- Mitigate N+1 queries when parsing commit references in comments.
- Enable more frozen string in app/controllers/. (gfyoung)
- Increase performance when creating discussions on diff.
- Enable frozen string in lib/api and lib/backup. (gfyoung)
- Enable frozen string in vestigial files. (gfyoung)
- Enable frozen string for app/helpers/**/*.rb. (gfyoung)
- Enable frozen string in app/graphql + app/finders. (gfyoung)
- Enable even more frozen string in app/controllers. (gfyoung)

### Added (37 changes, 21 of them are from the community)

- Allow file templates to be requested at the project level. !7776
- Add /lock and /unlock quick actions. !15197 (Mehdi Lahmam (@mehlah))
- Added search functionality for Work In Progress (WIP) merge requests. !18119 (Chantal Rollison)
- pipeline webhook event now contain pipeline variables. !18171 (Pierre Tardy)
- Add markdown header toolbar button to insert table. !18480 (George Tsiolis)
- Add link button to markdown editor toolbar. !18579 (Jan Beckmann)
- Add access control to GitLab pages and make it possible to enable/disable it in project settings. !18589 (Tuomo Ala-Vannesluoma)
- Add a filter bar to the admin runners view and add a state filter. !19625 (Alexis Reigel)
- Add a type filter to the admin runners view. !19649 (Alexis Reigel)
- Allow user to choose the email used for commits made through GitLab's UI. !21213 (Joshua Campbell)
- Add autocomplete drop down filter for project snippets. !21458 (Fabian Schneider)
- Allow events filter to be set in the URL in addition to cookie. !21557 (Igor @igas)
- Adds a initialize_with_readme parameter to POST /projects. !21617 (Steve)
- Add ability to skip user email confirmation with API. !21630
- Add sorting for labels on labels page. !21642
- Set user status from within user menu. !21643
- Copy nurtch demo notebooks at Jupyter startup. !21698 (Amit Rathi)
- Allows to sort projects by most stars. !21762 (Jacopo Beschi @jacopo-beschi)
- Allow pipelines to schedule delayed job runs. !21767
- Added tree of changed files to merge request diffs. !21833
- Add GitLab version components to CI environment variables. !21853
- Allows to chmod file with commits API. !21866 (Jacopo Beschi @jacopo-beschi)
- Make single diff patch limit configurable. !21886
- Extend reports feature to support Security Products. !21892
- Adds the user's public_email attribute to the API. !21909 (Alexis Reigel)
- Update all gitlab CI templates from gitlab-org/gitlab-ci-yml. !21929
- Add support for setting the public email through the api. !21938 (Alexis Reigel)
- Support db migration and initialization for Auto DevOps. !21955
- Add subscribe filter to group and project labels pages. !21965
- Add support for pipeline only/except policy for modified paths. !21981
- Docs for Project/Groups members API with inherited members. !21984 (Jacopo Beschi @jacopo-beschi)
- Adds Web IDE commits to usage ping. !22007
- Add timed incremental rollout to Auto DevOps. !22023
- Show percentage of language detection on the language bar. !22056 (Johann Hubert Sonntagbauer)
- Allows to filter issues by Any milestone in the API. !22080 (Jacopo Beschi @jacopo-beschi)
- Add button to download 2FA codes. (Luke Picciau)
- Render log artifact files in GitLab.

### Other (42 changes, 16 of them are from the community)

- Send deployment information in job API. !21307
- Split admin settings into multiple sub pages. !21467
- Remove Rugged and shell code from Gitlab::Git. !21488
- Add trigger information in job API. !21495
- Add empty state illustration information in job API. !21532
- Add retried jobs to pipeline stage. !21558
- Rails 5: fix issue move service In rails 5, the attributes method for an enum returns the name instead of the database integer. !21616 (Jasper Maes)
- Expose project runners in job API. !21618
- create from template: hide checkbox for initializing repository with readme. !21646
- Adds new 'Overview' tab on user profile page. !21663
- Add clean-up phase for ScheduleDiffFilesDeletion migration. !21734
- Prevents private profile help link from toggling checkbox. !21757
- Make AutoDevOps work behind proxy. !21775 (Sergej - @kinolaev)
- Use Vue components and new API to render Artifacts, Trigger Variables and Commit blocks on Job page. !21777
- Add wrapper rake task to migrate all uploads to OS. !21779
- Retroactively fill pipeline source for external pipelines. !21814
- Rename squash before merge vue component. !21851 (George Tsiolis)
- Fix merge request header margins. !21878
- Fix committer typo. !21899 (George Tsiolis)
- Adds an extra width to the responsive tables. !21928
- Expose has_trace in job API. !21950
- Rename block scope local variable in table pagination spec. !21969 (George Tsiolis)
- Fix blue, orange, and red color inconsistencies. !21972
- Update operations metrics empty state. !21974 (George Tsiolis)
- Improve empty project placeholder for non-members and members without write access. !21977 (George Tsiolis)
- Add copy to clipboard button for application id and secret. !21978 (George Tsiolis)
- Add link component to UserAvatarLink component. !21986 (George Tsiolis)
- Add link component to DownloadViewer component. !21987 (George Tsiolis)
- Rephrase 2FA and TOTP documentation and view. !21998 (Marc Schwede)
- Update project path on project name autofill. !22016
- Improve logging when username update fails due to registry tags. !22038
- Align collapsed sidebar avatar container. !22044 (George Tsiolis)
- Rails5: fix artifacts controller download spec Rails5 has params[:file_type] as '' if file_type is included as nil in the request. !22123 (Jasper Maes)
- Hide pagination for personal projects on profile overview tab. !22321
- Extracts scroll position check into reusable functions.
- Uses Vuex store in job details page and removes old mediator pattern.
- Render 412 when invalid UTF-8 parameters are passed to controller.
- Renders Job show page in new Vue app.
- Add link to User Snippets in breadcrumbs of New User Snippet page. (J.D. Bean)
- Log project services errors when executing async.
- Update docs regarding frozen string. (gfyoung)
- Check frozen string in style builds. (gfyoung)


## 11.3.14 (2018-12-20)

### Security (1 change)

- Fix persistent symlink in project import.


## 11.3.13 (2018-12-13)

### Security (1 change)

- Validate LFS hrefs before downloading them.


## 11.3.12 (2018-12-06)

### Security (1 change)

- Prevent a path traversal attack on global file templates.


## 11.3.11 (2018-11-26)

### Security (33 changes)

- Filter user sensitive data from discussions JSON. !2537
- Escape entity title while autocomplete template rendering to prevent XSS. !2557
- Restrict Personal Access Tokens to API scope on web requests.
- Fix XSS in merge request source branch name.
- Escape user fullname while rendering autocomplete template to prevent XSS.
- Fix CRLF vulnerability in Project hooks.
- Fix possible XSS attack in Markdown urls with spaces.
- Redact sensitive information on gitlab-workhorse log.
- Set timeout for syntax highlighting.
- Do not follow redirects in Prometheus service when making http requests to the configured api url.
- Persist only SHA digest of PersonalAccessToken#token.
- Sanitize JSON data properly to fix XSS on Issue details page.
- Don't expose confidential information in commit message list.
- Markdown API no longer displays confidential title references unless authorized.
- Provide email notification when a user changes their email address.
- Properly filter private references from system notes.
- Redact personal tokens in unsubscribe links.
- Resolve reflected XSS in Ouath authorize window.
- Fix SSRF in project integrations.
- Fix stored XSS in merge requests from imported repository.
- Fixed ability to comment on locked/confidential issues.
- Fixed ability of guest users to edit/delete comments on locked or confidential issues.
- Fix milestone promotion authorization check.
- Monkey kubeclient to not follow any redirects.
- Configure mermaid to not render HTML content in diagrams.
- Redact confidential events in the API.
- Fix xss vulnerability sourced from package.json.
- Fix a possible symlink time of check to time of use race condition in GitLab Pages.
- Removed ability to see private group names when the group id is entered in the url.
- Fix stored XSS for Environments.
- Block loopback addresses in UrlBlocker.
- Prevent SSRF attacks in HipChat integration.
- Validate Wiki attachments are valid temporary files.


## 11.3.10 (2018-11-18)

### Security (1 change)

- Escape user fullname while rendering autocomplete template to prevent XSS.


## 11.3.9 (2018-10-31)

### Security (1 change)

- Monkey kubeclient to not follow any redirects.


## 11.3.8 (2018-10-27)

- No changes.

## 11.3.7 (2018-10-26)

### Security (6 changes)

- Escape entity title while autocomplete template rendering to prevent XSS. !2557
- Persist only SHA digest of PersonalAccessToken#token.
- Fix XSS in merge request source branch name.
- Redact personal tokens in unsubscribe links.
- Prevent SSRF attacks in HipChat integration.
- Validate Wiki attachments are valid temporary files.


## 11.3.6 (2018-10-17)

- No changes.

## 11.3.5 (2018-10-15)

### Fixed (2 changes)

- Fix loading issue on some merge request discussion. !21982
- Fix project deletion when there is a export available. !22276


## 11.3.3 (2018-10-04)

- No changes.

## 11.3.2 (2018-10-03)

### Fixed (4 changes)

- Fix NULL pipeline import problem and pipeline user mapping issue. !21875
- Fix migration to avoid an exception during upgrade. !22055
- Fixes admin runners table not wrapping content.
- Fix Error 500 when forking projects with Gravatar disabled.

### Other (1 change)

- Removes the 'required' attribute from the 'project name' field. !21770


## 11.3.1 (2018-09-26)

### Security (6 changes)

- Redact confidential events in the API.
- Set timeout for syntax highlighting.
- Sanitize JSON data properly to fix XSS on Issue details page.
- Fix stored XSS in merge requests from imported repository.
- Fix xss vulnerability sourced from package.json.
- Block loopback addresses in UrlBlocker.


## 11.3.0 (2018-09-22)

### Security (5 changes, 1 of them is from the community)

- Disable the Sidekiq Admin Rack session. !21441
- Set issuable_sort, diff_view, and perf_bar_enabled cookies to secure when possible. !21442
- Update rubyzip to 1.2.2 (CVE-2018-1000544). !21460 (Takuya Noguchi)
- Fixed persistent XSS rendering/escaping of diff location lines.
- Block link-local addresses in URLBlocker.

### Removed (1 change)

- Remove Gemnasium service. !21185

### Fixed (83 changes, 24 of them are from the community)

- Hide PAT creation advice for HTTP clone if PAT exists. !18208 (George Thomas @thegeorgeous)
- Allow spaces in wiki markdown links when using CommonMark. !20417
- disable_statement_timeout no longer leak to other migrations. !20503
- Events API now requires the read_user or api scope. !20627 (Warren Parad)
- Fix If-Check the result that a function was executed several times. !20640 (Max Dicker)
- Add migration to cleanup internal_ids inconsistency. !20926
- Fix fallback logic for automatic MR title assignment. !20930 (Franz Liedke)
- Fixed bug when the project logo file is stored in LFS. !20948
- Fix buttons on the new file page wrapping outside of the container. !21015
- Solve tooltip appears under modal. !21017
- Fix Bitbucket Cloud importer omitting replies. !21076
- Fix pipeline fixture seeder. !21088
- Fix blocked user card style. !21095
- Fix empty merge requests not opening in the Web IDE. !21102
- Fix label list item container height when there is no label description. !21106
- Fixes input alignment in user admin form with errors. !21108 (Jacopo Beschi @jacopo-beschi)
- Rails5 fix specs duplicate key value violates unique constraint 'index_gpg_signatures_on_commit_sha'. !21119 (Jasper Maes)
- Add gitlab theme to spam logs pagination. !21145
- Split remembering sorting for issues and merge requests. !21153 (Jacopo Beschi @jacopo-beschi)
- Fix git submodule link for subgroup projects with relative path. !21154
- Fix: Project deletion may not log audit events during group deletion. !21162
- Fix 1px cutoff of emojis. !21180 (gfyoung)
- Auto-DevOps.gitlab-ci.yml: update glibc package to 2.28. !21191 (sgerrand)
- Show google icon in audit log. !21207 (Jan Beckmann)
- Fix bin/secpick error and security branch prefixing. !21210
- Importing a project no longer fails when visibility level holds a string value type. !21242
- Fix attachments not displaying inline with Google Cloud Storage. !21265
- Fix IDE issues with persistent banners. !21283
- Fix "Confidential comments" button not saving in project hooks. !21289
- Bump fog-google to 1.7.0 and google-api-client to 0.23.0. !21295
- Don't use arguments keyword in gettext script. !21296 (gfyoung)
- Fix breadcrumb link to issues on new issue page. !21305 (J.D. Bean)
- Show '< 1%' when percent value evaluated is less than 1 on Stacked Progress Bar. !21306
- API: Catch empty commit messages. !21322 (Robert Schilling)
- Fix SQL error when sorting 2FA-enabled users by name in admin area. !21324
- API: Catch empty code content for project snippets. !21325 (Robert Schilling)
- Avoid nil safe message. !21326 (Yi Siliang)
- Allow date parameters on Issues, Notes, and Discussions API for group owners. !21342 (Florent Dubois)
- Fix remote mirrors failing if Git remotes have not been added. !21351
- Removing a group no longer triggers hooks for project deletion twice. !21366
- Use slugs for default project path and sanitize names before import. !21367
- Vertically centres landscape avatars. !21371 (Vicary Archangel)
- Fix Web IDE unable to commit to same file twice. !21372
- Fix project transfer name validation issues causing a redirect loop. !21408
- Fix Error 500s due to encoding issues when Wiki hooks fire. !21414
- Rails 5: include opclasses in rails 5 schema dump. !21416 (Jasper Maes)
- Bump GitLab Pages to v1.1.0. !21419
- Fix links in RSS feed elements. !21424 (Marc Schwede)
- Allow gaps in multiseries metrics charts. !21427
- Auto-DevOps.gitlab-ci.yml: fix redeploying deleted app gives helm error. !21429
- Use sample data for push event when no commits created. !21440 (Takuya Noguchi)
- Fix importers not assigning a new default group. !21456
- Fix edge cases of JUnitParser. !21469
- Fix breadcrumb link to merge requests on new merge request page. !21502 (J.D. Bean)
- Handle database statement timeouts in usage ping. !21523
- Handles exception during file upload - replaces the stack trace with a small error message. !21528
- Fix closing issue default pattern. !21531 (Samuele Kaplun)
- Fix outdated discussions being shown on Merge Request Changes tab. !21543
- Remove orphaned label links. !21552
- Delete a container registry asynchronously. !21553
- Make MR diff file filter input Clear button functional. !21556
- Replace white spaces in wiki attachments file names. !21569
- API: Use find_branch! in all places. !21614 (Robert Schilling)
- Fixes double +/- on inline diff view. !21634
- Fix broken exports when they include a projet avatar. !21649
- Fix workhorse temp path for namespace uploads. !21650
- Fixed resolved discussions not toggling expanded state on changes tab. !21676
- Update GitLab Shell to v8.3.2. !21701
- Fix absent Click to Expand link on diffs not rendered on first load of Merge Requests Changes tab. !21716
- Update GitLab Shell to v8.3.3. !21750
- Fix import error when archive does not have the correct extension. !21765
- Fixed IDE deleting new files creating wrong state.
- Does not collapse runners section when using pagination.
- Fix Emojis cutting in the right way. (Alexander Popov)
- Fix NamespaceUploader.base_dir for remote uploads.
- Increase width of checkout branch modal box.
- Fixes SVGs for empty states in job page overflowing on mobile.
- Fix checkboxes on runner admin settings - The labels are now clickable.
- Fixed IDE file row scrolling into view when hovering.
- Accept upload files in public/uplaods/tmp when using accelerated uploads.
- Include correct CSS file for xterm in environments page.
- Increase padding in code blocks.
- Fix: Project deletion may not log audit events during user deletion.

### Changed (32 changes, 5 of them are from the community)

- Add default avatar to group. !17271 (George Tsiolis)
- Allow project owners to set up forking relation through API. !18104
- Limit navbar search for current project or group for small viewports. !18634 (George Tsiolis)
- Add Noto Color Emoji font support. !19036 (Alexander Popov)
- Update design of project overview page. !20536
- Improve visuals of language bar on projects. !21006
- Migrate NULL wiki_access_level to correct number so we count active wikis correctly. !21030
- Support a custom action, such as proxying to another server, after /api/v4/internal/allowed check succeeds. !21034
- Remove storage path dependency of gitaly install task. !21101
- Support Kubernetes RBAC for GitLab Managed Apps when adding a existing cluster. !21127
- Change 'Backlog' list title to 'Open' in Issue Boards. !21131
- Enable Auto DevOps Instance Wide Default. !21157
- Allow author to vote on their own issue and MRs. !21203
- Truncate branch names and update "commits behind" text in MR page. !21206
- Adds count for different board list types (label lists, assignee lists, and milestone lists) to usage statistics. !21208
- Render files (`.md`) and wikis using CommonMark. !21228
- Show deprecation message on project milestone page for category tabs. !21236
- Remove redundant header from metrics page. !21282
- Add default parameter to branches API. !21294 (Riccardo Padovani)
- Restrict reopening locked issues for non authorized issue authors. !21299
- Send back required object storage PUT headers in /uploads/authorize API. !21319
- Display default status emoji if only message is entered. !21330
- Move badge settings to general settings. !21333
- Move project settings for default branch under "Repository". !21380
- Import all common metrics into database. !21459
- Improved commit panel in Web IDE. !21471
- Administrative cleanup rake tasks now leverage Gitaly. !21588
- Remove health check feature flag in BackgroundMigrationWorker.
- Expose user's id in /admin/users/ show page. (Eva Kadlecova)
- Improved styling of top bar in IDE job trace pane.
- Make terminal button more visible.
- Shows download artifacts button for pipelines on small screens.

### Performance (13 changes, 2 of them are from the community)

- Enable frozen string in rest of app/models/**/*.rb.
- Add background migrations for legacy artifacts. !18615
- Optimize querying User#manageable_groups. !21050
- Incremental rendering with Vue on merge request page. !21063
- Remove redundant ci_builds (status) index. !21070
- Enable frozen in app/mailers/**/*.rb. !21147 (gfyoung)
- Improve performance when fetching related merge requests for an issue. !21237
- Speed up diff comparisons by limiting number of commit messages rendered. !21335
- Write diff highlighting cache upon MR creation (refactors caching). !21489
- Bulk-render commit titles in the tree view to improve performance. !21500
- Enable frozen string in vestigial app files. (gfyoung)
- Disable project avatar validation if avatar has not changed.
- Bitbucket Server importer: Eliminate most idle-in-transaction issues.

### Added (41 changes, 17 of them are from the community)

- API: Protected tags. !14986 (Robert Schilling)
- Include private contributions to contributions calendar. !17296 (George Tsiolis)
- Add an option to whitelist users based on email address as internal when the "New user set to external" setting is enabled. !17711 (Roger Rüttimann)
- Overhaul listing of projects in the group overview page. !20262
- Add the ability to reference projects in comments and other markdown text. !20285 (Reuben Pereira)
- Add branch filter to project webhooks. !20338 (Duana Saskia)
- Allows to cancel a Created job. !20635 (Jacopo Beschi @jacopo-beschi)
- First Improvements made to the contributor on-boarding experience. !20682 (Eddie Stubbington)
- `/tag` quick action on Commit comments. !20694 (Peter Leitzen)
- Allow admins to configure the maximum Git push size. !20758
- Expose all artifacts sizes in jobs api. !20821 (Peter Marko)
- Get the merge base of two refs through the API. !20929
- Add ability to suppress the global "You won't be able to use SSH" message. !21027 (Ævar Arnfjörð Bjarmason)
- API: Add expiration date for shared projects to the project entity. !21104 (Robert Schilling)
- Added tooltips to tree list header. !21138
- #47845 Add failure_reason to job webhook. !21143 (matemaciek)
- Vendor Auto-DevOps.gitlab-ci.yml with new proxy env vars passed through to docker. !21159 (kinolaev)
- Disable Auto DevOps for project upon first pipeline failure. !21172
- Add rake command to migrate archived traces from local storage to object storage. !21193
- Add Czech as an available language. !21201
- Add Galician as an available language. !21202
- Add support for extendable CI/CD config with. !21243
- Disable Web IDE button if user is not allowed to push the source branch. !21288
- Feature flag to disable Hashed Storage migration when renaming a repository. !21291
- Store wiki uploads inside git repository. !21362
- Adds Rubocop rule to enforce class_methods over module ClassMethods. !21379 (Jacopo Beschi @jacopo-beschi)
- Merge request copies all associated issue labels and milestone on creation. !21383
- Add group name badge under group milestone. !21384
- Adds diverged_commits_count field to GET api/v4/projects/:project_id/merge_requests/:merge_request_iid. !21405 (Jacopo Beschi @jacopo-beschi)
- Update Import/Export to only use new storage uploaders logic. !21409
- Ask user explicitly about usage stats agreement on single user deployments. !21423
- Added atom feed for tags. !21428
- Add search to a group labels page. !21480
- Display banner on project page if AutoDevOps is implicitly enabled. !21503
- Recognize 'UNLICENSE' license files. !21508 (J.D. Bean)
- Add git_v2 feature flag. !21520
- Added file templates to the Web IDE.
- Enabled multiple file uploads in the Web IDE.
- Allow to delete group milestones.
- Use separate model for tracking resource label changes and render label system notes based on data from this model.
- Add system note when due date is changed. (Eva Kadlecova)

### Other (48 changes, 16 of them are from the community)

- Remove extra spaces from MR discussion notes. !18946 (Takuya Noguchi)
- Add an example of the configuration of archive trace cron worker in gitlab.yml.example. !20583
- Add target branch name to cherrypick confirmation message. !20846 (George Andrinopoulos)
- CE Port of Protected Environments backend. !20859
- Added missing i18n strings to issue boards lables dropdown. !21081
- Combines emoji award spec files into single user_interacts_with_awards_in_issue_spec.rb file. !21126 (Nate Geslin)
- Clarify current runners online text. !21151 (Ben Bodenmiller)
- Rails5: Enable verbose query logs. !21231 (Jasper Maes)
- Update presentation for SSO providers on log in page. !21233
- Make margin of user status emoji consistent. !21268
- Move usage ping payload from User Cohorts page to admin application settings. !21343
- Add JSON logging for Bitbucket Server importer. !21378
- Re-add project name field on "Create new project" page. !21386
- Rails 5: replace removed silence_stream. !21387 (Jasper Maes)
- Rails5 update Gemfile.rails5.lock. !21388 (Jasper Maes)
- Rails5: fix can't quote ActiveSupport::HashWithIndifferentAccess. !21397 (Jasper Maes)
- Don't show flash messages for performance bar errors. !21411
- Backport schema_changed.sh from EE which prints the diff if the schema is different. !21422 (Jasper Maes)
- Remove unused CSS part in mobile framework. !21439 (Takuya Noguchi)
- Bump unauthenticated session time from 1 hour to 2 hours. !21453
- Run review-docs-cleanup job for gitlab-org repos only. !21463 (Takuya Noguchi)
- Rails 5: support schema t.index for mysql. !21485 (Jasper Maes)
- Add route information to lograge structured logging for API logs. !21487
- Add gitaly_calls attribute to API logs. !21496
- Ignore irrelevant sql commands in metrics. !21498
- Rails 5: fix hashed_path? method that looks up file_location that doesn't exist when running certain migration specs. !21510 (Jasper Maes)
- Explicit hashed path check for trace, prevents background migration from accessing file_location column that doesn't exist. !21533 (Jasper Maes)
- Add terminal_path to job API response. !21537
- Add User-Agent to production_json.log. !21546
- Make cluster page settings easier to read. !21550
- Remove striped table styling of Find files and Admin Area Applications views. !21560 (Andreas Kämmerle)
- Update ffi to 1.9.25. !21561 (Takuya Noguchi)
- Send max_patch_bytes to Gitaly via Gitaly::CommitDiffRequest. !21575
- Add margin between username and subsequent text in issuable header. !21697
- Send artifact information in job API. !50460
- Reduce differences between CE and EE code base in reports components.
- Move project services log to a separate file.
- Creates vue component for job log top bar with controllers.
- Creates Vue component for trigger variables block in job log page.
- Creates Vvue component for warning block about stuck runners.
- Creates vue component for job log trace.
- Creates vue component for erased block on job view.
- Creates vue component for environments information in job log view.
- Upgrade Monaco editor.
- Creates empty state vue component for job view.
- Creates vue component for commit block in job log page.
- Creates vue components for stage dropdowns and job list container for job log view.
- Creates Vue component for artifacts block on job page.


## 11.2.8 (2018-10-31)

### Security (1 change)

- Monkey kubeclient to not follow any redirects.


## 11.2.7 (2018-10-27)

- No changes.

## 11.2.6 (2018-10-26)

### Security (5 changes)

- Escape entity title while autocomplete template rendering to prevent XSS. !2558
- Fix XSS in merge request source branch name.
- Redact personal tokens in unsubscribe links.
- Persist only SHA digest of PersonalAccessToken#token.
- Prevent SSRF attacks in HipChat integration.


## 11.2.5 (2018-10-05)

### Security (3 changes)

- Filter user sensitive data from discussions JSON. !2538
- Properly filter private references from system notes.
- Markdown API no longer displays confidential title references unless authorized.


## 11.2.4 (2018-09-26)

### Security (6 changes)

- Redact confidential events in the API.
- Set timeout for syntax highlighting.
- Sanitize JSON data properly to fix XSS on Issue details page.
- Fix stored XSS in merge requests from imported repository.
- Fix xss vulnerability sourced from package.json.
- Block loopback addresses in UrlBlocker.


## 11.2.3 (2018-08-28)

### Fixed (1 change)

- Fixed cache invalidation issue with diff lines from 11.2.2.

## 11.2.2 (2018-08-27)

### Security (3 changes)

- Fixed persistent XSS rendering/escaping of diff location lines.
- Adding CSRF protection to Hooks resend action.
- Block link-local addresses in URLBlocker.


## 11.2.1 (2018-08-22)

### Fixed (2 changes)

- Fix wrong commit count in push event payload. !21338
- Fix broken Git over HTTP clones with LDAP users. !21352

### Performance (1 change)

- Eliminate unnecessary and duplicate system hook fires. !21337


## 11.2.0 (2018-08-22)

### Security (5 changes)

- Bump Gitaly to 0.117.1 for Rouge update. !21277
- Fix symlink vulnerability in project import.
- Bump rugged to 0.27.4 for security fixes.
- Fixed XSS in branch name in Web IDE.
- Adding CSRF protection to Hooks test action.

### Removed (1 change)

- Remove gitlab:user:check_repos, gitlab:check_repo, gitlab:git:prune, gitlab:git:gc, and gitlab:git:repack. !20806

### Fixed (81 changes, 26 of them are from the community)

- Fix namespace move callback behavior, especially to fix Geo replication of namespace moves during certain exceptions. !19297
- Fix breadcrumbs in Admin/User interface. !19608 (Robin Naundorf)
- Remove changes_count from MR API documentation where necessary. !19745 (Jan Beckmann)
- Fix email confirmation bug when user adds additional email to account. !20084 (muhammadn)
- Add support for daylight savings time to pipleline schedules. !20145
- Fixing milestone date change when editing. !20279 (Orlando Del Aguila)
- Add missing maximum_timeout parameter. !20355 (gfyoung)
- [Rails5] Fix 'Invalid single-table inheritance type: Group is not a subclass of Gitlab::BackgroundMigration::FixCrossProjectLabelLinks::Namespace'. !20462 (@blackst0ne)
- Rails5 fix mysql milliseconds problem in specs. !20464 (Jasper Maes)
- Update Gemfile.rails5.lock with latest Gemfile.lock changes. !20466 (Jasper Maes)
- Rails5 mysql fix milliseconds problem in pull request importer spec. !20475 (Jasper Maes)
- Rails5 MySQL fix rename_column as part of cleanup_concurrent_column_type_change. !20514 (Jasper Maes)
- Process commits as normal in forks when the upstream project is deleted. !20534
- Fix project visibility tooltip. !20535 (Jamie Schembri)
- Fix archived parameter for projects API. !20566 (Peter Marko)
- Limit maximum project build timeout setting to 1 month. !20591
- Fix GitLab project imports not loading due to API timeouts. !20599
- Avoid process deadlock in popen by consuming input pipes. !20600
- Disable SAML and Bitbucket if OmniAuth is disabled. !20608
- Support multiple scopes when authing container registry scopes. !20617
- Adds the ability to view group milestones on the dashboard milestone page. !20618
- Allow issues API to receive an internal ID (iid) on create. !20626 (Jamie Schembri)
- Fix typo in CSS transform property for Memory Graph component. !20650
- Update design for system metrics popovers. !20655
- Toggle Show / Hide Button for Kubernetes Password. !20659 (gfyoung)
- Board label edit dropdown shows incorrect selected labels summary. !20673
- Resolve "Unable to save user profile update with Safari". !20676
- Escape username and password in UrlSanitizer#full_url. !20684
- Remove background color from card-body style. !20689 (George Tsiolis)
- Update total storage size when changing size of artifacts. !20697 (Peter Marko)
- Rails5 fix user sees revert modal spec. !20706 (Jasper Maes)
- Fix Web IDE crashing on directories named 'blob'. !20712
- Fix accessing imported pipeline builds. !20713
- Fixed bug with invalid repository reference using the wiki search. !20722
- Resolve Copy diff file path as GFM is broken. !20725
- Chart versions for applications installed by one click install buttons should be version locked. !20765
- Fix misalignment of broadcast message on login page. !20794 (Robin Naundorf)
- Fix Vue datatype errors for markdownVersion parsing. !20800
- Fix authorization for interactive web terminals. !20811
- Increase width of Web IDE sidebar resize handles. !20818
- Fix new MR card styles. !20822
- Fix link color in markdown code brackets. !20841
- Rails5 update Gemfile.rails5.lock. !20858 (Jasper Maes)
- fix height of full-width Metrics charts on large screens. !20866
- Fix sorting by name on milestones page. !20881
- Permit concurrent loads in gpg keychain mutex. !20894 (Jasper Maes)
- Prevent editing and updating wiki pages with non UTF-8 encoding via web interface. !20906
- Retrieve merge request closing issues from database cache. !20911
- Fix LFS uploads not working with git-lfs 2.5.0. !20923
- Fix bug setting http headers in Files API. !20938
- Rails5: fix flaky spec. !20953 (Jasper Maes)
- Fixed list of projects not loading in group boards. !20955
- Fix autosave and ESC confirmation issues for MR discussions. !20968
- Fix navigation to First and Next discussion on MR Changes tab. !20968
- Fix rendering of the context lines in MR diffs page. !20968
- fix error caused when using the search bar while unauthenticated. !20970
- Fix GPG status badge loading regressions. !20987
- Ensure links in notifications footer are not escaped. !21000
- Rails5: update Rails5 lock for forgotten gem rouge. !21010 (Jasper Maes)
- Fix UI error whereby prometheus application status is updated. !21029
- Solves group dashboard line height is too tall for group names. !21033
- Fix rendering of pipeline failure view when directly navigationg to it. !21043
- Fix missing and duplicates on project milestone listing page. !21058
- Fix merge requests not showing any diff files for big patches. !21125
- Auto-DevOps.gitlab-ci.yml: Update glibc package signing key URL. !21182 (sgerrand)
- Fix issue stopping Instance Statistics javascript to be executed. !21211
- Fix broken JavaScript in IE11. !21214
- Improve JUnit test reports in merge request widgets. !49966
- Properly handle colons in URL passwords.
- Renders test reports for resolved failures and resets error state.
- Fix handling of annotated tags when Gitaly is not in use.
- Fix serialization of LegacyDiffNote.
- Escapes milestone and label's names on flash notice when promoting them.
- Allow to toggle notifications for issues due soon.
- Sanitize git URL in import errors. (Jamie Schembri)
- Add missing predefined variable and fix docs.
- Allow updating a project's avatar without other params. (Jamie Schembri)
- Fix the UI for listing system-level labels.
- Update hamlit to fix ruby 2.5 incompatibilities, fixes #42045. (Matthew Dawson)
- Fix updated_at if created_at is set for Note API.
- Fix search bar text input alignment.

### Changed (32 changes, 7 of them are from the community)

- Rack attack is now disabled by default. !16669
- Include full image URL in webhooks for uploaded images. !18109 (Satish Perala)
- Enable hashed storage for all newly created or renamed projects. !19747
- Support manually stopping any environment from the UI. !20077
- Close revert and cherry pick modal on escape keypress. !20341 (George Tsiolis)
- Adds with_projects optional parameter to GET /groups/:id API endpoint. !20494
- Improve feedback when a developer is unable to push to an empty repository. !20519
- Display GPG status on repository and blob pages. !20524
- Updated design of new entry dropdown in Web IDE. !20526
- UX improvements to top nav search bar. !20537
- Update issue closing pattern. !20554 (George Tsiolis)
- Add merge request header branch actions left margin. !20643 (George Tsiolis)
- Rubix, scikit-learn, tensorflow & other useful libraries pre-installed with JupyterHub. !20714 (Amit Rathi)
- Show decimal place up to single digit in Stacked Progress Bar. !20776
- Wrap job name on pipeline job sidebar. !20804 (George Tsiolis)
- Redesign Web IDE back button and context header. !20850
- Removes "show all" on reports and adds an actionButtons slot. !20855
- Put fallback reply-key address first in the References header. !20871
- Allow non-admins to view instance statistics (if permitted by the instance admins). !20874
- Adds the project and group name to the return type for project and group milestones. !20890
- Restyle status message input on profile settings. !20903
- Ensure installed Helm Tiller For GitLab Managed Apps Is protected by mutual auth. !20928
- Allow multiple JIRA transition ids. !20939
- Use Helm 2.7.2 for GitLab Managed Apps. !20956
- Create branch and MR picker for Web IDE. !20978
- Update commit message styles with monospace font and overflow-x. !20988
- Update to Rouge 3.2.0, including Terraform and Crystal lexer and bug fixes. !20991
- Update design of project templates. !21012
- Update to Rouge 3.2.1, which includes a critical fix to the Perl Lexer. !21263
- Add a 10 ms bucket for SQL timings.
- Show one digit after dot in commit_per_day value in charts page. (msdundar)
- Redesign GCP offer banner.

### Performance (30 changes, 10 of them are from the community)

- Stop dynamically creating project and namespace routes. !20313
- Tracking the number of repositories and wikis with a cached counter for site-wide statistics. !20413
- Optimize ProjectWiki#empty? check. !20573
- Delete UserActivities and related workers. !20597
- Enable frozen string in app/services/**/*.rb. !20656 (gfyoung)
- Enable more frozen string in app/services/**/*.rb. !20677 (gfyoung)
- Limit the TTL for anonymous sessions to 1 hour. !20700
- Enable even more frozen string in app/services/**/*.rb. !20702 (gfyoung)
- Enable frozen string in app/serializers/**/*.rb. !20726 (gfyoung)
- Enable frozen string in newly added files to previously processed directories. !20763 (gfyoung)
- Use limit parameter to retrieve Wikis from Gitaly. !20764
- Add Dangerfile for frozen_string_literal. !20767 (gfyoung)
- Remove method instrumentation for Banzai filters and reference parsers. !20770
- Enable frozen strings in lib/banzai/filter/*.rb. !20775
- Enable frozen strings in remaining lib/banzai/filter/*.rb files. !20777
- DNS prefetching if asset_host for CDN hosting is set. !20781
- Bump nokogiri to 1.8.4 and sanitize to 4.6.6 for performance. !20795
- Enable frozen string in app/presenters and app/policies. !20819 (gfyoung)
- Bump haml gem to 5.0.4. !20847
- Enable frozen string in app/models/*.rb. !20851 (gfyoung)
- Performing Commit GPG signature calculation in bulk. !20870
- Fix /admin/jobs failing to load due to statement timeout. !20909
- refactor pipeline job log animation to reduce CPU usage. !20915
- Improve performance when fetching collapsed diffs and commenting in merge requests. !20940
- Enable frozen string for app/models/**/*.rb. !21001 (gfyoung)
- Don't set gon variables in JSON requests. !21016 (Peter Leitzen)
- Improve performance and memory footprint of Changes tab of Merge Requests. !21028
- Avoid N+1 on MRs page when metrics merging date cannot be found. !21053
- Bump Gitaly to 0.117.0. !21055
- Access metadata directly from Object Storage.

### Added (41 changes, 18 of them are from the community)

- Show repository languages for projects. !19480
- Adds API endpoint /api/v4/(project/group)/:id/members/all to list also inherited members. !19748 (Jacopo Beschi @jacopo-beschi)
- Added live preview for JavaScript projects in the Web IDE. !19764
- Add support for SSH certificate authentication. !19911 (Ævar Arnfjörð Bjarmason)
- Add Hangouts Chat integration. !20290 (Kukovskii Vladimir)
- Add ability to import multiple repositories by uploading a manifest file. !20304
- Show Project ID on project home panel. !20305 (Tuğçe Nur Taş)
- Add an option to have a private profile on GitLab. !20387 (jxterry)
- Extend gitlab-ci.yml to request junit.xml test reports. !20390
- Add the first mutations for merge requests to GraphQL. !20443
- Add /-/health basic health check endpoint. !20456
- Add filter for minimal access level in groups and projects API. !20478 (Marko, Peter)
- Add download button for single file (including raw files) in repository. !20480 (Kia Mei Somabes)
- Gitaly Servers link into Admin > Overview navigation menu. !20550
- Adds foreign key to notification_settings.user_id. !20567 (Jacopo Beschi @jacopo-beschi)
- JUnit XML Test Summary In MR widget. !20576
- Cleans up display of Deploy Tokens to match Personal Access Tokens. !20578 (Marcel Amirault)
- Users can set a status message and emoji. !20614 (niedermyer & davamr)
- Add emails delivery Prometheus metrics. !20638
- Verify runner feature set. !20664
- Add more comprehensive metrics tracking authentication activity. !20668
- Add support for tar.gz AUTO_DEVOPS_CHART charts (#49324). !20691 (@kondi1)
- Adds Vuex store for reports section in MR widget. !20709
- Redirect commits to root if no ref is provided (31576). !20738 (Kia Mei Somabes)
- Search for labels by title or description on project labels page. !20749
- Add object storage logic to project import. !20773
- Enable renaming files and folders in Web IDE. !20835
- Warn user when reload IDE with staged changes. !20857
- Add local project uploads cleanup task. !20863
- Improve error message when adding invalid user to a project. !20885 (Jacopo Beschi @jacopo-beschi)
- Add link to homepage on static http status pages (404, 500, etc). !20898 (Jason Funk)
- Clean orphaned files in object storage. !20918
- Adds frontend support to render test reports on the MR widget. !20936
- Trigger system hooks when project is archived/unarchived. !20995
- Custom Wiki Sidebar Support Issue 14995. (Josh Sooter)
- Emails on push recipients now accepts formats like John Doe <johndoe@example.com>. (George Thomas)
- Add new model for tracking label events.
- Improve danger confirmation modals by focusing input field. (Jamie Schembri)
- Clicking CI icon in Web IDE now opens up pipelines panel.
- Enabled deletion of files in the Web IDE.
- Added button to regenerate 2FA codes. (Luke Picciau)

### Other (26 changes, 7 of them are from the community)

- Update specific runners help URL. !20213 (George Tsiolis)
- Enable frozen string in apps/uploaders/*.rb. !20401 (gfyoung)
- Update docs of Helm Tiller. !20515 (Takuya Noguchi)
- Persist 'Auto DevOps' banner dismissal globally. !20540
- Move xterm to a node dependency and remove it from vendor's folder. !20588
- Upgrade grape-path-helpers to 1.0.6. !20601
- Delete todos when user loses access to read the target. !20665
- Remove tooltips from commit author avatar and name in commit lists. !20674
- Allow cloning LFS repositories through DeployTokens. !20729
- Replace 'Sidekiq::Testing.inline!' with 'perform_enqueued_jobs'. !20768 (@blackst0ne)
- Replace author_link snake case in stylesheets, specs, and helpers. !20797 (George Tsiolis)
- Replace snake case in SCSS variables. !20799 (George Tsiolis)
- Add rbtrace to Gemfile. !20831
- Add support for searching users by confirmed e-mails. !20893
- Changes poll.js to keep polling on any 2xx http status code. !20904
- Remove todos of users without access to targets migration. !20927
- Improve and simplify Auto DevOps settings flow. !20946
- Keep admin settings sections open after submitting forms. !21040
- CE port of "List groups with developer maintainer access on project creation". !21051
- Update git rerere link in docs. !21060 (gfyoung)
- Add 'tabindex' attribute support on Icon component to show BS4 popover on trigger type 'focus'. !21066
- Add a Gitlab::Profiler.print_by_total_time convenience method for profiling from a Rails console.
- Automatically expand runner's settings block when linking to the runner's settings page.
- Increases title column on modal for reports.
- Disables toggle comments button if diff has no discussions.
- Moves help_popover component to a common location.


## 11.1.8 (2018-10-05)

### Security (3 changes)

- Filter user sensitive data from discussions JSON. !2539
- Properly filter private references from system notes.
- Markdown API no longer displays confidential title references unless authorized.


## 11.1.7 (2018-09-26)

### Security (6 changes)

- Redact confidential events in the API.
- Set timeout for syntax highlighting.
- Sanitize JSON data properly to fix XSS on Issue details page.
- Fix stored XSS in merge requests from imported repository.
- Fix xss vulnerability sourced from package.json.
- Block loopback addresses in UrlBlocker.


## 11.1.6 (2018-08-28)

### Fixed (1 change)

- Fixed cache invalidation issue with diff lines from 11.2.2.

## 11.1.5 (2018-08-27)

### Security (3 changes)

- Fixed persistent XSS rendering/escaping of diff location lines.
- Adding CSRF protection to Hooks resend action.
- Block link-local addresses in URLBlocker.

### Fixed (1 change, 1 of them is from the community)

- Sanitize git URL in import errors. (Jamie Schembri)


## 11.1.4 (2018-07-30)

### Fixed (4 changes, 1 of them is from the community)

- Rework some projects table indexes around repository_storage field. !20377
- Don't overflow project/group dropdown results. !20704 (gfyoung)
- Fixed IDE not opening JSON files. !20798
- Disable Gitaly timeouts when creating or restoring backups. !20810

## 11.1.3 (2018-07-27)

- Not released.

## 11.1.2 (2018-07-26)

### Security (4 changes)

- Adding CSRF protection to Hooks test action.
- Don't expose project names in GitHub counters.
- Don't expose project names in various counters.
- Fixed XSS in branch name in Web IDE.

### Fixed (1 change)

- Escapes milestone and label's names on flash notice when promoting them.

### Performance (1 change)

- Fix slow Markdown rendering. !20820


## 11.1.1 (2018-07-23)

### Fixed (2 changes)

- Add missing Gitaly branch_update nil checks. !20711
- Fix filename for accelerated uploads.

### Added (1 change)

- Add uploader support to Import/Export uploads. !20484


## 11.1.0 (2018-07-22)

### Security (6 changes)

- Fix XSS vulnerability for table of content generation.
- Update sanitize gem to 4.6.5 to fix HTML injection vulnerability.
- HTML escape branch name in project graphs page.
- HTML escape the name of the user in ProjectsHelper#link_to_member.
- Don't show events from internal projects for anonymous users in public feed.
- Fix symlink vulnerability in project import.

### Removed (1 change)

- Remove deprecated object_storage_upload queue.

### Fixed (98 changes, 52 of them are from the community)

- Keep lists ordered when copying only list items. !18522 (Jan Beckmann)
- Fix bug where maintainer would not be allowed to push to forks with merge requests that have `Allow maintainer edits` enabled. !18968
- mergeError message has been binded using v-html directive. !19058 (Murat Dogan)
- Set MR target branch to default branch if target branch is not valid. !19067
- Fix CSS for buttons not to be hidden on issues/MR title. !19176 (Takuya Noguchi)
- Use same gem versions for rails5 as for rails4 where possible. !19498 (Jasper Maes)
- Fix extra blank line at start of rendered reStructuredText code block. !19596
- Fix username validation order on signup, resolves #45575. !19610 (Jan Beckmann)
- Make quick commands case insensitive. !19614 (Jan Beckmann)
- Remove incorrect CI doc re: PowerShell. !19622 (gfyoung)
- Fixes Microsoft Teams notifications for pipeline events. !19632 (Jeff Brown)
- Fix branch name encoding for dropdown on issue page. !19634
- Rails5 fix expected `issuable.reload.updated_at` to have changed. !19733 (Jasper Maes)
- Rails5 fix stack level too deep. !19762 (Jasper Maes)
- Rails5 ActionController::ParameterMissing: param is missing or the value is empty: application_setting. !19763 (Jasper Maes)
- Invalidate cache with project details when repository is updated. !19774
- Rails5 fix no implicit conversion of Hash into String. ActionController::Parameters no longer returns an hash in Rails 5. !19792 (Jasper Maes)
- [Rails5] Fix snippets_finder arel queries. !19796 (@blackst0ne)
- Fix fields for author & assignee in MR API docs. !19798 (gfyoung)
- Remove scrollbar in Safari in repo settings page. !19809 (gfyoung)
- Omits operartions and kubernetes item from project sidebar when repository or builds are disabled. !19835
- Rails5 fix passing Group objects array into for_projects_and_groups milestone scope. !19863 (Jasper Maes)
- Fix chat service tag notifications not sending when only default branch enabled. !19864
- Only show new issue / new merge request on group page when issues / merge requests are enabled. !19869 (Jan Beckmann)
- [Rails5] Explicitly set request.format for blob_controller. !19876 (@blackst0ne)
- [Rails5] Fix optimistic lock value. !19878 (@blackst0ne)
- Rails5 fix update_attribute usage not causing a save. !19881 (Jasper Maes)
- Rails5 fix connection execute return integer instead of string. !19901 (Jasper Maes)
- Rails5 fix format in uploads actions. !19907 (Jasper Maes)
- [Rails5] Fix "-1 is not a valid data_store". !19917 (@blackst0ne)
- [Rails5] Invalid single-table inheritance type: Group is not a subclass of Namespace. !19918 (@blackst0ne)
- [Rails5] Fix pipeline_schedules_controller_spec. !19919 (@blackst0ne)
- Rails5 fix passing Group objects array into for_projects_and_groups milestone scope. !19920 (Jasper Maes)
- Rails5 update Gemfile.rails5.lock. !19921 (Jasper Maes)
- [Rails5] Fix sessions_controller_spec. !19936 (@blackst0ne)
- [Rails5] Set request.format for artifacts_controller. !19937 (@blackst0ne)
- Fix webhook error when password is not present. !19945 (Jan Beckmann)
- Fix label and milestone duplicated records and IID errors. !19961
- Rails5 fix expected: 1 time with arguments: (97, anything, {"squash"=>false}) received: 0 times. !20004 (Jasper Maes)
- Rails5 fix Projects::PagesController spec. !20007 (Jasper Maes)
- [Rails5] Fix ActionCable '/cable' mountpoint conflict. !20015 (@blackst0ne)
- Fix branches are not shown in Merge Request dropdown when preferred language is not English. !20016 (Hiroyuki Sato)
- Rails5 fix Admin::HooksController. !20017 (Jasper Maes)
- Rails5 fix  expected: 0 times with any arguments received: 1 time with arguments: DashboardController. !20018 (Jasper Maes)
- [Rails5] Set request.format in commits_controller. !20023 (@blackst0ne)
- Keeps the label on an issue when the issue is moved. !20036
- Cleanup Prometheus ruby metrics. !20039 (Ben Kochie)
- Rails 5 fix Capybara::ElementNotFound: Unable to find visible css #modal-revert-commit and expected: "/bar" got: "/foo". !20044 (Jasper Maes)
- [Rails5] Force the callback run first. !20055 (@blackst0ne)
- Add readme button to non-empty project page. !20104
- Fixed bug when editing a comment in an issue,the preview mode is toggled in the main textarea. !20112 (Constance Okoghenun)
- Ignore unknown OAuth sources in ApplicationSetting. !20129
- Fix paragraph line height for emoji. !20137 (George Tsiolis)
- Fixes issue with uploading same image to Profile Avatar twice. !20161 (Chirag Bhatia)
- Rails5 fix arel from in mysql_median_datetime_sql. !20167 (Jasper Maes)
- Adds the `locked` state to the merge request API so that it can be used as a search filter. !20186
- Enable Doorkeeper option to avoid generating new tokens when users login via oauth. !20200
- Fix OAuth Application Authorization screen to appear with each access. !20216
- Rails5 fix MySQL milliseconds problem in specs. !20221 (Jasper Maes)
- Rails5 fix Mysql comparison failure caused by milliseconds problem. !20222 (Jasper Maes)
- Updated last commit link color. !20234 (Constance Okoghenun)
- Fixed Merge request changes dropdown displays incorrectly. !20237 (Constance Okoghenun)
- Show jobs from same pipeline in sidebar in job details view. !20243
- [Rails5] Fix milestone GROUP BY query. !20256 (@blackst0ne)
- Line separator to the left of the 'Admin area' wrench icon had vanished. !20282 (bitsapien)
- Check if archived trace exist before archive it. !20297
- Load Devise with Omniauth when auto_sign_in_with_provider is configured. !20302
- Fix link to job when creating a new issue from a failed job. !20328
- Fix double "in" in time to artifact deletion message. !20357 (@bbodenmiller)
- Fix wrong role badge displayed in projects dashboard. !20374
- Stop relying on migrations in the CacheableAttributes cache key and cache attributes for 1 minute instead. !20389
- Fixes toggle discussion button not expanding collapsed discussions. !20452
- Resolve compatibility issues with node 6. !20461
- Fixes base command used in Helm installations. !20471
- Fix RSS button interaction on Dashboard, Project and Group activities. !20549
- Use appropriate timeout on Gitaly server info checks, avoid error on timeout. !20552
- Remove healthchecks from prometheus endpoint. !20565
- Render MR page when diffs cannot be fetched from the database or the git repository. !20680
- Expire correct method caches after HEAD changed.
- Ensure MR diffs always exist in the PR importer.
- Fix overlapping file title and file actions in MR changes tag.
- Mark MR as merged regardless of errors when closing issues.
- Fix performance bar modal visibility in Safari.
- Prevent browser autocomplete for milestone date fields.
- Limit the action suffixes in transaction metrics.
- Add /uploads subdirectory to allowed upload paths.
- Fix cross-project label references.
- Invalidate merge request diffs cache if diff data change.
- Don't show context button for diffs of deleted files.
- Structure getters for diff Store properly and adds specs.
- Bump rugged to 0.27.2.
- Fix Bamboo CI status not showing for branch plans.
- Fixed bug that allowed to remove other wiki pages if the title had wildcard characters.
- Disabled Web IDE autocomplete suggestions for Markdown files. (Isaac Smith)
- Fix merge request diffs when created with gitaly_diff_between enabled.
- Properly detect label reference if followed by period or question mark.
- Deactivate new KubernetesService created from active template to prevent project creation from failing.
- Allow trailing whitespace on blockquote fence lines.

### Deprecated (1 change)

- Removes unused bootstrap 4 scss files. !19423

### Changed (33 changes, 16 of them are from the community)

- Change label link vertical alignment property. !18777 (George Tsiolis)
- Updated the icon for expand buttons to ellipsis. !18793 (Constance Okoghenun)
- Create new or add existing Kubernetes cluster from a single page. !18963
- Use object storage as the first class persistable store for new live trace architecture. !19515
- Hide project name if searching against a project. !19595
- Allows you to create another deploy token dimmediately after creating one. !19639
- Removes the environment scope field for users that cannot edit it. !19643
- Don't hash user ID in OIDC subject claim. !19784 (Markus Koller)
- Milestone page list redesign. !19832 (Constance Okoghenun)
- Add environment dropdown for the metrics page. !19833
- Allow querying a single merge request within a project. !19853
- Update WebIDE to show file in tree on load. !19887
- Remove small container width. !19893 (George Tsiolis)
- Improve U2F workflow when using unsupported browsers. !19938 (Jan Beckmann)
- Update Web IDE file tree styles. !19969
- Highlight cluster settings message. !19996 (George Tsiolis)
- Fade uneditable area in Web IDE. !20008
- Update pipeline icon in web ide sidebar. !20058 (George Tsiolis)
- Revert merge request discussion buttons padding. !20060 (George Tsiolis)
- Fix boards issue highlight. !20063 (George Tsiolis)
- Update external link icon in header user dropdown. !20150 (George Tsiolis)
- Update external link icon in merge request widget. !20154 (George Tsiolis)
- Update environments nav controls icons. !20199 (George Tsiolis)
- Update integrations external link icons. !20205 (George Tsiolis)
- Fixes an issue where migrations instead of schema loading were run. !20227
- Add title placeholder for new issues. !20271 (George Tsiolis)
- Close revoke deploy token modal on escape keypress. !20347 (George Tsiolis)
- Change environment scope text depending on number of project clusters. Update form to only include form-groups.
- Improve Web IDE commit flow.
- Add machine type and pricing documentation links, add class to labels to make bold.
- Remove remaining traces of the Allocations Gem.
- Use one column form layout on Admin Area Settings page.
- Add back copy for existing gcp accounts within offer banner.

### Performance (16 changes, 4 of them are from the community)

- Fully migrate pipeline stages position. !19369
- Use Tooltip component in MrWidgetAuthorTime vue comonent. !19635 (George Tsiolis)
- Move boards modal EmptyState vue component. !20068 (George Tsiolis)
- Bump carrierwave gem verion to 1.2.3. !20287
- Remove redundant query when removing trace. !20324
- Improves performance of mr code, by fixing the state being mutated outside of the store in the util function trimFirstCharOfLineContent and in map operations. Avoids map operation in an empty array. Adds specs to the trimFirstCharOfLineContent function. !20380 (filipa)
- Reduce the number of queries when searching for groups. !20398
- Improve render performance of large wiki pages. !20465 (Peter Leitzen)
- Improves performance on Merge Request diff tab by removing the scroll event listeners being added to every file.
- Remove the ci_job_request_with_tags_matcher.
- Updated Gitaly fail-fast timeout values.
- Add index on deployable_type/id for deployments.
- Eliminate N+1 queries in LFS file locks checks during a push.
- Fix performance problem of accessing tag list for projects api endpoints.
- Improve performance of listing users without projects.
- Fixed pagination of web hook logs.

### Added (29 changes, 9 of them are from the community)

- Add dropdown to Groups link in top bar. !18280
- Web IDE supports now Image + Download Diff Viewing. !18768
- Use CommonMark syntax and rendering for new Markdown content. !19331
- Add SHA256 and HEAD on File API. !19439 (ahmet2mir)
- Add filename filtering to code search. !19509
- Add CI_PIPELINE_URL and CI_JOB_URL. !19618
- Expose visibility via Snippets API. !19620 (Jan Beckmann)
- Fixed pagination of groups API. !19665 (Marko, Peter)
- Added id sorting option to GET groups and subgroups API. !19665 (Marko, Peter)
- Add a link to the contributing page in the user dropdown. !19708
- Add Object Storage to project export. !20105
- Change avatar image in the header when user updates their avatar. !20119 (Jamie Schembri)
- Allow straight diff in Compare API. !20120 (Maciej Nowak)
- Add transfer project API endpoint. !20122 (Aram Visser)
- Expose permissions of the current user on resources in GraphQL. !20152
- Run repository checks in parallel for each shard. !20179
- Add pipeline lists to GraphQL. !20249
- Add option to add README when creating a project. !20335
- Add option to hide third party offers in admin application settings. !20379
- Add /confidential quick action. (Jan Beckmann)
- Support direct_upload for generic uploads.
- Display merge request title & description in Web IDE.
- Prune web hook logs older than 90 days.
- Add Web Terminal for Ci Builds. (Vicky Chijwani)
- Expose whether current user can push into a branch on branches API.
- Present state indication on GFM preview.
- migrate backup rake task to gitaly.
- Add Gitlab::SQL:CTE for easily building CTE statements.
- Added with_statsoption for GET /projects/:id/repository/commits.

### Other (28 changes, 11 of them are from the community)

- Move some Gitaly RPC's to opt-out. !19591
- Bump grape-path-helpers to 1.0.5. !19604 (@blackst0ne)
- Add CI job to check Gemfile.rails5.lock. !19605 (@blackst0ne)
- Move Gitaly branch/tag/ref RPC's to opt-out. !19644
- CE port gitlab-ee!6112. !19714
- Enable no-multi-assignment in JS files. !19808 (gfyoung)
- Enable no-restricted globals in JS files. !19877 (gfyoung)
- Improve no-multi-assignment fixes after enabling rule. !19915 (gfyoung)
- Enable prefer-structuring in JS files. !19943 (gfyoung)
- Enable frozen string in app/workers/*.rb. !19944 (gfyoung)
- Uses long sha version of the merged commit in MR widget copy to clipboard button. !19955
- Update new group page to better explain what groups are. !19991
- Update new SSH key page to improve copy. !19994
- Update new SSH key page to improve key input validation. !19997
- Gitaly metrics check for read/writeability. !20022
- Add ellispsis to web ide commit button. !20030
- Minor style changes to personal access token form and scope checkboxes. !20052
- Finish enabling frozen string for app/workers/*.rb. !20197 (gfyoung)
- Allows settings sections to expand by default when linking to them. !20211
- Enable frozen string in apps/validators/*.rb. !20220 (gfyoung)
- update bcrypt to also support libxcrypt. !20260 (muhammadn)
- Enable frozen string in apps/validators/*.rb. !20382 (gfyoung)
- Removes unused vuex code in mr refactor and removes unneeded dependencies. !20499
- Delete non-latest merge request diff files upon merge.
- Schedule workers to delete non-latest diffs in post-migration.
- Remove the use of `is_shared` of `Ci::Runner`.
- Add more detailed logging to githost.log when rebasing.
- Use monospaced font for MR diff commit link ref on GFM.


## 11.0.6 (2018-08-27)

### Security (3 changes)

- Fixed persistent XSS rendering/escaping of diff location lines.
- Adding CSRF protection to Hooks resend action.
- Block link-local addresses in URLBlocker.

### Fixed (1 change, 1 of them is from the community)

- Sanitize git URL in import errors. (Jamie Schembri)


## 11.0.5 (2018-07-26)

### Security (4 changes)

- Don't expose project names in various counters.
- Don't expose project names in GitHub counters.
- Adding CSRF protection to Hooks test action.
- Fixed XSS in branch name in Web IDE.

### Fixed (1 change)

- Escapes milestone and label's names on flash notice when promoting them.


## 11.0.4 (2018-07-17)

### Security (1 change)

- Fix symlink vulnerability in project import.


## 11.0.3 (2018-07-05)

### Fixed (14 changes, 1 of them is from the community)

- Revert merge request widget button max height. !20175 (George Tsiolis)
- Implement upload copy when moving an issue with upload on object storage. !20191
- Fix broken '!' support to autocomplete MRs in GFM fields. !20204
- Restore showing Elasticsearch and Geo status on dashboard. !20276
- Fix merge request page rendering error when its target/source branch is missing. !20280
- Fix sidebar collapse breapoints for job and wiki pages.
- fix size of code blocks in headings.
- Fix loading screen for search autocomplete dropdown.
- Fix ambiguous due_date column for Issue scopes.
- Always serve favicon from main GitLab domain so that CI badge can be drawn over it.
- Fix tooltip flickering bug.
- Fix refreshing cache keys for open issues count.
- Replace deprecated bs.affix in merge request tabs with sticky polyfill.
- Prevent pipeline job tooltip from scrolling off dropdown container.


## 11.0.2 (2018-06-26)

### Fixed (8 changes, 1 of them is from the community)

- Serve favicon image always from the main GitLab domain to avoid issues with CORS. !19810 (Alexis Reigel)
- Specify chart version when installing applications on Clusters. !20010
- Fix invalid fuzzy translations being generated during installation. !20048
- Fix incremental rollouts for Auto DevOps. !20061
- Notify conflict for only open merge request. !20125
- Only load Omniauth if enabled. !20132
- Fix sorting by name on explore projects page. !20162
- Fix alert button styling so that they don't show up white.

### Performance (1 change)

- Remove performance bottleneck preventing large wiki pages from displaying. !20174

### Added (1 change)

- Add support for verifying remote uploads, artifacts, and LFS objects in check rake tasks. !19501


## 11.0.1 (2018-06-21)

### Security (5 changes)

- Fix XSS vulnerability for table of content generation.
- Update sanitize gem to 4.6.5 to fix HTML injection vulnerability.
- HTML escape branch name in project graphs page.
- HTML escape the name of the user in ProjectsHelper#link_to_member.
- Don't show events from internal projects for anonymous users in public feed.


## 11.0.0 (2018-06-22)

### Security (3 changes)

- Fix API to remove deploy key from project instead of deleting it entirely.
- Fixed bug that allowed importing arbitrary project attributes.
- Prevent user passwords from being changed without providing the previous password.

### Removed (2 changes)

- Removed API v3 from the codebase. !18970
- Removes outdated `g t` shortcut for TODO in favor of `Shift+T`. !19002

### Fixed (69 changes, 23 of them are from the community)

- Optimize the upload migration proces. !15947
- Import bitbucket issues that are reported by an anonymous user. !18199 (bartl)
- Fix an issue where the notification email address would be set to an unconfirmed email address. !18474
- Stop logging email information when emails are disabled. !18521 (Marc Shaw)
- Fix double-brackets being linkified in wiki markdown. !18524 (brewingcode)
- Use case in-sensitive ordering by name for dashboard. !18553 (@vedharish)
- Fix width of contributors graphs. !18639 (Paul Vorbach)
- Fix modal width of shorcuts help page. !18766 (Lars Greiss)
- Add missing tooltip to creation date on container registry overview. !18767 (Lars Greiss)
- Add missing migration for minimal Project build_timeout. !18775
- Update commit status from external CI services less aggressively. !18802
- Fix Runner contacted at tooltip cache. !18810
- Added support for LFS Download in the importing process. !18871
- Fix issue board bug with long strings in titles. !18924
- Does not log failed sign-in attempts when the database is in read-only mode. !18957
- Fixes 500 error on /estimate BIG_VALUE. !18964 (Jacopo Beschi @jacopo-beschi)
- Forbid to patch traces for finished jobs. !18969
- Do not allow to trigger manual actions that were skipped. !18985
- Renamed 'Overview' to 'Project' in collapsed contextual navigation at a project level. !18996 (Constance Okoghenun)
- Fixed bug where generated api urls didn't add the base url if set. !19003
- Fixed badge api endpoint route when relative url is set. !19004
- Fixes: Runners search input placeholder is cut off. !19015 (Jacopo Beschi @jacopo-beschi)
- Exclude CI_PIPELINE_ID from variables supported in dynamic environment name. !19032
- Updates updated_at on label changes. !19065 (Jacopo Beschi @jacopo-beschi)
- Disallow updating job status if the job is not running. !19101
- Fix FreeBSD can not upload artifacts due to wrong tmp path. !19148
- Check for nil AutoDevOps when saving project CI/CD settings. !19190
- Missing timeout value in object storage pre-authorization. !19201
- Use strings as properties key in kubernetes service spec. !19265 (Jasper Maes)
- Fixed HTTP_PROXY environment not honored when reading remote traces. !19282 (NLR)
- Updates ReactiveCaching clear_reactive_caching method to clear both data and alive caching. !19311
- Fixes the styling on the modal headers. !19312 (samdbeckham)
- Fixes a spelling error on the new label page. !19316 (samdbeckham)
- Rails5 fix arel from. !19340 (Jasper Maes)
- Support rails5 in postgres indexes function and fix some migrations. !19400 (Jasper Maes)
- Fix repository archive generation when hashed storage is enabled. !19441
- Rails 5 fix unknown keywords: changes, key_id, project, gl_repository, action, secret_token, protocol. !19466 (Jasper Maes)
- Rails 5 fix glob spec. !19469 (Jasper Maes)
- Showing project import_status in a humanized form no longer gives an error. !19470
- Make avatars/icons hidden on mobile. !19585 (Takuya Noguchi)
- Fix active tab highlight when creating new merge request. !19781 (Jan Beckmann)
- Fixes Web IDE button on merge requests when GitLab is installed with relative URL.
- Unverified hover state color changed to black.
- Fix &nbsp; after sign-in with Google button.
- Don't trim incoming emails that create new issues. (Cameron Crockett)
- Wrapping problem on the issues page has been fixed.
- Fix resolvable check if note's commit could not be found.
- Fix filename matching when processing file or blob search results.
- Allow maintainers to retry pipelines on forked projects (if allowed in merge request).
- Fix deletion of Object Store uploads.
- Fix overflowing Failed Jobs table in sm viewports on IE11.
- Adjust insufficient diff hunks being persisted on NoteDiffFile.
- Render calendar feed inline when accessed from GitLab.
- Line height fixed. (Murat Dogan)
- Use upload ID for creating lease key for file uploaders.
- Use Github repo visibility during import while respecting restricted visibility levels.
- Adjust permitted params filtering on merge scheduling.
- Fix unscrollable Markdown preview of WebIDE on Firefox.
- Enforce UTF-8 encoding on user input in LogrageWithTimestamp formatter and filter out file content from logs.
- Fix project destruction failing due to idle in transaction timeouts.
- Add a unique and not null constraint on the project_features.project_id column.
- Expire Wiki content cache after importing a repository.
- Fix admin counters not working when PostgreSQL has secondaries.
- Fix backup creation and restore for specific Rake tasks.
- Fix cross-origin errors when attempting to download JavaScript attachments.
- Fix api_json.log not always reporting the right HTTP status code.
- Fix attr_encryption key settings.
- Remove gray button styles.
- Fix print styles for markdown pages.

### Deprecated (4 changes)

- Deprecate Gemnasium project service. !18954
- Rephrasing Merge Request's 'allow edits from maintainer' functionality. !19061
- Rename issue scope created-by-me to created_by_me, and assigned-to-me to assigned_to_me. !44799
- Migrate any remaining jobs from deprecated `object_storage_upload` queue.

### Changed (42 changes, 11 of them are from the community)

- Add support for smarter system notes. !17164
- Automatically accepts project/group invite by email after user signup. !17634 (Jacopo Beschi @jacopo-beschi)
- Dynamically fetch GCP cluster creation parameters. !17806
- Label list page redesign. !18466
- Move discussion actions to the right for small viewports. !18476 (George Tsiolis)
- Add 2FA filter to the group members page. !18483
- made listing and showing public issue apis available without authentication. !18638 (haseebeqx)
- Refactoring UrlValidators to include url blocking. !18686
- Removed "(Beta)" from "Auto DevOps" messages. !18759
- Expose runner ip address to runners API. !18799 (Lars Greiss)
- Moves MR widget external link icon to the right. !18828 (Jacopo Beschi @jacopo-beschi)
- Add support for 'active' setting on Runner Registration API endpoint. !18848
- Add dot to separate system notes content. !18864
- Remove modalbox confirmation when retrying a pipeline. !18879
- Remove docker pull prefix from registry clipboard feature. !18933 (Lars Greiss)
- Move project sidebar sub-entries 'Environments' and 'Kubernetes' from 'CI/CD' to a new entry 'Operations'. !18941
- Updated icons for branch and tag names in commit details. !18953 (Constance Okoghenun)
- Expose readme url in Project API. !18960 (Imre Farkas)
- Changes keyboard shortcut of Activity feed to `g v`. !19002
- Updated Mattermost integration to use API v4 and only allow creation of Mattermost slash commands in the current user's teams. !19043 (Harrison Healey)
- Add shortcuts to Web IDE docs and modal. !19044
- Rename merge request widget author component. !19079 (George Tsiolis)
- Rename the Master role to Maintainer. !19080
- Use "right now" for short time periods. !19095
- Update 404 and 403 pages with helpful actions. !19096
- Add username to terms message in git and API calls. !19126
- Change the IDE file buttons for an "Open in file view" button. !19129 (Sam Beckham)
- Removes redundant script failure message from Job page. !19138
- Add flash notice if user has already accepted terms and allow users to continue to root path. !19156
- Redesign group settings page into expandable sections. !19184
- Hashed Storage: migration rake task now can be executed to specific project. !19268
- Make CI job update entrypoint to work as keep-alive endpoint. !19543
- Avoid checking the user format in every url validation. !19575
- Apply notification settings level of groups to all child objects.
- Support restoring repositories into gitaly.
- Bump omniauth-gitlab to 1.0.3.
- Move API group deletion to Sidekiq.
- Improve Failed Jobs tab in the Pipeline detail page.
- Add additional theme color options.
- Include milestones from parent groups when assigning a milestone to an issue or merge request.
- Restore API v3 user endpoint.
- Hide merge request option in IDE when disabled.

### Performance (28 changes, 1 of them is from the community)

- Add backgound migration for filling nullfied file_store columns. !18557
- Add a cronworker to rescue stale live traces. !18680
- Move SquashBeforeMerge vue component. !18813 (George Tsiolis)
- Add index on runner_type for ci_runners. !18897
- Fix CarrierWave reads local files into memoery when migrates to ObjectStorage. !19102
- Remove double-checked internal id generation. !19181
- Throttle updates to Project#last_repository_updated_at. !19183
- Add background migrations for archiving legacy job traces. !19194
- Use NPM provided version of SortableJS. !19274
- Improve performance of group issues filtering on GitLab.com. !19429
- Improve performance of LFS integrity check. !19494
- Fix an N+1 when loading user avatars.
- Only preload member records for the relevant projects/groups/user in projects API.
- Fix some sources of excessive query counts when calculating notification recipients.
- Optimise PagesWorker usage.
- Optimise paused runners to reduce amount of used requests.
- Update runner cached informations without performing validations.
- Improve performance of project pipelines pages.
- Persist truncated note diffs on a new table.
- Remove unused running_or_pending_build_count.
- Remove N+1 query for author in issues API.
- Eliminate N+1 queries with authors and push_data_payload in Events API.
- Eliminate cached N+1 queries for projects in Issue API.
- Eliminate N+1 queries for CI job artifacts in /api/prjoects/:id/pipelines/:pipeline_id/jobs.
- Fix N+1 with source_projects in merge requests API.
- Replace grape-route-helpers with our own grape-path-helpers.
- Move PR IO operations out of a transaction.
- Improve performance of GroupsController#show.

### Added (25 changes, 10 of them are from the community)

- Closes MR check out branch modal with escape. (19050)
- Allow changing the default favicon to a custom icon. !14497 (Alexis Reigel)
- Export assigned issues in iCalendar feed. !17783 (Imre Farkas)
- When MR becomes unmergeable, notify and create todo for author and merge user. !18042
- Display help text below auto devops domain with nip.io domain name (#45561). !18496
- Add per-project pipeline id. !18558
- New design for wiki page deletion confirmation. !18712 (Constance Okoghenun)
- Updates updated_at on issuable when setting time spent. !18757 (Jacopo Beschi @jacopo-beschi)
- Expose artifacts_expire_at field for job entity in api. !18872 (Semyon Pupkov)
- Add support for variables expression pattern matching syntax. !18902
- Add API endpoint to render markdown text. !18926 (@blackst0ne)
- Add `Squash and merge` to GitLab Core (CE). !18956 (@blackst0ne)
- Adds keyboard shortcut `g k` for Kubernetes on Project pages. !19002
- Adds keyboard shortcut `g e` for Environments on Project pages. !19002
- Setup graphql with initial project & merge request query. !19008
- Adds JupyterHub to cluster applications. !19019
- Added ability to search by wiki titles. !19112
- Add Avatar API. !19121 (Imre Farkas)
- Add variables to POST api/v4/projects/:id/pipeline. !19124 (Jacopo Beschi @jacopo-beschi)
- Add deploy strategies to the Auto DevOps settings. !19172
- Automatize Deploy Token creation for Auto Devops. !19507
- Add anchor for incoming email regex.
- Support direct_upload with S3 Multipart uploads.
- Add Open in Xcode link for xcode repositories.
- Add pipeline status to the status bar of the Web IDE.

### Other (40 changes, 17 of them are from the community)

- Expand documentation for Runners API. !16484
- Order UsersController#projects.json by updated_at. !18227 (Takuya Noguchi)
- Replace the `project/issues/references.feature` spinach test with an rspec analog. !18769 (@blackst0ne)
- Replace the `project/merge_requests/references.feature` spinach test with an rspec analog. !18794 (@blackst0ne)
- Replace the `project/deploy_keys.feature` spinach test with an rspec analog. !18796 (@blackst0ne)
- Replace the `project/ff_merge_requests.feature` spinach test with an rspec analog. !18800 (@blackst0ne)
- Apply NestingDepth (level 5) (pages/pipelines.scss). !18830 (Takuya Noguchi)
- Replace the `project/forked_merge_requests.feature` spinach test with an rspec analog. !18867 (@blackst0ne)
- Remove Spinach. !18869 (@blackst0ne)
- Add NOT NULL constraints to project_authorizations. !18980
- Add helpful messages to empty wiki view. !19007
- Increase text limit for GPG keys (mysql only). !19069
- Take two for MR metrics population background migration. !19097
- Remove Gemnasium badge from project README.md. !19136 (Takuya Noguchi)
- Update awesome_print to 1.8.0. !19163 (Takuya Noguchi)
- Update email_spec to 2.2.0. !19164 (Takuya Noguchi)
- Update redis-namespace to 1.6.0. !19166 (Takuya Noguchi)
- Update rdoc to 6.0.4. !19167 (Takuya Noguchi)
- Updates the version of kubeclient from 3.0 to 3.1.0. !19199
- Fix UI broken in line profiling modal due to Bootstrap 4. !19253 (Takuya Noguchi)
- Add migration to disable the usage of DSA keys. !19299
- Use the default strings of timeago.js for timeago. !19350 (Takuya Noguchi)
- Update selenium-webdriver to 3.12.0. !19351 (Takuya Noguchi)
- Include username in output when testing SSH to GitLab. !19358
- Update screenshot in GitLab.com integration documentation. !19433 (Tuğçe Nur Taş)
- Users can accept terms during registration. !19583
- Fix issue count on sidebar.
- Add merge requests list endpoint for groups.
- Upgrade GitLab from Bootstrap 3 to 4.
- Make ActiveRecordSubscriber rails 5 compatible.
- Show a more helpful error for import status.
- Log response body to production_json.log when a controller responds with a 422 status.
- Log Workhorse queue duration for Grape API calls.
- Adjust SQL and transaction Prometheus buckets.
- Adding branches through the WebUI is handled by Gitaly.
- Remove shellout implementation for Repository checksums.
- Refs containting sha checks are done by Gitaly.
- Finding a wiki page is done by Gitaly by default.
- Workhorse will use Gitaly to create archives.
- Workhorse to send raw diff and patch for commits.


## 10.8.6 (2018-07-17)

### Security (2 changes)

- Fix symlink vulnerability in project import.
- Merge branch 'fix-mr-widget-border' into 'master'.


## 10.8.5 (2018-06-21)

### Security (5 changes)

- Fix XSS vulnerability for table of content generation.
- Update sanitize gem to 4.6.5 to fix HTML injection vulnerability.
- HTML escape branch name in project graphs page.
- HTML escape the name of the user in ProjectsHelper#link_to_member.
- Don't show events from internal projects for anonymous users in public feed.


## 10.8.4 (2018-06-06)

- No changes.

## 10.8.3 (2018-05-30)

### Fixed (4 changes)

- Replace Gitlab::REVISION with Gitlab.revision and handle installations without a .git directory. !19125
- Fix encoding of branch names on compare and new merge request page. !19143
- Fix remote mirror database inconsistencies when upgrading from EE to CE. !19196
- Fix local storage not being cleared after creating a new issue.

### Performance (1 change)

- Memoize Gitlab::Database.version.


## 10.8.2 (2018-05-28)

### Security (3 changes)

- Prevent user passwords from being changed without providing the previous password.
- Fix API to remove deploy key from project instead of deleting it entirely.
- Fixed bug that allowed importing arbitrary project attributes.


## 10.8.1 (2018-05-23)

### Fixed (9 changes)

- Allow CommitStatus class to use presentable methods. !18979
- Fix corrupted environment pages with unathorized proxy url. !18989
- Fixes deploy token variables on Ci::Build. !19047
- Fix project mirror database inconsistencies when upgrading from EE to CE. !19109
- Render 404 when prometheus adapter is disabled in Prometheus metrics controller. !19110
- Fix error when deleting an empty list of refs.
- Fixed U2F login when used with LDAP.
- Bump prometheus-client-mmap to 0.9.3 to fix nil exception error.
- Fix system hook not firing for blocked users when LDAP sign-in is used.


## 10.8.0 (2018-05-22)

### Security (3 changes, 1 of them is from the community)

- Update faraday_middlewar to 0.12.2. !18397 (Takuya Noguchi)
- Serve archive requests with the correct file in all cases.
- Sanitizes user name to avoid XSS attacks.

### Fixed (47 changes, 11 of them are from the community)

- Refactor CSS to eliminate vertical misalignment of login nav. !16275 (Takuya Noguchi)
- Fix pipeline status in branch/tag tree page. !17995
- Allow group owner to enable runners from subgroups (#41981). !18009
- Fix template selector menu visibility when toggling preview mode in file edit view. !18118 (Fabian Schneider)
- Fix confirmation modal for deleting a protected branch. !18176 (Paul Bonaud @PaulRbR)
- Triggering custom hooks by Wiki UI edit. !18251
- Now `rake cache:clear` will also clear pipeline status cache. !18257
- Fix `joined` information on project members page. !18290 (Fabian Schneider)
- Fix missing namespace for some internal users. !18357
- Show shared projects on group page. !18390
- Restore label underline color. !18407 (George Tsiolis)
- Fix undefined `html_escape` method during markdown rendering. !18418
- Fix unassign slash command preview. !18447
- Correct text and functionality for delete user / delete user and contributions modal. !18463 (Marc Schwede)
- Fix discussions API setting created_at for notable in a group or notable in a project in a group with owners. !18464
- Don't include lfs_file_locks data in export bundle. !18495
- Reset milestone filter when clicking "Any Milestone" in dashboard. !18531
- Ensure member notifications are sent after the member actual creation/update in the DB. !18538
- Update links to /ci/lint with ones to project ci/lint. !18539 (Takuya Noguchi)
- Fix tabs container styles to make RSS button clickable. !18559
- Raise NoRepository error for non-valid repositories when calculating repository checksum. !18594
- Don't automatically remove artifacts for pages jobs after pages:deploy has run. !18628
- Increase new issue metadata form margin. !18630 (George Tsiolis)
- Add loading icon padding for pipeline environments. !18631 (George Tsiolis)
- ShaAttribute no longer stops startup if database is missing. !18726
- Fix close keyboard shortcuts dialog using the keyboard shortcut. !18783 (Lars Greiss)
- Fixes database inconsistencies between Community and Enterprise Edition on import state. !18811
- Add database foreign key constraint between pipelines and build. !18822
- Fix finding wiki pages when they have invalidly-encoded content. !18856
- Fix outdated Web IDE welcome copy. !18861
- fixed copy to blipboard button in embed bar of snippets. !18923 (haseebeqx)
- Disables RBAC on nginx-ingress. !18947
- Correct skewed Kubernetes popover illustration. !18949
- Resolve Import/Export ci_cd_settings error updating the project. !46049
- Fix project creation for user endpoint when jobs_enabled parameter supplied.
- 46210 Display logo and user dropdown on mobile for terms page and fix styling.
- Adds illustration for when job log was erased.
- Ensure web hook 'blocked URL' errors are stored in web hook logs and properly surfaced to the user.
- Make toggle markdown preview shortcut only toggle selected field.
- Verifiy if pipeline has commit idetails and render information in MR widget when branch is deleted.
- Fixed inconsistent protected branch pill baseline.
- Fix setting GitLab metrics content types.
- Display only generic message on merge error to avoid exposing any potentially sensitive or user unfriendly backend messages.
- Fix label links update on project transfer.
- Breaks commit not found message in pipelines table.
- Adjust issue boards list header label text color.
- Prevent pipeline actions in dropdown to redirct to a new page.

### Changed (35 changes, 15 of them are from the community)

- Improve tooltips in collapsed right sidebar. !17714
- Partition job_queue_duration_seconds with jobs_running_for_project. !17730
- For group dashboard, we no longer show groups which the visitor is not a member of (this applies to admins and auditors). !17884 (Roger Rüttimann)
- Use RFC 3676 mail signature delimiters. !17979 (Enrico Scholz)
- Add sha filter to pipelines list API. !18125
- New CI Job live-trace architecture. !18169
- Make project deploy keys table more clearly structured. !18279
- Remove green background from unlock button in admin area. !18288
- Renamed Overview to Project in the contextual navigation at a project level. !18295 (Constance Okoghenun)
- Load branches on new merge request page asynchronously. !18315
- Create settings section for autodevops. !18321
- Add a comma to the time estimate system notes. !18326
- Enable specifying variables when executing a manual pipeline. !18440
- Fix size and position for fork icon. !18449 (George Tsiolis)
- Refactored activity calendar. !18469 (Enrico Scholz)
- Small improvements to repository checks. !18484
- Add 2FA filter to users API for admins only. !18503
- Align project avatar on small viewports. !18513 (George Tsiolis)
- Show group and project LFS settings in the interface to Owners and Masters. !18562
- Update environment item action buttons icons. !18632 (George Tsiolis)
- Update timeline icon for description edit. !18633 (George Tsiolis)
- Revert discussion counter height. !18656 (George Tsiolis)
- Improve quick actions summary preview. !18659 (George Tsiolis)
- Change font for tables inside diff discussions. !18660 (George Tsiolis)
- Add padding to profile description. !18663 (George Tsiolis)
- Break issue title for board card title and issuable header text. !18674 (George Tsiolis)
- Adds push mirrors to GitLab Community Edition. !18715
- Inform the user when there are no project import options available. !18716 (George Tsiolis)
- Improve commit message body rendering and fix responsive compare panels. !18725 (Constance Okoghenun)
- Reconcile project templates with Auto DevOps. !18737
- Remove branch name from the status bar of WebIDE.
- Clean up WebIDE status bar and add useful info.
- Improve interaction on WebIDE commit panel.
- Keep current labels visible when editing them in the sidebar.
- Use VueJS for rendering pipeline stages.

### Performance (26 changes, 11 of them are from the community)

- Move WorkInProgress vue component. !17536 (George Tsiolis)
- Move ReadyToMerge vue component. !17545 (George Tsiolis)
- Move BoardBlankState vue component. !17666 (George Tsiolis)
- Improve DB performance of calculating total artifacts size. !17839
- Add i18n and update specs for UnresolvedDiscussions vue component. !17866 (George Tsiolis)
- Introduce new ProjectCiCdSetting model with group_runners_enabled. !18144
- Move PipelineFailed vue component. !18277 (George Tsiolis)
- Move TimeTrackingEstimateOnlyPane vue component. !18318 (George Tsiolis)
- Move TimeTrackingHelpState vue component. !18319 (George Tsiolis)
- Reduce queries on merge requests list page for merge requests from forks. !18561
- Destroy build_chunks efficiently with FastDestroyAll module. !18575
- Improve performance of a service responsible for creating a pipeline. !18582
- Replace time_ago_in_words with JS-based one. !18607 (Takuya Noguchi)
- Move TimeTrackingNoTrackingPane vue component. !18676 (George Tsiolis)
- Move SidebarTimeTracking vue component. !18677 (George Tsiolis)
- Move TimeTrackingSpentOnlyPane vue component. !18710 (George Tsiolis)
- Detecting tags containing a commit uses Gitaly by default.
- Increase cluster applications installer availability using alpine linux mirrors.
- Compute notification recipients in background jobs.
- Use persisted diff data instead fetching Git on discussions.
- Detecting branchnames containing a commit uses Gitaly by default.
- Detect repository license on Gitaly by default.
- Finish NamespaceService migration to Gitaly.
- Check if a ref exists is done by Gitaly by default.
- Compute Gitlab::Git::Repository#checksum on Gitaly by default.
- Repository#exists? is always executed through Gitaly.

### Added (22 changes, 10 of them are from the community)

- Allow group masters to configure runners for groups. !9646 (Alexis Reigel)
- Adds Embedded Snippets Support. !15695 (haseebeqx)
- Add Copy metadata quick action. !16473 (Mateusz Bajorski)
- Show Runner's description on job's page. !17321
- Add deprecation message to dynamic milestone pages. !17505
- Show new branch/mr button even when branch exists. !17712 (Jacopo Beschi @jacopo-beschi)
- API: add languages of project GET /projects/:id/languages. !17770 (Roger Rüttimann)
- Display active sessions and allow the user to revoke any of it. !17867 (Alexis Reigel)
- Add cron job to email users on issue due date. !17985 (Stuart Nelson)
- Rubocop rule to avoid returning from a block. !18000 (Jacopo Beschi @jacopo-beschi)
- Add the signature verfication badge to the compare view. !18245 (Marc Shaw)
- Expose Deploy Token data as environment varialbes on CI/CD jobs. !18414
- Show group id in group settings. !18482 (George Tsiolis)
- Allow admins to enforce accepting Terms of Service on an instance. !18570
- Add CI_COMMIT_MESSAGE, CI_COMMIT_TITLE and CI_COMMIT_DESCRIPTION predefined variables. !18672
- Add GCP signup offer to cluster index / create pages. !18684
- Output some useful information when running the rails console. !18697
- Display merge commit SHA in merge widget after merge. !18722
- git SHA is now displayed alongside the GitLab version on the Admin Dashboard.
- Expose the target commit ID through the tag API.
- Added fuzzy file finder to web IDE.
- Add discussion API for merge requests and commits.

### Other (22 changes, 8 of them are from the community)

- Replace the `project/issues/milestones.feature` spinach test with an rspec analog. !18300 (@blackst0ne)
- Replace the `project/commits/branches.feature` spinach test with an rspec analog. !18302 (@blackst0ne)
- Replacing gollum libraries for gitlab custom libs. !18343
- Replace the `project/commits/comments.feature` spinach test with an rspec analog. !18356 (@blackst0ne)
- Replace "Click" with "Select" to be more inclusive of people with accessibility requirements. !18386 (Mark Lapierre)
- Remove ahead/behind graphs on project branches on mobile. !18415 (Takuya Noguchi)
- Replace the `project/source/markdown_render.feature` spinach test with an rspec analog. !18525 (@blackst0ne)
- Add missing changelog type to docs. !18526 (@blackst0ne)
- Added Webhook SSRF prevention to documentation. !18532
- Upgrade underscore.js to 1.9.0. !18578
- Add documentation about how to use variables to define deploy policies for staging/production environments. !18675
- Replace the `project/builds/artifacts.feature` spinach test with an rspec analog. !18729 (@blackst0ne)
- Block access to the API & git for users that did not accept enforced Terms of Service. !18816
- Transition to atomic internal ids for all models. !44259
- Removes modal boards store and mixins from global scope.
- Replace GKE acronym with Google Kubernetes Engine.
- Replace vue resource with axios for pipelines details page.
- Enable prometheus monitoring by default.
- Replace vue resource with axios in pipelines table.
- Bump lograge to 0.10.0 and remove monkey patch.
- Improves wording in new pipeline page.
- Gitaly handles repository forks by default.


## 10.7.7 (2018-07-17)

### Security (1 change)

- Fix symlink vulnerability in project import.


## 10.7.6 (2018-06-21)

### Security (6 changes)

- Fix XSS vulnerability for table of content generation.
- Update sanitize gem to 4.6.5 to fix HTML injection vulnerability.
- HTML escape branch name in project graphs page.
- HTML escape the name of the user in ProjectsHelper#link_to_member.
- Don't show events from internal projects for anonymous users in public feed.
- XSS fix to use safe_params instead of params in url_for helpers.

### Other (1 change)

- Replacing gollum libraries for gitlab custom libs. !18343


## 10.7.5 (2018-05-28)

### Security (3 changes)

- Prevent user passwords from being changed without providing the previous password.
- Fix API to remove deploy key from project instead of deleting it entirely.
- Fixed bug that allowed importing arbitrary project attributes.


## 10.7.4 (2018-05-21)

### Fixed (1 change)

- Fix error when deleting an empty list of refs.


## 10.7.3 (2018-05-02)

### Fixed (8 changes)

- Fixed wrong avatar URL when the avatar is on object storage. !18092
- Fix errors on pushing to an empty repository. !18462
- Update doorkeeper to 4.3.2 to fix GitLab OAuth authentication. !18543
- Ports omniauth-jwt gem onto GitLab OmniAuth Strategies suite. !18580
- Fix redirection error for applications using OpenID. !18599
- Fix commit trailer rendering when Gravatar is disabled.
- Fix file_store for artifacts and lfs when saving.
- Fix users not seeing labels from private groups when being a member of a child project.


## 10.7.2 (2018-04-25)

### Security (2 changes)

- Serve archive requests with the correct file in all cases.
- Sanitizes user name to avoid XSS attacks.


## 10.7.1 (2018-04-23)

### Fixed (11 changes)

- [API] Fix URLs in the `Link` header for `GET /projects/:id/repository/contributors` when no value is passed for `order_by` or `sort`. !18393
- Fix a case with secret variables being empty sometimes. !18400
- Fix `Trace::HttpIO` can not render multi-byte chars. !18417
- Fix specifying a non-default ref when requesting an archive using the legacy URL. !18468
- Respect visibility options and description when importing project from template. !18473
- Removes 'No Job log' message from build trace. !18523
- Align action icons in pipeline graph.
- Fix direct_upload when records with null file_store are used.
- Removed alert box in IDE when redirecting to new merge request.
- Fixed IDE not loading for sub groups.
- Fixed IDE not showing loading state when tree is loading.

### Performance (4 changes)

- Validate project path prior to hitting the database. !18322
- Add index to file_store on ci_job_artifacts. !18444
- Fix N+1 queries when loading participants for a commit note.
- Support Markdown rendering using multiple projects.

### Added (1 change)

- Add an API endpoint to download git repository snapshots. !18173


## 10.7.0 (2018-04-22)

### Security (6 changes, 2 of them are from the community)

- Fixed some SSRF vulnerabilities in services, hooks and integrations. !2337
- Update ruby-saml to 1.7.2 and omniauth-saml to 1.10.0. !17734 (Takuya Noguchi)
- Update rack-protection to 2.0.1. !17835 (Takuya Noguchi)
- Adds confidential notes channel for Slack/Mattermost.
- Fix XSS on diff view stored on filenames.
- Fix GitLab Auth0 integration signing in the wrong user.

### Fixed (65 changes, 20 of them are from the community)

- File uploads in remote storage now support project renaming. !4597
- Fixed bug in dropdown selector when selecting the same selection again. !14631 (bitsapien)
- Fixed group deletion linked to Mattermost. !16209 (Julien Millau)
- Create commit API and Web IDE obey LFS filters. !16718
- Set breadcrumb for admin/runners/show. !17431 (Takuya Noguchi)
- Enable restore rake task to handle nested storage directories. !17516 (Balasankar C)
- Fix hover style of dropdown items in the right sidebar. !17519
- Improve empty state for canceled job. !17646
- Fix generated URL when listing repoitories for import. !17692
- Use singular in the diff stats if only one line has been changed. !17697 (Jan Beckmann)
- Long instance urls do not overflow anymore during project creation. !17717
- Fix importing multiple assignees from GitLab export. !17718
- Correct copy text for the promote milestone and label modals. !17726
- Fix search results stripping last endline when parsing the results. !17777 (Jasper Maes)
- Add read-only banner to all pages. !17798
- Fix viewing diffs on old merge requests. !17805
- Fix forking to subgroup via API when namespace is given by name. !17815 (Jan Beckmann)
- Fix UI breakdown for Create merge request button. !17821 (Takuya Noguchi)
- Unify format for nested non-task lists. !17823 (Takuya Noguchi)
- UX re-design branch items with flexbox. !17832 (Takuya Noguchi)
- Use porcelain commit lookup method on CI::CreatePipelineService. !17911
- Update dashboard milestones breadcrumb link. !17933 (George Tsiolis)
- Deleting a MR you are assigned to should decrements counter. !17951 (m b)
- Update no repository placeholder. !17964 (George Tsiolis)
- Drop JSON response in Project Milestone along with avoiding error. !17977 (Takuya Noguchi)
- Fix personal access token clipboard button style. !17978 (Fabian Schneider)
- Avoid validation errors when running the Pages domain verification service. !17992
- Project creation will now raise an error if a service template is invalid. !18013
- Add better LDAP connection handling. !18039
- Fix autolinking URLs containing ampersands. !18045
- Fix exceptions raised when migrating pipeline stages in the background. !18076
- Always display Labels section in issuable sidebar, even when the project has no labels. !18081 (Branka Martinovic)
- Fixed gitlab:uploads:migrate task ignoring some uploads. !18082
- Fixed gitlab:uploads:migrate task failing for Groups' avatar. !18088
- Increase dropdown width in pipeline graph & center action icon. !18089
- Fix `JobsController#raw` endpoint can not read traces in database. !18101
- Fix `gitlab-rake gitlab:two_factor:disable_for_all_users`. !18154
- Adjust 404's for LegacyDiffNote discussion rendering. !18201
- Work around Prometheus Helm chart name changes to fix integration. !18206 (joshlambert)
- Prioritize weight over title when sorting charts. !18233
- Verify that deploy token has valid access when pulling container registry image. !18260
- Stop redirecting the page in pipeline main actions.
- Fixed IDE button opening the wrong URL in tree list.
- Ensure hooks run when a deploy key without a user pushes.
- Fix 404 in group boards when moving issue between lists.
- Display state indicator for issuable references in non-project scope (e.g. when referencing issuables from group scope).
- Add missing port to artifact links.
- Fix data race between ObjectStorage background_upload and Pages publishing.
- Fixes unresolved discussions rendering the error state instead of the diff.
- Don't show Jump to Discussion button on Issues.
- Fix bug rendering group icons when forking.
- Automatically cleanup stale worktrees and lock files upon a push.
- Use the GitLab version as part of the appearances cache key.
- Fix Firefox stealing formatting characters on issue notes.
- Include matching branches and tags in protected branches / tags count. (Jan Beckmann)
- Fix 500 error when a merge request from a fork has conflicts and has not yet been updated.
- Test if remote repository exists when importing wikis.
- Hide emoji popup after multiple spaces. (Jan Beckmann)
- Fix relative uri when "#" is in branch name. (Jan)
- Escape Markdown characters properly when using autocomplete.
- Ignore project internal references in group context.
- Fix finding wiki file when Gitaly is enabled.
- Fix listing commit branch/tags that contain special characters.
- Ensure internal users (ghost, support bot) get assigned a namespace.
- Fix links to subdirectories of a directory with a plus character in its path.

### Deprecated (1 change)

- Remove support for legacy tar.gz pages artifacts. !18090

### Changed (22 changes, 2 of them are from the community)

- Add yellow favicon when `CANARY=true` to differientate canary environment. !12477
- Use human readable value build_timeout in Project. !17386
- Improved visual styles and consistency for commit hash and possible actions across commit lists. !17406
- Don't create permanent redirect routes. !17521
- Add empty repo check before running AutoDevOps pipeline. !17605
- Update wording to specify create/manage project vs group labels in labels dropdown. !17640
- Add tooltips to icons in lists of issues and merge requests. !17700
- Change avatar error message to include allowed file formats. !17747 (Fabian Schneider)
- Polish design for verifying domains. !17767
- Move email footer info to a single line. !17916
- Add average and maximum summary statistics to the prometheus dashboard. !17921
- Add additional cluster usage metrics to usage ping. !17922
- Move 'Registry' after 'CI/CD' in project navigation sidebar. !18018 (Elias Werberich)
- Redesign application settings to match project settings. !18019
- Allow HTTP(s) when git request is made by GitLab CI. !18021
- Added hover background color to IDE file list rows.
- Make project avatar in IDE consistent with the rest of GitLab.
- Show issues of subgroups in group-level issue board.
- Repository checksum calculation is handled by Gitaly when feature is enabled.
- Allow viewing timings for AJAX requests in the performance bar.
- Fixes remove source branch checkbox being visible when user cannot remove the branch.
- Make /-/ delimiter optional for search endpoints.

### Performance (24 changes, 11 of them are from the community)

- Move AssigneeTitle vue component. !17397 (George Tsiolis)
- Move TimeTrackingCollapsedState vue component. !17399 (George Tsiolis)
- Move MemoryGraph and MemoryUsage vue components. !17533 (George Tsiolis)
- Move UnresolvedDiscussions vue component. !17538 (George Tsiolis)
- Move NothingToMerge vue component. !17544 (George Tsiolis)
- Move ShaMismatch vue component. !17546 (George Tsiolis)
- Stop caching highlighted diffs in Redis unnecessarily. !17746
- Add i18n and update specs for ShaMismatch vue component. !17870 (George Tsiolis)
- Update spec import path for vue mount component helper. !17880 (George Tsiolis)
- Move TimeTrackingComparisonPane vue component. !17931 (George Tsiolis)
- Improves the performance of projects list page. !17934
- Remove N+1 query for Noteable association. !17956
- Improve performance of loading issues with lots of references to merge requests. !17986
- Reuse root_ref_hash for performance on Branches. !17998 (Takuya Noguchi)
- Update asciidoctor-plantuml to 0.0.8. !18022 (Takuya Noguchi)
- Cache personal projects count. !18197
- Reduce complexity of issuable finder query. !18219
- Reduce number of queries when viewing a merge request.
- Free open file descriptors and libgit2 buffers in UpdatePagesService.
- Memoize Git::Repository#has_visible_content?.
- Require at least one filter when listing issues or merge requests on dashboard page.
- lazy load diffs on merge request discussions.
- Bulk deleting refs is handled by Gitaly by default.
- ListCommitsByOid is executed by Gitaly by default.

### Added (38 changes, 7 of them are from the community)

- Add HTTPS-only pages. !16273 (rfwatson)
- adds closed by informations in issue api. !17042 (haseebeqx)
- Projects and groups badges settings UI. !17114
- Add per-runner configured job timeout. !17221
- Add alternate archive route for simplified packaging. !17225
- Add support for pipeline variables expressions in only/except. !17316
- Add object storage support for LFS objects, CI artifacts, and uploads. !17358
- Added confirmation modal for changing username. !17405
- Implement foreground verification of CI artifacts. !17578
- Extend API for exporting a project with direct upload URL. !17686
- Move ci/lint under project's namespace. !17729
- Add Total CPU/Memory consumption metrics for Kubernetes. !17731
- Adds the option to the project export API to override the project description and display GitLab export description once imported. !17744
- Port direct upload of LFS artifacts from EE. !17752
- Adds support for OmniAuth JWT provider. !17774
- Display error message on job's tooltip if this one fails. !17782
- Add 'Assigned Issues' and 'Assigned Merge Requests' as dashboard view choices for users. !17860 (Elias Werberich)
- Extend API for importing a project export with overwrite support. !17883
- Create Deploy Tokens to allow permanent access to repository and registry. !17894
- Detect commit message trailers and link users properly to their accounts on GitLab. !17919 (cousine)
- Adds cancel btn to new pages domain page. !18026 (Jacopo Beschi @jacopo-beschi)
- API: Add parameter merge_method to projects. !18031 (Jan Beckmann)
- Introduce simpler env vars for auto devops REPLICAS and CANARY_REPLICAS #41436. !18036
- Allow overriding params on project import through API. !18086
- Support LFS objects when importing/exporting GitLab project archives. !18115
- Store sha256 checksum of artifact metadata. !18149
- Limit the number of failed logins when using LDAP for authentication. !43525
- Allow assigning and filtering issuables by ancestor group labels.
- Include subgroup issues when searching for group issues using the API.
- Allow to store uploads by default on Object Storage.
- Add slash command for moving issues. (Adam Pahlevi)
- Render MR commit SHA instead "diffs" when viable.
- Send @mention notifications even if a user has explicitly unsubscribed from item.
- Add support for Sidekiq JSON logging.
- Add Gitaly call details to performance bar.
- Add support for patch link extension for commit links on GitLab Flavored Markdown.
- Allow feature gates to be removed through the API.
- Allow merge requests related to a commit to be found via API.

### Other (27 changes, 11 of them are from the community)

- Send notification emails when push to a merge request. !7610 (YarNayar)
- Rename modal.vue to deprecated_modal.vue. !17438
- Atomic generation of internal ids for issues. !17580
- Use object ID to prevent duplicate keys Vue warning on Issue Boards page during development. !17682
- Update foreman from 0.78.0 to 0.84.0. !17690 (Takuya Noguchi)
- Add realtime pipeline status for adding/viewing files. !17705
- Update documentation to reflect current minimum required versions of node and yarn. !17706
- Update knapsack to 1.16.0. !17735 (Takuya Noguchi)
- Update CI services documnetation. !17749
- Added i18n support for the prometheus memory widget. !17753
- Use specific names for filtered CI variable controller parameters. !17796
- Apply NestingDepth (level 5) (framework/dropdowns.scss). !17820 (Takuya Noguchi)
- Clean up selectors in framework/header.scss. !17822 (Takuya Noguchi)
- Bump `state_machines-activerecord` to 0.5.1. !17924 (blackst0ne)
- Increase the memory limits used in the unicorn killer. !17948
- Replace the spinach test with an rspec analog. !17950 (blackst0ne)
- Remove unused index from events table. !18014
- Make all workhorse gitaly calls opt-out, take 2. !18043
- Update brakeman 3.6.1 to 4.2.1. !18122 (Takuya Noguchi)
- Replace the `project/issues/labels.feature` spinach test with an rspec analog. !18126 (blackst0ne)
- Bump html-pipeline to 2.7.1. !18132 (@blackst0ne)
- Remove test_ci rake task. !18139 (Takuya Noguchi)
- Add documentation for Pipelines failure reasons. !18352
- Improve JIRA event descriptions.
- Add query counts to profiler output.
- Move Sidekiq exporter logs to log/sidekiq_exporter.log.
- Upgrade Gitaly to upgrade its charlock_holmes.


## 10.6.6 (2018-05-28)

### Security (4 changes)

- Do not allow non-members to create MRs via forked projects when MRs are private.
- Prevent user passwords from being changed without providing the previous password.
- Fix API to remove deploy key from project instead of deleting it entirely.
- Fixed bug that allowed importing arbitrary project attributes.


## 10.6.5 (2018-04-24)

### Security (1 change)

- Sanitizes user name to avoid XSS attacks.


## 10.6.4 (2018-04-09)

### Fixed (8 changes, 1 of them is from the community)

- Correct copy text for the promote milestone and label modals. !17726
- Avoid validation errors when running the Pages domain verification service. !17992
- Fix autolinking URLs containing ampersands. !18045
- Fix exceptions raised when migrating pipeline stages in the background. !18076
- Work around Prometheus Helm chart name changes to fix integration. !18206 (joshlambert)
- Don't show Jump to Discussion button on Issues.
- Fix listing commit branch/tags that contain special characters.
- Fix 404 in group boards when moving issue between lists.

### Performance (1 change)

- Free open file descriptors and libgit2 buffers in UpdatePagesService.


## 10.6.3 (2018-04-03)

### Security (2 changes)

- Fix XSS on diff view stored on filenames.
- Adds confidential notes channel for Slack/Mattermost.


## 10.6.2 (2018-03-29)

### Fixed (2 changes, 1 of them is from the community)

- Don't capture trailing punctuation when autolinking. !17965
- Cloning a repository over HTTPS with LDAP credentials causes a HTTP 401 Access denied. (Horatiu Eugen Vlad)


## 10.6.1 (2018-03-27)

### Security (1 change)

- Bump rails-html-sanitizer to 1.0.4.

### Fixed (2 changes)

- Prevent auto-retry AccessDenied error from stopping transition to failed. !17862
- Fix 500 error when trying to resolve non-ASCII conflicts in the editor. !17962

### Performance (1 change)

- Add indexes for user activity queries. !17890

### Other (1 change)

- Add documentation for runner IP address (#44232). !17837


## 10.6.0 (2018-03-22)

### Security (4 changes)

- Fixed some SSRF vulnerabilities in services, hooks and integrations. !2337
- Ensure that OTP backup codes are always invalidated.
- Add verification for GitLab Pages custom domains.
- Fix GitLab Auth0 integration signing in the wrong user.

### Fixed (75 changes, 17 of them are from the community)

- Ensure users cannot create environments with leading or trailing slashes (Fixes #39885). !15273
- Fix new project path input overlapping. !16755 (George Tsiolis)
- Respect description and visibility when creating project from template. !16820 (George Tsiolis)
- Remove user notification settings for groups and projects when user leaves. !16906 (Jacopo Beschi @jacopo-beschi)
- Fix Teleporting Emoji. !16963 (Jared Deckard <jared.deckard@gmail.com>)
- Fix duplicate system notes when merging a merge request. !17035
- Fix breadcrumb on labels page for groups. !17045 (Onuwa Nnachi Isaac)
- Fix user avatar's vertical align on the issues and merge requests pages. !17072 (Laszlo Karpati)
- Fix settings panels not expanding when fragment hash linked. !17074
- Fix 404 when listing archived projects in a group where all projects have been archived. !17077 (Ashley Dumaine)
- Allow to call PUT /projects/:id API with only ci_config_path specified. !17105 (Laszlo Karpati)
- Fix long list of recipients on group request membership email. !17121 (Jacopo Beschi @jacopo-beschi)
- Remove duplicated error message on duplicate variable validation. !17135
- Keep "Import project" tab/form active when validation fails trying to import "Repo by URL". !17136
- Fixed bug with unauthenticated requests through git ssh. !17149
- Allows project rename after validation error. !17150
- Fix "Remove source branch" button in Merge request widget during merge when pipeline succeeds state. !17192
- Add missing pagination on the commit diff endpoint. !17203 (Maxime Roussin-Bélanger)
- Fix get a single pages domain when project path contains a period. !17206 (Travis Miller)
- remove avater underline. !17219 (Ken Ding)
- Allows the usage of /milestone quick action for group milestones. !17239 (Jacopo Beschi @jacopo-beschi)
- Encode branch name as binary before creating a RPC request to copy attributes. !17291
- Restart Unicorn and Sidekiq when GRPC throws 14:Endpoint read failed. !17293
- Do not persist Google Project verification flash errors after a page reload. !17299
- Ensure group issues and merge requests pages show results from subgroups when there are no results from the current group. !17312
- Prevent trace artifact migration to incur data loss. !17313
- Fixes gpg popover layout. !17323
- Return a 404 instead of 403 if the repository does not exist on disk. !17341
- Fix Slack/Mattermost notifications not respecting `notify_only_default_branch` setting for pushes. !17345
- Fix Group labels load failure when there are duplicate labels present. !17353
- Allow Prometheus application to be installed from Cluster applications. !17372
- Fixes Prometheus admin configuration page. !17377
- Enable filtering MR list based on clicked label in MR sidebar. !17390
- Fix code and wiki search results pages when non-ASCII text is displayed. !17413
- Count comments on diffs and discussions as contributions for the contributions calendar. !17418 (Riccardo Padovani)
- Add Assignees vue component missing data container. !17426 (George Tsiolis)
- Update tooltip on pipeline cancel to Stop (#42946). !17444
- Removing the two factor check when the user sets a new password. !17457
- Fix quick actions for users who cannot update issues and merge requests. !17482
- Stop loading spinner on error of milestone update on issue. !17507 (Takuya Noguchi)
- Set margins around dropdown dividers to 4px. !17517
- Fix pages flaky failure by reloading stale object. !17522
- Remove extra breadcrumb on tags. !17562 (Takuya Noguchi)
- Fix missing uploads after group transfer. !17658
- Fix markdown table showing extra column. !17669
- Ensure the API returns https links when https is configured. !17681
- Sanitize extra blank spaces used when uploading a SSH key. !40552
- Render htmlentities correctly for links not supported by Rinku.
- Keep link when redacting unauthorized object links.
- Handle empty state in Pipelines page.
- Revert Project.public_or_visible_to_user changes and only apply to snippets.
- Release libgit2 cache and open file descriptors after `git gc` run.
- Fix project dashboard showing the wrong timestamps.
- Fix "Can't modify frozen hash" error when project is destroyed.
- Fix Error 500 when viewing a commit with a GPG signature in Geo.
- Don't error out in system hook if user has `nil` datetime columns.
- Remove double caching of Repository#empty?.
- Don't delete todos or unassign issues and MRs when a user leaves a project.
- Don't cache a nil repository root ref to prevent caching issues.
- Escape HTML entities in commit messages.
- Verify project import status again before marking as failed.
- [GitHub Import] Create an empty wiki if wiki import failed.
- Create empty wiki when import from GitLab and wiki is not there.
- Make sure wiki exists when it's enabled.
- Fix broken loading state for close issue button.
- Fix code and wiki search results when filename is non-ASCII.
- Fix file upload on project show page.
- Fix squashing when a file is renamed.
- Show loading button inline in refresh button in MR widget.
- Fix close button on issues not working on mobile.
- Adds tooltip in environment names to increase readability.
- Fixed issue edit shortcut not opening edit form.
- Fix 500 error being shown when diff has context marker with invalid encoding.
- Render modified icon for moved file in changes dropdown.
- Remember assignee when moving an issue.

### Changed (16 changes, 9 of them are from the community)

- Allow including custom attributes in API responses. !16526 (Markus Koller)
- Apply new default and inline label design. !16956 (George Tsiolis)
- Remove whitespace from the username/email sign in form field. !17020 (Peter lauck)
- CI charts now include the current day. !17032 (Dakkaron)
- Hide CI secret variable values after saving. !17044
- Add new modal Vue component. !17108
- Asciidoc now support inter-document cross references between files in repository. !17125 (Turo Soisenniemi)
- Update issue closing pattern to allow variations in punctuation. !17198 (Vicky Chijwani)
- Add a button to deploy a runner to a Kubernetes cluster in the settings page. !17278
- Pages custom domain: allow update of key/certificate. !17376 (rfwatson)
- Clear the Labels dropdown search filter after a selection is made. !17393 (Andrew Torres)
- Hook data for pipelines includes detailed_status. !17607
- Avoid showing unnecessary Trigger checkboxes for project Integrations with only one event. !17607
- Display a link to external issue tracker when enabled.
- Allow token authentication on go-get request.
- Update SSH key link to include existing keys. (Brendan O'Leary)

### Performance (24 changes, 5 of them are from the community)

- Add catch-up background migration to migrate pipeline stages. !15741
- Move BoardNewIssue vue component. !16947 (George Tsiolis)
- Move IssuableTimeTracker vue component. !16948 (George Tsiolis)
- Move RecentSearchesDropdownContent vue component. !16951 (George Tsiolis)
- Move Assignees vue component. !16952 (George Tsiolis)
- Improve performance of pipeline page by reducing DB queries. !17168
- Store sha256 checksum to job artifacts. !17354
- Move SidebarAssignees vue component. !17398 (George Tsiolis)
- Improve database response time for user activity listing. !17454
- Use persisted/memoized value for MRs shas instead of doing git lookups. !17555
- Cache MergeRequests can_be_resolved_in_ui? git operations. !17589
- Prevent the graphs page from generating unnecessary Gitaly requests. !37602
- Use a user object in ApplicationHelper#avatar_icon where possible to avoid N+1 queries. !42800
- Submit a single batch blob RPC to Gitaly per HTTP request when viewing diffs.
- Avoid re-fetching merge-base SHA from Gitaly unnecessarily.
- Don't use ProjectsFinder in TodosFinder.
- Adding missing indexes on taggings table.
- Add index on section_name_id on ci_build_trace_sections table.
- Cache column_exists? for application settings.
- Cache table_exists?('application_settings') to reduce repeated schema reloads.
- Make --prune a configurable parameter in fetching a git remote.
- Fix timeouts loading /admin/projects page.
- Add partial indexes on todos to handle users with many todos.
- Optimize search queries on the search page by setting a limit for matching records in project scope.

### Added (30 changes, 9 of them are from the community)

- Add CommonMark markdown engine (experimental). !14835 (blackst0ne)
- API: Get references a commit is pushed to. !15026 (Robert Schilling)
- Add overview of branches and a filter for active/stale branches. !15402 (Takuya Noguchi)
- Add project export API. !15860 (Travis Miller)
- expose more metrics in merge requests api. !16589 (haseebeqx)
- #28481: Display time tracking totals on milestone page. !16753 (Riccardo Padovani)
- Add a button on the project page to set up a Kubernetes cluster and enable Auto DevOps. !16900
- Include cycle time in usage ping data. !16973
- Add ability to use external plugins as an alternative to system hooks. !17003
- Add search param to Branches API. !17005 (bunufi)
- API endpoint for importing a project export. !17025
- Display ingress IP address in the Kubernetes page. !17052
- Implemented badge API endpoints. !17082
- Allow installation of GitLab Runner with a single click. !17134
- Allow commits endpoint to work over all commits of a repository. !17182
- Display Runner IP Address. !17286
- Add archive feature to trace. !17314
- Allow maintainers to push to forks of their projects when a merge request is open. !17395
- Foreground verification of uploads and LFS objects. !17402
- Adds updated_at filter to issues and merge_requests API. !17417 (Jacopo Beschi @jacopo-beschi)
- Port /wip quick action command to Merge Request creation (on description). !17463 (Adam Pahlevi)
- Add a paragraph about security implications on Cluster's page. !17486
- Add plugins list to the system hooks page. !17518
- Enable privileged mode for GitLab Runner. !17528
- Expose GITLAB_FEATURES as CI/CD variable (fixes #40994).
- Upgrade GitLab Workhorse to 4.0.0.
- Add discussions API for Issues and Snippets.
- Add one group board to Libre.
- Add support for filtering by source and target branch to merge requests API.

### Other (18 changes, 7 of them are from the community)

- Group MRs on issue page by project and namespace. !8494 (Jeff Stubler)
- Make oauth provider login generic. !8809 (Horatiu Eugen Vlad)
- Add email button to new issue by email. !10942 (Islam Wazery)
- Update vue component naming guidelines. !17018 (George Tsiolis)
- Added new design for promotion modals. !17197
- Update to github-linguist 5.3.x. !17241 (Ken Ding)
- update toml-rb to 1.0.0. !17259 (Ken Ding)
- Keep track of projects a user interacted with. !17327
- Moved o_auth/saml/ldap modules under gitlab/auth. !17359 (Horatiu Eugen Vlad)
- Enables eslint in codeclimate job. !17392
- Port Labels Select dropdown to Vue. !17411
- Add NOT NULL constraint to projects.namespace_id. !17448
- Ensure foreign keys on clusters applications. !17488
- Started translation into Turkish, Indonesian and Filipino. !17526
- Add documentation for displayed K8s Ingress IP address (#44330). !17836
- Move Ruby endpoints to OPT_OUT.
- Upgrade Workhorse to version 3.8.0 to support structured logging.
- Use host URL to build JIRA remote link icon.


## 10.5.8 (2018-04-24)

### Security (1 change)

- Sanitizes user name to avoid XSS attacks.


## 10.5.7 (2018-04-03)

### Security (2 changes)

- Fix XSS on diff view stored on filenames.
- Adds confidential notes channel for Slack/Mattermost.


## 10.5.6 (2018-03-16)

### Security (2 changes)

- Fixed some SSRF vulnerabilities in services, hooks and integrations. !2337
- Fix GitLab Auth0 integration signing in the wrong user.


## 10.5.5 (2018-03-15)

### Fixed (3 changes)

- Fix missing uploads after group transfer. !17658
- Fix code and wiki search results when filename is non-ASCII.
- Remove double caching of Repository#empty?.

### Performance (2 changes)

- Adding missing indexes on taggings table.
- Add index on section_name_id on ci_build_trace_sections table.


## 10.5.4 (2018-03-08)

### Fixed (11 changes)

- Encode branch name as binary before creating a RPC request to copy attributes. !17291
- Restart Unicorn and Sidekiq when GRPC throws 14:Endpoint read failed. !17293
- Ensure group issues and merge requests pages show results from subgroups when there are no results from the current group. !17312
- Prevent trace artifact migration to incur data loss. !17313
- Return a 404 instead of 403 if the repository does not exist on disk. !17341
- Allow Prometheus application to be installed from Cluster applications. !17372
- Fixes Prometheus admin configuration page. !17377
- Fix code and wiki search results pages when non-ASCII text is displayed. !17413
- Fix pages flaky failure by reloading stale object. !17522
- Fixed issue edit shortcut not opening edit form.
- Revert Project.public_or_visible_to_user changes and only apply to snippets.

### Performance (1 change)

- Don't use ProjectsFinder in TodosFinder.


## 10.5.3 (2018-03-01)

### Security (1 change)

- Ensure that OTP backup codes are always invalidated.


## 10.5.2 (2018-02-25)

### Fixed (7 changes)

- Fix single digit value clipping for stacked progress bar. !17217
- Fix issue with cache key being empty when variable used as the key. !17260
- Enable Legacy Authorization by default on Cluster creations. !17302
- Allow branch names to be named the same as the sha it points to.
- Fix 500 error when loading an invalid upload URL.
- Don't attempt to update user tracked fields if database is in read-only.
- Prevent MR Widget error when no CI configured.

### Performance (5 changes)

- Improve query performance for snippets dashboard. !17088
- Only check LFS integrity for first ref in a push to avoid timeout. !17098
- Improve query performance of MembersFinder. !17190
- Increase feature flag cache TTL to one hour.
- Improve performance of searching for and autocompleting of users.


## 10.5.1 (2018-02-22)

- No changes.

## 10.5.0 (2018-02-22)

### Security (3 changes, 1 of them is from the community)

- Update marked from 0.3.6 to 0.3.12. !16480 (Takuya Noguchi)
- Update nokogiri to 1.8.2. !16807
- Add verification for GitLab Pages custom domains.

### Fixed (77 changes, 25 of them are from the community)

- Fix the Projects API with_issues_enabled filter behaving incorrectly any user. !12724 (Jan Christophersen)
- Hide pipeline schedule take ownership for current owner. !12986
- Handle special characters on API request of issuable templates. !15323 (Takuya Noguchi)
- Shows signin tab after new user email confirmation. !16174 (Jacopo Beschi @jacopo-beschi)
- Make project README containers wider on fixed layout. !16181 (Takuya Noguchi)
- Fix dashboard projects nav links height. !16204 (George Tsiolis)
- Fix error on empty query for Members API. !16235
- Issue board: fix for dragging an issue to the very bottom in long lists. !16250 (David Kuri)
- Make rich blob viewer wider for PC. !16262 (Takuya Noguchi)
- Substitute deprecated ui_charcoal with new default ui_indigo. !16271 (Takuya Noguchi)
- Generate HTTP URLs for custom Pages domains when appropriate. !16279
- Make modal dialog common for Groups tree app. !16311
- Allow moving wiki pages from the UI. !16313
- Filter groups and projects dropdowns of search page on backend. !16336
- Adjust layout width for fixed layout. !16337 (George Tsiolis)
- Fix custom header logo design nitpick: Remove unneeded margin on empty logo text. !16383 (Markus Doits)
- File Upload UI can create LFS pointers based on .gitattributes. !16412
- Fix Ctrl+Enter keyboard shortcut saving comment/note edit. !16415
- Fix file search results when they match file contents with a number between two colons. !16462
- Fix tooltip displayed for running manual actions. !16489
- Allow trailing + on labels in board filters. !16490
- Prevent JIRA issue identifier from being humanized. !16491 (Andrew McCallum)
- Add horizontal scroll to wiki tables. !16527 (George Tsiolis)
- Fix a bug calculating artifact size for project statistics. !16539
- Stop loading spinner on error of issuable templates. !16600 (Takuya Noguchi)
- Allows html text in commits atom feed. !16603 (Jacopo Beschi @jacopo-beschi)
- Disable MR check out button when source branch is deleted. !16631 (Jacopo Beschi @jacopo-beschi)
- Fix export removal for hashed-storage projects within a renamed or deleted namespace. !16658
- Default to HTTPS for all Gravatar URLs. !16666
- Login via OAuth now only marks new users as external. !16672
- Fix default avatar icon missing when Gravatar is disabled. !16681 (Felix Geyer)
- Change button group width on mobile. !16726 (George Tsiolis)
- Fix version information not showing on help page if commercial content display was disabled. !16743
- Adds spacing between edit and delete tag btn in tag list. !16757 (Jacopo Beschi @jacopo-beschi)
- Fix 500 error when loading a merge request with an invalid comment. !16795
- Deleting an upload will correctly clean up the filesystem. !16799
- Cleanup new branch/merge request form in issues. !16854
- Fix GitLab import leaving group_id on ProjectLabel. !16877
- Fix forking projects when no restricted visibility levels are defined applicationwide. !16881
- Trigger change event on filename input when file template is applied. !16911 (Sebastian Klingler)
- Fixes different margins between buttons in tag list. !16927 (Jacopo Beschi @jacopo-beschi)
- Close low level rugged repository in project cache worker. !16930 (Bastian Blank)
- Override group sidebar links. !16942 (George Tsiolis)
- Avoid running `PopulateForkNetworksRange`-migration multiple times. !16988
- Resolve PrepareUntrackedUploads PostgreSQL syntax error. !17019
- Fix monaco editor features which were incompatable with GitLab CDN settings. !17021
- Fixed error 500 when removing an identity with synced attributes and visiting the profile page. !17054
- Fix cnacel edit note button reverting changes. !42462
- For issues display time of last edit of title or description instead of time of any attribute change.
- Handle all Psych YAML parser exceptions (fixes #41209).
- Fix validation of environment scope of variables.
- Display user friendly error message if rebase fails.
- Hide new branch and tag links for projects with an empty repo.
- Fix protected branches API to accept name parameter with dot.
- Closes #38540 - Remove .ssh/environment file that now breaks the gitlab:check rake task.
- Keep subscribers when promoting labels to group labels.
- Replace verified badge icons and uniform colors.
- Fix error on changes tab when merge request cannot be created.
- Ignore leading slashes when searching for files within context of repository. (Andrew McCallum)
- Close and do not reload MR diffs when source branch is deleted.
- Bypass commits title markdown on notes.
- Reload MRs memoization after diffs creation.
- Return more consistent values for merge_status on MR APIs.
- Contribution calendar label was cut off. (Branka Martinovic)
- LDAP Person no longer throws exception on invalid entry.
- Fix bug where award emojis would be lost when moving issues between projects.
- Fix not all events being shown in group dashboard.
- Fix JIRA not working when a trailing slash is included.
- Fix squash not working when diff contained non-ASCII data.
- Remove erroneous text in shared runners page that suggested more runners available.
- Execute system hooks after-commit when executing project hooks.
- Makes forking protect default branch on completion.
- Validate user, group and project paths consistently, and only once.
- Validate user namespace before saving so that errors persist on model.
- Permits 'password_authentication_enabled_for_git' parameter for ApplicationSettingsController.
- Fix duplicate item in protected branch/tag dropdown.
- Open visibility level help in a new tab. (Jussi Räsänen)

### Deprecated (1 change)

- Add note within ux documentation that further changes should be made within the design.gitlab project.

### Changed (20 changes, 7 of them are from the community)

- Show coverage to two decimal points in coverage badge. !10083 (Jeff Stubler)
- Update 'removed assignee' note to include old assignee reference. !16301 (Maurizio De Santis)
- Move row containing Projects, Users and Groups count to the top in admin dashboard. !16421
- Add Auto DevOps Domain application setting. !16604
- Changes Revert this merge request text. !16611 (Jacopo Beschi @jacopo-beschi)
- Link Auto DevOps settings to Clusters page. !16641
- Internationalize charts page. !16687 (selrahman)
- Internationalize graph page selrahman. !16688 (Shah El-Rahman)
- Save traces as artifacts. !16702
- Hide variable values on pipeline schedule edit page. !16729
- Update runner info on all authenticated requests. !16756
- Improve issue note dropdown and mr button. !16758 (George Tsiolis)
- Replace "cluster" with "Kubernetes cluster". !16778
- Enable Prometheus metrics for deployed Ingresses. !16866 (joshlambert)
- Rename button to enable CI/CD configuration to "Set up CI/CD". !16870
- Double padding for file-content wiki class on larger screens.
- Improve wording about additional costs for Ingress on custom clusters.
- Last push widget will show banner for new pushes to previously merged branch.
- Save user ID and username in Grape API log (api_json.log).
- Include subgroup issues and merge requests on the group page.

### Performance (14 changes, 1 of them is from the community)

- Fix double query execution on groups page. !16314
- Speed up loading merged merge requests when they contained a lot of commits before merging. !16320
- Properly memoize some predicate methods. !16329
- Reduce the number of Prometheus metrics. !16443
- Only highlight search results under the highlighting size limit. !16462
- Add fast-blank. !16468
- Move BoardList vue component to vue file. !16888 (George Tsiolis)
- Fix N+1 query problem for snippets dashboard. !16944
- Optimize search queries on the search page by setting a limit for matching records.
- Store number of commits in merge_request_diffs table.
- Improve performance of target branch dropdown.
- Remove duplicate calls of MergeRequest#can_be_reverted?.
- Stop checking if discussions are in a mergeable state if the MR isn't.
- Remove N+1 queries with /projects/:project_id/{access_requests,members} API endpoints.

### Added (28 changes, 10 of them are from the community)

- Add link on commit page to merge request that introduced that commit. !13713 (Hiroyuki Sato)
- System hooks for Merge Requests. !14387 (Alexis Reigel)
- Add `pipelines` endpoint to merge requests API. !15454 (Tony Rom <thetonyrom@gmail.com>)
- Adds Rubocop rule for line break around conditionals. !15739 (Jacopo Beschi @jacopo-beschi)
- Add Colors to GitLab Flavored Markdown. !16095 (Tony Rom <thetonyrom@gmail.com>)
- Initial work to add notification reason to emails. !16160 (Mario de la Ossa)
- Implement multi server support and use kube proxy to connect to Prometheus servers inside K8S cluster. !16182
- Add ability to transfer a group into another group. !16302
- Add blue dot feature highlight to make GKE Clusters more visible to users. !16379
- Add section headers to plus button dropdown. !16394 (George Tsiolis)
- Support PostgreSQL 10. !16471
- Enables Project Milestone Deletion via the API. !16478 (Jacopo Beschi @jacopo-beschi)
- Add realtime ci status for the repository -> files view. !16523
- User can now git push to create a new project. !16547
- Improve empty project overview. !16617 (George Tsiolis)
- Added uploader metadata to the uploads. !16779
- Added ldap config setting to lower case the username. !16791
- Add search support into the API. !16878
- Backport of LFS File Locking API. !16935
- Add a link to documentation on how to get external ip in the Kubernetes cluster details page. !16937
- Add sorting options for /users API (admin only). !16945
- Adds sorting to deployments API. (Jacopo Beschi @jacopo-beschi)
- Add rake task to check integrity of uploaded files.
- Add backend for persistently dismissably callouts.
- Track and act upon the number of executed queries.
- Add a gRPC health check to ensure Gitaly is up.
- Log and send a system hook if a blocked user attempts to login.
- Add Gitaly Servers admin dashboard.

### Other (25 changes, 7 of them are from the community)

- Updated the katex library. !15864
- Add modal for deleting a milestone. !16229
- Remove unused CSS selectors for Cycle Analytics. !16270 (Takuya Noguchi)
- Add reason to keep postgresql 9.2 for CI. !16277 (Takuya Noguchi)
- Adjust modal style to new design. !16310
- Default to Gitaly for 'git push' HTTP/SSH, and make Gitaly mandatory for SSH pull. !16586
- Set timezone for karma to UTC. !16602 (Takuya Noguchi)
- Make Gitaly RepositoryExists opt-out. !16680
- Update minimum git version to 2.9.5. !16683
- Disable throwOnError in KaTeX to reveal user where is the problem. !16684 (Jakub Jirutka)
- fix documentation about node version. !16720 (Tobias Gurtzick)
- Enable RuboCop Style/RegexpLiteral. !16752 (Takuya Noguchi)
- Add confirmation-input component. !16816
- Add unique constraint to trending_projects#project_id. !16846
- Add foreign key and NOT NULL constraints to todos table. !16849
- Include branch in mobile view for pipelines. !16910 (George Tsiolis)
- Downgrade google-protobuf gem. !16941
- Refactors mr widget components into vue files and adds i18n.
- increase-readability-of-colored-text-in-job-output-log.
- Finish any remaining jobs for issues.closed_at.
- Translate issuable sidebar.
- Set standard disabled state for all buttons.
- Upgrade GitLab Workhorse to v3.6.0.
- Improve readability of underlined links for dyslexic users.
- Adds empty state illustration for pending job.


## 10.4.7 (2018-04-03)

### Security (2 changes)

- Fix XSS on diff view stored on filenames.
- Adds confidential notes channel for Slack/Mattermost.


## 10.4.6 (2018-03-16)

### Security (2 changes)

- Fixed some SSRF vulnerabilities in services, hooks and integrations. !2337
- Fix GitLab Auth0 integration signing in the wrong user.


## 10.4.5 (2018-03-01)

### Security (1 change)

- Ensure that OTP backup codes are always invalidated.


## 10.4.4 (2018-02-16)

### Security (1 change)

- Update nokogiri to 1.8.2. !16807

### Fixed (9 changes)

- Fix 500 error when loading a merge request with an invalid comment. !16795
- Cleanup new branch/merge request form in issues. !16854
- Fix GitLab import leaving group_id on ProjectLabel. !16877
- Fix forking projects when no restricted visibility levels are defined applicationwide. !16881
- Resolve PrepareUntrackedUploads PostgreSQL syntax error. !17019
- Fixed error 500 when removing an identity with synced attributes and visiting the profile page. !17054
- Validate user namespace before saving so that errors persist on model.
- LDAP Person no longer throws exception on invalid entry.
- Fix JIRA not working when a trailing slash is included.


## 10.4.3 (2018-02-05)

### Security (4 changes)

- Fix namespace access issue for GitHub, BitBucket, and GitLab.com project importers.
- Fix stored XSS in code blocks that ignore highlighting.
- Fix wilcard protected tags protecting all branches.
- Restrict Todo API mark_as_done endpoint to the user's todos only.


## 10.4.2 (2018-01-30)

### Fixed (6 changes)

- Fix copy/paste on iOS devices due to a bug in webkit. !15804
- Fix missing "allow users to request access" option in public project permissions. !16485
- Fix encoding issue when counting commit count. !16637
- Fixes destination already exists, and some particular service errors on Import/Export error. !16714
- Fix cache clear bug withg using : on Windows. !16740
- Use has_table_privilege for TRIGGER on PostgreSQL.

### Changed (1 change)

- Vendor Auto DevOps template with DAST security checks enabled. !16691


## 10.4.1 (2018-01-24)

### Fixed (4 changes)

- Ensure that users can reclaim a namespace or project path that is blocked by an orphaned route. !16242
- Correctly escape UTF-8 path elements for uploads. !16560
- Fix issues when rendering groups and their children. !16584
- Fix bug in which projects with forks could not change visibility settings from Private to Public. !16595

### Performance (2 changes)

- rework indexes on redirect_routes.
- Remove unecessary query from labels filter.


## 10.4.0 (2018-01-22)

### Security (8 changes, 1 of them is from the community)

- Upgrade Ruby to 2.3.6 to include security patches. !16016
- Prevent a SQL injection in the MilestonesFinder.
- Check user authorization for source and target projects when creating a merge request.
- Fix path traversal in gitlab-ci.yml cache:key.
- Fix writable shared deploy keys.
- Filter out sensitive fields from the project services API. (Robert Schilling)
- Fix RCE via project import mechanism.
- Prevent OAuth login POST requests when a provider has been disabled.

### Fixed (68 changes, 24 of them are from the community)

- Update comment on image cursor and icons. !15760
- Fixes the wording of headers in system info page. !15802 (Gilbert Roulot)
- Reset todo counters when the target is deleted. !15807
- Execute quick actions (if present) when creating MR from issue. !15810
- fix build count in pipeline success mail. !15827 (Christiaan Van den Poel)
- Fix error that was preventing users to change the access level of access requests for Groups or Projects. !15832
- Last push event widget width for fixed layout. !15862 (George Tsiolis)
- Hide link to issues/MRs from labels list if issues/MRs are disabled. !15863 (Sophie Herold)
- Use relative URL for projects to avoid storing domains. !15876
- Fix gitlab-rake gitlab:import:repos import schedule. !15931
- Removed incorrect guidance stating blocked users will be removed from groups and project as members. !15947 (CesarApodaca)
- Fix some POST/DELETE requests in IE by switching some bundles to Axios for Ajax requests. !15951
- Fixing error 500 when member exist but not the user. !15970
- show None when issue is in closed list and no labels assigned. !15976 (Christiaan Van den Poel)
- Fix tags in the Activity tab not being clickable. !15996 (Mario de la Ossa)
- Disable Vue pagination when only one page of content is available. !15999 (Mario de la Ossa)
- disables shortcut to issue boards when issues are not enabled. !16020 (Christiaan Van den Poel)
- Ignore lost+found folder during backup on a volume. !16036 (Julien Millau)
- Fix abuse reports link url in admin area navbar. !16068 (megos)
- Keep typographic hierarchy in User Settings. !16090 (George Tsiolis)
- Adjust content width for User Settings, GPG Keys. !16093 (George Tsiolis)
- Fix gitlab-rake gitlab:import:repos import schedule. !16115
- Fix import project url not updating project name. !16120
- Fix activity inline event line height on mobile. !16121 (George Tsiolis)
- Fix slash commands dropdown description mis-alignment on Firefox. !16125 (Maurizio De Santis)
- Remove unnecessary sidebar element realignment. !16159 (George Tsiolis)
- User#projects_limit remove DB default and added NOT NULL constraint. !16165 (Mario de la Ossa)
- Fix API endpoints to edit wiki pages where project belongs to a group. !16170
- Fix breadcrumbs in User Settings. !16172 (rfwatson)
- Move 2FA disable button. !16177 (George Tsiolis)
- Fixing bug when wiki last version. !16197
- Protected branch is now created for default branch on import. !16198
- Prevent excessive DB load due to faulty DeleteConflictingRedirectRoutes background migration. !16205
- Force Auto DevOps kubectl version to 1.8.6. !16218
- Fix missing references to pipeline objects when restoring project with import/export feature. !16221
- Fix inconsistent downcase of filenames in prefilled `Add` commit messages. !16232 (James Ramsay)
- Default merge request title is set correctly again when external issue tracker is activated. !16356 (Ben305)
- Ensure that emails contain absolute, rather than relative, links to user uploads. !16364
- Prevent invalid Route path if path is unchanged. !16397
- Fixing rack request mime type when using rack attack. !16427
- Prevent RevList failing on non utf8 paths. !16440
- Fix giant fork icons on forks page. !16474
- Fix links to uploaded files on wiki pages. !16499
- Modify `LDAP::Person` to return username value based on attributes.
- Fixed merge request status badge not updating after merging.
- Remove related links in MR widget when empty state.
- Gracefully handle garbled URIs in Markdown.
- Fix hooks not being set up properly for bare import Rake task.
- Fix Mermaid drawings not loading on some browsers.
- Humanize the units of "Showing last X KiB of log" in job trace.
- Avoid leaving a push event empty if payload cannot be created.
- Show authored date rather than committed date on the commit list.
- Fix when branch creation fails don't post system note. (Mateusz Bajorski)
- Fix viewing merge request diffs where the underlying blobs are unavailable.
- Fix 500 error when visiting a commit where the blobs do not exist.
- Set target_branch to the ref branch when creating MR from issue.
- Fix closed text for issues on Todos page.
- [API] Fix creating issue when assignee_id is empty.
- Fix false positive issue references in merge requests caused by header anchor links.
- Fixed chanages dropdown ellipsis positioning.
- Fix shortcut links on help page.
- Clears visual token on second backspace. (Martin Wortschack)
- Fix onion-skin re-entering state.
- fix button alignment on MWPS component.
- Add optional search param for Merge Requests API.
- Normalizing Identity extern_uid when saving the record.
- Fixed typo for issue description field declaration. (Marcus Amargi)
- Fix ANSI 256 bold colors in pipelines job output.

### Changed (18 changes, 3 of them are from the community)

- Make mail notifications of discussion notes In-Reply-To of each other. !14289
- Migrate existing data from KubernetesService to Clusters::Platforms::Kubernetes. !15589
- Implement checking GCP project billing status in cluster creation form. !15665
- Present multiple clusters in a single list instead of a tabbed view. !15669
- Remove soft removals related code. !15789
- Only mark import and fork jobs as failed once all Sidekiq retries get exhausted. !15844
- Translate date ranges on contributors page. !15846
- Update issuable status icons. !15898
- Update feature toggle design to use icons and make it i18n friendly. !15904
- Update groups tree to use GitLab SVG icons, add last updated at information for projects. !15980
- Allow forking a public project to a private group. !16050
- Expose project_id on /api/v4/pages/domains. !16200 (Luc Didry)
- Display graph values on hover within monitoring page. !16261
- removed tabindexes from tag form. (Marcus Amargi)
- Move edit button to second row on issue page (and change it to a pencil icon).
- Run background migrations with a minimum interval.
- Provide additional cookies to JIRA service requests to allow Oracle WebGates Basic Auth. (Stanislaw Wozniak)
- Hide markdown toolbar in preview mode.

### Performance (11 changes)

- Improve the performance for counting diverging commits. Show 999+ if it is more than 1000 commits. !15963
- Treat empty markdown and html strings as valid cached text, not missing cache that needs to be updated.
- Cache merged and closed events data in merge_request_metrics table.
- Speed up generation of commit stats by using Rugged native methods.
- Improve search query for issues.
- Improve search query for merge requests.
- Eager load event target authors whenever possible.
- Use simple Next/Prev paging for jobs to avoid large count queries on arbitrarily large sets of historical jobs.
- Improve performance of MR discussions on large diffs.
- Add index on namespaces lower(name) for UsersController#exists.
- Fix timeout when filtering issues by label.

### Added (26 changes, 8 of them are from the community)

- Support new chat notifications parameters in Services API. !11435
- Add online and status attribute to runner api entity. !11750
- Adds ordering to projects contributors in API. !15469 (Jacopo Beschi @jacopo-beschi)
- Add assets_sync gem to Gemfile. !15734
- Add a gitlab:tcp_check rake task. !15759
- add support for sorting in tags api. !15772 (haseebeqx)
- Add Prometheus to available Cluster applications. !15895
- Validate file status when commiting multiple files. !15922
- List of avatars should never show +1. !15972 (Jacopo Beschi @jacopo-beschi)
- Do not generate NPM links for private NPM modules in blob view. !16002 (Mario de la Ossa)
- Backport fast database lookup of SSH authorized_keys from EE. !16014
- Add i18n helpers to branch comparison view. !16031 (James Ramsay)
- Add pause/resume button to project runners. !16032 (Mario de la Ossa)
- Added option to user preferences to enable the multi file editor. !16056
- Implement project jobs cache reset. !16067
- Rendering of emoji's in Group-Overview. !16098 (Jacopo Beschi @jacopo-beschi)
- Allow automatic creation of Kubernetes Integration from template. !16104
- API: get participants from merge_requests & issues. !16187 (Brent Greeff)
- Added option to disable commits stats in the commit endpoint. !16309
- Disable creation of new Kubernetes Integrations unless they're active or created from template. !41054
- Added badge to tree & blob views to indicate LFS tracked files.
- Enable ordering of groups and their children by name.
- Add button to run scheduled pipeline immediately.
- Allow user to rebase merge requests.
- Handle GitLab hashed storage repositories using the repo import task.
- Hide runner token in CI/CD settings page.

### Other (12 changes, 3 of them are from the community)

- Adds the multi file editor as a new beta feature. !15430
- Use relative URLs when linking to uploaded files. !15751
- Add docs for why you might be signed out when using the Remember me token. !15756
- Replace '.team << [user, role]' with 'add_role(user)' in specs. !16069 (@blackst0ne)
- Add id to modal.vue to support data-toggle="modal". !16189
- Update scss-lint to 0.56.0. !16278 (Takuya Noguchi)
- Fix web ide user preferences copy and buttons. !41789
- Update redis-rack to 2.0.4.
- Import some code and functionality from gitlab-shell to improve subprocess handling.
- Update Browse file to Choose file in all occurences.
- Bump mysql2 gem version from 0.4.5 to 0.4.10. (asaparov)
- Use a background migration for issues.closed_at.


## 10.3.9 (2018-03-16)

### Security (3 changes)

- Fixed some SSRF vulnerabilities in services, hooks and integrations. !2337
- Update nokogiri to 1.8.2. !16807
- Fix GitLab Auth0 integration signing in the wrong user.


## 10.3.8 (2018-03-01)

### Security (1 change)

- Ensure that OTP backup codes are always invalidated.


## 10.3.7 (2018-02-05)

### Security (4 changes)

- Fix namespace access issue for GitHub, BitBucket, and GitLab.com project importers.
- Fix stored XSS in code blocks that ignore highlighting.
- Fix wilcard protected tags protecting all branches.
- Restrict Todo API mark_as_done endpoint to the user's todos only.


## 10.3.6 (2018-01-22)

### Fixed (17 changes, 2 of them are from the community)

- Fix abuse reports link url in admin area navbar. !16068 (megos)
- Fix gitlab-rake gitlab:import:repos import schedule. !16115
- Fixing bug when wiki last version. !16197
- Prevent excessive DB load due to faulty DeleteConflictingRedirectRoutes background migration. !16205
- Default merge request title is set correctly again when external issue tracker is activated. !16356 (Ben305)
- Prevent invalid Route path if path is unchanged. !16397
- Fixing rack request mime type when using rack attack. !16427
- Prevent RevList failing on non utf8 paths. !16440
- Fix 500 error when visiting a commit where the blobs do not exist.
- Fix viewing merge request diffs where the underlying blobs are unavailable.
- Gracefully handle garbled URIs in Markdown.
- Fix hooks not being set up properly for bare import Rake task.
- Fix Mermaid drawings not loading on some browsers.
- Fixed chanages dropdown ellipsis positioning.
- Avoid leaving a push event empty if payload cannot be created.
- Set target_branch to the ref branch when creating MR from issue.
- Fix shortcut links on help page.


## 10.3.5 (2018-01-18)

- Fix error that prevented the 'deploy_keys' migration from working in MySQL databases.

## 10.3.4 (2018-01-10)

### Security (7 changes, 1 of them is from the community)

- Prevent a SQL injection in the MilestonesFinder.
- Fix RCE via project import mechanism.
- Prevent OAuth login POST requests when a provider has been disabled.
- Filter out sensitive fields from the project services API. (Robert Schilling)
- Check user authorization for source and target projects when creating a merge request.
- Fix path traversal in gitlab-ci.yml cache:key.
- Fix writable shared deploy keys.


## 10.3.3 (2018-01-02)

### Fixed (3 changes)

- Fix links to old commits in merge request comments.
- Fix 404 errors after a user edits an issue description and solves the reCAPTCHA.
- Gracefully handle orphaned write deploy keys in /internal/post_receive.


## 10.3.2 (2017-12-28)

### Fixed (1 change)

- Fix migration for removing orphaned issues.moved_to_id values in MySQL and PostgreSQL.


## 10.3.1 (2017-12-27)

### Fixed (3 changes)

- Don't link LFS objects to a project when unlinking forks when they were already linked. !16006
- Execute project hooks and services after commit when moving an issue.
- Fix Error 500s with anonymous clones for a project that has moved.

### Changed (1 change)

- Reduce the number of buckets in gitlab_cache_operation_duration_seconds metric. !15881


## 10.3.0 (2017-12-22)

### Security (1 change, 1 of them is from the community)

- Upgrade jQuery to 2.2.4. !15570 (Takuya Noguchi)

### Fixed (55 changes, 8 of them are from the community)

- Fail jobs if its dependency is missing. !14009
- Fix errors when selecting numeric-only labels in the labels autocomplete selector. !14607 (haseebeqx)
- Fix pipeline status transition for single manual job. This would also fix pipeline duration becuse it is depending on status transition. !15251
- Fix acceptance of username for Mattermost service update. !15275
- Set the default gitlab-shell timeout to 3 hours. !15292
- Make sure a user can add projects to subgroups they have access to. !15294
- OAuth identity lookups case-insensitive. !15312
- Fix filter by my reaction is not working. !15345 (Hiroyuki Sato)
- Avoid deactivation when pipeline schedules execute a branch includes `[ci skip]` comment. !15405
- Add recaptcha modal to issue updates detected as spam. !15408
- Fix item name and namespace text overflow in Projects dropdown. !15451
- Removed unused rake task, 'rake gitlab:sidekiq:drop_post_receive'. !15493
- Fix commits page throwing 500 when the multi-file editor was enabled. !15502
- Fix Issue comment submit button being disabled when pasting content from another GFM note. !15530
- Reenable Prometheus metrics, add more control over Prometheus method instrumentation. !15558
- Fix broadcast message not showing up on login page. !15578
- Initializes the branches dropdown when the 'Start new pipeline' failed due to validation errors. !15588 (Christiaan Van den Poel)
- Fix merge requests where the source or target branch name matches a tag name. !15591
- Create a fork network for forks with a deleted source. !15595
- Fix search results when a filename would contain a special character. !15606 (haseebeqx)
- Strip leading & trailing whitespaces in CI/CD secret variable keys. !15615
- Correctly link to a forked project from the new fork page. !15653
- Fix the fork project functionality for projects with hashed storage. !15671
- Added default order to UsersFinder. !15679
- Fix graph notes number duplication. !15696 (Vladislav Kaverin)
- Fix updateEndpoint undefined error for issue_show app root. !15698
- Change boards page boards_data absolute urls to paths. !15703
- Using appropiate services in the API for managing forks. !15709
- Confirming email with invalid token should no longer generate an error. !15726
- fix #39233 - 500 in merge request. !15774 (Martin Nowak)
- Use Markdown styling for new project guidelines. !15785 (Markus Koller)
- Fix error during schema dump. !15866
- Fix broken illustration images for monitoring page empty states. !15889
- Make sure user email is read only when synced with LDAP. !15915
- Fixed outdated browser flash positioning.
- Fix gitlab:import:repos Rake task moving repositories into the wrong location.
- Gracefully handle case when repository's root ref does not exist.
- Fix GitHub importer using removed interface.
- Align retry button with job title with new grid size.
- Fixed admin welcome screen new group path.
- Fix related branches/Merge requests failing to load when the hostname setting is changed.
- Init zen mode in snippets pages.
- Remove extra margin from wordmark in header.
- Fixed long commit links not wrapping correctly.
- Fixed deploy keys remove button loading state not resetting.
- Use app host instead of asset host when rendering image blob or diff.
- Hide log size for mobile screens.
- Fix sending notification emails to users with the mention level set who were mentioned in an issue or merge request description.
- Changed validation error message on wrong milestone dates. (Xurxo Méndez Pérez)
- Fix access to the final page of todos.
- Fixed new group milestone breadcrumbs.
- Fix image diff notification email from showing wrong content.
- Fixed merge request lock icon size.
- Make sure head pippeline always corresponds with the head sha of an MR.
- Prevent 500 error when inspecting job after trigger was removed.

### Changed (14 changes, 2 of them are from the community)

- Only owner or master can erase jobs. !15216
- Allow password authentication to be disabled entirely. !15223 (Markus Koller)
- Add the option to automatically run a pipeline after updating AutoDevOps settings. !15380
- Add total_time_spent to the `changes` hash in issuable Webhook payloads. !15381
- Monitor NFS shards for circuitbreaker in a separate process. !15426
- Add inline editing to issues on mobile. !15438
- Add custom brand text on new project pages. !15541 (Markus Koller)
- Show only group name by default and put full namespace in tooltip in Groups tree. !15650
- Use custom user agent header in all GCP API requests. !15705
- Changed the deploy markers on the prometheus dashboard to be more verbose. !38032
- Animate contextual sidebar on collapse/expand.
- Update emojis. Add :gay_pride_flag: and :speech_left:. Remove extraneous comma in :cartwheel_tone4:.
- When a custom header logo is present, don't show GitLab type logo.
- Improved diff changed files dropdown design.

### Performance (19 changes)

- Add timeouts for Gitaly calls. !15047
- Performance issues when loading large number of wiki pages. !15276
- Add performance logging to UpdateMergeRequestsWorker. !15360
- Keep track of all circuitbreaker keys in a set. !15613
- Improve the performance for counting commits. !15628
- Reduce requests for project forks on show page of projects that have forks. !15663
- Perform SQL matching of Build&Runner tags to greatly speed-up job picking.
- Only load branch names for protected branch checks.
- Optimize API /groups/:id/projects by preloading associations.
- Remove allocation tracking code from InfluxDB sampler for performance.
- Throttle the number of UPDATEs triggered by touch.
- Make finding most recent merge request diffs more efficient.
- Fetch blobs in bulk when generating diffs.
- Cache commits for MergeRequest diffs.
- Use fuzzy search with minimum length of 3 characters where appropriate.
- Add axios to common file.
- Remove template selector from global namespace.
- check the import_status field before doing SQL operations to check the import url.
- Stop sending milestone and labels data over the wire for MR widget requests.

### Added (22 changes, 15 of them are from the community)

- Limit autocomplete menu to applied labels. !11110 (Vitaliy @blackst0ne Klachkov)
- Make diff notes created on a commit in a merge request to persist a rebase. !12148
- Allow creation of merge request from email. !13817 (janp)
- Add an ability to use a custom branch name on creation from issues. !13884 (Vitaliy @blackst0ne Klachkov)
- Add anonymous rate limit per IP, and authenticated (web or API) rate limits per user. !14708
- Create a new form to add Existing Kubernetes Cluster. !14805
- Add support of Mermaid (generation of diagrams and flowcharts from text). !15107 (Vitaliy @blackst0ne Klachkov)
- Add total time spent to milestones. !15116 (George Andrinopoulos)
- Add /groups/:id/subgroups endpoint to API. !15142 (marbemac)
- Add administrative endpoint to list all pages domains. !15160 (Travis Miller)
- Adds Rubocop rule for line break after guard clause. !15188 (Jacopo Beschi @jacopo-beschi)
- Add edit button to mobile file view. !15199 (Travis Miller)
- Add dropdown sort to group milestones. !15230 (George Andrinopoulos)
- added support for ordering and sorting in notes api. !15342 (haseebeqx)
- Hashed Storage migration script now supports migrating project attachments. !15352
- New API endpoint - list jobs for a specified runner. !15432
- Add new API endpoint - get a namespace by ID. !15442
- Disables autocomplete in filtered searc. !15477 (Jacopo Beschi @jacopo-beschi)
- Update empty state page of merge request 'changes' tab. !15611 (Vitaliy @blackst0ne Klachkov)
- Allow git pull/push on group/user/project redirects. !15670
- show status of gitlab reference links in wiki. !15694 (haseebeqx)
- Add email confirmation parameters for user creation and update via API. (Daniel Juarez)

### Other (17 changes, 7 of them are from the community)

- Enable UnnecessaryMantissa in scss-lint. !15255 (Takuya Noguchi)
- Add untracked files to uploads table. !15270
- Move update_project_counter_caches? out of issue and merge request. !15300 (George Andrinopoulos)
- Removed tooltip from clone dropdown. !15334
- Clean up empty fork networks. !15373
- Create issuable destroy service. !15604 (George Andrinopoulos)
- Upgrade seed-fu to 2.3.7. !15607 (Takuya Noguchi)
- Rename GKE as Kubernetes Engine. !15608 (Takuya Noguchi)
- Prefer ci_config_path validation for leading slashes instead of sanitizing the input. !15672 (Christiaan Van den Poel)
- Fix typo in docs about Elasticsearch. !15699 (Takuya Noguchi)
- Add internationalization support for the prometheus integration. !33338
- Export text utils functions as es6 module and add tests.
- Stop reloading the page when using pagination and tabs - use API calls - in Pipelines table.
- Clean up schema of the "issues" table.
- Clarify wording of protected branch settings for the default branch.
- Update svg external depencency.
- Clean up schema of the "merge_requests" table.


## 10.2.8 (2018-02-07)

### Security (4 changes)

- Fix namespace access issue for GitHub, BitBucket, and GitLab.com project importers.
- Fix stored XSS in code blocks that ignore highlighting.
- Fix wilcard protected tags protecting all branches.
- Restrict Todo API mark_as_done endpoint to the user's todos only.


## 10.2.7 (2018-01-18)

- No changes.

## 10.2.6 (2018-01-11)

### Security (9 changes, 1 of them is from the community)

- Fix writable shared deploy keys.
- Filter out sensitive fields from the project services API. (Robert Schilling)
- Fix RCE via project import mechanism.
- Fixed IPython notebook output not being sanitized.
- Prevent OAuth login POST requests when a provider has been disabled.
- Prevent a SQL injection in the MilestonesFinder.
- Check user authorization for source and target projects when creating a merge request.
- Fix path traversal in gitlab-ci.yml cache:key.
- Fix XSS vulnerability in pipeline job trace.


## 10.2.5 (2017-12-15)

### Fixed (8 changes)

- Create a fork network for forks with a deleted source. !15595
- Correctly link to a forked project from the new fork page. !15653
- Fix the fork project functionality for projects with hashed storage. !15671
- Fix updateEndpoint undefined error for issue_show app root. !15698
- Fix broken illustration images for monitoring page empty states. !15889
- Fix related branches/Merge requests failing to load when the hostname setting is changed.
- Fix gitlab:import:repos Rake task moving repositories into the wrong location.
- Gracefully handle case when repository's root ref does not exist.

### Performance (3 changes)

- Keep track of all circuitbreaker keys in a set. !15613
- Only load branch names for protected branch checks.
- Optimize API /groups/:id/projects by preloading associations.


## 10.2.4 (2017-12-07)

### Security (5 changes)

- Fix e-mail address disclosure through member search fields
- Prevent creating issues through API when user does not have permissions
- Prevent an information disclosure in the Groups API
- Fix user without access to private Wiki being able to see it on the project page
- Fix Cross-Site Scripting (XSS) vulnerability while editing a comment


## 10.2.3 (2017-11-30)

### Fixed (7 changes)

- Fix hashed storage for Import/Export uploads. !15482
- Ensure that rake gitlab:cleanup:repos task does not mess with hashed repositories. !15520
- Ensure that rake gitlab:cleanup:dirs task does not mess with hashed repositories. !15600
- Fix WIP system note not being created.
- Fix link text from group context.
- Fix defaults for MR states and merge statuses.
- Fix pulling and pushing using a personal access token with the sudo scope.

### Performance (3 changes)

- Drastically improve project search performance by no longer searching namespace name.
- Reuse authors when rendering event Atom feeds.
- Optimise StuckCiJobsWorker using cheap SQL query outside, and expensive inside.


## 10.2.2 (2017-11-23)

### Fixed (5 changes)

- Label addition/removal are not going to be redacted wrongfully in the API. !15080
- Fix bitbucket wiki import with hashed storage enabled. !15490
- Impersonation no longer gets stuck on password change. !15497
- Fix blank states using old css.
- Fix promoting milestone updating all issuables without milestone.

### Performance (3 changes)

- Update Issue Boards to fetch the notification subscription status asynchronously.
- Update composite pipelines index to include "id".
- Use arrays in Pipeline#latest_builds_with_artifacts.

### Other (2 changes)

- Don't move repositories and attachments for projects using hashed storage. !15479
- Add logs for monitoring the merge process.


## 10.2.1 (2017-11-22)

### Fixed (1 change)

- Force disable Prometheus metrics.


## 10.2.0 (2017-11-22)

### Security (4 changes)

- Upgrade Ruby to 2.3.5 to include security patches. !15099
- Prevent OAuth phishing attack by presenting detailed wording about app to user during authorization.
- Convert private tokens to Personal Access Tokens with sudo scope.
- Remove private tokens from web interface and API.

### Removed (5 changes)

- Remove help text from group issues page and group merge requests page. !14963
- Remove overzealous tooltips in projects page tabs. !15017
- Stop merge requests from fetching their refs when the data is already available. !15129
- Remove update merge request worker tagging.
- Remove Session API now that private tokens are removed from user API endpoints.

### Fixed (75 changes, 18 of them are from the community)

- Fix 404 errors in API caused when the branch name had a dot. !14462 (gvieira37)
- Remove unnecessary alt-texts from pipeline emails. !14602 (gernberg)
- Renders 404 in commits controller if no commits are found for a given path. !14610 (Guilherme Vieira)
- Cleanup data-page attribute after each Karma test. !14742
- Removed extra border radius from .file-editor and .file-holder when editing a file. !14803 (Rachel Pipkin)
- Add support for markdown preview to group milestones. !14806 (Vitaliy @blackst0ne Klachkov)
- Fixed 'Removed source branch' checkbox in merge widget being ignored. !14832
- Fix unnecessary ajax requests in admin broadcast message form. !14853
- Make NamespaceSelect change URL when filtering. !14888
- Get true failure from evalulate_script by checking for element beforehand. !14898
- Fix SAML error 500 when no groups are defined for user. !14913
- Fix 500 errors caused by empty diffs in some discussions. !14945 (Alexander Popov)
- Fix the atom feed for group events. !14974
- Hides pipeline duration in commit box when it is zero (nil). !14979 (gvieira37)
- Add new diff discussions on MR diffs tab in "realtime". !14981
- Returns a ssh url for go-get=1. !14990 (gvieira37)
- Case insensitive search for branches. !14995 (George Andrinopoulos)
- Fixes 404 error to 'Issues assigned to me' and 'Issues I've created' when issues are disabled. !15021 (Jacopo Beschi @jacopo-beschi)
- Update the groups API documentation. !15024 (Robert Schilling)
- Validate username/pw for Jiraservice, require them in the API. !15025 (Robert Schilling)
- Update Merge Request polling so there is only one request at a time. !15032
- Use project select dropdown not only as a combobutton. !15043
- Remove create MR button from issues when MRs are disabled. !15071 (George Andrinopoulos)
- Tighten up whitelisting of certain Geo routes. !15082
- Allow to disable the Performance Bar. !15084
- Refresh open Issue and Merge Request project counter caches when re-opening. !15085 (Rob Ede @robjtede)
- Fix markdown form tabs toggling preview mode from double clicking write mode button. !15119
- Fix cancel button not working while uploading on the new issue page. !15137
- Fix webhooks recent deliveries. !15146 (Alexander Randa (@randaalex))
- Fix issues with forked projects of which the source was deleted. !15150
- Fix GPG signature popup info in Safari and Firefox. !15228
- Fix GFM reference links for closed milestones. !15234 (Vitaliy @blackst0ne Klachkov)
- When deleting merged branches, ignore protected tags. !15252
- Revert a regression on runners sorting (!15134). !15341 (Takuya Noguchi)
- Don't use JS to delete memberships from projects and groups. !15344
- Don't try to create fork network memberships for forks with a missing source. !15366
- Fix gitlab:backup rake for hashed storage based repositories. !15400
- Fix issue where clicking a GPG verification badge would scroll to the top of the page. !15407
- Update container repository path reference and allow using double underscore. !15417
- Fix crash when navigating to second page of the group dashbaord when there are projects and groups on the first page. !15456
- Fix flash errors showing up on a non configured prometheus integration. !35652
- Fix timezone bug in Pikaday and upgrade Pikaday version.
- Fix arguments Import/Export error importing project merge requests.
- Moves mini graph of pipeline to the end of sentence in MR widget. Cleans HTML and tests.
- Fix user autocomplete in subgroups.
- Fixed user profile activity tab being off-screen on mobile.
- Fix diff parser so it tolerates to diff special markers in the content.
- Fix a migration that adds merge_requests_ff_only_enabled column to MR table.
- Don't create build failed todos when the job is automatically retried.
- Render 404 when polling commit notes without having permissions.
- Show error message when fast-forward merge is not possible.
- Prevents position update for image diff notes.
- Mobile-friendly table on Admin Runners. (Takuya Noguchi)
- Decreases z-index of select2 to a lower number of our navigation bar.
- Fix broken Members link when relative URL root paths are used.
- Avoid regenerating the ref path for the environment.
- Memoize GitLab logger to reduce open file descriptors.
- Fix hashed storage with project transfers to another namespace.
- Fix bad type checking to prevent 0 count badge to be shown.
- Fix problem with issuable header wrapping when content is too long.
- Move retry button in job page to sidebar.
- Formats bytes to human reabale number in registry table.
- Fix commit pipeline showing wrong status.
- Include link to issue in reopen message for Slack and Mattermost notifications.
- Fix double border UI bug on pipelines/environments table and pagination.
- Remove native title tooltip in pipeline jobs dropdown in Safari.
- Fix namespacing for MergeWhenPipelineSucceedsService in MR API.
- Prevent error when authorizing an admin-created OAauth application without a set owner.
- Always return full avatar URL for private/internal groups/projects when asset host is set.
- Make sure group and project creation is blocked for new users that are external by default.
- Make sure NotesActions#noteable returns a Noteable in the update action.
- Reallow project paths ending in periods.
- Only set Auto-Submitted header once for emails on push.
- Fix overlap of right-sidebar and main content when creating a Wiki page.
- Enables scroll to bottom once user has scrolled back to bottom in job log.

### Changed (21 changes, 7 of them are from the community)

- Added possibility to enter past date in /spend command to log time in the past. !3044 (g3dinua, LockiStrike)
- Add Prometheus equivalent of all InfluxDB metrics. !13891
- Show collapsible project lists. !14055
- Make Prometheus metrics endpoint return empty response when metrics are disabled. !14490
- Support custom attributes on groups and projects. !14593 (Markus Koller)
- Avoid fetching all branches for branch existence checks. !14778
- Update participants and subscriptions button in issuable sidebar to be async. !14836
- Replace WikiPage::CreateService calls with wiki_page factory in specs. !14850 (Jacopo Beschi @jacopo-beschi)
- Add lazy option to UserAvatarImage. !14895
- Add readme only option as project view. !14900
- Todos spelled correctly on Todos list page. !15015
- Support uml:: and captions in reStructuredText. !15120 (Markus Koller)
- Add system hooks user_rename and group_rename. !15123
- Change tags order in refs dropdown. !15235 (Vitaliy @blackst0ne Klachkov)
- Change default cluster size to n1-default-2. !39649 (Fabio Busatto)
- Change 'Sign Out' route from a DELETE to a GET. !39708 (Joe Marty)
- Change background color of nav sidebar to match other gl sidebars.
- Update i18n section in FE docs for marking and interpolation.
- Add a count of changes to the merge requests API.
- Improve GitLab Import rake task to work with Hashed Storage and Subgroups.
- 14830 Move GitLab export option to top of import list when creating a new project.

### Performance (14 changes)

- Improve branch listing page performance. !14729
- Improve DashboardController#activity.json performance. !14985
- Add a latest_merge_request_diff_id column to merge_requests. !15035
- Improve performance of the /projects/:id/repository/branches API endpoint. !15215
- Ensure merge requests with lots of version don't time out when searching for pipelines.
- Speed up issues list APIs.
- Remove Filesystem check metrics that use too much CPU to handle requests.
- Disable Unicorn sampling in Sidekiq since there are no Unicorn sockets to monitor.
- Truncate tree to max 1,000 items and display notice to users.
- Add Performance improvement as category on the changelog.
- Cache commits fetched from the repository.
- Cache the number of user SSH keys.
- Optimise getting the pipeline status of commits.
- Improve performance of commits list by fully using DB index when getting commit note counts.

### Added (26 changes, 10 of them are from the community)

- Expose duration in Job entity. !13644 (Mehdi Lahmam (@mehlah))
- Prevent git push when LFS objects are missing. !13837
- Automatic configuration settings page. !13850 (Francisco Lopez)
- Add API endpoints for Pages Domains. !13917 (Travis Miller)
- Include the changes in issuable webhook payloads. !14308
- Add Packagist project service. !14493 (Matt Coleman)
- Add sort runners on admin runners. !14661 (Takuya Noguchi)
- Repo Editor: Add option to start a new MR directly from comit section. !14665
- Issue JWT token with registry:catalog:* scope when requested by GitLab admin. !14751 (Vratislav Kalenda)
- Support show-all-refs for git over HTTP. !14834
- Add loading button for new UX paradigm. !14883
- Get Project Branch API shows an helpful error message on invalid refname. !14884 (Jacopo Beschi @jacopo-beschi)
- Refactor have_http_status into have_gitlab_http_status. !14958 (Jacopo Beschi @jacopo-beschi)
- Suggest to rename the remote for existing repository instructions. !14970 (helmo42)
- Adds project_id to pipeline hook data. !15044 (Jacopo Beschi @jacopo-beschi)
- Hashed Storage support for Attachments. !15068
- Add metric tagging for sidekiq workers. !15111
- Expose project visibility as CI variable - CI_PROJECT_VISIBILITY. !15193
- Allow multiple queries in a single Prometheus graph to support additional environments (Canary, Staging, et al.). !15201
- Allow promoting project milestones to group milestones.
- Added submodule support in multi-file editor.
- Add applications section to GKE clusters page to easily install Helm Tiller, Ingress.
- Allow files to uploaded in the multi-file editor.
- Add Ingress to available Cluster applications.
- Adds typescript support.
- Add sudo scope for OAuth and Personal Access Tokens to be used by admins to impersonate other users on the API.

### Other (18 changes, 8 of them are from the community)

- Decrease Perceived Complexity threshold to 14. !14231 (Maxim Rydkin)
- Replace the 'features/explore/projects.feature' spinach test with an rspec analog. !14755 (Vitaliy @blackst0ne Klachkov)
- While displaying a commit, do not show list of related branches if there are thousands of branches. !14812
- Removed d3.js from the graph and users bundles and used the common_d3 bundle instead. !14826
- Make contributors page translatable. !14915
- Decrease ABC threshold to 54.28. !14920 (Maxim Rydkin)
- Clarify system_hook triggers in documentation. !14957 (Joe Marty)
- Free up some reserved group names. !15052
- Bump carrierwave to 1.2.1. !15072 (Takuya Noguchi)
- Enable NestingDepth (level 6) on scss-lint. !15073 (Takuya Noguchi)
- Enable BorderZero rule in scss-lint. !15168 (Takuya Noguchi)
- Internationalized tags page. !38589
- Moves placeholders components into shared folder with documentation. Makes them easier to reuse in MR and Snippets comments.
- Reorganize welcome page for new users.
- Refactor GroupLinksController. (15121)
- Remove filter icon from search bar.
- Use title as placeholder instead of issue title for reusability.
- Add Gitaly metrics to the performance bar.


## 10.1.7 (2018-01-18)

- No changes.

## 10.1.6 (2018-01-11)

### Security (8 changes, 1 of them is from the community)

- Fix writable shared deploy keys.
- Filter out sensitive fields from the project services API. (Robert Schilling)
- Fix RCE via project import mechanism.
- Prevent OAuth login POST requests when a provider has been disabled.
- Prevent a SQL injection in the MilestonesFinder.
- Check user authorization for source and target projects when creating a merge request.
- Fix path traversal in gitlab-ci.yml cache:key.
- Fix XSS vulnerability in pipeline job trace.


## 10.1.5 (2017-12-07)

### Security (5 changes)

- Fix e-mail address disclosure through member search fields
- Prevent creating issues through API when user does not have permissions
- Prevent an information disclosure in the Groups API
- Fix user without access to private Wiki being able to see it on the project page
- Fix Cross-Site Scripting (XSS) vulnerability while editing a comment


## 10.1.4 (2017-11-14)

### Fixed (4 changes)

- Don't try to create fork network memberships for forks with a missing source. !15366
- Formats bytes to human reabale number in registry table.
- Prevent error when authorizing an admin-created OAauth application without a set owner.
- Prevents position update for image diff notes.


## 10.1.3 (2017-11-10)

- [SECURITY] Prevent OAuth phishing attack by presenting detailed wording about app to user during authorization.
- [FIXED] Fix cancel button not working while uploading on the new issue page. !15137
- [FIXED] Fix webhooks recent deliveries. !15146 (Alexander Randa (@randaalex))
- [FIXED] Fix issues with forked projects of which the source was deleted. !15150
- [FIXED] Fix GPG signature popup info in Safari and Firefox. !15228
- [FIXED] Make sure group and project creation is blocked for new users that are external by default.
- [FIXED] Fix arguments Import/Export error importing project merge requests.
- [FIXED] Fix diff parser so it tolerates to diff special markers in the content.
- [FIXED] Fix a migration that adds merge_requests_ff_only_enabled column to MR table.
- [FIXED] Render 404 when polling commit notes without having permissions.
- [FIXED] Show error message when fast-forward merge is not possible.
- [FIXED] Avoid regenerating the ref path for the environment.
- [PERFORMANCE] Remove Filesystem check metrics that use too much CPU to handle requests.

## 10.1.2 (2017-11-08)

- [SECURITY] Add X-Content-Type-Options header in API responses to make it more difficult to find other vulnerabilities.
- [SECURITY] Properly translate IP addresses written in decimal, octal, or other formats in SSRF protections in project imports.
- [FIXED] Fix TRIGGER checks for MySQL.

## 10.1.1 (2017-10-31)

- [FIXED] Auto Devops kubernetes default namespace is now correctly built out of gitlab project group-name. !14642 (Mircea Danila Dumitrescu)
- [FIXED] Forbid the usage of `Redis#keys`. !14889
- [FIXED] Make the circuitbreaker more robust by adding higher thresholds, and multiple access attempts. !14933
- [FIXED] Only cache last push event for existing projects when pushing to a fork. !14989
- [FIXED] Fix bug preventing secondary emails from being confirmed. !15010
- [FIXED] Fix broken wiki pages that link to a wiki file. !15019
- [FIXED] Don't rename paths that were freed up when upgrading. !15029
- [FIXED] Fix bitbucket login. !15051
- [FIXED] Update gitaly in GitLab 10.1 to 0.43.1 for temp file cleanup. !15055
- [FIXED] Use the correct visibility attribute for projects in system hooks. !15065
- [FIXED] Normalize LDAP DN when looking up identity.
- [FIXED] Adds callback functions for initial request in clusters page.
- [FIXED] Fix missing Import/Export issue assignees.
- [FIXED] Allow boards as top level route.
- [FIXED] Fix widget of locked merge requests not being presented.
- [FIXED] Fix editing issue description in mobile view.
- [FIXED] Fix deletion of container registry or images returning an error.
- [FIXED] Fix the writing of invalid environment refs.
- [CHANGED] Store circuitbreaker settings in the database instead of config. !14842
- [CHANGED] Update default disabled merge request widget message to reflect a general failure. !14960
- [PERFORMANCE] Stop merge requests with thousands of commits from timing out. !15063

## 10.1.0 (2017-10-22)

- [SECURITY] Use a timeout on certain git operations. !14872
- [SECURITY] Move project repositories between namespaces when renaming users.
- [SECURITY] Prevent an open redirect on project pages.
- [SECURITY] Prevent a persistent XSS in user-provided markup.
- [REMOVED] Remove the ability to visit the issue edit form directly. !14523
- [REMOVED] Remove animate.js and label animation.
- [FIXED] Perform prometheus data endpoint requests in parallel. !14003
- [FIXED] Escape quotes in git username. !14020 (Brandon Everett)
- [FIXED] Fixed non-UTF-8 valid branch names from causing an error. !14090
- [FIXED] Read import sources from setting at first initialization. !14141 (Visay Keo)
- [FIXED] Display full pre-receive and post-receive hook output in GitLab UI. !14222 (Robin Bobbitt)
- [FIXED] Fix incorrect X-axis labels in Prometheus graphs. !14258
- [FIXED] Fix the default branches sorting to actually be 'Last updated'. !14295
- [FIXED] Fixes project denial of service via gitmodules using Extended ASCII. !14301
- [FIXED] Fix the filesystem shard health check to check all configured shards. !14341
- [FIXED] Compare email addresses case insensitively when verifying GPG signatures. !14376 (Tim Bishop)
- [FIXED] Allow the git circuit breaker to correctly handle missing repository storages. !14417
- [FIXED] Fix `rake gitlab:incoming_email:check` and make it report the actual error. !14423
- [FIXED] Does not check if an invariant hashed storage path exists on disk when renaming projects. !14428
- [FIXED] Also reserve refs/replace after importing a project. !14436
- [FIXED] Fix profile image orientation based on EXIF data gvieira37. !14461 (gvieira37)
- [FIXED] Move the deployment flag content to the left when deployment marker is near the end. !14514
- [FIXED] Fix notes type created from import. This should fix some missing notes issues from imported projects. !14524
- [FIXED] Fix bottom spacing for dropdowns that open upwards. !14535
- [FIXED] Adjusts tag link to avoid underlining spaces. !14544 (Guilherme Vieira)
- [FIXED] Add missing space in Sidekiq memory killer log message. !14553 (Benjamin Drung)
- [FIXED] Ensure no exception is raised when Raven tries to get the current user in API context. !14580
- [FIXED] Fix edit project service cancel button position. !14596 (Matt Coleman)
- [FIXED] Fix case sensitive email confirmation on signup. !14606 (robdel12)
- [FIXED] Whitelist authorized_keys.lock in the gitlab:check rake task. !14624
- [FIXED] Allow merge in MR widget with no pipeline but using "Only allow merge requests to be merged if the pipeline succeeds". !14633
- [FIXED] Fix navigation dropdown close animation on mobile screens. !14649
- [FIXED] Fix the project import with issues and milestones. !14657
- [FIXED] Use explicit boolean true attribute for show-disabled-button in Vue files. !14672
- [FIXED] Make tabs on top scrollable on admin dashboard. !14685 (Takuya Noguchi)
- [FIXED] Fix broken Y-axis scaling in some Prometheus graphs. !14693
- [FIXED] Search or compare LDAP DNs case-insensitively and ignore excess whitespace. !14697
- [FIXED] Allow prometheus graphs to correctly handle NaN values. !14741
- [FIXED] Don't show an "Unsubscribe" link in snippet comment notifications. !14764
- [FIXED] Fixed duplicate notifications when added multiple labels on an issue. !14798
- [FIXED] Fix alignment for indeterminate marker in dropdowns. !14809
- [FIXED] Fix error when updating a forked project with deleted `ForkedProjectLink`. !14916
- [FIXED] Correctly render asset path for locales with a region. !14924
- [FIXED] Fix the external URLs generated for online view of HTML artifacts. !14977
- [FIXED] Reschedule merge request diff background migrations to catch failures from 9.5 run.
- [FIXED] fix merge request widget status icon for failed CI.
- [FIXED] Fix the number representing the amount of commits related to a push event.
- [FIXED] Sync up hover and legend data across all graphs for the prometheus dashboard.
- [FIXED] Fixes mini pipeline graph in commit view.
- [FIXED] Fix comment deletion confirmation dialog typo.
- [FIXED] Fix project snippets breadcrumb link.
- [FIXED] Make usage ping scheduling more robust.
- [FIXED] Make "merge ongoing" check more consistent.
- [FIXED] Add 1000+ counters to job page.
- [FIXED] Fixed issue/merge request breadcrumb titles not having links.
- [FIXED] Fixed commit avatars being centered vertically.
- [FIXED] Tooltips in the commit info box now all face the same direction. (Jedidiah Broadbent)
- [FIXED] Fixed navbar title colors leaking out of the navbar.
- [FIXED] Fix bug that caused merge requests with diff notes imported from Bitbucket to raise errors.
- [FIXED] Correctly detect multiple issue URLs after 'Closes...' in MR descriptions.
- [FIXED] Set default scope on PATs that don't have one set to allow them to be revoked.
- [FIXED] Fix application setting to cache nil object.
- [FIXED] Fix image diff swipe handle offset to correctly align with the frame.
- [FIXED] Force non diff resolved discussion to display when collapse toggled.
- [FIXED] Fix resolved discussions not expanding on side by side view.
- [FIXED] Fixed the sidebar scrollbar overlapping links.
- [FIXED] Issue board tooltips are now the correct width when the column is collapsed. (Jedidiah Broadbent)
- [FIXED] Improve autodevops banner UX and render it only in project page.
- [FIXED] Fix typo in cycle analytics breaking time component.
- [FIXED] Force two up view to load by default for image diffs.
- [FIXED] Fixed milestone breadcrumb links.
- [FIXED] Fixed group sort dropdown defaulting to empty.
- [FIXED] Fixed notes not being scrolled to in merge requests.
- [FIXED] Adds Event polyfill for IE11.
- [FIXED] Update native unicode emojis to always render as normal text (previously could render italicized). (Branka Martinovic)
- [FIXED] Sort JobsController by id, not created_at.
- [FIXED] Fix revision and total size missing for Container Registry.
- [FIXED] Fixed milestone issuable assignee link URL.
- [FIXED] Fixed breadcrumbs container expanding in side-by-side diff view.
- [FIXED] Fixed merge request widget merged & closed date tooltip text.
- [FIXED] Prevent creating multiple ApplicationSetting instances.
- [FIXED] Fix username and ID not logging in production_json.log for Git activity.
- [FIXED] Make Redcarpet Markdown renderer thread-safe.
- [FIXED] Two factor auth messages in settings no longer overlap the button. (Jedidiah Broadbent)
- [FIXED] Made the "remember me" check boxes have consistent styles and alignment. (Jedidiah Broadbent)
- [FIXED] Prevent branches or tags from starting with invalid characters (e.g. -, .).
- [DEPRECATED] Removed two legacy config options. (Daniel Voogsgerd)
- [CHANGED] Show notes number more user-friendly in the graph. !13949 (Vladislav Kaverin)
- [CHANGED] Link SAML users to LDAP by email. !14216
- [CHANGED] Display whether branch has been merged when deleting protected branch. !14220
- [CHANGED] Make the labels in the Compare form less confusing. !14225
- [CHANGED] Confirmation email shows link as text instead of human readable text. !14243 (bitsapien)
- [CHANGED] Return only group's members in user dropdowns on issuables list pages. !14249
- [CHANGED] Added defaults for protected branches dropdowns on the repository settings. !14278
- [CHANGED] Show confirmation modal before deleting account. !14360
- [CHANGED] Allow creating merge requests across a fork network. !14422
- [CHANGED] Re-arrange script HTML tags before template HTML tags in .vue files. !14671
- [CHANGED] Create idea of read-only database. !14688
- [CHANGED] Add active states to nav bar counters.
- [CHANGED] Add view replaced file link for image diffs.
- [CHANGED] Adjust tooltips to adhere to 8px grid and make them more readable.
- [CHANGED] breadcrumbs receives padding when double lined.
- [CHANGED] Allow developer role to admin milestones.
- [CHANGED] Stop using Sidekiq for updating Key#last_used_at.
- [CHANGED] Include GitLab full name in Slack messages.
- [ADDED] Expose last pipeline details in API response when getting a single commit. !13521 (Mehdi Lahmam (@mehlah))
- [ADDED] Allow to use same periods for different housekeeping tasks (effectively skipping the lesser task). !13711 (cernvcs)
- [ADDED] Add GitLab-Pages version to Admin Dashboard. !14040 (travismiller)
- [ADDED] Commenting on image diffs. !14061
- [ADDED] Script to migrate project's repositories to new Hashed Storage. !14067
- [ADDED] Hide close MR button after merge without reloading page. !14122 (Jacopo Beschi @jacopo-beschi)
- [ADDED] Add Gitaly version to Admin Dashboard. !14313 (Jacopo Beschi @jacopo-beschi)
- [ADDED] Add 'closed_at' attribute to Issues API. !14316 (Vitaliy @blackst0ne Klachkov)
- [ADDED] Add tooltip for milestone due date to issue and merge request lists. !14318 (Vitaliy @blackst0ne Klachkov)
- [ADDED] Improve list of sorting options. !14320 (Vitaliy @blackst0ne Klachkov)
- [ADDED] Add client and call site metadata to Gitaly calls for better traceability. !14332
- [ADDED] Strip gitlab-runner section markers in build trace HTML view. !14393
- [ADDED] Add online view of HTML artifacts for public projects. !14399
- [ADDED] Create Kubernetes cluster on GKE from k8s service. !14470
- [ADDED] Add support for GPG subkeys in signature verification. !14517
- [ADDED] Parse and store gitlab-runner timestamped section markers. !14551
- [ADDED] Add "implements" to the default issue closing message regex. !14612 (Guilherme Vieira)
- [ADDED] Replace `tag: true` into `:tag` in the specs. !14653 (Jacopo Beschi @jacopo-beschi)
- [ADDED] Discussion lock for issues and merge requests.
- [ADDED] Add an API endpoint to determine the forks of a project.
- [ADDED] Add help text to runner edit: tags should be separated by commas. (Brendan O'Leary)
- [ADDED] Only copy old/new code when selecting left/right side of parallel diff.
- [ADDED] Expose avatar_url when requesting list of projects from API with simple=true.
- [ADDED] A confirmation email is now sent when adding a secondary email address. (digitalmoksha)
- [ADDED] Move Custom merge methods from EE.
- [ADDED] Makes @mentions links have a different styling for better separation.
- [ADDED] Added tabs to dashboard/projects to easily switch to personal projects.
- [OTHER] Extract AutocompleteController#users into finder. !13778 (Maxim Rydkin, Mayra Cabrera)
- [OTHER] Replace 'project/wiki.feature' spinach test with an rspec analog. !13856 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Expand docs for changing username or group path. !13914
- [OTHER] Move `lib/ci` to `lib/gitlab/ci`. !14078 (Maxim Rydkin)
- [OTHER] Decrease Cyclomatic Complexity threshold to 13. !14152 (Maxim Rydkin)
- [OTHER] Decrease Perceived Complexity threshold to 15. !14160 (Maxim Rydkin)
- [OTHER] Replace project/group_links.feature spinach test with an rspec analog. !14169 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Replace the project/milestone.feature spinach test with an rspec analog. !14171 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Replace the profile/emails.feature spinach test with an rspec analog. !14172 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Replace the project/team_management.feature spinach test with an rspec analog. !14173 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Replace the 'project/merge_requests/accept.feature' spinach test with an rspec analog. !14176 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Replace the 'project/builds/summary.feature' spinach test with an rspec analog. !14177 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Optimize the boards' issues fetching. !14198
- [OTHER] Replace the 'project/merge_requests/revert.feature' spinach test with an rspec analog. !14201 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Replace the 'project/issues/award_emoji.feature' spinach test with an rspec analog. !14202 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Replace the 'profile/active_tab.feature' spinach test with an rspec analog. !14239 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Replace the 'search.feature' spinach test with an rspec analog. !14248 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Load sidebar participants avatars only when visible. !14270
- [OTHER] Adds gitlab features and components to usage ping data. !14305
- [OTHER] Replace the 'project/archived.feature' spinach test with an rspec analog. !14322 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Replace the 'project/commits/revert.feature' spinach test with an rspec analog. !14325 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Replace the 'project/snippets.feature' spinach test with an rspec analog. !14326 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Add link to OpenID Connect documentation. !14368 (Markus Koller)
- [OTHER] Upgrade doorkeeper-openid_connect. !14372 (Markus Koller)
- [OTHER] Upgrade gitlab-markup gem. !14395 (Markus Koller)
- [OTHER] Index projects on repository storage. !14414
- [OTHER] Replace the 'project/shortcuts.feature' spinach test with an rspec analog. !14431 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Replace the 'project/service.feature' spinach test with an rspec analog. !14432 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Improve GitHub import performance. !14445
- [OTHER] Add basic sprintf implementation to JavaScript. !14506
- [OTHER] Replace the 'project/merge_requests.feature' spinach test with an rspec analog. !14621 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Update GitLab Pages to v0.6.0. !14630
- [OTHER] Add documentation to summarise project archiving. !14650
- [OTHER] Remove 'Repo' prefix from API entites. !14694 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Removes cycle analytics service and store from global namespace.
- [OTHER] Improves i18n for Auto Devops callout.
- [OTHER] Exports common_utils utility functions as modules.
- [OTHER] Use `simple=true` for projects API in Projects dropdown for better search performance.
- [OTHER] Change index on ci_builds to optimize Jobs Controller.
- [OTHER] Add index for merge_requests.merge_commit_sha.
- [OTHER] Add (partial) index on Labels.template.
- [OTHER] Cache issue and MR template names in Redis.
- [OTHER] changed dashed border button color to be darker.
- [OTHER] Speed up permission checks.
- [OTHER] Fix docs for lightweight tag creation via API.
- [OTHER] Clarify artifact download via the API only accepts branch or tag name for ref.
- [OTHER] Change recommended MySQL version to 5.6.
- [OTHER] Bump google-api-client Gem from 0.8.6 to 0.13.6.
- [OTHER] Detect when changelog entries are invalid.
- [OTHER] Use a UNION ALL for getting merge request notes.
- [OTHER] Remove an index on ci_builds meant to be only temporary.
- [OTHER] Remove a SQL query from the todos index page.
- Support custom attributes on users. !13038 (Markus Koller)
- made read-only APIs for public merge requests available without authentication. !13291 (haseebeqx)
- Hide read_registry scope when registry is disabled on instance. !13314 (Robin Bobbitt)
- creation of keys moved to services. !13331 (haseebeqx)
- Add username as GL_USERNAME in hooks.

## 10.0.7 (2017-12-07)

### Security (5 changes)

- Fix e-mail address disclosure through member search fields
- Prevent creating issues through API when user does not have permissions
- Prevent an information disclosure in the Groups API
- Fix user without access to private Wiki being able to see it on the project page
- Fix Cross-Site Scripting (XSS) vulnerability while editing a comment


## 10.0.5 (2017-11-03)

- [FIXED] Fix incorrect X-axis labels in Prometheus graphs. !14258
- [FIXED] Fix `rake gitlab:incoming_email:check` and make it report the actual error. !14423
- [FIXED] Does not check if an invariant hashed storage path exists on disk when renaming projects. !14428
- [FIXED] Fix bottom spacing for dropdowns that open upwards. !14535
- [FIXED] Fix the project import with issues and milestones. !14657
- [FIXED] Fix broken Y-axis scaling in some Prometheus graphs. !14693
- [FIXED] Fixed duplicate notifications when added multiple labels on an issue. !14798
- [FIXED] Don't rename paths that were freed up when upgrading. !15029
- [FIXED] Fixed issue/merge request breadcrumb titles not having links.
- [FIXED] Fix application setting to cache nil object.
- [FIXED] Fix missing Import/Export issue assignees.
- [FIXED] Allow boards as top level route.
- [FIXED] Fixed milestone breadcrumb links.
- [FIXED] Fixed merge request widget merged & closed date tooltip text.
- [FIXED] fix merge request widget status icon for failed CI.

## 10.0.4 (2017-10-16)

- [SECURITY] Move project repositories between namespaces when renaming users.
- [SECURITY] Prevent an open redirect on project pages.
- [SECURITY] Prevent a persistent XSS in user-provided markup.

## 10.0.3 (2017-10-05)

- [FIXED] find_user Users helper method no longer overrides find_user API helper method. !14418
- [FIXED] Fix CSRF validation issue when closing/opening merge requests from the UI. !14555
- [FIXED] Kubernetes integration: ensure v1.8.0 compatibility. !14635
- [FIXED] Fixes data parameter not being sent in ajax request for jobs log.
- [FIXED] Improves UX of autodevops popover to match gpg one.
- [FIXED] Fixed commenting on side-by-side commit diff.
- [FIXED] Make sure API responds with 401 when invalid authentication info is provided.
- [FIXED] Fix merge request counter updates after merge.
- [FIXED] Fix gitlab-rake gitlab:import:repos task failing.
- [FIXED] Fix pushes to an empty repository not invalidating has_visible_content? cache.
- [FIXED] Ensure all refs are restored on a restore from backup.
- [FIXED] Gitaly RepositoryExists remains opt-in for all method calls.
- [FIXED] Fix 500 error on merged merge requests when GitLab is restored from a backup.
- [FIXED] Adjust MRs being stuck on "process of being merged" for more than 2 hours.

## 10.0.2 (2017-09-27)

- [FIXED] Notes will not show an empty bubble when the author isn't a member. !14450
- [FIXED] Some checks in `rake gitlab:check` were failling with 'undefined method `run_command`'. !14469
- [FIXED] Make locked setting of Runner to not affect jobs scheduling. !14483
- [FIXED] Re-allow `name` attribute on user-provided anchor HTML.

## 10.0.1 (2017-09-23)

- [FIXED] Fix duplicate key errors in PostDeployMigrateUserExternalMailData migration.

## 10.0.0 (2017-09-22)

- [SECURITY] Upgrade brace-expansion NPM package due to security issue. !13665 (Markus Koller)
- [REMOVED] Remove CI API v1.
- [FIXED] Ensure correct visibility level options shown on all Project, Group, and Snippets forms. !13442
- [FIXED] Fix the /projects/:id/repository/files/:file_path/raw endpoint to handle dots in the file_path. !13512 (mahcsig)
- [FIXED] Merge request reference in merge commit changed to full reference. !13518 (haseebeqx)
- [FIXED] Removes Sortable default scope. !13558
- [FIXED] Wiki table of contents are now properly nested to reflect header level. !13650 (Akihiro Nakashima)
- [FIXED] Improve bare project import: Allow subgroups, take default visibility level into account. !13670
- [FIXED] Fix group and project search for anonymous users. !13745
- [FIXED] Fix searching for files by path. !13798
- [FIXED] Fix division by zero error in blame age mapping. !13803 (Jeff Stubler)
- [FIXED] Fix incorrect date/time formatting on prometheus graphs. !13865
- [FIXED] Changes the password change workflow for admins. !13901
- [FIXED] API: Respect default group visibility when creating a group. !13903 (Robert Schilling)
- [FIXED] Unescape HTML characters in Wiki title. !13942 (Jacopo Beschi @jacopo-beschi)
- [FIXED] Make blob viewer for rich contents wider for mobile. !14011 (Takuya Noguchi)
- [FIXED] Fix typo in the API Deploy Keys documentation page. !14014 (Vitaliy @blackst0ne Klachkov)
- [FIXED] Hide admin link from default search results for non-admins. !14015
- [FIXED] Fix problems sanitizing URLs with empty passwords. !14083
- [FIXED] Fix stray OR in New Project page. !14096 (Robin Bobbitt)
- [FIXED] Fix a wrong `X-Gitlab-Event` header when testing webhooks. !14108
- [FIXED] Fix the diff file header from being html escaped for renamed files. !14121
- [FIXED] Image attachments are properly displayed in notification emails again. !14161
- [FIXED] Fixes the 500 errors caused by a race condition in GPG's tmp directory handling. !14194 (Alexis Reigel)
- [FIXED] Fix MR ready to merge buttons/controls at mobile breakpoint. !14242
- [FIXED] Fix Pipeline Triggers to show triggered label and predefined variables (e.g. CI_PIPELINE_TRIGGERED). !14244
- [FIXED] Allow using newlines in pipeline email service recipients. !14250
- [FIXED] Fix errors when moving issue with reference to a group milestone. !14294
- [FIXED] Fix the "resolve discussion in a new issue" button. !14357
- [FIXED] File uploaders do not perform hard check, only soft check.
- [FIXED] Add to_project_id parameter to Move Issue via API example.
- [FIXED] Update x/x discussions resolved checkmark icon to be green when all discussions resolved.
- [FIXED] Fixed add diff note button not showing after deleting a comment.
- [FIXED] Fix broken svg in jobs dropdown for success status.
- [FIXED] Fix buttons with different height in merge request widget.
- [FIXED] Removes disabled state from dashboard project button.
- [FIXED] Better align fallback image emojis.
- [FIXED] Remove focus styles from dropdown empty links.
- [FIXED] Fix inconsistent spacing for edit buttons on issues and merge request page.
- [FIXED] Fix edit merge request and issues button inconsistent letter casing.
- [FIXED] Improve Import/Export memory usage.
- [FIXED] Fix Import/Export issue to do with fork merge requests.
- [FIXED] Fix invite by email address duplication.
- [FIXED] Adds tooltip to the branch name and improves performance.
- [FIXED] Disable GitLab Project Import Button if source disabled.
- [FIXED] Migrate issues authored by deleted user to the Ghost user.
- [FIXED] Fix new navigation wrapping and causing height to grow.
- [FIXED] Normalize styles for empty state combo button.
- [FIXED] Fix external link to Composer website.
- [FIXED] Prevents jobs dropdown from closing in pipeline graph.
- [FIXED] Include the `is_admin` field in the `GET /users/:id` API when current user is an admin.
- [FIXED] Fix breadcrumbs container in issue boards.
- [FIXED] Fix project feature being deleted when updating project with invalid visibility level.
- [FIXED] Truncate milestone title if sidebar is collapsed.
- [FIXED] Prevents rendering empty badges when request fails.
- [FIXED] Fixes margins on the top buttons of the pipeline table.
- [FIXED] Bump jira-ruby gem to 1.4.1 to fix issues with HTTP proxies.
- [FIXED] Eliminate N+1 queries in loading discussions.json endpoint.
- [FIXED] Eliminate N+1 queries referencing issues.
- [FIXED] Remove unnecessary loading of discussions in `IssuesController#show`.
- [FIXED] Fix errors thrown in merge request widget with external CI service/integration.
- [FIXED] Do not show the Auto DevOps banner when the project has a .gitlab-ci.yml on master.
- [FIXED] Reword job to pipeline to reflect what the graphs are really about.
- [FIXED] Sort templates in the dropdown.
- [FIXED] Fix Auto DevOps banner to be shown on empty projects.
- [FIXED] Resolve Image onion skin + swipe does not work anymore.
- [FIXED] Fix mini graph pipeline breakin in merge request view.
- [FIXED] Fixed merge request changes bar jumping.
- [FIXED] Improve migrations using triggers.
- [FIXED] Fix ConvDev Index nav item and Monitoring submenu regression.
- [FIXED] disabling notifications globally now properly turns off group/project added
  emails !13325
- [DEPRECATED] Deprecate custom SSH client configuration for the git user. !13930
- [CHANGED] allow all users to delete their account. !13636 (Jacopo Beschi @jacopo-beschi)
- [CHANGED] Use full path of project's avatar in webhooks. !13649 (Vitaliy @blackst0ne Klachkov)
- [CHANGED] Add filtered search to group merge requests dashboard. !13688 (Hiroyuki Sato)
- [CHANGED] Fire hooks asynchronously when creating a new job to improve performance. !13734
- [CHANGED] Improve performance for AutocompleteController#users.json. !13754 (Hiroyuki Sato)
- [CHANGED] Update the GPG verification semantics: A GPG signature must additionally match the committer in order to be verified. !13771 (Alexis Reigel)
- [CHANGED] Support a multi-word fuzzy seach issues/merge requests on search bar. !13780 (Hiroyuki Sato)
- [CHANGED] Default LDAP config "verify_certificates" to true for security. !13915
- [CHANGED] "Share with group lock" now applies to subgroups, but owner can override setting on subgroups. !13944
- [CHANGED] Make Gitaly PostUploadPack mandatory. !13953
- [CHANGED] Remove project select dropdown from breadcrumb. !14010
- [CHANGED] Redesign project feature permissions settings. !14062
- [CHANGED] Document version Group Milestones API introduced.
- [CHANGED] Finish migration to the new events setup.
- [CHANGED] restyling of OAuth authorization confirmation. (Jacopo Beschi @jacopo-beschi)
- [CHANGED] Added support for specific labels and colors.
- [CHANGED] Move "Move issue" controls to right-sidebar.
- [CHANGED] Remove pages settings when not available.
- [CHANGED] Allow all AutoDevOps banners to be turned off.
- [CHANGED] Update Rails project template to use Postgresql by default.
- [CHANGED] Added support the multiple time series for prometheus monitoring.
- [ADDED] API: Respect the "If-Unmodified-Since" header when delting a resource. !9621 (Robert Schilling)
- [ADDED] Protected runners. !13194
- [ADDED] Add support for copying permalink to notes via more actions dropdown. !13299
- [ADDED] Add API support for wiki pages. !13372 (Vitaliy @blackst0ne Klachkov)
- [ADDED] Add a `Last 7 days` option for Cycle Analytics view. !13443 (Mehdi Lahmam (@mehlah))
- [ADDED] inherits milestone and labels when a merge request is created from issue. !13461 (haseebeqx)
- [ADDED] Add 'from commit' information to cherry-picked commits. !13475 (Saverio Miroddi)
- [ADDED] Add an option to list only archived projects. !13492 (Mehdi Lahmam (@mehlah))
- [ADDED] Extend API: Pipeline Schedule Variable. !13653
- [ADDED] Add settings for minimum SSH key strength and allowed key type. !13712 (Cory Hinshaw)
- [ADDED] Add div id to the readme in the project overview. !13735 (Riccardo Padovani @rpadovani)
- [ADDED] Add CI/CD job predefined variables with user name and login. !13824
- [ADDED] API: Add GPG key management. !13828 (Robert Schilling)
- [ADDED] Add CI/CD active kubernetes job policy. !13849
- [ADDED] Add dropdown to Projects nav item. !13866
- [ADDED] Allow users and administrator to configure Auto-DevOps. !13923
- [ADDED] Implement `failure_reason` on `ci_builds`. !13937
- [ADDED] Add branch existence check to the APIv4 branches via HEAD request. !13979 (Vitaliy @blackst0ne Klachkov)
- [ADDED] Add quick submission on user settings page. !14007 (Vitaliy @blackst0ne Klachkov)
- [ADDED] Add my_reaction_emoji param to /issues and /merge_requests API. !14016 (Hiroyuki Sato)
- [ADDED] Make it possible to download a single job artifact file using the API. !14027
- [ADDED] Add repository toggle for automatically resolving outdated diff discussions. !14053 (AshleyDumaine)
- [ADDED] Scripts to detect orphaned repositories. !14204
- [ADDED] Created callout for auto devops.
- [ADDED] Add option in preferences to change navigation theme color.
- [ADDED] Add JSON logger in `log/api_json.log` for Grape API endpoints.
- [ADDED] Add CI_PIPELINE_SOURCE variable on CI Jobs.
- [ADDED] Changed message and title on the 404 page. (Branka Martinovic)
- [ADDED] Handle if Auto DevOps domain is not set in project settings.
- [ADDED] Add collapsable sections for Pipeline Settings.
- [OTHER] Add badge for dependency status. !13588 (Markus Koller)
- [OTHER] Migration to remove pending delete projects with non-existing namespace. !13598
- [OTHER] Bump rouge to v2.2.0. !13633
- [OTHER] Fix repository equality check and avoid fetching ref if the commit is already available. This affects merge request creation performance. !13685
- [OTHER] Replace 'source/search_code.feature' spinach test with an rspec analog. !13697 (blackst0ne)
- [OTHER] Remove unwanted refs after importing a project. !13766
- [OTHER] Never wait for sidekiq jobs when creating projects. !13775
- [OTHER] Gitaly feature toggles are on by default in development. !13802
- [OTHER] Remove `is_` prefix from predicate method names. !13810 (Maxim Rydkin)
- [OTHER] Update 'Using Docker images' documentation. !13848
- [OTHER] Update gpg documentation with gpg2. !13851 (M M Arif)
- [OTHER] Replace 'project/star.feature' spinach test with an rspec analog. !13855 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Replace 'project/user_lookup.feature' spinach test with an rspec analog. !13863 (Vitaliy @blackst0ne Klachkov)
- [OTHER] Bump rouge to v2.2.1. !13887
- [OTHER] Add documentation for PlantUML in reStructuredText. !13900 (Markus Koller)
- [OTHER] Decrease ABC threshold to 55.25. !13904 (Maxim Rydkin)
- [OTHER] Decrease Cyclomatic Complexity threshold to 14. !13972 (Maxim Rydkin)
- [OTHER] Update documentation for confidential issue. !14117
- [OTHER] Remove redundant WHERE from event queries.
- [OTHER] Memoize the latest builds of a pipeline on a project's homepage.
- [OTHER] Re-use issue/MR counts for the pagination system.
- [OTHER] Memoize pipelines for project download buttons.
- [OTHER] Reorganize indexes for the "deployments" table.
- [OTHER] Improves markdown rendering performance for commit lists.
- [OTHER] Only update the sidebar count caches when needed.
- [OTHER] Improves performance of vue code by using vue files and moving svg out of data function in pipeline schedule callout.
- [OTHER] Rework how recent push events are retrieved.
- [OTHER] Restyle dropdown menus to make them look consistent.
- [OTHER] Upgrade grape to 1.0.
- [OTHER] Add usage data for Auto DevOps.
- [OTHER] Cache the number of open issues and merge requests.
- [OTHER] Constrain environment deployments to project IDs.
- [OTHER] Eager load namespace owners for project dashboards.
- [OTHER] Add description template examples to documentation.
- [OTHER] Disallow NULL values for environments.project_id.
- Add my reaction filter to search bar. !12962 (Hiroyuki Sato)
- Generalize profile updates from providers. !12968 (Alexandros Keramidas)
- Validate PO-files in static analysis. !13000
- First-time contributor badge. !13143 (Micaël Bergeron <micaelbergeron@gmail.com>)
- Add option to disable project export on instance. !13211 (Robin Bobbitt)
- Hashed Storage support for Repositories (EXPERIMENTAL). !13246
- Added tests for commits API unauthenticated user and public/private project. !13287 (Jacopo Beschi @jacopo-beschi)
- Fix CI_PROJECT_PATH_SLUG slugify. !13350 (Ivan Chernov)
- Add checks for branch existence before changing HEAD. !13359 (Vitaliy @blackst0ne Klachkov)
- Fix the alignment of line numbers to lines of code in code viewer. !13403 (Trevor Flynn)
- Allow users to move issues to other projects using a / command. !13436 (Manolis Mavrofidis)
- Bumps omniauth-ldap gem version to 2.0.4. !13465
- Implement the Gitaly RefService::RefExists endpoint. !13528 (Andrew Newdigate)
- Changed all font-weight values to 400 and 600 and introduced 2 variables to manage them.
- Simplify checking if objects exist code in new issaubles workers.
- Present enqueued merge jobs as Merging as well.
- Don't escape html entities in InlineDiffMarkdownMarker.
- Move ConvDev Index location to after Cohorts.
- Added type to CHANGELOG entries. (Jacopo Beschi @jacopo-beschi)
- [BUGIFX] Improves subgroup creation permissions. !13418

## 9.5.10 (2017-11-08)

- [SECURITY] Add SSRF protections for hostnames that will never resolve but will still connect to localhost
- [SECURITY] Include X-Content-Type-Options (XCTO) header into API responses

## 9.5.9 (2017-10-16)

- [SECURITY] Move project repositories between namespaces when renaming users.
- [SECURITY] Prevent an open redirect on project pages.
- [SECURITY] Prevent a persistent XSS in user-provided markup.
- [FIXED] Allow using newlines in pipeline email service recipients. !14250
- Escape user name in filtered search bar.

## 9.5.8 (2017-10-04)

- [FIXED] Fixed fork button being disabled for users who can fork to a group.

## 9.5.7 (2017-10-03)

- Fix gitlab rake:import:repos task.

## 9.5.6 (2017-09-29)

- [FIXED] Fix MR ready to merge buttons/controls at mobile breakpoint. !14242
- [FIXED] Fix errors thrown in merge request widget with external CI service/integration.
- [FIXED] Update x/x discussions resolved checkmark icon to be green when all discussions resolved.
- [FIXED] Fix 500 error on merged merge requests when GitLab is restored from a backup.

## 9.5.5 (2017-09-18)

- [SECURITY] Upgrade mail and nokogiri gems due to security issues. !13662 (Markus Koller)
- [FIXED] Fix division by zero error in blame age mapping. !13803 (Jeff Stubler)
- [FIXED] Fix problems sanitizing URLs with empty passwords. !14083
- [FIXED] Fix a wrong `X-Gitlab-Event` header when testing webhooks. !14108
- [FIXED] Fixes the 500 errors caused by a race condition in GPG's tmp directory handling. !14194 (Alexis Reigel)
- [FIXED] Fix Pipeline Triggers to show triggered label and predefined variables (e.g. CI_PIPELINE_TRIGGERED). !14244
- [FIXED] Fix project feature being deleted when updating project with invalid visibility level.
- [FIXED] Fix new navigation wrapping and causing height to grow.
- [FIXED] Fix buttons with different height in merge request widget.
- [FIXED] Normalize styles for empty state combo button.
- [FIXED] Fix broken svg in jobs dropdown for success status.
- [FIXED] Improve migrations using triggers.
- [FIXED] Disable GitLab Project Import Button if source disabled.
- [CHANGED] Update the GPG verification semantics: A GPG signature must additionally match the committer in order to be verified. !13771 (Alexis Reigel)
- [OTHER] Fix repository equality check and avoid fetching ref if the commit is already available. This affects merge request creation performance. !13685
- [OTHER] Update documentation for confidential issue. !14117

## 9.5.4 (2017-09-06)

- [SECURITY] Upgrade mail and nokogiri gems due to security issues. !13662 (Markus Koller)
- [SECURITY] Prevent a persistent XSS in the commit author block.
- Fix XSS issue in go-get handling.
- Resolve CSRF token leakage via pathname manipulation on environments page.
- Fixes race condition in project uploads.
- Disallow arbitrary properties in `th` and `td` `style` attributes.
- Disallow the `name` attribute on all user-provided markup.

## 9.5.3 (2017-09-03)

- [SECURITY] Filter additional secrets from Rails logs.
- [FIXED] Make username update fail if the namespace update fails. !13642
- [FIXED] Fix failure when issue is authored by a deleted user. !13807
- [FIXED] Reverts changes made to signin_enabled. !13956
- [FIXED] Fix Merge when pipeline succeeds button dropdown caret icon horizontal alignment.
- [FIXED] Fixed diff changes bar buttons from showing/hiding whilst scrolling.
- [FIXED] Fix events error importing GitLab projects.
- [FIXED] Fix pipeline trigger via API fails with 500 Internal Server Error in 9.5.
- [FIXED] Fixed fly-out nav flashing in & out.
- [FIXED] Remove closing external issues by reference error.
- [FIXED] Re-allow appearances.description_html to be NULL.
- [CHANGED] Update and fix resolvable note icons for easier recognition.
- [OTHER] Eager load head pipeline projects for MRs index.
- [OTHER] Instrument MergeRequest#fetch_ref.
- [OTHER] Instrument MergeRequest#ensure_ref_fetched.

## 9.5.2 (2017-08-28)

- [FIXED] Fix signing in using LDAP when attribute mapping uses simple strings instead of arrays.
- [FIXED] Show un-highlighted text diffs when we do not have references to the correct blobs.
- [FIXED] Fix display of push events for removed refs.
- [FIXED] Testing of some integrations were broken due to missing ServiceHook record.
- [FIXED] Fire system hooks when a user is created via LDAP.
- [FIXED] Fix new project form not resetting the template value.

## 9.5.1 (2017-08-23)

- [FIXED] Fix merge request pipeline status when pipeline has errors. !13664
- [FIXED] Commit rows would occasionally render with the wrong language.
- [FIXED] Fix caching of future broadcast messages.
- [FIXED] Only require Sidekiq throttling library when enabled, to reduce cache misses.
- Raise Housekeeping timeout to 24 hours. !13719

## 9.5.0 (2017-08-22)

- [FIXED] Fix timeouts when creating projects in groups with many members. !13508
- [FIXED] Improve API pagination headers when no record found. !13629 (Jordan Patterson)
- [FIXED] Fix deleting GitLab Pages files when a project is removed. !13631
- [FIXED] Fix commit list not loading the correct page when scrolling.
- [OTHER] Cache the number of forks of a project. !13535
- GPG signed commits integration. !9546 (Alexis Reigel)
- Alert the user if a Wiki page changed while they were editing it in order to prevent overwriting changes. !9707 (Hiroyuki Sato)
- Add custom linter for inline JavaScript to haml_lint. !9742 (winniehell)
- Add /shrug and /tableflip commands. !10068 (Alex Ives)
- Allow wiki pages to be renamed in the UI. !10069 (wendy0402)
- Insert user name directly without encoding. !10085 (Nathan Neulinger <nneul@neulinger.org>)
- Avoid plucking Todo ids in TodoService. !10845
- Handle errors while a project is being deleted asynchronously. !11088
- Decrease ABC threshold to 56.96. !11227 (Maxim Rydkin)
- Remove Mattermost team when deleting a group. !11362
- Block access to failing repository storage. !11449
- Add coordinator url to admin area runner page. !11603
- Allow testing any events for project hooks and system hooks. !11728 (Alexander Randa (@randaalex))
- Disallow running the pipeline if ref is protected and user cannot merge the branch or create the tag. !11910
- Remove project_key from the Jira configuration. !12050
- Add CSRF token verification to API. !12154 (Vitaliy @blackst0ne Klachkov)
- Fixes needed when GitLab sign-in is not enabled. !12491 (Robin Bobbitt)
- Lazy load images for better Frontend performance. !12503
- Replaces dashboard/event_filters.feature spinach with rspec. !12651 (Alexander Randa (@randaalex))
- Toggle import description with import_sources_enabled. !12691 (Brianna Kicia)
- Bump scss-lint to 0.54.0. !12733 (Takuya Noguchi)
- Enable SpaceAfterComma in scss-lint. !12734 (Takuya Noguchi)
- Remove CSS for nprogress removed. !12737 (Takuya Noguchi)
- Enable UnnecessaryParentReference in scss-lint. !12738 (Takuya Noguchi)
- Extract "@request.env[devise.mapping] = Devise.mappings[:user]" to a test helper. !12742 (Jacopo Beschi @jacopo-beschi)
- Enable ImportPath in scss-lint. !12749 (Takuya Noguchi)
- Enable PropertySpelling in scss-lint. !12752 (Takuya Noguchi)
- Add API for protected branches to allow for wildcard matching and no access restrictions. !12756 (Eric Yu)
- refactor initializations in dropzone_input.js. !12768 (Brandon Everett)
- Improve CSS for global nav dropdown UI. !12772 (Takuya Noguchi)
- Remove public/ci/favicon.ico. !12803 (Takuya Noguchi)
- Enable DeclarationOrder in scss-lint. !12805 (Takuya Noguchi)
- Increase width of dropdown menus automatically. !12809 (Thomas Wucher)
- Enable BangFormat in scss-lint [ci skip]. !12815 (Takuya Noguchi)
- Added /duplicate quick action to close a duplicate issue. !12845 (Ryan Scott)
- Make all application-settings accessible through the API. !12851
- Remove Inactive Personal Access Tokens list from Access Tokens page. !12866
- Replaces dashboard/dashboard.feature spinach with rspec. !12876 (Alexander Randa (@randaalex))
- Reduce memory usage of the GitHub importer. !12886
- Bump fog-core to 1.44.3 and fog providers' plugins to latest. !12897 (Takuya Noguchi)
- Use only CSS to truncate commit message in blame. !12900 (Takuya Noguchi)
- Protect manual actions against protected tag too. !12908
- Allow to configure automatic retry of a failed CI/CD job. !12909
- Remove help message about prioritized labels for non-members. !12912 (Takuya Noguchi)
- Add link to doc/api/ci/lint.md. !12914 (Takuya Noguchi)
- Add RequestCache which makes caching with RequestStore easier. !12920
- Free up some top level words, reject top level groups named like files in the public folder. !12932
- Extend API for Group Secret Variable. !12936
- Hide description about protected branches to non-member. !12945 (Takuya Noguchi)
- Support custom directory in gitlab:backup:create task. !12984 (Markus Koller)
- Raise guessed encoding confidence threshold to 50. !12990
- Add author_id & assignee_id param to /issues API. !13004
- Fix today day highlight in calendar. !13048
- Prevent LDAP login callback from being called with a GET request. !13059
- Add top-level merge_requests API endpoint. !13060
- Handle maximum pages artifacts size correctly. !13072
- Enable gitaly_post_upload_pack by default. !13078
- Add Prometheus metrics exporter to Sidekiq. !13082
- Fix improperly skipped backups of wikis. !13096
- Projects can be created from templates. !13108
- Fix the /projects/:id/repository/branches endpoint to handle dots in the branch name when the project full path contains a `/`. !13115
- Fix project logos that are not centered vertically on list pages. !13124 (Florian Lemaitre)
- Derive project path from import URL. !13131
- Fix deletion of deploy keys linked to other projects. !13162
- repository archive download url now ends with selected file extension. !13178 (haseebeqx)
- Show auto-generated avatars for Groups without avatars. !13188
- Allow any logged in users to read_users_list even if it's restricted. !13201
- Unlock stuck merge request and set the proper state. !13207
- Fix timezone inconsistencies in user contribution graph. !13208
- Fix Issue board when using Ruby 2.4. !13220
- Don't rename namespace called system when upgrading from 9.1.x to 9.5. !13228
- Fix encoding error for WebHook logging. !13230 (Alexander Randa (@randaalex))
- Uniquify reserved word usernames on OAuth user creation. !13244 (Robin Bobbitt)
- Expose target_iid in Events API. !13247 (sue445)
- Add star for action scope, in order to delete image from registry. !13248 (jean)
- Make Delete Merged Branches handle wildcard protected branches correctly. !13251
- Fix an order of operations for CI connection error message in merge request widget. !13252
- Don't send rejection mails for all auto-generated mails. !13254
- Expose noteable_iid in Note. !13265 (sue445)
- Fix pipeline_schedules pages when active schedule has an abnormal state. !13286
- Move some code from services to workers in order to improve performance. !13326
- Fix destroy of case-insensitive conflicting redirects. !13357
- Fix the /projects/:id/repository/tags endpoint to handle dots in the tag name when the project full path contains a `/`. !13368
- Fix the /projects/:id/repository/commits endpoint to handle dots in the ref name when the project full path contains a `/`. !13370
- Project pending delete no longer return 500 error in admins projects view. !13389
- Use full path of user's avatar in webhooks. !13401 (Vitaliy @blackst0ne Klachkov)
- Make GPGME temporary directory handling thread safe. !13481 (Alexis Reigel)
- Add support for kube_namespace in Metrics queries. !16169
- Fix bar chart does not display label at 0 hour. !35136 (Jason Dai)
- Use project_ref_path to create the link to a branch to fix links that 404.
- Declare related resources into V4 API entities.
- Add Slack and JIRA services counts to Usage Data.
- Prevent web hook and project service background jobs from going to the dead jobs queue.
- Display specific error message when JIRA test fails.
- clean up merge request widget UI.
- Associate Issues tab only with internal issues tracker.
- Remove events column from notification settings table.
- Clarifies and rearranges the input variables on the kubernetes integration page and adjusts the docs slightly to meet the same order.
- Respect blockquote line breaks in markdown.
- Update confidential issue UI - add confidential visibility and settings to sidebar.
- Add icons to contextual sidebars.
- Make contextual sidebar collapsible.
- Update Pipeline's badge count in Merge Request and Commits view to match real-time content.
- Added link to the MR widget that directs to the monitoring dashboard.
- Use jQuery to control scroll behavior in job log for cross browser consistency.
- move edit comment button outside of dropdown.
- Updates vue resource and code according to breaking changes.
- Add GitHub imported projects count to usage data.
- Rename about to overview for group and project page.
- Prevent disabled pagination button to be clicked.
- Remove coffee-rails gem. (Takuya Noguchi)
- Remove net-ssh gem. (Takuya Noguchi)
- Bump rubocop to 0.49.1 and rubocop-rspec to 1.15.1. (Takuya Noguchi)
- improve file upload/replace experience.
- allow closing Cycle Analytics intro box in firefox.
- Fix label creation from new list for subgroup projects.
- fix transient js error in rspec tests.
- fix jump to next discussion button.
- Fix translations for Star/Unstar in JS file.
- Improve mobile sidebar.
- Rename Pipelines tab to CI / CD in new navigation.
- Fix display of new diff comments after changing b between diff views.
- Store & use ConvDev percentages returned by the Version app.
- Fixes new issue button for failed job returning 404.
- Align OR separator to center in new project page.
- Add filtered search to group issue dashboard.
- Cache Appearance instances in Redis.
- Fixed breadcrumbs title aggressively collapsing.
- Better caching and indexing of broadcast messages.
- Moved diff changed files into a dropdown.
- Improve performance of large (initial) push into default branch.
- Improve performance of checking for projects on the projects dashboard.
- Eager load project creators for project dashboards.
- Modify if condition to be more readable.
- Fix links to group milestones from issue and merge request sidebar.
- Remove hidden symlinks from project import files.
- Fixed sign-in restrictions buttons not toggling active state.
- Fix replying to commit comments on merge requests created from forks.
- Support Markdown references, autocomplete, and quick actions for group milestones.
- Cache recent projects for group-level new resource creation.
- Fix API responses when dealing with txt files.
- Fix project milestones import when projects belongs to a group.
- Fix Mattermost integration.
- Memoize the number of personal projects a user has to reduce COUNT queries.
- Merge issuable "reopened" state into "opened".
- Migrate events into a new format to reduce the storage necessary and improve performance.
- MR branch link now links to tree instead of commits.
- Use Prev/Next pagination for exploring projects.
- Pass before_script and script as-is preserving arrays.
- Change project FK migration to skip existing FKs.
- Remove redundant query when retrieving the most recent push of a user.
- Re-organise "issues" indexes for faster ordering.
- Disallow Git URLs that include a username or hostname beginning with a non-alphanumeric character.
- Fix search box losing focus when typing.
- Add structured logging for Rails processes.
- Skip oAuth authorization for trusted applications.
- Use a specialized class for querying events to improve performance.
- Update build badges to be pipeline badges and display passing instead of success.

## 9.4.7 (2017-10-16)

- [SECURITY] Upgrade mail and nokogiri gems due to security issues. !13662 (Markus Koller)
- [SECURITY] Move project repositories between namespaces when renaming users.
- [SECURITY] Prevent an open redirect on project pages.
- [SECURITY] Prevent a persistent XSS in user-provided markup.
- [FIXED] Allow using newlines in pipeline email service recipients. !14250
- Escape user name in filtered search bar.

## 9.4.6 (2017-09-06)

- [SECURITY] Upgrade mail and nokogiri gems due to security issues. !13662 (Markus Koller)
- [SECURITY] Prevent a persistent XSS in the commit author block.
- Fix XSS issue in go-get handling.
- Remove hidden symlinks from project import files.
- Fixes race condition in project uploads.
- Disallow Git URLs that include a username or hostname beginning with a non-alphanumeric character.
- Disallow arbitrary properties in `th` and `td` `style` attributes.
- Resolve CSRF token leakage via pathname manipulation on environments page.
- Disallow the `name` attribute on all user-provided markup.

## 9.4.5 (2017-08-14)

- Fix deletion of deploy keys linked to other projects. !13162
- Allow any logged in users to read_users_list even if it's restricted. !13201
- Make Delete Merged Branches handle wildcard protected branches correctly. !13251
- Fix an order of operations for CI connection error message in merge request widget. !13252
- Fix pipeline_schedules pages when active schedule has an abnormal state. !13286
- Add missing validation error for username change with container registry tags. !13356
- Fix destroy of case-insensitive conflicting redirects. !13357
- Project pending delete no longer return 500 error in admins projects view. !13389
- Fix search box losing focus when typing.
- Use jQuery to control scroll behavior in job log for cross browser consistency.
- Use project_ref_path to create the link to a branch to fix links that 404.
- improve file upload/replace experience.
- fix jump to next discussion button.
- Fixes new issue button for failed job returning 404.
- Fix links to group milestones from issue and merge request sidebar.
- Fixed sign-in restrictions buttons not toggling active state.
- Fix Mattermost integration.
- Change project FK migration to skip existing FKs.

## 9.4.4 (2017-08-09)

- Remove hidden symlinks from project import files.
- Disallow Git URLs that include a username or hostname beginning with a non-alphanumeric character.

## 9.4.3 (2017-07-31)

- Fix Prometheus client PID reuse bug. !13130
- Improve deploy environment chatops slash command. !13150
- Fix asynchronous javascript paths when GitLab is installed under a relative URL. !13165
- Fix LDAP authentication to Git repository or container registry.
- Fixed new navigation breadcrumb title on help pages.
- Ensure filesystem metrics test files are deleted.
- Properly affixes nav bar in job view in microsoft edge.

## 9.4.2 (2017-07-28)

- Fix job merge request link to a forked source project. !12965
- Improve redirect route query performance. !13062
- Allow admin to read_users_list even if it's restricted. !13066
- Fixes 500 error caused by pending delete projects in admin dashboard. !13067
- Add instrumentation to MarkupHelper#link_to_gfm. !13069
- Pending delete projects should not show in deploy keys. !13088
- Fix sizing of custom header logo in new navigation.
- Fix crash on /help/ui.
- Fix creating merge request diffs when diff contains bytes that are invalid in UTF-8.
- fix vertical alignment of New Project button.
- Add LDAP SSL certificate verification option.
- Fix vertical alignment in firefox and safari for pipeline mini graph.

## 9.4.1 (2017-07-25)

- Fix pipeline_schedules pages throwing error 500 (when ref is empty). !12983
- Fix editing project with container images present. !13028
- Fix some invalid entries in PO files. !13032
- Fix cross site request protection when logging in as a regular user when LDAP is enabled. !13049
- Fix bug causing metrics files to be truncated. !35420
- Fix anonymous access to public projects in groups with pending invites.
- Fixed issue boards sidebar close icon size.
- Fixed duplicate new milestone buttons when new navigation is turned on.
- Fix margins in the mini graph for pipeline in commits box.

## 9.4.0 (2017-07-22)

- Add blame view age mapping. !7198 (Jeff Stubler)
- Add support for image and services configuration in .gitlab-ci.yml. !8578
- Fix an email parsing bug where brackets would be inserted in emails from some Outlook clients. !9045 (jneen)
- Use fa-chevron-down on dropdown arrows for consistency. !9659 (TM Lee)
- Update the devise mail templates to match the design of the pipeline emails. !10483 (Alexis Reigel)
- Handle renamed submodules in repository browser. !10798 (David Turner)
- Display all current broadcast messages, not just the last one. !11113 (rickettm)
- Fix CI/CD status in case there are only allowed to failed jobs in the pipeline. !11166
- Omit trailing / leading hyphens in CI_COMMIT_REF_SLUG variable to make it usable as a hostname. !11218 (Stefan Hanreich)
- Moved "Members in a project" menu entry and path locations. !11560
- Additional Prometheus metrics support. !11712
- Rename all reserved paths that could have been created. !11713
- Move uploads from `uploads/system` to `uploads/-/system` to free up `system` as a group name. !11713
- Fix offline runner detection. !11751 (Alessio Caiazza)
- Use authorize_update_pipeline_schedule in PipelineSchedulesController. !11846
- Rollback project repo move if there is an error in Projects::TransferService. !11877
- Help landing page customizations. !11878 (Robin Bobbitt)
- Fixes "sign in / Register" active state underline misalignment. !11890 (Frank Sierra)
- Honor the "Remember me" parameter for OAuth-based login. !11963
- Instruct user to use personal access token for Git over HTTP. !11986 (Robin Bobbitt)
- Accept image for avatar in project API. !11988 (Ivan Chernov)
- Supplement Simplified Chinese translation of Project Page & Repository Page. !11994 (Huang Tao)
- Supplement Traditional Chinese in Hong Kong translation of Project Page & Repository Page. !11995 (Huang Tao)
- Make the revision on the `/help` page clickable. !12016
- Display issue state in issue links section of merge request widget. !12021
- Enable support for webpack code-splitting by dynamically setting publicPath at runtime. !12032
- Replace PhantomJS with headless Chrome for karma test suite. !12036
- Prevent description change notes when toggling tasks. !12057 (Jared Deckard <jared.deckard@gmail.com>)
- Update QA Dockerfile to lock Chrome browser version. !12071
- Fix FIDO U2F for Opera browser. !12082 (Jakub Kramarz and Jonas Kalderstam)
- Supplement Bulgarian translation of Project Page & Repository Page. !12083 (Lyubomir Vasilev)
- Removes deleted_at and pending_delete occurrences in Project related queries. !12091
- Provide hint to create a personal access token for Git over HTTP. !12105 (Robin Bobbitt)
- Display own user id in account settings page. !12141 (Riccardo Padovani)
- Accept image for avatar in user API. !12143 (Ivan Chernov)
- Disable fork button on project limit. !12145 (Ivan Chernov)
- Added "created_after" and "created_before" params to issuables. !12151 (Kyle Bishop @kybishop)
- Supplement Portuguese Brazil translation of Project Page & Repository Page. !12156 (Huang Tao)
- Add review apps to usage metrics. !12185
- Adding French translations. !12200 (Erwan "Dremor" Georget)
- Ensures default user limits when external user is unchecked. !12218
- Provide KUBECONFIG from KubernetesService for runners. !12223
- Filter archived project in API v3 only if param present. !12245 (Ivan Chernov)
- Add explicit message when no runners on admin. !12266 (Takuya Noguchi)
- Split pipelines as internal and external in the usage data. !12277
- Fix API Scoping. !12300
- Remove registry image delete button if user cant delete it. !12317 (Ivan Chernov)
- Allow the feature flags to be enabled/disabled with more granularity. !12357
- Allow to enable the performance bar per user or Feature group. !12362
- Rename duplicated variables with the same key for projects. Add environment_scope column to variables and add unique constraint to make sure that no variables could be created with the same key within a project. !12363
- Add variables to pipelines schedules. !12372
- Add User#full_private_access? to check if user has access to all private groups & projects. !12373
- Change milestone endpoint for groups. !12374 (Takuya Noguchi)
- Improve performance of the pipeline charts page. !12378
- Add option to run Gitaly on a remote server. !12381
- #20628 Enable implicit grant in GitLab as OAuth Provider. !12384 (Mateusz Pytel)
- Replace 'snippets/snippets.feature' spinach with rspec. !12385 (Alexander Randa @randaalex)
- Add Simplified Chinese translations of Commits Page. !12405 (Huang Tao)
- Add Traditional Chinese in HongKong translations of Commits Page. !12406 (Huang Tao)
- Add Traditional Chinese in Taiwan translations of Commits Page. !12407 (Huang Tao)
- Add Portuguese Brazil translations of Commits Page. !12408 (Huang Tao)
- Add French translations of Commits Page. !12409 (Huang Tao)
- Add Esperanto translations of Commits Page. !12410 (Huang Tao)
- Add Bulgarian translations of Commits Page. !12411 (Huang Tao)
- Remove bin/ci/upgrade.rb as not working all. !12414 (Takuya Noguchi)
- Store merge request ref_fetched status in the database. !12424
- Replace 'dashboard/merge_requests' spinach with rspec. !12440 (Alexander Randa (@randaalex))
- Add Esperanto translations for Cycle Analytics, Project, and Repository pages. !12442 (Huang Tao)
- Allow unauthenticated access to the /api/v4/users API. !12445
- Drop GFM support for the title of Milestone/MergeRequest in template. !12451 (Takuya Noguchi)
- Replace 'dashboard/todos' spinach with rspec. !12453 (Alexander Randa (@randaalex))
- Cache open issue and merge request counts for project tabs to speed up project pages. !12457
- Introduce cache policies for CI jobs. !12483
- Improve support for external issue references. !12485
- Fix errors caused by attempts to report already blocked or deleted users. !12502 (Horacio Bertorello)
- Allow customize CI config path. !12509 (Keith Pope)
- Supplement Traditional Chinese in Taiwan translation of Project Page & Repository Page. !12514 (Huang Tao)
- Closes any open Autocomplete of the markdown editor when the form is closed. !12521
- Inserts exact matches of name, username and email to the top of the search list. !12525
- Use smaller min-width for dropdown-menu-nav only on mobile. !12528 (Takuya Noguchi)
- Hide archived project labels from group issue tracker. !12547 (Horacio Bertorello)
- Replace 'dashboard/new-project.feature' spinach with rspec. !12550 (Alexander Randa (@randaalex))
- Remove group modal like remove project modal (requires typing + confirmation). !12569 (Diego Souza)
- Add Italian translation of Cycle Analytics Page & Project Page & Repository Page. !12578 (Huang Tao)
- Add Group secret variables. !12582
- Update jobs page output to have a scrollable page. !12587
- Add user projects API. !12596 (Ivan Chernov)
- Allow creation of files and directories with spaces through Web UI. !12608
- Improve members view on mobile. !12619
- Fixed the chart legend not being set correctly. !12628
- Add Italian translations of Commits Page. !12645 (Huang Tao)
- Allow admins to disable all restricted visibility levels. !12649
- Allow admins to retrieve user agent details for an issue or snippet. !12655
- Update welcome page UX for new users. !12662
- N+1 problems on milestone page. !12670 (Takuya Noguchi)
- Upgrade GitLab Workhorse to v2.3.0. !12676
- Remove option to disable Gitaly. !12677
- Improve the performance of the project list API. !12679
- Add creation time filters to user search API for admins. !12682
- Add Japanese translations for Cycle Analytics & Project pages & Repository pages & Commits pages & Pipeline Charts. !12693 (Huang Tao)
- Undo adding the /reassign quick action. !12701
- Fix dashboard labels dropdown. !12708
- Username and password are no longer stripped from import url on mirror update. !12725
- Add Russian translations for Cycle Analytics & Project pages & Repository pages & Commits pages & Pipeline Charts. !12743 (Huang Tao)
- Add Ukrainian translations for Cycle Analytics & Project pages & Repository pages & Commits pages & Pipeline Charts. !12744 (Huang Tao)
- Prevent bad data being added to application settings when Redis is unavailable. !12750
- Do not show pipeline schedule button for non-member. !12757 (Takuya Noguchi)
- Return `is_admin` attribute in the GET /user endpoint for admins. !12811
- Recover from renaming project that has container images. !12840
- Exact matches of username and email are now on top of the user search. !12868
- Use Ghost user for last_edited_by and merge_user when original user is deleted. !12933
- Fix docker tag reference routing constraints. !12961
- Optimize creation of commit API by using Repository#commit instead of Repository#commits.
- Speed up used languages calculation on charts page.
- Make loading new merge requests (those created after the 9.4 upgrade) faster.
- Ensure participants for issues, merge requests, etc. are calculated correctly when sending notifications.
- Handle nameless legacy jobs.
- Bump Faraday and dependent OAuth2 gem version to support no_proxy variable.
- Renders 404 if given project is not readable by the user on Todos dashboard.
- Render CI statuses with warnings in orange.
- Document the Delete Merged Branches functionality.
- Add wells to admin dashboard overview to fix spacing problems.
- Removes hover style for nodes that are either links or buttons in the pipeline graph.
- more visual contrast in pagination widget.
- Deprecate Healthcheck Access Token in favor of IP whitelist.
- Drop GFM support for issuable title on milestone for consistency and performance. (Takuya Noguchi)
- fix left & right padding on sidebar.
- Cleanup minor UX issues in the performance dashboard.
- Remove two columned layout from project member settings.
- Make font size of contextual sub menu items 14px.
- Fix vertical space in job details sidebar.
- Fix alignment of controls in mr issuable list.
- Add wip message to new navigation preference section.
- Add group members counting and plan related data on namespaces API.
- Fix spacing on runner buttons.
- Remove uploads/appearance symlink. A leftover from a previous migration.
- Change order of monospace fonts to fix bug on some linux distros.
- Limit commit & snippets comments width.
- Fixed dashboard milestone tabs not loading.
- Detect if file that appears to be text in the first 1024 bytes is actually binary afer loading all data.
- Fix inconsistent display of the "Browse files" button in the commit list.
- Implement diff viewers.
- Fix 'New merge request' button for users who don't have push access to canonical project.
- Fix issues with non-UTF8 filenames by always fixing the encoding of tree and blob paths.
- Show group name instead of path on group page.
- Don't check if MailRoom is running on Omnibus.
- Limit OpenGraph image size to 64x64.
- Don't show auxiliary blob viewer for README when there is no wiki.
- Strip trailing whitespace in relative submodule URL.
- Update /target_branch slash command description to be more consistent.
- Remove unnecessary top padding on group MR index.
- Added printing_merge_requst_link_enabled to the API. (David Turner <dturner@twosigma.com>)
- Re-enable realtime for environments table.
- Create responsive mobile view for pipelines table.
- Adds realtime feature to job show view header and sidebar info. Updates UX.
- Use color inputs for broadcast messages.
- Center dropdown for mini graph.
- Users can subscribe to group labels on the group labels page.
- Add issuable-list class to shared mr/issue lists to fix new responsive layout design.
- Rename "Slash commands" to "Quick actions" and deprecate "chat commands" in favor of "slash commands".
- Don't mark empty MRs as merged on push to the target branch.
- Improve issue rendering performance with lots of notes from other users.
- Fixed overflow on mobile screens for the slash commands.
- Fix an infinite loop when handling user-supplied regular expressions.
- Fixed sidebar not collapsing on merge requests in mobile screens.
- Speed up project removals by adding foreign keys with cascading deletes to various tables.
- Fix mobile view of files view buttons.
- Fixed dropdown filter input not focusing after transition.
- Fixed GFM references not being included when updating issues inline.
- Remove issues/merge requests drag n drop and sorting from milestone view.
- Add native group milestones.
- Fix API bug accepting wrong parameter to create merge request.
- Clean up UI of issuable lists and make more responsive.
- Improve the overall UX for the new monitoring dashboard.
- Fixed the y_label not setting correctly for each graph on the monitoring dashboard.
- Changed utilities imports from ~ to relative paths.
- Remove unused space in sidebar todo toggle when not signed in.
- Limit the width of the projects README text.
- Add a simple mode to merge request API.
- Make Project#ensure_repository force create a repo.
- Use uploads/system directory for personal snippets.
- Defer project destroys within a namespace in Groups::DestroyService#async_execute.
- Log rescued exceptions to Sentry.
- Remove remaining N+1 queries in merge requests API with emojis and labels.

## 9.3.11 (2017-09-06)

- [SECURITY] Upgrade mail and nokogiri gems due to security issues. !13662 (Markus Koller)
- [SECURITY] Prevent a persistent XSS in the commit author block.
- Improve support for external issue references. !12485
- Use uploads/system directory for personal snippets.
- Remove uploads/appearance symlink. A leftover from a previous migration.
- Fix XSS issue in go-get handling.
- Remove hidden symlinks from project import files.
- Fix an infinite loop when handling user-supplied regular expressions.
- Fixes race condition in project uploads.
- Fixes race condition in project uploads.
- Disallow Git URLs that include a username or hostname beginning with a non-alphanumeric character.
- Disallow arbitrary properties in `th` and `td` `style` attributes.
- Resolve CSRF token leakage via pathname manipulation on environments page.
- Disallow the `name` attribute on all user-provided markup.
- Renders 404 if given project is not readable by the user on Todos dashboard.

## 9.3.10 (2017-08-09)

- Remove hidden symlinks from project import files.
- Disallow Git URLs that include a username or hostname beginning with a non-alphanumeric character.

## 9.3.9 (2017-07-20)

- Fix an infinite loop when handling user-supplied regular expressions.

## 9.3.8 (2017-07-19)

- Improve support for external issue references. !12485
- Renders 404 if given project is not readable by the user on Todos dashboard.
- Use uploads/system directory for personal snippets.
- Remove uploads/appearance symlink. A leftover from a previous migration.

## 9.3.7 (2017-07-18)

- Prevent bad data being added to application settings when Redis is unavailable. !12750
- Return `is_admin` attribute in the GET /user endpoint for admins. !12811

## 9.3.6 (2017-07-12)

- Fix API Scoping. !12300
- Username and password are no longer stripped from import url on mirror update. !12725
- Fix issues with non-UTF8 filenames by always fixing the encoding of tree and blob paths.
- Fixed GFM references not being included when updating issues inline.

## 9.3.5 (2017-07-05)

- Remove "Remove from board" button from backlog and closed list. !12430
- Do not delete protected branches when deleting all merged branches. !12624
- Set default for Remove source branch to false.
- Prevent accidental deletion of protected MR source branch by repeating checks before actual deletion.
- Expires full_path cache after a repository is renamed/transferred.

## 9.3.4 (2017-07-03)

- Update gitlab-shell to 5.1.1 !12615

## 9.3.3 (2017-06-30)

- Fix head pipeline stored in merge request for external pipelines. !12478
- Bring back branches badge to main project page. !12548
- Fix diff of requirements.txt file by not matching newlines as part of package names.
- Perform housekeeping only when an import of a fresh project is completed.
- Fixed issue boards closed list not showing all closed issues.
- Fixed multi-line markdown tooltip buttons in issue edit form.

## 9.3.2 (2017-06-27)

- API: Fix optional arugments for POST :id/variables. !12474
- Bump premailer-rails gem to 1.9.7 and its dependencies to prevent network retrieval of assets.

## 9.3.1 (2017-06-26)

- Fix reversed breadcrumb order for nested groups. !12322
- Fix 500 when failing to create private group. !12394
- Fix linking to line number on side-by-side diff creating empty discussion box.
- Don't match tilde and exclamation mark as part of requirements.txt package name.
- Perform project housekeeping after importing projects.
- Fixed ctrl+enter not submit issue edit form.

## 9.3.0 (2017-06-22)

- Refactored gitlab:app:check into SystemCheck liberary and improve some checks. !9173
- Add an ability to cancel attaching file and redesign attaching files UI. !9431 (blackst0ne)
- Add Aliyun OSS as the backup storage provider. !9721 (Yuanfei Zhu)
- Add suport for find_local_branches GRPC from Gitaly. !10059
- Allow manual bypass of auto_sign_in_with_provider with a new param. !10187 (Maxime Besson)
- Redirect to user's keys index instead of user's index after a key is deleted in the admin. !10227 (Cyril Jouve)
- Changed Blame to Annotate in the UI to promote blameless culture. !10378 (Ilya Vassilevsky)
- Implement ability to update deploy keys. !10383 (Alexander Randa)
- Allow numeric values in gitlab-ci.yml. !10607 (blackst0ne)
- Add a feature test for Unicode trace. !10736 (dosuken123)
- Notes: Warning message should go away once resolved. !10823 (Jacopo Beschi @jacopo-beschi)
- Project authorizations are calculated much faster when using PostgreSQL, and nested groups support for MySQL has been removed
. !10885
- Fix long urls in the title of commit. !10938 (Alexander Randa)
- Update gem sidekiq-cron from 0.4.4 to 0.6.0 and rufus-scheduler from 3.1.10 to 3.4.0. !10976 (dosuken123)
- Use relative paths for group/project/user avatars. !11001 (blackst0ne)
- Enable cancelling non-HEAD pending pipelines by default for all projects. !11023
- Implement web hook logging. !11027 (Alexander Randa)
- Add indices for auto_canceled_by_id for ci_pipelines and ci_builds on PostgreSQL. !11034
- Add post-deploy migration to clean up projects in `pending_delete` state. !11044
- Limit User's trackable attributes, like `current_sign_in_at`, to update at most once/hour. !11053
- Disallow multiple selections for Milestone dropdown. !11084
- Link to commit author user page from pipelines. !11100
- Fix the last coverage in trace log should be extracted. !11128 (dosuken123)
- Remove redirect for old issue url containing id instead of iid. !11135 (blackst0ne)
- Backported new SystemHook event: `repository_update`. !11140
- Keep input data after creating a tag that already exists. !11155
- Fix support for external CI services. !11176
- Translate backend for Project & Repository pages. !11183
- Fix LaTeX formatting for AsciiDoc wiki. !11212
- Add foreign key for pipeline schedule owner. !11233
- Print Go version in rake gitlab:env:info. !11241
- Include the blob content when printing a blob page. !11247
- Sync email address from specified omniauth provider. !11268 (Robin Bobbitt)
- Disable reference prefixes in notes for Snippets. !11278
- Rename build_events to job_events. !11287
- Add API support for pipeline schedule. !11307 (dosuken123)
- Use route.cache_key for project list cache key. !11325
- Make environment table realtime. !11333
- Cache npm modules between pipelines with yarn to speed up setup-test-env. !11343
- Allow GitLab instance to start when InfluxDB hostname cannot be resolved. !11356
- Add ConvDev Index page to admin area. !11377
- Fix Git-over-HTTP error statuses and improve error messages. !11398
- Renamed users 'Audit Log'' to 'Authentication Log'. !11400
- Style people in issuable search bar. !11402
- Change /builds in the URL to /-/jobs. Backward URLs were also added. !11407
- Update password field label while editing service settings. !11431
- Add an optional performance bar to view performance metrics for the current page. !11439
- Update task_list to version 2.0.0. !11525 (Jared Deckard <jared.deckard@gmail.com>)
- Avoid resource intensive login checks if password is not provided. !11537 (Horatiu Eugen Vlad)
- Allow numeric pages domain. !11550
- Exclude manual actions when checking if pipeline can be canceled. !11562
- Add server uptime to System Info page in admin dashboard. !11590 (Justin Boltz)
- Simplify testing and saving service integrations. !11599
- Fixed handling of the `can_push` attribute in the v3 deploy_keys api. !11607 (Richard Clamp)
- Improve user experience around slash commands in instant comments. !11612
- Show current user immediately in issuable filters. !11630
- Add extra context-sensitive functionality for the top right menu button. !11632
- Reorder Issue action buttons in order of usability. !11642
- Expose atom links with an RSS token instead of using the private token. !11647 (Alexis Reigel)
- Respect merge, instead of push, permissions for protected actions. !11648
- Job details page update real time. !11651
- Improve performance of ProjectFinder used in /projects API endpoint. !11666
- Remove redundant data-turbolink attributes from links. !11672 (blackst0ne)
- Minimum postgresql version is now 9.2. !11677
- Add protected variables which would only be passed to protected branches or protected tags. !11688
- Introduce optimistic locking support via optional parameter last_commit_sha on File Update API. !11694 (electroma)
- Add $CI_ENVIRONMENT_URL to predefined variables for pipelines. !11695
- Simplify project repository settings page. !11698
- Fix pipeline_schedules pages throwing error 500. !11706 (dosuken123)
- Add performance deltas between app deployments on Merge Request widget. !11730
- Add feature toggles and API endpoints for admins. !11747
- Replace 'starred_projects.feature' spinach test with an rspec analog. !11752 (blackst0ne)
- Introduce an Events API. !11755
- Display Shared Runner status in Admin Dashboard. !11783 (Ivan Chernov)
- Persist pipeline stages in the database. !11790
- Revert the feature that would include the current user's username in the HTTP clone URL. !11792
- Enable Gitaly by default in installations from source. !11796
- Use zopfli compression for frontend assets. !11798
- Add tag_list param to project api. !11799 (Ivan Chernov)
- Add changelog for improved Registry description. !11816
- Automatically adjust project settings to match changes in project visibility. !11831
- Add slugify project path to CI enviroment variables. !11838 (Ivan Chernov)
- Add all pipeline sources as special keywords to 'only' and 'except'. !11844 (Filip Krakowski)
- Allow pulling of container images using personal access tokens. !11845
- Expose import_status in Projects API. !11851 (Robin Bobbitt)
- Allow admins to delete users from the admin users page. !11852
- Allow users to be hard-deleted from the API. !11853
- Fix hard-deleting users when they have authored issues. !11855
- Fix missing optional path parameter in "Create project for user" API. !11868
- Allow users to be hard-deleted from the admin panel. !11874
- Add a Rake task to aid in rotating otp_key_base. !11881
- Fix submodule link to then project under subgroup. !11906
- Fix binary encoding error on MR diffs. !11929
- Limit non-administrators to adding 100 members at a time to groups and projects. !11940
- add bulgarian translation of cycle analytics page to I18N. !11958 (Lyubomir Vasilev)
- Make backup task to continue on corrupt repositories. !11962
- Fix incorrect ETag cache key when relative instance URL is used. !11964
- Reinstate is_admin flag in users api when authenticated user is an admin. !12211 (rickettm)
- Fix edit button for deploy keys available from other projects. !12301 (Alexander Randa)
- Fix passing CI_ENVIRONMENT_NAME and CI_ENVIRONMENT_SLUG for CI_ENVIRONMENT_URL. !12344
- Disable environment list refresh due to bug https://gitlab.com/gitlab-org/gitlab-ee/issues/2677. !12347
- Standardize timeline note margins across different viewport sizes. !12364
- Fix Ordered Task List Items. !31483 (Jared Deckard <jared.deckard@gmail.com>)
- Upgrade dependency to Go 1.8.3. !31943
- Add prometheus metrics on pipeline creation.
- Fix etag route not being a match for environments.
- Sort folder for environments.
- Support descriptions for snippets.
- Hide clone panel and file list when user is only a guest. (James Clark)
- Don’t create comment on JIRA if it already exists for the entity.
- Update Dashboard Groups UI with better support for subgroups.
- Confirm Project forking behaviour via the API.
- Add prometheus based metrics collection to gitlab webapp.
- Fix: Wiki is not searchable with Guest permissions.
- Center all empty states.
- Remove 'New issue' button when issues search returns no results.
- Add API URL to JIRA settings.
- animate adding issue to boards.
- Update session cookie key name to be unique to instance in development.
- Single click on filter to open filtered search dropdown.
- Makes header information of pipeline show page realtine.
- Creates a mediator for pipeline details vue in order to mount several vue apps with the same data.
- Scope issue/merge request recent searches to project.
- Increase individual diff collapse limit to 100 KB, and render limit to 200 KB.
- Fix Pipelines table empty state - only render empty state if we receive 0 pipelines.
- Make New environment empty state btn lowercase.
- Removes duplicate environment variable in documentation.
- Change links in issuable meta to black.
- Fix border-bottom for project activity tab.
- Adds new icon for CI skipped status.
- Create equal padding for emoji.
- Use briefcase icon for company in profile page.
- Remove overflow from comment form for confidential issues and vertically aligns confidential issue icon.
- Keep trailing newline when resolving conflicts by picking sides.
- Fix /unsubscribe slash command creating extra todos when you were already mentioned in an issue.
- Fix math rendering on blob pages.
- Allow group reporters to manage group labels.
- Use pre-wrap for commit messages to keep lists indented.
- Count badges depend on translucent color to better adjust to different background colors and permission badges now feature a pill shaped design similar to labels.
- Allow reporters to promote project labels to group labels.
- Enabled keyboard shortcuts on artifacts pages.
- Perform filtered search when state tab is changed.
- Remove duplication for sharing projects with groups in project settings.
- Change order of commits ahead and behind on divergence graph for branch list view.
- Creates CI Header component for Pipelines and Jobs details pages.
- Invalidate cache for issue and MR counters more granularly.
- disable blocked manual actions.
- Load tree readme asynchronously.
- Display extra info about files on .gitlab-ci.yml, .gitlab/route-map.yml and LICENSE blob pages.
- Fix replying to a commit discussion displayed in the context of an MR.
- Consistently use monospace font for commit SHAs and branch and tag names.
- Consistently display last push event widget.
- Don't copy empty elements that were not selected on purpose as GFM.
- Copy as GFM even when parts of other elements are selected.
- Autolink package names in Gemfile.
- Resolve N+1 query issue with discussions.
- Don't match email addresses or foo@bar as user references.
- Fix title of discussion jump button at top of page.
- Don't return nil for missing objects from parser cache.
- Make .gitmodules parsing more resilient to syntax errors.
- Add username parameter to gravatar URL.
- Autolink package names in more dependency files.
- Return nil when looking up config for unknown LDAP provider.
- Add system note with link to diff comparison when MR discussion becomes outdated.
- Don't wrap pasted code when it's already inside code tags.
- Revert 'New file from interface on existing branch'.
- Show last commit for current tree on tree page.
- Add documentation about adding foreign keys.
- add username field to push webhook. (David Turner)
- Rename CI/CD Pipelines to Pipelines in the project settings.
- Make environment tables responsive.
- Expand/collapse backlog & closed lists in issue boards.
- Fix GitHub importer performance on branch existence check.
- Fix counter cache for acts as taggable.
- Github - Fix token interpolation when cloning wiki repository.
- Fix token interpolation when setting the Github remote.
- Fix N+1 queries for non-members in comment threads.
- Fix terminals support for Kubernetes Service.
- Fix: A diff comment on a change at last line of a file shows as two comments in discussion.
- Instrument MergeRequestDiff#load_commits.
- Introduce source to Pipeline entity.
- Fixed create new label form in issue form not working for sub-group projects.
- Fixed style on unsubscribe page. (Gustav Ernberg)
- Enables inline editing for an issues title & description.
- Ask for an example project for bug reports.
- Add summary lines for collapsed details in the bug report template.
- Prevent commits from upstream repositories to be re-processed by forks.
- Avoid repeated queries for pipeline builds on merge requests.
- Preloads head pipeline for merge request collection.
- Handle head pipeline when creating merge requests.
- Migrate artifacts to a new path.
- Rescue OpenSSL::SSL::SSLError in JiraService & IssueTrackerService.
- Repository browser: handle in-repository submodule urls. (David Turner)
- Prevent project transfers if a new group is not selected.
- Allow 'no one' as an option for allowed to merge on a procted branch.
- Reduce time spent waiting for certain Sidekiq jobs to complete.
- Refactor ProjectsFinder#init_collection to produce more efficient queries for retrieving projects.
- Remove unused code and uses underscore.
- Restricts search projects dropdown to group projects when group is selected.
- Properly handle container registry redirects to fix metadata stored on a S3 backend.
- Fix LFS timeouts when trying to save large files.
- Set artifact working directory to be in the destination store to prevent unnecessary I/O.
- Strip trailing whitespaces in submodule URLs.
- Make sure reCAPTCHA configuration is loaded when spam checks are initiated.
- Fix up arrow not editing last discussion comment.
- Added application readiness endpoints to the monitoring health check admin view.
- Use wait_for_requests for both ajax and Vue requests.
- Cleanup ci_variables schema and table.
- Remove foreigh key on ci_trigger_schedules only if it exists.
- Allow translation of Pipeline Schedules.

## 9.2.10 (2017-08-09)

- Remove hidden symlinks from project import files.
- Disallow Git URLs that include a username or hostname beginning with a non-alphanumeric character.

## 9.2.9 (2017-07-20)

- Fix an infinite loop when handling user-supplied regular expressions.

## 9.2.8 (2017-07-19)

- Improve support for external issue references. !12485
- Renders 404 if given project is not readable by the user on Todos dashboard.
- Fix incorrect project authorizations.
- Remove uploads/appearance symlink. A leftover from a previous migration.

## 9.2.7 (2017-06-21)

- Reinstate is_admin flag in users api when authenticated user is an admin. !12211 (rickettm)

## 9.2.6 (2017-06-16)

- Fix the last coverage in trace log should be extracted. !11128 (dosuken123)
- Respect merge, instead of push, permissions for protected actions. !11648
- Fix pipeline_schedules pages throwing error 500. !11706 (dosuken123)
- Make backup task to continue on corrupt repositories. !11962
- Fix incorrect ETag cache key when relative instance URL is used. !11964
- Fix math rendering on blob pages.
- Invalidate cache for issue and MR counters more granularly.
- Fix terminals support for Kubernetes Service.
- Fix LFS timeouts when trying to save large files.
- Strip trailing whitespaces in submodule URLs.
- Make sure reCAPTCHA configuration is loaded when spam checks are initiated.
- Remove foreigh key on ci_trigger_schedules only if it exists.

## 9.2.5 (2017-06-07)

- No changes.

## 9.2.4 (2017-06-02)

- Fix visibility when referencing snippets.

## 9.2.3 (2017-05-31)

- Move uploads from 'public/uploads' to 'public/uploads/system'.
- Escapes html content before appending it to the DOM.
- Restrict API X-Frame-Options to same origin.
- Allow users autocomplete by author_id only for authenticated users.

## 9.2.2 (2017-05-25)

- Fix issue where real time pipelines were not cached. !11615
- Make all notes use equal padding.

## 9.2.1 (2017-05-23)

- Fix placement of note emoji on hover.
- Fix migration for older PostgreSQL versions.

## 9.2.0 (2017-05-22)

- API: Filter merge requests by milestone and labels. (10924)
- Reset New branch button when issue state changes. !5962 (winniehell)
- Frontend prevent authored votes. !6260 (Barthc)
- Change issues list in MR to natural sorting. !7110 (Jeff Stubler)
- Add animations to all the dropdowns. !8419
- Add update time to project lists. !8514 (Jeff Stubler)
- Remove view fragment caching for project READMEs. !8838
- API: Add parameters to allow filtering project pipelines. !9367 (dosuken123)
- Database SSL support for backup script. !9715 (Guillaume Simon)
- Fix UI inconsistency different files view (find file button missing). !9847 (TM Lee)
- Display slash commands outcome when previewing Markdown. !10054 (Rares Sfirlogea)
- Resolve "Add more tests for spec/controllers/projects/builds_controller_spec.rb". !10244 (dosuken123)
- Add keyboard edit shotcut for wiki. !10245 (George Andrinopoulos)
- Redirect old links after renaming a user/group/project. !10370
- Add system note on description change of issue/merge request. !10392 (blackst0ne)
- Improve validation of namespace & project paths. !10413
- Add board_move slash command. !10433 (Alex Sanford)
- Update all instances of the old loading icon. !10490 (Andrew Torres)
- Implement protected manual actions. !10494
- Implement search by extern_uid in Users API. !10509 (Robin Bobbitt)
- add support for .vue templates. !10517
- Only add newlines between multiple uploads. !10545
- Added balsamiq file viewer. !10564
- Remove unnecessary test helpers includes. !10567 (Jacopo Beschi @jacopo-beschi)
- Add tooltip to header of Done board. !10574 (Andy Brown)
- Fix redundant cache expiration in Repository. !10575 (blackst0ne)
- Add hashie-forbidden_attributes gem. !10579 (Andy Brown)
- Add spec for schema.rb. !10580 (blackst0ne)
- Keep webpack-dev-server process functional across branch changes. !10581
- Turns true value and false value database methods from instance to class methods. !10583
- Improve text on todo list when the todo action comes from yourself. !10594 (Jacopo Beschi @jacopo-beschi)
- Replace rake cache:clear:db with an automatic mechanism. !10597
- Remove heading and trailing spaces from label's color and title. !10603 (blackst0ne)
- Add webpack_bundle_tag helper to improve non-localhost GDK configurations. !10604
- Added quick-update (fade-in) animation to newly rendered notes. !10623
- Fix rendering emoji inside a string. !10647 (blackst0ne)
- Dockerfiles templates are imported from gitlab.com/gitlab-org/Dockerfile. !10663
- Add support for i18n on Cycle Analytics page. !10669
- Allow OAuth clients to push code. !10677
- Add configurable timeout for git fetch and clone operations. !10697
- Move labels of search results from bottom to title. !10705 (dr)
- Added build failures summary page for pipelines. !10719
- Expand/collapse button -> Change to make it look like a toggle. !10720 (Jacopo Beschi @jacopo-beschi)
- Decrease ABC threshold to 57.08. !10724 (Rydkin Maxim)
- Removed target blank from the metrics action inside the environments list. !10726
- Remove Repository#version method and tests. !10734
- Refactor Admin::GroupsController#members_update method and add some specs. !10735
- Refactor code that creates project/group members. !10735
- Add Slack slash command api to services documentation and rearrange order and cases. !10757 (TM Lee)
- Disable test settings on chat notification services when repository is empty. !10759
- Add support for instantly updating comments. !10760
- Show checkmark on current assignee in assignee dropdown. !10767
- Remove pipeline controls for last deployment from Environment monitoring page. !10769
- Pipeline view updates in near real time. !10777
- Fetch pipeline status in batch from redis. !10785
- Add username to activity atom feed. !10802 (winniehell)
- Support Markdown previews for personal snippets. !10810
- Implement ability to edit hooks. !10816 (Alexander Randa)
- Allow admins to sudo to blocked users via the API. !10842
- Don't display the is_admin flag in most API responses. !10846
- Refactor add_users method for project and group. !10850
- Pipeline schedules got a new and improved UI. !10853
- Fix updating merge_when_build_succeeds via merge API endpoint. !10873
- Add index on ci_builds.user_id. !10874 (blackst0ne)
- Improves test settings for chat notification services for empty projects. !10886
- Change Git commit command in Existing folder to git commit -m. !10900 (TM Lee)
- Show group name on flash container when group is created from Admin area. !10905
- Make markdown tables thinner. !10909 (blackst0ne)
- Ensure namespace owner is Master of project upon creation. !10910
- Updated CI status favicons to include the tanuki. !10923
- Decrease Cyclomatic Complexity threshold to 16. !10928 (Rydkin Maxim)
- Replace header merge request icon. !10932 (blackst0ne)
- Fix error on CI/CD Settings page related to invalid pipeline trigger. !10948 (dosuken123)
- rickettm Add repo parameter to gitaly:install and workhorse:install rake tasks. !10979 (M. Ricketts)
- Generate and handle a gl_repository param to pass around components. !10992
- Prevent 500 errors caused by testing the Prometheus service. !10994
- Disable navigation to Project-level pages configuration when Pages disabled. !11008
- Fix caching large snippet HTML content on MySQL databases. !11024
- Hide external environment URL button on terminal page if URL is not defined. !11029
- Always show the latest pipeline information in the commit box. !11038
- Fix misaligned buttons in wiki pages. !11043
- Colorize labels in search field. !11047
- Sort the network graph both by commit date and topographically. !11057
- Remove carriage returns from commit messages. !11077
- Add tooltips to user contribution graph key. !11138
- Add German translation for Cycle Analytics. !11161
- Fix skipped manual actions problem when processing the pipeline. !11164
- Fix cross referencing for private and internal projects. !11243
- Add state to MR widget that prevent merges when branch changes after page load. !11316
- Fixes the 500 when accessing customized appearance logos. !11479 (Alexis Reigel)
- Implement Users::BuildService. !30349 (George Andrinopoulos)
- Display comments for personal snippets.
- Support comments for personal snippets.
- Support uploaders for personal snippets comments.
- Handle incoming emails from aliases correctly.
- Re-rewrites pipeline graph in vue to support realtime data updates.
- Add issues/:iid/closed_by api endpoint. (mhasbini)
- Disallow merge requests from fork when source project have disabled merge requests. (mhasbini)
- Improved UX on project members settings view.
- Clear emoji search in awards menu after picking emoji.
- Cleanup markdown spacing.
- Separate CE params on Grape API.
- Allow to create new branch and empty WIP merge request from issue page.
- Prevent people from creating branches if they don't have persmission to push.
- Redesign auth 422 page.
- 29595 Update callout design.
- Detect already enabled DeployKeys in EnableDeployKeyService.
- Add transparent top-border to the hover state of done todos.
- Refactor all CI vue badges to use the same vue component.
- Update note edits in real-time.
- Add button to delete filters from filtered search bar.
- Added profile name to user dropdown.
- Display GitLab Pages status in Admin Dashboard.
- Fix label creation from issuable for subgroup projects.
- Vertically align mini pipeline stage container.
- prevent nav tabs from wrapping to new line.
- Fix environments vue architecture to match documentation.
- Enforce project features when searching blobs and wikis.
- fix inline diff copy in firefox.
- Note Ghost user and refer to user deletion documentation.
- Expose project statistics on single requests via the API.
- Job dropdown of pipeline mini graph updates in realtime when its opened.
- Add default margin-top to user request table on project members page.
- Add tooltips to note action buttons.
- Remove `#` being added on commit sha in MR widget.
- Remove spinner from loading comment.
- Fixes an issue preventing screen readers from reading some icons.
- Load milestone tabs asynchronously to increase initial load performance.
- [BB Importer] Save the error trace and the whole raw document to debug problems easier.
- Fixed branches dropdown rendering branch names as HTML.
- Make Asciidoc & other markup go through pipeline to prevent XSS.
- Validate URLs in markdown using URI to detect the host correctly.
- Side-by-side view in commits correcly expands full window width.
- Deploy keys load are loaded async.
- Fixed spacing of discussion submit buttons.
- Add hostname to usage ping.
- Allow usage ping to be disabled completely in gitlab.yml.
- Add artifact file page that uses the blob viewer.
- Add breadcrumb, build header and pipelines submenu to artifacts browser.
- Show Raw button as Download for binary files.
- Add Source/Rendered switch to blobs for SVG, Markdown, Asciidoc and other text files that can be rendered.
- Catch all URI errors in ExternalLinkFilter.
- Allow commenting on older versions of the diff and comparisons between diff versions.
- Paste a copied MR source branch name as code when pasted into a GFM form.
- Fix commenting on an existing discussion on an unchanged line that is no longer in the diff.
- Link to outdated diff in older MR version from outdated diff discussion.
- Bump Sidekiq to 5.0.0.
- Use blob viewers for snippets.
- Add download button to project snippets.
- Display video blobs in-line like images.
- Gracefully handle failures for incoming emails which do not match on the To header, and have no References header.
- Added title to award emoji buttons.
- Fixed alignment of empty task list items.
- Removed the target=_blank from the monitoring component to prevent opening a new tab.
- Fix new admin integrations not taking effect on existing projects.
- Prevent further repository corruption when resolving conflicts from a fork where both the fork and upstream projects require housekeeping.
- Add missing project attributes to Import/Export.
- Remove N+1 queries in processing MR references.
- Fixed wrong method call on notify_post_receive. (Luigi Leoni)
- Fixed search terms not correctly highlighting.
- Refactored the anchor tag to remove the trailing space in the target branch.
- Prevent user profile tabs to display raw json when going back and forward in browser history.
- Add index to webhooks type column.
- Change line-height on build-header so elements don't overlap. (Dino Maric)
- Fix dead link to GDK on the README page. (Dino Maric)
- Fixued preview shortcut focusing wrong preview tab.
- Issue assignees are now removed without loading unnecessary data into memory.
- Refactor backup/restore docs.
- Fixed group issues assignee dropdown loading all users.
- Fix for XSS in project import view caused by Hamlit filter usage.
- Fixed avatar not display on issue boards when Gravatar is disabled.
- Fixed create new label form in issue boards sidebar.
- Add realtime descriptions to issue show pages.
- Issue API change: assignee_id parameter and assignee object in a response have been deprecated.
- Fixed bug where merge request JSON would be displayed.
- Fixed Prometheus monitoring graphs not showing empty states in certain scenarios.
- Removed the milestone references from the milestone views.
- Show sizes correctly in merge requests when diffs overflow.
- Fix notify_only_default_branch check for Slack service.
- Make the `gitlab:gitlab_shell:check` task check that the repositories storage path are owned by the `root` group.
- Optimise pipelines.json endpoint.
- Pass docsUrl to pipeline schedules callout component.
- Fixed alignment of CI icon in issues related branches.
- Set the issuable sidebar to remain closed for mobile devices.
- Sanitize submodule URLs before linking to them in the file tree view.
- Upgrade Sidekiq to 4.2.10.
- Cache Routable#full_path in RequestStore to reduce duplicate route loads.
- Refactor snippets finder & dont return internal snippets for external users.
- Fix snippets visibility for show action - external users can not see internal snippets.
- Store retried in database for CI Builds.
- repository browser: handle submodule urls that don't end with .git. (David Turner)
- Fixed tags sort from defaulting to empty.
- Do not show private groups on subgroups page if user doesn't have access to.
- Make MR link in build sidebar bold.
- Unassign all Issues and Merge Requests when member leaves a team.
- Fix preemptive scroll bar on user activity calendar.
- Pipeline chat notifications convert seconds to minutes and hours.

## 9.1.10 (2017-08-09)

- Remove hidden symlinks from project import files.
- Disallow Git URLs that include a username or hostname beginning with a non-alphanumeric character.

## 9.1.9 (2017-07-20)

- Fix an infinite loop when handling user-supplied regular expressions.

## 9.1.8 (2017-07-19)

- Improve support for external issue references. !12485
- Renders 404 if given project is not readable by the user on Todos dashboard.
- Fix incorrect project authorizations.
- Remove uploads/appearance symlink. A leftover from a previous migration.

## 9.1.7 (2017-06-07)

- No changes.

## 9.1.6 (2017-06-02)

- Fix visibility when referencing snippets.

## 9.1.5 (2017-05-31)

- Move uploads from 'public/uploads' to 'public/uploads/system'.
- Restrict API X-Frame-Options to same origin.
- Allow users autocomplete by author_id only for authenticated users.

## 9.1.4 (2017-05-12)

- Fix error on CI/CD Settings page related to invalid pipeline trigger. !10948 (dosuken123)
- Sort the network graph both by commit date and topographically. !11057
- Fix cross referencing for private and internal projects. !11243
- Handle incoming emails from aliases correctly.
- Gracefully handle failures for incoming emails which do not match on the To header, and have no References header.
- Add missing project attributes to Import/Export.
- Fixed search terms not correctly highlighting.
- Fixed bug where merge request JSON would be displayed.

## 9.1.3 (2017-05-05)

- Do not show private groups on subgroups page if user doesn't have access to.
- Enforce project features when searching blobs and wikis.
- Fixed branches dropdown rendering branch names as HTML.
- Make Asciidoc & other markup go through pipeline to prevent XSS.
- Validate URLs in markdown using URI to detect the host correctly.
- Fix for XSS in project import view caused by Hamlit filter usage.
- Sanitize submodule URLs before linking to them in the file tree view.
- Refactor snippets finder & dont return internal snippets for external users.
- Fix snippets visibility for show action - external users can not see internal snippets.

## 9.1.2 (2017-05-01)

- Add index on ci_runners.contacted_at. !10876 (blackst0ne)
- Fix pipeline events description for Slack and Mattermost integration. !10908
- Fixed milestone sidebar showing incorrect number of MRs when collapsed. !10933
- Fix ordering of commits in the network graph. !10936
- Ensure the chat notifications service properly saves the "Notify only default branch" setting. !10959
- Lazily sets UUID in ApplicationSetting for new installations.
- Skip validation when creating internal (ghost, service desk) users.
- Use GitLab Pages v0.4.1.

## 9.1.1 (2017-04-26)

- Add a transaction around move_issues_to_ghost_user. !10465
- Properly expire cache for all MRs of a pipeline. !10770
- Add sub-nav for Project Integration Services edit page. !10813
- Fix missing duration for blocked pipelines. !10856
- Fix lastest commit status text on main project page. !10863
- Add index on ci_builds.updated_at. !10870 (blackst0ne)
- Fix 500 error due to trying to show issues from pending deleting projects. !10906
- Ensures that OAuth/LDAP/SAML users don't need to be confirmed.
- Ensure replying to an individual note by email creates a note with its own discussion ID.
- Fix OAuth, LDAP and SAML SSO when regular sign-ups are disabled.
- Fix usage ping docs link from empty cohorts page.
- Eliminate N+1 queries in loading namespaces for every issuable in milestones.

## 9.1.0 (2017-04-22)

- Add Jupyter notebook rendering !10017
- Added merge requests empty state. !7342
- Add option to start a new resolvable discussion in an MR. !7527
- Hide form inputs for group member without editing rights. !7816
- Create a new issue for a single discussion in a Merge Request. !8266 (Bob Van Landuyt)
- Adding non_archived scope for counting projects. !8305 (Naveen Kumar)
- Don't show links to tag a commit for users that are not permitted. !8407
- New file from interface on existing branch. !8427 (Jacopo Beschi @jacopo-beschi)
- Strip reference prefixes on branch creation. !8498 (Matthieu Tardy)
- Support 2FA requirement per-group. !8763 (Markus Koller)
- Add Undo to Todos in the Done tab. !8782 (Jacopo Beschi @jacopo-beschi)
- Shows 'Go Back' link only when browser history is available. !9017
- Implement user create service. !9220 (George Andrinopoulos)
- Incorporate Gitaly client for refs service. !9291
- Cancel pending pipelines if commits not HEAD. !9362 (Rydkin Maxim)
- Add indication for closed or merged issuables in GFM. !9462 (Adam Buckland)
- Periodically clean up temporary upload files to recover storage space. !9466 (blackst0ne)
- Use toggle button to expand / collapse mulit-nested groups. !9501
- Fixes dismissable error close is not visible enough. !9516
- Fixes an issue in the new merge request form, where a tag would be selected instead of a branch when they have the same names. !9535 (Weiqing Chu)
- Expose CI/CD status API endpoints with Gitlab::Ci::Status facility on pipeline, job and merge request for favicon. !9561 (dosuken123)
- Use Gitaly for CommitController#show. !9629
- Order milestone issues by position ascending in api. !9635 (George Andrinopoulos)
- Convert Issue into ES6 class. !9636 (winniehell)
- Link issuable reference to itself in meta-header. !9641 (mhasbini)
- Add ability to disable Merge Request URL on push. !9663 (Alex Sanford)
- ProjectsFinder should handle more options. !9682 (Jacopo Beschi @jacopo-beschi)
- Fix create issue form buttons are misaligned on mobile. !9706 (TM Lee)
- Labels support color names in backend. !9725 (Dongqing Hu)
- Standardize on core-js for es2015 polyfills. !9749
- Fix GitHub Import deleting branches for open PRs from a fork. !9758
- Do not show LFS object when LFS is disabled. !9779 (Christopher Bartz)
- Fix symlink icon in project tree. !9780 (mhasbini)
- Fix bug when system hook for deploy key. !9796 (billy.lb)
- Make authorized projects worker use a specific queue instead of the default one. !9813
- Simplify trigger_docs build job for CE and EE. !9820 (winniehell)
- Add `aria-label` for feature status accessibility. !9830
- Add dashboard and group milestones count badges. !9836 (Alex Braha Stoll)
- Use Gitaly for Repository#is_ancestor. !9864
- After copying a diff file or blob path, pasting it into a comment field will format it as Markdown. !9876
- Fix visibility level on new project page. !9885 (blackst0ne)
- Fix xml.updated field in rss/atom feeds. !9889 (blackst0ne)
- Add Undo mark all as done to Todos. !9890 (Jacopo Beschi @jacopo-beschi)
- Add a name field to the group form. !9891 (Douglas Lovell)
- Add custom attributes in factories. !9892 (George Andrinopoulos)
- Resolve project pipeline status caching problem on dashboard. !9895
- Display error message when deleting tag in web UI fails. !9906
- Add quick submit for snippet forms. !9911 (blackst0ne)
- New directory from interface on existing branch. !9921 (Jacopo Beschi @jacopo-beschi)
- Removes UJS from pipelines tables. !9929
- Fix project title validation, prevent clicking on disabled button. !9931
- Show correct user & creation time in heading of the pipeline page. !9936
- Include time tracking attributes in webhooks payload. !9942
- Add `requirements: { id: /.+/ }` for all projects and groups namespaced API routes. !9944
- Improved UX for the environments metrics view. !9946
- Remove whitespace in group links. !9947 (Xurxo Méndez Pérez)
- Adds Frontend Styleguide to documentation. !9961
- Add metadata to system notes. !9964
- When viewing old wiki page version, edit button should be disabled. !9966 (TM Lee)
- Added labels array to the issue web hook returned object. !9972
- Upgrade VueJS to v2.2.4 and disable dev mode warnings. !9981
- Only add code coverage instrumentation when generating coverage report. !9987
- Fix Project Wiki update. !9990 (Dongqing Hu)
- Fix trigger webhook for ref with a dot. !10001 (George Andrinopoulos)
- Fix quick submit short-cut on preview tab for comments. !10002
- Add option to receive email notifications about your own activity. !10032 (Richard Macklin)
- Rename 'All issues' to 'Open issues' in Add issues modal. !10042 (blackst0ne)
- Disable pipeline and environment actions that are not playable. !10052
- Added clarification to the Jira integration documentation. !10066 (Matthew Bender)
- Move milestone summary content into the sidebar. !10096
- Replace closing MR icon. !10103 (blackst0ne)
- Add support for multi-level container image repository names. !10109 (André Guede)
- Add ECMAScript polyfills for Symbol and Array.find. !10120
- Add tooltip to user's calendar activities. !10123 (Alex Argunov)
- Resolve "Run CI/CD pipelines on a schedule" - "Basic backend implementation". !10133 (dosuken123)
- Change hint on first row of filters dropdown to `Press Enter or click to search`. !10138
- Remove useless queries with false conditions (e.g 1=0). !10141 (mhasbini)
- Show CI status as Favicon on Pipelines, Job and MR pages. !10144
- Update color palette to a more harmonious and consistent one. !10154
- Add tooltip and accessibility for profile cover buttons. !10182
- Change Done column to Closed in issue boards. !10198 (blackst0ne)
- Add metrics button to environments overview page. !10234
- Force unlimited terminal size when checking processes via call to ps. !10246 (Sebastian Reitenbach)
- Fix sub-nav highlighting for `Environments` and `Jobs` pages. !10254
- Drop support for correctly processing legacy pipelines. !10266
- Fix project creation failure due to race condition in namespace directory creation. !10268 (Robin Bobbitt)
- Introduced error/empty states for the environments performance metrics. !10271
- Improve performance of GitHub importer for large repositories. !10273
- Introduce "polling_interval_multiplier" as application setting. !10280
- Prevent users from disconnecting GitLab account from CAS. !10282
- Clearly show who triggered the pipeline in email. !10283
- Make user mentions case-insensitive. !10285 (blackst0ne)
- Update rugged to 0.25.1.1. !10286 (Elan Ruusamäe)
- Handle parsing OpenBSD ps output properly to display sidekiq infos on admin->monitoring->background. !10303 (Sebastian Reitenbach)
- Log errors during generating of GitLab Pages to debug log. !10335 (Danilo Bargen)
- Update issue board cards design. !10353
- Tags can be protected, restricting creation of matching tags by user role. !10356
- Set GIT_TERMINAL_PROMPT env variable in initializer. !10372
- Remove index for users.current sign in at. !10401 (blackst0ne)
- Include reopened MRs when searching for opened ones. !10407
- Integrates Microsoft Teams webhooks with GitLab. !10412
- Fix subgroup repository disappearance if group was moved. !10414
- Add /-/readiness /-/liveness and /-/metrics endpoints to track application health. !10416
- Changed capitalisation of buttons across GitLab. !10418
- Fix blob highlighting in search. !10420
- Add remove_concurrent_index to database helper. !10441 (blackst0ne)
- Fix wiki commit message. !10464 (blackst0ne)
- Deleting a user should not delete associated records. !10467
- Include endpoint in metrics for ETag caching middleware. !10495
- Change project view default for existing users and anonymous visitors to files+readme. !10498
- Hide header counters for issue/mr/todos if zero. !10506
- Remove the User#is_admin? method. !10520 (blackst0ne)
- Removed Milestone#is_empty?. !10523 (Jacopo Beschi @jacopo-beschi)
- Add UI for Trigger Schedule. !10533 (dosuken123)
- Add foreign key for ci_trigger_requests on ci_triggers. !10537
- Upgrade webpack to v2.3.3 and webpack-dev-server to v2.4.2. !10552
- Bugfix: POST /projects/:id/hooks and PUT /projects/:id/hook/:hook_id no longer ignore the the job_events param in the V4 API. !10586
- Fix MR widget bug that merged a MR when Merge when pipeline succeeds was clicked via the dropdown. !10611
- Hide new subgroup button if user has no permission to create one. !10627
- Fix PlantUML integration in GFM. !10651
- Show sub-nav under Merge Requests when issue tracker is non-default. !10658
- Fix bad query for PostgreSQL showing merge requests list. !10666
- Fix invalid encoding when showing some traces. !10681
- Add lighter colors and fix existing light colors. !10690
- Fix another case where trace does not have proper encoding set. !10728
- Fix trace cannot be written due to encoding. !10758
- Replace builds_enabled with jobs_enabled in projects API v4. !10786 (winniehell)
- Add retry to system hook worker. !10801
- Fix error when an issue reference has a pending deleting project. !10843
- Update permalink/blame buttons with line number fragment hash.
- Limit line length for project home page.
- Fix filtered search input width for IE.
- Update wikis_controller.rb to use strong params.
- Fix API group/issues default state filter. (Alexander Randa)
- Prevent builds dropdown to close when the user clicks in a build.
- Display all closed issues in “done” board list.
- Remove no-new annotation from file_template_mediator.js.
- Changed dropdown style slightly.
- Change gfm textarea to use monospace font.
- Prevent filtering issues by multiple Milestones or Authors.
- Recent search history for issues.
- Remove duplicated tokens in issuable search bar.
- Adds empty and error state to pipelines.
- Allow admin to view all namespaces. (George Andrinopoulos)
- allow offset query parameter for infinite list pages.
- Fix wrong message on starred projects filtering. (George Andrinopoulos)
- Adds pipeline mini-graph to system information box in Commit View.
- Remove confusing placeholder for JIRA transition_id.
- Remove extra margin at bottom of todos page.
- Add back expandable folder behavior.
- Create todos only for new mentions.
- Linking to blob edit page handles anonymous users and users without enough permissions to edit directly.
- Fix projects_limit RangeError on user create. (Alexander Randa)
- Add helpful icons to profile events.
- Refactor dropdown_milestone_spec.rb. (George Andrinopoulos)
- Fix alignment of resolve button.
- Change label for name on sign up form.
- Don’t show source project name when user does not have access.
- Update toggle buttons to be <button>.
- Display full project name with namespace upon deletion.
- Spam check only when spammable attributes have changed.
- align Mark all as done with other Done buttons on Todos page.
- Adds polling utility function for vue resource.
- Allow unauthenticated access to some Branch API GET endpoints.
- Fix redirection after login when the referer have params. (mhasbini)
- fix sidebar padding for build and wiki pages.
- Correctly update paths when changing a child group.
- Add shortcuts and counters to MRs and issues in navbar.
- Remove forced scroll into view when switching to Changes MR tab.
- Fix link to Jira service documentation.
- consistent icons in vue and kaminari pagers.
- refocus textarea after attaching a file.
- Enable creation of deploy keys with write access via the API.
- Disable invalid service templates.
- Remove the class attribute from the whitelist for HTML generated from Markdown.
- Add search optional param and docs for V4.
- Fix issue's note cache expiration after delete. (mhasbini)
- Fixes HTML structure that was preventing the tooltip to disappear when hovering out of the button.
- fix Status icons overlapping sidebar on mobile.
- Add dropdown sort to project milestones. (George Andrinopoulos)
- Prevent more than one issue tracker to be active for the same project. (luisdgs19)
- Add copy button to blob header and use icon for Raw button.
- Add metrics events for incoming emails.
- Shows loading icon in issue boards modal when changing filters.
- Added tests for the w.gl.utils.backOff promise.
- Add `g t` global shortcut to go to todos.
- Fix conflict resolution when files contain valid UTF-8 characters.
- Added award emoji animation and improved active state.
- Fixes milestone/merge_requests endpoint to actually scope the result. (Joren De Groof)
- Added remaining_time method to milestoneish, specs and updated the milestone_helper milestone_remaining_days method to correctly return the correct remaining time. (Michael Robinson)
- Removed unnecessary 'add' text in additional award emoji button.
- adds todo functionality to closed issuable sidebar and changes todo bell icon to check-square.
- Copy code as GFM from diffs, blobs and GFM code blocks.
- Removed the duplicated search icon in the award emoji menu.
- Enable snippets for new projects by default.
- Add rake task to import GitHub projects from the command line.
- New rake task to reset all email and private tokens.
- Fix path disclosure in project import/export.
- Fix 'Object not found - no match for id (sha)' when importing GitHub Pull Requests.
- Display custom hook error messages when automatic merge is enabled.
- Fix layout of projects page on admin area.
- Fix encoding issue exporting a project.
- Periodically mark projects that are stuck in importing as failed.
- Skip groups validation on the client.
- Fix Import/Export MR diffs not showing and missing forked MRs.
- Create subgroups if they don't exist while importing projects.
- Fix Milestone name on show page. (Raveesh)
- Fix missing capitalisation on views.
- Removed orphaned notification settings without a namespace.
- Fix restricted project visibility setting available to users.
- Moved the gear settings dropdown to a tab in the groups view.
- Fixed group milestone date dropdowns not opening.
- Fixed bug in issue boards which stopped cards being able to be dragged.
- Added new filtered search bar to issue boards.
- Add closed_at field to issues.
- Do not set closed_at to nil when issue is reopened.
- Centered issues empty state.
- Fixed private group name disclosure via new/update forms.
- Add keyboard shortcuts to main menu.
- Moved the monitoring button inside the show view for the environments page.
- Speed up initial rendering of MR diffs page.
- Fixed tabs on new merge request page causing incorrect URLs.
- Fix for open redirect vulnerability using continue[to] in URL when requesting project import status.
- Fix for open redirect vulnerabilities in todos, issues, and MR controllers.
- Optimise builds endpoint.
- Fixed pipeline actions tooltips overflowing.
- Fixed job tooltip being cut-off.
- Fixed projects list lines breaking.
- Only email pipeline creators; only email for successful pipelines with custom settings.
- Reset users.authorized_projects_populated to automatically refresh user permissions.
- Corrected alignment for the remember-me checkbox in the login view.
- Fixed tabs not scrolling on mobile.
- Add unique index for notes_id to system note metadata table.
- Handle SSH keys that have multiple spaces between each marker.
- Don't delete a branch involved in an open merge request in "Delete all merged branches" service.
- Relax constraint on Wiki IDs, since subdirectories can contain spaces.
- Remove Tags filter from Projects Explore dropdown.
- Enable Style/Proc cop for rubocop. (mhasbini)
- Show the build/pipeline coverage if it is available.
- Corrected time tracking icon color in the issuable side bar.
- update test_bundle.js ignored files.
- Add usage ping to CE.
- User callout only shows on current users profile.
- Removed the hours & minutes from the users start date on their profile.
- Only send chat notifications for the default branch.
- Don't fill in the default kubernetes namespace.

## 9.0.13 (2017-08-09)

- Remove hidden symlinks from project import files.
- Disallow Git URLs that include a username or hostname beginning with a non-alphanumeric character.

## 9.0.12 (2017-07-20)

- Fix an infinite loop when handling user-supplied regular expressions.

## 9.0.11 (2017-07-19)

- Renders 404 if given project is not readable by the user on Todos dashboard.
- Fix incorrect project authorizations.
- Remove uploads/appearance symlink. A leftover from a previous migration.

## 9.0.10 (2017-06-07)

- No changes.

## 9.0.9 (2017-06-02)

- Fix visibility when referencing snippets.

## 9.0.8 (2017-05-31)

- Move uploads from 'public/uploads' to 'public/uploads/system'.
- Restrict API X-Frame-Options to same origin.
- Allow users autocomplete by author_id only for authenticated users.

## 9.0.7 (2017-05-05)

- Enforce project features when searching blobs and wikis.
- Fixed branches dropdown rendering branch names as HTML.
- Make Asciidoc & other markup go through pipeline to prevent XSS.
- Validate URLs in markdown using URI to detect the host correctly.
- Fix for XSS in project import view caused by Hamlit filter usage.
- Sanitize submodule URLs before linking to them in the file tree view.
- Refactor snippets finder & dont return internal snippets for external users.
- Fix snippets visibility for show action - external users can not see internal snippets.
- Do not show private groups on subgroups page if user doesn't have access to.

## 9.0.6 (2017-04-21)

- Bugfix: POST /projects/:id/hooks and PUT /projects/:id/hook/:hook_id no longer ignore the the job_events param in the V4 API. !10586
- Fix MR widget bug that merged a MR when Merge when pipeline succeeds was clicked via the dropdown. !10611
- Fix PlantUML integration in GFM. !10651
- Show sub-nav under Merge Requests when issue tracker is non-default. !10658
- Fix restricted project visibility setting available to users.
- Removed orphaned notification settings without a namespace.
- Fix issue's note cache expiration after delete. (mhasbini)
- Display custom hook error messages when automatic merge is enabled.
- Fix filtered search input width for IE.

## 9.0.5 (2017-04-10)

- Add shortcuts and counters to MRs and issues in navbar.
- Disable invalid service templates.
- Handle SSH keys that have multiple spaces between each marker.

## 9.0.4 (2017-04-05)

- Don’t show source project name when user does not have access.
- Remove the class attribute from the whitelist for HTML generated from Markdown.
- Fix path disclosure in project import/export.
- Fix for open redirect vulnerability using continue[to] in URL when requesting project import status.
- Fix for open redirect vulnerabilities in todos, issues, and MR controllers.

## 9.0.3 (2017-04-05)

- Fix name colision when importing GitHub pull requests from forked repositories. !9719
- Fix GitHub Importer for PRs of deleted forked repositories. !9992
- Fix environment folder route when special chars present in environment name. !10250
- Improve Markdown rendering when a lot of merge requests are referenced. !10252
- Allow users to import GitHub projects to subgroups.
- Backport API changes needed to fix sticking in EE.
- Remove unnecessary ORDER BY clause from `forked_to_project_id` subquery. (mhasbini)
- Make CI build to use optimistic locking only on status change.
- Fix race condition where a namespace would be deleted before a project was deleted.
- Fix linking to new issue with selected template via url parameter.
- Remove unnecessary ORDER BY clause when updating todos. (mhasbini)
- API: Make the /notes endpoint work with noteable iid instead of id.
- Fixes method not replacing URL parameters correctly and breaking pipelines pagination.
- Move issue, mr, todos next to profile dropdown in top nav.

## 9.0.2 (2017-03-29)

- Correctly update paths when changing a child group.
- Fixed private group name disclosure via new/update forms.

## 9.0.1 (2017-03-28)

- Resolve "404 when requesting build trace". !9759 (dosuken123)
- Simplify search queries for projects and merge requests. !10053 (mhasbini)
- Fix after_script processing for Runners APIv4. !10185
- Fix escaped html appearing in milestone page. !10224
- Fix bug that caused jobs that already had been retried to be retried again when retrying a pipeline. !10249
- Allow filtering by all started milestones.
- Allow sorting by due date and priority.
- Fixed branches pagination not displaying.
- Fixed filtered search not working in IE.
- Optimize labels finder query when searching for a project with a group. (mhasbini)

## 9.0.0 (2017-03-22)

- Fix inconsistent naming for services that delete things. !5803 (dixpac)
- UI: Allow a project variable to be set to an empty value. !6044 (Lukáš Nový)
- Align task list checkboxes. !6487 (Jared Deckard <jared.deckard@gmail.com>)
- SanitizationFilter allows html5 details and summary tags. !6568
- on branch deletion show loading icon and disabled the button. !6761 (wendy0402)
- Use an entity for RepoBranch commits and enhance RepoCommit. !7138 (Ben Boeckel)
- Deleting a user doesn't delete issues they've created/are assigned to. !7393
- Fix position of counter in milestone panels. !7842 (Andrew Smith (EspadaV8))
- Added a feature to create a 'directly addressed' Todo when mentioned in the beginning of a line. !7926 (Ershad Kunnakkadan)
- Implement OpenID Connect identity provider. !8018 (Markus Koller)
- Show directory hierarchy when listing wiki pages. !8133 (Alex Braha Stoll)
- Migrate SlackService and MattermostService from build_events to pipeline_events, and migrate BuildsEmailService to PipelinesEmailService. Update Hipchat to use pipeline events rather than build events. !8196
- Execute web hooks for WikiPage delete operation. !8198
- Added external environment link to web terminal view. !8303
- Responsive title in diffs inline, side by side, with and without sidebar. !8475
- Bypass email domain validation when a user is created by an admin. !8575 (Reza Mohammadi @remohammadi)
- API: Paginate all endpoints that return an array. !8606 (Robert Schilling)
- pass in current_user in MergeRequest and MergeRequestsHelper. !8624 (Dongqing Hu)
- Add user & build links in Slack Notifications. !8641 (Poornima M)
- Todo done clicking is kind of unusable. !8691 (Jacopo Beschi @jacopo-beschi)
- Filter todos by manual add. !8691 (Jacopo Beschi @jacopo-beschi)
- Add runner version to /admin/runners view. !8733 (Jonathon Reinhart)
- API: remove `public` param for projects. !8736
- Allow creating nested groups via UI. !8786
- API: Add environment stop action. !8808
- Add discussion events to contributions calendar. !8821
- Unify issues search behavior by always filtering when ALL labels matches. !8849
- V3 deprecated templates endpoints removal. !8853
- Expose pipelines as PipelineBasic `api/v3/projects/:id/pipelines`. !8875
- Alphabetically sort tags on runner list. !8922 (blackst0ne)
- Added documentation for permalinks to most recent build artifacts. !8934 (Christian Godenschwager)
- Standardize branch name params as branch on V4 API. !8936
- Move /projects/fork/:id to /projects/:id/fork. !8940
- Fix small height of activity header page. !8952 (Pavel Sorokin)
- Optionally make users created via the API set their password. !8957 (Joost Rijneveld)
- GitHub Importer - Find users based on GitHub email address. !8958
- API: Consolidate /projects endpoint. !8962
- Add filtered search visual tokens. !8969
- Store group and project full name and full path in routes table. !8979
- Add internal API to notify Gitaly of post receive. !8983
- Remove inactive default email services. !8987
- Option to prevent signing in from multiple ips. !8998
- Download snippets with LF line-endings by default. !8999
- Fixes dropdown width in admin project page. !9002
- fixes issue number alignment problem in MR and issue list. !9020
- Fix CI/CD pipeline retry and take stages order into account. !9021
- Make stuck builds detection more performant. !9025
- Filter by projects in the end of search. !9030
- Add nested groups to the API. !9034
- Use ETag to improve performance of issue notes polling. !9036
- Add the oauth2_generic OmniAuth strategy. !9048 (Joe Marty)
- Brand header logo for pipeline emails. !9049 (Alexis Reigel)
- replace npm with yarn and add yarn.lock. !9055
- Fix displaying error messages for create label dropdown. !9058 (Tom Koole)
- Set dropdown height fixed to 250px and make it scrollable. !9063
- Update API docs for new namespace format. !9073 (Markus Koller)
- Replace static fixture for behaviors/quick_submit_spec.js. !9086 (winniehell)
- Use iids as filter parameter. !9096
- Manage user personal access tokens through api and add impersonation tokens. !9099 (Simon Vocella)
- Added the ability to copy a branch name to the clipboard. !9103 (Glenn Sayers)
- Rename Files::DeleteService to Files::DestroyService. !9110 (dixpac)
- Fixes FE Doc broken link. !9120
- Add git version to gitlab:env:info. !9128 (Semyon Pupkov)
- Replace static fixture for new_branch_spec.js. !9131 (winniehell)
- Reintroduce coverage report for JavaScript. !9133 (winniehell)
- Fix MR widget jump. !9146
- Avoid calling Build#trace_with_state for performance. !9149 (Takuya Noguchi)
- fix background color for labels mention in todo. !9155 (mhasbini)
- Replace static fixture for behaviors/requires_input_spec.js. !9162 (winniehell)
- Added AsciiDoc Snippet to CI/CD Badges. !9164 (Jan Christophersen)
- Make Karma output look nicer for CI. !9165 (winniehell)
- show 99+ for large count in todos notification bell. !9171 (mhasbini)
- Replace static fixture for header_spec.js. !9174 (winniehell)
- Replace static fixture for project_title_spec.js. !9175 (winniehell)
- Fixes markdown in activity-feed is gray. !9179
- Show notifications settings dropdown even if repository feature is disabled. !9180
- Fixes job dropdown action throws error in js console. !9182
- Set maximum width for mini pipeline graph text so it is not truncated to early. !9188
- Added 'Most Recent Activity' header to the User Profile page. !9189 (Jan Christophersen)
- Show Issues mentioned / being closed from a Merge Requests title below the 'Accept Merge Request' button. !9194 (Jan Christophersen)
- Stop linking to deleted Branches in Activity tabs. !9203 (Jan Christophersen)
- Make it possible to pass coverage value to commit status API. !9214 (wendy0402)
- Add admin setting for default artifacts expiration. !9219
- add :iids param to IssuableFinder (resolve technical dept). !9222 (mhasbini)
- Add Links to Branches in Calendar Activity. !9224 (Jan Christophersen)
- Fix pipeline retry and cancel buttons on pipeline details page. !9225
- Remove es6 file extension from JavaScript files. !9241 (winniehell)
- Add Runner's registration/deletion v4 API. !9246
- Add merge request count to each issue on issues list. !9252 (blackst0ne)
- Fix error in MR widget after /merge slash command. !9259
- Clean-up Project navigation order. !9272
- Add Runner's jobs v4 API. !9273
- Add pipeline trigger API with user permissions. !9277
- Enhanced filter issues layout for better mobile experiance. !9280 (Pratik Borsadiya)
- Move babel config for instanbul to karma config. !9286 (winniehell)
- Document U2F limitations with multiple URLs. !9300
- Wrap long Project and Group titles. !9301
- Clean-up Groups navigation order. !9309
- Truncate long Todo titles for non-mobile screens. !9311
- add rake tasks to handle yarn dependencies and update documentation. !9316
- API: - Make subscription API more RESTful. Use `post ":project_id/:subscribable_type/:subscribable_id/subscribe"` to subscribe and `post ":project_id/:subscribable_type/:subscribable_id/unsubscribe"` to unsubscribe from a resource. !9325 (Robert Schilling)
- API: Moved `DELETE /projects/:id/star` to `POST /projects/:id/unstar`. !9328 (Robert Schilling)
- API: Use `visibility` as string parameter everywhere. !9337
- Add the Username to the HTTP(S) clone URL of a Repository. !9347 (Jan Christophersen)
- Add spec for todo with target_type Commit. !9351 (George Andrinopoulos)
- API: Remove `DELETE projects/:id/deploy_keys/:key_id/disable`. !9365 (Robert Schilling)
- Fixes includes line number during unfold copy n paste in parallel diff view. !9365
- API: Use POST to (un)block a user. !9371 (Robert Schilling)
- Remove markup that was showing in tooltip for renamed files. !9374
- Drop unused ci_projects table and some unused project_id columns, then rename gl_project_id to project_id. Stop exporting job trace when exporting projects. !9378 (David Wagner)
- Adds remote logout functionality to the Authentiq OAuth provider. !9381 (Alexandros Keramidas)
- Introduce /award slash command; Allow posting of just an emoji in comment. !9382 (mhasbini)
- API: Remove deprecated fields Notes#upvotes and Notes#downvotes. !9384 (Robert Schilling)
- Redo internals of Incoming Mail Support. !9385
- update Vue to v2.1.10. !9386
- Add button to create issue for failing build. !9391 (Alex Sanford)
- test compiling production assets and generate webpack bundle report in CI. !9396
- API: Return 204 for all delete endpoints. !9397 (Robert Schilling)
- Add KUBE_CA_PEM_FILE, deprecate KUBE_CA_PEM. !9398
- API: Use POST requests to mark todos as done. !9410 (Robert Schilling)
- API project create: Make name or path required. !9416
- Add housekeeping endpoint for Projects API. !9421
- Fixes delimiter removes when todo marked as done. !9435
- Document when current coverage configuration option was introduced. !9443
- Uploaded files which content can change now require revalidation on each page load. !9453
- Only add a newline in the Markdown Editor if the current line is not empty. !9455 (Jan Christophersen)
- Rename builds to job for the v4 API. !9463
- API: Remove /groups/owned endpoint. !9505 (Robert Schilling)
- API: Return 400 for all validation erros in the mebers API. !9523 (Robert Schilling)
- Fixes large file name tooltip cutoff in diff header. !9529
- Keep consistent in handling indexOf results. !9531 (Takuya Noguchi)
- Make documentation of list repository tree API call more detailed. !9532 (Marius Kleiner)
- Fix Sort dropdown reflow issue. !9533 (Jarkko Tuunanen)
- Improve grammar in GitLab flow documentation. !9552 (infogrind)
- Change default project view for user from readme to files view. !9584
- Make it possible to configure blocking manual actions. !9585
- Show public RSS feeds to anonymous users. !9596 (Michael Kozono)
- Update storage settings to allow extra values per repository storage. !9597
- Enable filtering milestones by search criteria in the API. !9606
- Ensure archive download is only one directory deep. !9616
- Fix updaing commit status when using optional attributes. !9618
- Add filter and sorting to dashboard groups page. !9619
- Remove deprecated build status badge and related services. !9620
- Remove the newrelic gem. !9622 (Robert Schilling)
- Rename table ci_commits to ci_pipelines. !9638
- Remove various unused CI tables and columns. !9639
- Use webpack CommonsChunkPlugin to place common javascript libraries in their own bundles. !9647
- CORS: Whitelist pagination headers. !9651 (Robert Schilling)
- Remove "subscribed" field from API responses returning list of issues or merge requests. !9661
- Highlight line number if specified on diff pages when page loads. !9664
- Set default cache key to "default" for jobs. !9666
- Set max height to screen height for Zen mode. !9667
- GET 'projects/:id/repository/commits' endpoint improvements. !9679 (George Andrinopoulos, Jordan Ryan Reuter)
- Restore keyboard shortcuts for "Activity" and "Charts". !9680
- Added commit array to Syshook json. !9685 (Gabriele Pongelli)
- Document ability to list issues with no labels using API. !9697 (Vignesh Ravichandran)
- Fix typo in GitLab config file. !9702 (medied)
- Fix json response in branches controller. !9710 (George Andrinopoulos)
- Refactor dropdown_assignee_spec. !9711 (George Andrinopoulos)
- Delete artifacts for pages unless expiry date is specified. !9716
- Use gitlab-workhorse 1.4.0. !9724
- Add GET /projects/:id/pipelines/:pipeline_id/jobs endpoint. !9727
- Restrict nested group names to prevent ambiguous routes. !9738
- Rename job environment variables to new terminology. !9756
- Deprecate usage of `types` configuration entry to describe CI/CD stages. !9766
- Moved project settings from the gear drop-down menu to a tab. !9786
- Fix "passed with warnings" stage status on MySQL installations. !9802
- Fix for creating a project through API when import_url is nil. !9841
- Use GitLab Pages v0.4.0. !9896
- Reserve few project and nested group paths that have wildcard routes associated. !9898
- Speed up project dashboard by caching pipeline status and eager loading routes. !9903
- Fixes n+1 query for tags and branches index page. !9905
- Hide ancestor groups in the share group dropdown list. !9965
- Allow creating merge request even if target branch is not specified in query params. !9968
- Removed d3 from the main application.js bundle. !10062
- Return 404 in project issues API endpoint when project cannot be found. !10093
- Fix positioning of `Scroll to top` button.
- Add limit to the number of events showed in cycle analytics.
- Only run timeago loops after rendering timeago components.
- Increase right side of file header to button stays on same line.
- Centers loading icon vertically and horizontally in pipelines table in commit view.
- Fix issues mentioned but not closed for external issue trackers.
- fix milestone does not automatically assign when create issue from milestone.
- Re-add Assign to me link to Merge Request and Issues.
- Format timeago date to short format.
- Fix errors in slash commands matcher, add simple test coverage. (YarNayar)
- Make Git history follow renames again by performing the --skip in Ruby.
- Added option to update to owner for group members.
- Pick up option from GDK to disable webpack dev server livereload.
- Introduce Pipeline Triggers that are user-aware.
- Fixed loading spinner position on issue template toggle.
- Removed duplicate "Visibility Level" label on New Project page. (Robert Marcano)
- Fix 'New Tag' layout on Tags page. (Robert Marcano)
- Update API endpoints for raw files.
- Fix issuable stale object error handler for js when updating tasklists.
- Gather issuable metadata to avoid n+1 queries on index view.
- Remove JIRA closed status icon.
- Fix z index issues with sidebar.
- Fixed long file names overflowing under action buttons.
- Only show public emails in atom feeds.
- Add Mock CI service/integration for development.
- Move tag services to Tags namespace. (dixpac)
- Set Auto-Submitted header to mails. (Semyon Pupkov)
- Improved diff comment button UX.
- Adds API endpoint to fetch all merge request for a single milestone. (Joren De Groof)
- Only create unmergeable todos once when MR fails to merge.
- Only yield valid references in ReferenceFilter.references_in.
- Add member: Always return 409 when a member exists.
- Remove plus icon from MR button on compare view.
- Re-add the New Project button in nav bar.
- Default to subtle MR mege button until CI status is available.
- Rename priority sorting option to label priority.
- Added headers to protected branch access dropdowns.
- Hide issue info when project issues are disabled. (George Andrinopoulos)
- removed unused parameter 'status_only: true'.
- Left align logo.
- Replaced jQuery UI datepicker.
- Removed jQuery UI highlight & autocomplete.
- Replaced jQuery UI sortable.
- Remove readme-only project view preference.
- Remove tooltips from label subscription buttons.
- Rename retry failed button on pipeline page to just retry.
- Align bulk update issues button to the right.
- Remove remnants of git annex support.
- Dispatch needed JS when creating a new MR in diff view.
- Change project count limit from 10 to 100000.
- Remove repeated routes.path check for postgresql database. (mhasbini)
- Fixed RSS button alignment on activity pages.
- Seed abuse reports for development.
- Bump Hashie to 3.5.5 and omniauth to 1.4.2 to eliminate warning noise.
- Add user deletion permission check in `Users::DestroyService`.
- Fix snippets search result spacing.
- Sort builds in stage dropdown.
- SSH key field updates title after pasting key.
- To protect against Server-side Request Forgery project import URLs are now prohibited against localhost or the server IP except for the assigned instance URL and port. Imports are also prohibited from ports below 1024 with the exception of ports 22, 80, and 443.
- Remove fixed positioning from top nav.
- Deduplicate markdown task lists.
- update issue count when closing/reopening an issue.
- Update code editor (ACE) to 1.2.6, to fix input problems with compose key.
- Improves a11y in sidebar by adding aria-hidden attributes in i tags and by fixing two broken aria-hidden attributes.
- Use redis channel to post notifications.
- Removed top border from user contribution calendar.
- Added user callouts to the projects dashboard and user profile.
- Removes label when moving issue to another list that it is currently in.
- Return 202 with JSON body on async removals on V4 API.
- Add filtered search to MR page.
- Add frequently used emojis back to awards menu.
- don't animate logo when downloading files.
- Stop setting Strict-Transport-Securty header from within the app.
- Use "branch_name" instead "branch" on V3 branch creation API.
- Fix archive prefix bug for refs containing dots.
- ensure MR widget dropdown is same color as button.
- Adds Pending and Finished tabs to pipelines page.
- Decrease tanuki logo size.
- Add all available statuses to scope filter for project builds endpoint. (George Andrinopoulos)
- Add filter param for project membership for current_user in API v4.
- Remove help link from right dropdown.
- Fix jobs table header height.
- Combined deploy keys, push rules, protect branches and mirror repository settings options into a single one called Repository.
- Add storage class configuration option for Amazon S3 remote backups. (Jon Keys)
- Specify in the documentation that only projects owners can transfer projects.
- Use native unicode emojis.
- Clear ActiveRecord connections before starting Sidekiq.
- Update account view to display new username.
- Narrow environment payload by using basic project details resource.
- Creating a new branch from an issue will automatically initialize a repository if one doesn't already exist.
- Dashboard project search keeps selected sort & filters.
- Visually show expanded diff lines cant have comments.
- Use full group name in GFM group reference title.
- Make a default namespace of Kubernetes service to contain project ID.
- Present GitLab version for each V3 to V4 API change on v3_to_v4.md.
- Add badges to global dropdown.
- Changed coverage reg expression placeholder text to be more like a placeholder.
- Show members of parent groups on project members page.
- Fix grammer issue in admin/runners.
- Allow slashes in slash command arguments.
- Adds paginationd and folders view to environments table.
- hide loading spinners for server-rendered sidebar fields.
- Change development tanuki favicon colors to match logo color order.
- API issues - support filtering by iids.

## 8.17.8 (2017-08-09)

- Remove hidden symlinks from project import files.
- Disallow Git URLs that include a username or hostname beginning with a non-alphanumeric character.

## 8.17.7 (2017-07-19)

- Renders 404 if given project is not readable by the user on Todos dashboard.
- Fix incorrect project authorizations.

## 8.17.6 (2017-05-05)

- Enforce project features when searching blobs and wikis.
- Fixed branches dropdown rendering branch names as HTML.
- Make Asciidoc & other markup go through pipeline to prevent XSS.
- Validate URLs in markdown using URI to detect the host correctly.
- Fix for XSS in project import view caused by Hamlit filter usage.
- Sanitize submodule URLs before linking to them in the file tree view.
- Refactor snippets finder & dont return internal snippets for external users.
- Fix snippets visibility for show action - external users can not see internal snippets.

## 8.17.5 (2017-04-05)

- Don’t show source project name when user does not have access.
- Remove the class attribute from the whitelist for HTML generated from Markdown.
- Fix path disclosure in project import/export.
- Fix for open redirect vulnerability using continue[to] in URL when requesting project import status.
- Fix for open redirect vulnerabilities in todos, issues, and MR controllers.

## 8.17.4 (2017-03-19)

- Only show public emails in atom feeds.
- To protect against Server-side Request Forgery project import URLs are now prohibited against localhost or the server IP except for the assigned instance URL and port. Imports are also prohibited from ports below 1024 with the exception of ports 22, 80, and 443.

## 8.17.3 (2017-03-07)

- Fix the redirect to custom home page URL. !9518
- Fix broken migration when upgrading straight to 8.17.1. !9613
- Make projects dropdown only show projects you are a member of. !9614
- Fix creating a file in an empty repo using the API. !9632
- Don't copy tooltip when copying GFM.
- Fix cherry-picking or reverting through an MR.

## 8.17.2 (2017-03-01)

- Expire all webpack assets after 8.17.1 included a badly compiled asset. !9602

## 8.17.1 (2017-02-28)

- Replace setInterval with setTimeout to prevent highly frequent requests. !9271 (Takuya Noguchi)
- Disable unused tags count cache for Projects, Builds and Runners.
- Spam check and reCAPTCHA improvements.
- Allow searching issues for strings containing colons.
- Disabled tooltip on add issues button in usse boards.
- Fixed commit search UI.
- Fix MR changes tab size count when there are over 100 files in the diff.
- Disable invalid service templates.
- Use default branch as target_branch when parameter is missing.
- Upgrade GitLab Pages to v0.3.2.
- Add performance query regression fix for !9088 affecting #27267.
- Chat slash commands show labels correctly.

## 8.17.0 (2017-02-22)

- API: Fix file downloading. !0 (8267)
- Changed composer installer script in the CI PHP example doc. !4342 (Jeffrey Cafferata)
- Display fullscreen button on small screens. !5302 (winniehell)
- Add system hook for when a project is updated (other than rename/transfer). !5711 (Tommy Beadle)
- Fix notifications when set at group level. !6813 (Alexandre Maia)
- Project labels can now be promoted to group labels. !7242 (Olaf Tomalka)
- use webpack to bundle frontend assets and use karma for frontend testing. !7288
- Adds back ability to stop all environments. !7379
- Added labels empty state. !7443
- Add ability to define a coverage regex in the .gitlab-ci.yml. !7447 (Leandro Camargo)
- Disable automatic login after clicking email confirmation links. !7472
- Search feature: redirects to commit page if query is commit sha and only commit found. !8028 (YarNayar)
- Create a TODO for user who set auto-merge when a build fails, merge conflict occurs. !8056 (twonegatives)
- Don't group issues by project on group-level and dashboard issue indexes. !8111 (Bernardo Castro)
- Mark MR as WIP when pushing WIP commits. !8124 (Jurre Stender @jurre)
- Flag multiple empty lines in eslint, fix offenses. !8137
- Add sorting pipeline for a commit. !8319 (Takuya Noguchi)
- Adds service trigger events to api. !8324
- Update pipeline and commit links when CI status is updated. !8351
- Hide version check image if there is no internet connection. !8355 (Ken Ding)
- Prevent removal of input fields if it is the parent dropdown element. !8397
- Introduce maximum session time for terminal websocket connection. !8413
- Allow creating protected branches when user can merge to such branch. !8458
- Refactor MergeRequests::BuildService. !8462 (Rydkin Maxim)
- Added GitLab Pages to CE. !8463
- Support notes when a project is not specified (personal snippet notes). !8468
- Use warning icon in mini-graph if stage passed conditionally. !8503
- Don’t count tasks that are not defined as list items correctly. !8526
- Reformat messages ChatOps. !8528
- Copy commit SHA to clipboard. !8547
- Improve button accessibility on pipelines page. !8561
- Display project ID in project settings. !8572 (winniehell)
- PlantUML support for Markdown. !8588 (Horacio Sanson)
- Fix reply by email without sub-addressing for some clients from Microsoft and Apple. !8620
- Fix nested tasks in ordered list. !8626
- Fix Sort by Recent Sign-in in Admin Area. !8637 (Poornima M)
- Avoid repeated dashes in $CI_ENVIRONMENT_SLUG. !8638
- Only show Merge Request button when user can create a MR. !8639
- Prevent copying of line numbers in parallel diff view. !8706
- Improve build policy and access abilities. !8711
- API: Remove /projects/:id/keys/.. endpoints. !8716 (Robert Schilling)
- API: Remove deprecated 'expires_at' from project snippets. !8723 (Robert Schilling)
- Add `copy` backup strategy to combat file changed errors. !8728
- adds avatar for discussion note. !8734
- Add link verification to badge partial in order to render a badge without a link. !8740
- Reduce hits to LDAP on Git HTTP auth by reordering auth mechanisms. !8752
- prevent diff unfolding link from appearing when there are no more lines to show. !8761
- Redesign searchbar in admin project list. !8776
- Rename Builds to Pipelines, CI/CD Pipelines, or Jobs everywhere. !8787
- dismiss sidebar on repo buttons click. !8798 (Adam Pahlevi)
- fixed small mini pipeline graph line glitch. !8804
- Make all system notes lowercase. !8807
- Support unauthenticated LFS object downloads for public projects. !8824 (Ben Boeckel)
- Add read-only full_path and full_name attributes to Group API. !8827
- allow relative url change without recompiling frontend assets. !8831
- Use vue.js Pipelines table in commit and merge request view. !8844
- Use reCaptcha when an issue is identified as a spam. !8846
- resolve deprecation warnings. !8855 (Adam Pahlevi)
- Cop for gem fetched from a git source. !8856 (Adam Pahlevi)
- Remove flash warning from login page. !8864 (Gerald J. Padilla)
- Adds documentation for how to use Vue.js. !8866
- Add 'View on [env]' link to blobs and individual files in diffs. !8867
- Replace word user with member. !8872
- Change the reply shortcut to focus the field even without a selection. !8873 (Brian Hall)
- Unify MR diff file button style. !8874
- Unify projects search by removing /projects/:search endpoint. !8877
- Fix disable storing of sensitive information when importing a new repo. !8885 (Bernard Pietraga)
- Fix pipeline graph vertical spacing in Firefox and Safari. !8886
- Fix filtered search user autocomplete for gitlab instances that are hosted on a subdirectory. !8891
- Fix Ctrl+Click support for Todos and Merge Request page tabs. !8898
- Fix wrong call to ProjectCacheWorker.perform. !8910
- Don't perform Devise trackable updates on blocked User records. !8915
- Add ability to export project inherited group members to Import/Export. !8923
- replace `find_with_namespace` with `find_by_full_path`. !8949 (Adam Pahlevi)
- Fixes flickering of avatar border in mention dropdown. !8950
- Remove unnecessary queries for .atom and .json in Dashboard::ProjectsController#index. !8956
- Fix deleting projects with pipelines and builds. !8960
- Fix broken anchor links when special characters are used. !8961 (Andrey Krivko)
- Ensure autogenerated title does not cause failing spec. !8963 (brian m. carlson)
- Update doc for enabling or disabling GitLab CI. !8965 (Takuya Noguchi)
- Remove deprecated MR and Issue endpoints and preserve V3 namespace. !8967
- Fixed "substract" typo on /help/user/project/slash_commands. !8976 (Jason Aquino)
- Preserve backward compatibility CI/CD and disallow setting `coverage` regexp in global context. !8981
- use babel to transpile all non-vendor javascript assets regardless of file extension. !8988
- Fix MR widget url. !8989
- Fixes hover cursor on pipeline pagenation. !9003
- Layer award emoji dropdown over the right sidebar. !9004
- Do not display deploy keys in user's own ssh keys list. !9024
- upgrade babel 5.8.x to babel 6.22.x. !9072
- upgrade to webpack v2.2. !9078
- Trigger autocomplete after selecting a slash command. !9117
- Add space between text and loading icon in Megre Request Widget. !9119
- Fix job to pipeline renaming. !9147
- Replace static fixture for merge_request_tabs_spec.js. !9172 (winniehell)
- Replace static fixture for right_sidebar_spec.js. !9211 (winniehell)
- Show merge errors in merge request widget. !9229
- Increase process_commit queue weight from 2 to 3. !9326 (blackst0ne)
- Don't require lib/gitlab/request_profiler/middleware.rb in config/initializers/request_profiler.rb.
- Force new password after password reset via API. (George Andrinopoulos)
- Allows to search within project by commit hash. (YarNayar)
- Show organisation membership and delete comment on smaller viewports, plus change comment author name to username.
- Remove turbolinks.
- Convert pipeline action icons to svg to have them propperly positioned.
- Remove rogue scrollbars for issue comments with inline elements.
- Align Segoe UI label text.
- Color + and - signs in diffs to increase code legibility.
- Fix tab index order on branch commits list page. (Ryan Harris)
- Add hover style to copy icon on commit page header. (Ryan Harris)
- Remove hover animation from row elements.
- Improve pipeline status icon linking in widgets.
- Fix commit title bar and repository view copy clipboard button order on last commit in repository view.
- Fix mini-pipeline stage tooltip text wrapping.
- Updated builds info link on the project settings page. (Ryan Harris)
- 27240 Make progress bars consistent.
- Only render hr when user can't archive project.
- 27352-search-label-filter-header.
- Include :author, :project, and :target in Event.with_associations.
- Don't instantiate AR objects in Event.in_projects.
- Don't capitalize environment name in show page.
- Update and pin the `jwt` gem to ~> 1.5.6.
- Edited the column header for the environments list from created to updated and added created to environments detail page colum header titles.
- Give ci status text on pipeline graph a better font-weight.
- Add default labels to bulk assign dropdowns.
- Only return target project's comments for a commit.
- Fixes Pipelines table is not showing branch name for commit.
- Fix regression where cmd-click stopped working for todos and merge request tabs.
- Fix stray pipelines API request when showing MR.
- Fix Merge request pipelines displays JSON.
- Fix current build arrow indicator.
- Fix contribution activity alignment.
- Show Pipeline(not Job) in MR desktop notification.
- Fix tooltips in mini pipeline graph.
- Display loading indicator when filtering ref switcher dropdown.
- Show pipeline graph in MR widget if there are any stages.
- Fix icon colors in merge request widget mini graph.
- Improve blockquote formatting in notification emails.
- Adds container to tooltip in order to make it work with overflow:hidden in parent element.
- Restore pagination to admin abuse reports.
- Ensure export files are removed after a namespace is deleted.
- Add `y` keyboard shortcut to move to file permalink.
- Adds /target_branch slash command functionality for merge requests. (YarNayar)
- Patch Asciidocs rendering to block XSS.
- contribution calendar scrolls from right to left.
- Copying a rendered issue/comment will paste into GFM textareas as actual GFM.
- Don't delete assigned MRs/issues when user is deleted.
- Remove new branch button for confidential issues.
- Don't allow project guests to subscribe to merge requests through the API. (Robert Schilling)
- Don't connect in Gitlab::Database.adapter_name.
- Prevent users from creating notes on resources they can't access.
- Ignore encrypted attributes in Import/Export.
- Change rspec test to guarantee window is resized before visiting page.
- Prevent users from deleting system deploy keys via the project deploy key API.
- Fix XSS vulnerability in SVG attachments.
- Make MR-review-discussions more reliable.
- fix incorrect sidekiq concurrency count in admin background page. (wendy0402)
- Make notification_service spec DRYer by making test reusable. (YarNayar)
- Redirect http://someproject.git to http://someproject. (blackst0ne)
- Fixed group label links in issue/merge request sidebar.
- Improve gl.utils.handleLocationHash tests.
- Fixed Issuable sidebar not closing on smaller/mobile sized screens.
- Resets assignee dropdown when sidebar is open.
- Disallow system notes for closed issuables.
- Fix timezone on issue boards due date.
- Remove unused js response from refs controller.
- Prevent the GitHub importer from assigning labels and comments to merge requests or issues belonging to other projects.
- Fixed merge requests tab extra margin when fixed to window.
- Patch XSS vulnerability in RDOC support.
- Refresh authorizations when transferring projects.
- Remove issue and MR counts from labels index.
- Don't use backup Active Record connections for Sidekiq.
- Add index to ci_trigger_requests for commit_id.
- Add indices to improve loading of labels page.
- Reduced query count for snippet search.
- Update GitLab Pages to v0.3.1.
- Upgrade omniauth gem to 1.3.2.
- Remove deprecated GitlabCiService.
- Requeue pending deletion projects.

## 8.16.9 (2017-04-05)

- Don’t show source project name when user does not have access.
- Remove the class attribute from the whitelist for HTML generated from Markdown.
- Fix path disclosure in project import/export.
- Fix for open redirect vulnerability using continue[to] in URL when requesting project import status.
- Fix for open redirect vulnerabilities in todos, issues, and MR controllers.

## 8.16.8 (2017-03-19)

- Only show public emails in atom feeds.
- To protect against Server-side Request Forgery project import URLs are now prohibited against localhost or the server IP except for the assigned instance URL and port. Imports are also prohibited from ports below 1024 with the exception of ports 22, 80, and 443.

## 8.16.7 (2017-02-27)

- Fix MR changes tab size count when there are over 100 files in the diff.

## 8.16.6 (2017-02-17)

- API: Fix file downloading. !0 (8267)
- Reduce hits to LDAP on Git HTTP auth by reordering auth mechanisms. !8752
- Fix filtered search user autocomplete for gitlab instances that are hosted on a subdirectory. !8891
- Fix wrong call to ProjectCacheWorker.perform. !8910
- Remove unnecessary queries for .atom and .json in Dashboard::ProjectsController#index. !8956
- Fix broken anchor links when special characters are used. !8961 (Andrey Krivko)
- Do not display deploy keys in user's own ssh keys list. !9024
- Show merge errors in merge request widget. !9229
- Don't delete assigned MRs/issues when user is deleted.
- backport of EE fix !954.
- Refresh authorizations when transferring projects.
- Don't use backup Active Record connections for Sidekiq.
- Check public snippets for spam.

## 8.16.5 (2017-02-14)

- Patch Asciidocs rendering to block XSS.
- Fix XSS vulnerability in SVG attachments.
- Prevent the GitHub importer from assigning labels and comments to merge requests or issues belonging to other projects.
- Patch XSS vulnerability in RDOC support.

## 8.16.4 (2017-02-02)

- Support non-ASCII characters in GFM autocomplete. !8729
- Fix search bar search param encoding. !8753
- Fix project name label's for reference in project settings. !8795
- Fix filtering with multiple words. !8830
- Fixed services form cancel not redirecting back the integrations settings view. !8843
- Fix filtering usernames with multiple words. !8851
- Improve performance of slash commands. !8876
- Remove old project members when retrying an export.
- Fix permalink discussion note being collapsed.
- Add project ID index to `project_authorizations` table to optimize queries.
- Check public snippets for spam.
- 19164 Add settings dropdown to mobile screens.

## 8.16.3 (2017-01-27)

- Add caching of droplab ajax requests. !8725
- Fix access to the wiki code via HTTP when repository feature disabled. !8758
- Revert 3f17f29a. !8785
- Fix race conditions for AuthorizedProjectsWorker.
- Fix autocomplete initial undefined state.
- Fix Error 500 when repositories contain annotated tags pointing to blobs.
- Fix /explore sorting.
- Fixed label dropdown toggle text not correctly updating.

## 8.16.2 (2017-01-25)

- allow issue filter bar to be operated with mouse only. !8681
- Fix CI requests concurrency for newer runners that prevents from picking pending builds (from 1.9.0-rc5). !8760
- Add some basic fixes for IE11/Edge.
- Remove blue border from comment box hover.
- Fixed bug where links in merge dropdown wouldn't work.

## 8.16.1 (2017-01-23)

- Ensure export files are removed after a namespace is deleted.
- Don't allow project guests to subscribe to merge requests through the API. (Robert Schilling)
- Prevent users from creating notes on resources they can't access.
- Prevent users from deleting system deploy keys via the project deploy key API.
- Upgrade omniauth gem to 1.3.2.

## 8.16.0 (2017-01-22)

- Add LDAP Rake task to rename a provider. !2181
- Validate label's title length. !5767 (Tomáš Kukrál)
- Allow to add deploy keys with write-access. !5807 (Ali Ibrahim)
- Allow to use + symbol in filenames. !6644 (blackst0ne)
- Search bar redesign first iteration. !7345
- Fix date inconsistency on due date picker. !7422 (Giuliano Varriale)
- Add email confirmation field to registration form. !7432
- Updated project visibility settings UX. !7645
- Go to a project order. !7737 (Jacopo Beschi @jacopo-beschi)
- Support slash comand `/merge` for merging merge requests. !7746 (Jarka Kadlecova)
- Add more storage statistics. !7754 (Markus Koller)
- Add support for PlantUML diagrams in AsciiDoc documents. !7810 (Horacio Sanson)
- Remove extra orphaned rows when removing stray namespaces. !7841
- Added lighter count badge background-color for on white backgrounds. !7873
- Fixes issue boards list colored top border visual glitch. !7898 (Pier Paolo Ramon)
- change 'gray' color theme name to 'black' to match the actual color. !7908 (BM5k)
- Remove trailing whitespace when generating changelog entry. !7948
- Remove checking branches state in issue new branch button. !8023
- Log LDAP blocking/unblocking events to application log. !8042 (Markus Koller)
- ensure permalinks scroll to correct position on multiple clicks. !8046
- Allow to use ENV variables in redis config. !8073 (Semyon Pupkov)
- fix button layout issue on branches page. !8074
- Reduce DB-load for build-queues by storing last_update in Redis. !8084
- Record and show last used date of SSH Keys. !8113 (Vincent Wong)
- Resolves overflow in compare branch and tags dropdown. !8118
- Replace wording for slash command confirmation message. !8123
- remove build_user. !8162 (Arsenev Vladislav)
- Prevent empty pagination when list is not empty. !8172
- Make successful pipeline emails off for watchers. !8176
- Improve copy in Issue Tracker empty state. !8202
- Adds CSS class to status icon on MR widget to prevent non-colored icon. !8219
- Improve visibility of "Resolve conflicts" and "Merge locally" actions. !8229
- Add Gitaly to the architecture documentation. !8264 (Pablo Carranza <pablo@gitlab.com>)
- Sort numbers in build names more intelligently. !8277
- Show nested groups tab on group page. !8308
- Rename users with namespace ending with .git. !8309
- Rename filename to file path in tooltip of file header in merge request diff. !8314
- About GitLab link in sidebar that links to help page. !8316
- Merged the 'Groups' and 'Projects' tabs when viewing user profiles. !8323 (James Gregory)
- re-enable change username button after failure. !8332
- Darkened hr border color in descriptions because of update of bootstrap. !8333
- display merge request discussion tab for empty branches. !8347
- Fix double spaced CI log. !8349 (Jared Deckard <jared.deckard@gmail.com>)
- Refactored note edit form to improve frontend performance on MR and Issues pages, especially pages with has a lot of discussions in it. !8356
- Make CTRL+Enter submits a new merge request. !8360 (Saad Shahd)
- Fixes too short input for placeholder message in commit listing page. !8367
- Fix typo: seach to search. !8370
- Adds label to Environments "Date Created". !8376 (Saad Shahd)
- Convert project setting text into protected branch path link. !8377 (Ken Ding)
- Precompile all JavaScript fixtures. !8384
- Use original casing for build action text. !8387
- Scroll to bottom on build completion if autoscroll was active. !8391
- Properly handle failed reCAPTCHA on user registration. !8403
- Changed alerts to be responsive, centered text on smaller viewports. !8424 (Connor Smallman)
- Pass Gitaly resource path to gitlab-workhorse if Gitaly is enabled. !8440
- Fixes and Improves CSS and HTML problems in mini pipeline graph and builds dropdown. !8443
- Don't instrument 405 Grape calls. !8445
- Change CI template linter textarea with Ace Editor. !8452 (Didem Acet)
- Removes unneeded `window` declaration in environments related code. !8456
- API: fix query response for `/projects/:id/issues?milestone="No%20Milestone"`. !8457 (Panagiotis Atmatzidis, David Eisner)
- Fix broken url on group avatar. !8464 (hogewest)
- Fixes buttons not being accessible via the keyboard when creating new group. !8469
- Restore backup correctly when "BACKUP" environment variable is passed. !8477
- Add new endpoints for Time Tracking. !8483
- Fix Compare page throws 500 error when any branch/reference is not selected. !8492 (Martin Cabrera)
- Treat environments matching `production/*` as Production. !8500
- Hide build artifacts keep button if operation is not allowed. !8501
- Update the gitlab-markup gem to the version 1.5.1. !8509
- Remove Lock Icon on Protected Tag. !8513 (Sergey Nikitin)
- Use cached values to compute total issues count in milestone index pages. !8518
- Speed up dashboard milestone index by scoping IssuesFinder to user authorized projects. !8524
- Copy <some text> to clipboard. !8535
- Check for env[Grape::Env::GRAPE_ROUTING_ARGS] instead of endpoint.route. !8544
- Fixes builds dropdown making request when clicked to be closed. !8545
- Fixes pipeline status cell is too wide by adding missing classes in table head cells. !8549
- Mutate the attribute instead of issuing a write operation to the DB in `ProjectFeaturesCompatibility` concern. !8552
- Fix links to commits pages on pipelines list page. !8558
- Ensure updating project settings shows a flash message on success. !8579 (Sandish Chen)
- Fixes big pipeline and small pipeline width problems and tooltips text being outside the tooltip. !8593
- Autoresize markdown preview. !8607 (Didem Acet)
- Link external build badge to its target URL. !8611
- Adjust ProjectStatistic#repository_size with values saved as MB. !8616
- Correct User-agent placement in robots.txt. !8623 (Eric Sabelhaus)
- Record used SSH keys only once per day. !8655
- Do not generate pipeline branch/tag path if not present. !8658
- Fix Merge When Pipeline Succeeds immediate merge bug. !8685
- Fix blame 500 error on invalid path. !25761 (Jeff Stubler)
- Added animations to issue boards interactions.
- Check if user can read project before being assigned to issue.
- Show 'too many changes' message for created merge requests when they are too large.
- Fix redirect after update file when user has forked project.
- Parse JIRA issue references even if Issue Tracker is disabled.
- Made download artifacts button accessible via keyboard by changing it from an anchor tag to an actual button. (Ryan Harris)
- Make play button on Pipelines page accessible via keyboard. (Ryan Harris)
- Decreases font-size on login page.
- Fixed merge request tabs dont move when opening collapsed sidebar.
- Display project avatars on Admin Area and Projects pages for mobile views. (Ryan Harris)
- Fix participants margins to fit on one line.
- 26352 Change Profile settings to User / Settings.
- Fix Commits API to accept a Project path upon POST.
- Expire related caches after changing HEAD. (Minqi Pan)
- Add various hover animations throughout the application.
- Re-order update steps in the 8.14 -> 8.15 upgrade guide.
- Move award emoji's out of the discussion tab for merge requests.
- Synchronize all project authorization refreshing work to prevent race conditions.
- Remove the project_authorizations.id column.
- Combined the settings options project members and groups into a single one called members.
- Change earlier to task_status_short to avoid titlebar line wraps.
- 25701 standardize text colors.
- Handle HTTP errors in environment list.
- Re-add Google Cloud Storage as a backup strategy.
- Change status colors of runners to better defaults.
- Added number_with_delimiter to counter on milestone panels. (Ryan Harris)
- Query external CI statuses in the background.
- Allow group and project paths when transferring projects via the API.
- Don't validate environment urls on .gitlab-ci.yml.
- Fix a Grape deprecation, use `#request_method` instead of `#route_method`.
- Fill missing authorized projects rows.
- Allow API query to find projects with dots in their name. (Bruno Melli)
- Fix import/export wrong user mapping.
- Removed bottom padding from merge manually from CLI because of repositioning award emoji's.
- Fix project queued for deletion re-creation tooltip.
- Fix search group/project filtering to show results.
- Fix 500 error when POSTing to Users API with optional confirm param.
- 26504 Fix styling of MR jump to discussion button.
- Add margin to markdown math blocks.
- Add hover state to MR comment reply button.

## 8.15.8 through 0.8.0

- See [changelogs/archive.md](changelogs/archive.md)
