/*
 * Decompiled with CFR 0.152.
 */
package freemind.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import freemind.common.PropertyBean;
import freemind.common.PropertyControl;
import freemind.common.TextTranslator;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class StringProperty
extends PropertyBean
implements PropertyControl {
    String description;
    String label;
    JTextField mTextField;

    public StringProperty(String description, String label) {
        this.initializeTextfield();
        this.description = description;
        this.label = label;
        this.mTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent pE) {
                StringProperty.this.firePropertyChangeEvent();
            }
        });
    }

    protected void initializeTextfield() {
        this.mTextField = new JTextField();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setValue(String value) {
        this.mTextField.setText(value);
        this.mTextField.selectAll();
    }

    @Override
    public String getValue() {
        return this.mTextField.getText();
    }

    @Override
    public void layout(DefaultFormBuilder builder, TextTranslator pTranslator) {
        JLabel label = builder.append(pTranslator.getText(this.getLabel()), (Component)this.mTextField);
        label.setToolTipText(pTranslator.getText(this.getDescription()));
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mTextField.setEnabled(pEnabled);
    }
}

