/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.html;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.CommandResources;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.dom.html.TableUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;

public class TableDeleteColumnCommand
extends DesignerCommand {
    private Element _tableEle;
    private int _columnIndex;
    private TableUtil _tableUtil;

    public TableDeleteColumnCommand(IHTMLGraphicalViewer viewer, Element dataTable, int index) {
        super(CommandResources.getString("TableDeleteColumnCommand.Label.DeleteColumn"), viewer);
        this._tableEle = dataTable;
        this._columnIndex = index;
        this._tableUtil = new TableUtil(this._tableEle);
    }

    public boolean canExecute() {
        if (this._columnIndex < 0) {
            return false;
        }
        boolean hasColSpan = this._tableUtil.hasColumnSpanElement(this._columnIndex);
        boolean isAffectedByColSpan = this._tableUtil.isAffectedByColSpan(this._columnIndex);
        if (hasColSpan || isAffectedByColSpan) {
            return false;
        }
        return super.canExecute();
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._tableEle);
    }

    protected void doExecute() {
        ArrayList trList = new ArrayList();
        TableUtil.getTrElements(this._tableEle, trList);
        List[] lists = this._tableUtil.getTrCellLists();
        int i = 0;
        int size = trList.size();
        while (i < size) {
            Element cell;
            Element tr = (Element)trList.get(i);
            List cells = lists[i];
            if (cells.size() > this._columnIndex && !(cell = (Element)cells.get(this._columnIndex)).getTagName().equalsIgnoreCase("fake")) {
                tr.removeChild(cell);
            }
            ++i;
        }
    }
}

