/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional.scanner;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.pde.api.tools.internal.CompilationUnit;
import org.eclipse.pde.api.tools.internal.JavadocTagManager;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;

public class TagScanner {
    private static TagScanner fSingleton = null;

    public static final TagScanner newScanner() {
        if (fSingleton == null) {
            fSingleton = new TagScanner();
        }
        return fSingleton;
    }

    private TagScanner() {
    }

    public void scan(ICompilationUnit unit, IApiDescription description, IApiTypeContainer container, IProgressMonitor monitor) throws CoreException {
        this.scan(new CompilationUnit(unit), description, container, unit.getJavaProject().getOptions(true), monitor);
    }

    public void scan(CompilationUnit source, IApiDescription description, IApiTypeContainer container, Map<String, String> options, IProgressMonitor monitor) throws CoreException {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ASTParser parser = ASTParser.newParser((int)10);
        InputStream inputStream = null;
        try {
            try {
                inputStream = source.getInputStream();
                parser.setSource(Util.getInputStreamAsCharArray(inputStream, -1, source.getEncoding()));
            }
            catch (FileNotFoundException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", MessageFormat.format("Compilation unit source not found: {0}", source.getName()), (Throwable)e));
            }
            catch (IOException e) {
                if (ApiPlugin.DEBUG_TAG_SCANNER) {
                    System.err.println(source.getName());
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", MessageFormat.format("Error reading compilation unit: {0}", source.getName()), (Throwable)e));
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        localmonitor.split(1);
        Hashtable loptions = options;
        if (loptions == null) {
            loptions = JavaCore.getOptions();
        }
        loptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions((Map)loptions);
        org.eclipse.jdt.core.dom.CompilationUnit cunit = (org.eclipse.jdt.core.dom.CompilationUnit)parser.createAST((IProgressMonitor)localmonitor.split(1));
        Visitor visitor = new Visitor(description, container);
        cunit.accept((ASTVisitor)visitor);
    }

    static class Visitor
    extends ASTVisitor {
        private IApiDescription fDescription = null;
        private IPackageDescriptor fPackage = Factory.packageDescriptor("");
        private IReferenceTypeDescriptor fType = null;
        private IApiTypeContainer fContainer = null;

        public Visitor(IApiDescription description, IApiTypeContainer container) {
            this.fDescription = description;
            this.fContainer = container;
        }

        private void enterType(SimpleName name) {
            this.fType = this.fType == null ? this.fPackage.getType(name.getFullyQualifiedName()) : this.fType.getType(name.getFullyQualifiedName());
        }

        private void exitType() {
            this.fType = this.fType.getEnclosingType();
        }

        public boolean visit(MarkerAnnotation node) {
            ASTNode parent;
            String name = node.getTypeName().getFullyQualifiedName();
            if (JavadocTagManager.ALL_ANNOTATIONS.contains(name) && (parent = node.getParent()) != null) {
                switch (parent.getNodeType()) {
                    case 55: {
                        this.scanTypeAnnotation(name, (TypeDeclaration)parent);
                        break;
                    }
                    case 71: 
                    case 81: {
                        int restrictions;
                        IApiAnnotations annots = this.fDescription.resolveAnnotations(this.fType);
                        int n = restrictions = annots != null ? annots.getRestrictions() : 0;
                        if (!"NoReference".equals(name)) break;
                        this.fDescription.setRestrictions(this.fType, restrictions |= 8);
                        break;
                    }
                    case 23: {
                        this.scanFieldAnnotation(name, (FieldDeclaration)parent);
                        break;
                    }
                    case 31: {
                        this.scanMethodAnnotation(name, (MethodDeclaration)parent);
                        break;
                    }
                }
            }
            return false;
        }

        void scanTypeAnnotation(String name, TypeDeclaration node) {
            int restrictions;
            int flags = node.getModifiers();
            IApiAnnotations annots = this.fDescription.resolveAnnotations(this.fType);
            int n = restrictions = annots != null ? annots.getRestrictions() : 0;
            if ("NoReference".equals(name)) {
                restrictions |= 8;
            }
            if ("NoExtend".equals(name) && !Flags.isFinal((int)flags)) {
                restrictions |= 2;
            }
            if (node.isInterface()) {
                if ("NoImplement".equals(name)) {
                    restrictions |= 1;
                }
            } else if ("NoInstantiate".equals(name) && !Flags.isAbstract((int)flags)) {
                restrictions |= 4;
            }
            if (restrictions != 0) {
                this.fDescription.setRestrictions(this.fType, restrictions);
            }
        }

        void scanFieldAnnotation(String name, FieldDeclaration node) {
            List fields = node.fragments();
            int flags = node.getModifiers();
            if (!Flags.isFinal((int)flags) && "NoReference".equals(name)) {
                for (VariableDeclarationFragment fragment : fields) {
                    IFieldDescriptor descriptor = this.fType.getField(fragment.getName().getFullyQualifiedName());
                    this.fDescription.setRestrictions(descriptor, 8);
                }
            }
        }

        void scanMethodAnnotation(String name, MethodDeclaration node) {
            String signature = Signatures.getMethodSignatureFromNode(node, true);
            if (signature != null) {
                int restrictions;
                IMethodDescriptor descriptor;
                block14: {
                    String methodname = node.getName().getFullyQualifiedName();
                    if (node.isConstructor()) {
                        methodname = "<init>";
                    }
                    descriptor = this.fType.getMethod(methodname, signature);
                    try {
                        descriptor = Factory.resolveMethod(this.fContainer, descriptor);
                    }
                    catch (CoreException e) {
                        if (!ApiPlugin.DEBUG_TAG_SCANNER) break block14;
                        System.err.println(e.getLocalizedMessage());
                    }
                }
                IApiAnnotations annots = this.fDescription.resolveAnnotations(descriptor);
                int n = restrictions = annots != null ? annots.getRestrictions() : 0;
                if ("NoReference".equals(name)) {
                    restrictions |= 8;
                }
                if ("NoOverride".equals(name) && !Flags.isFinal((int)node.getModifiers()) && !Flags.isStatic((int)node.getModifiers())) {
                    ASTNode parent = node.getParent();
                    if (parent instanceof TypeDeclaration) {
                        TypeDeclaration type = (TypeDeclaration)parent;
                        if (type.isInterface()) {
                            if (Flags.isDefaultMethod((int)node.getModifiers())) {
                                restrictions |= 0x10;
                            }
                        } else if (!Flags.isFinal((int)type.getModifiers())) {
                            restrictions |= 0x10;
                        }
                    } else if (parent instanceof AnonymousClassDeclaration) {
                        restrictions |= 0x10;
                    }
                }
                if (restrictions != 0) {
                    this.fDescription.setRestrictions(descriptor, restrictions);
                }
            }
        }

        public boolean visit(TypeDeclaration node) {
            if (this.isNotVisible(node.getModifiers())) {
                return false;
            }
            this.enterType(node.getName());
            this.scanTypeJavaDoc(node);
            return true;
        }

        void scanTypeJavaDoc(TypeDeclaration node) {
            Javadoc doc = node.getJavadoc();
            if (doc != null) {
                List tags = doc.tags();
                IApiAnnotations annots = this.fDescription.resolveAnnotations(this.fType);
                int restrictions = annots != null ? annots.getRestrictions() : 0;
                for (TagElement tag : tags) {
                    String tagname = tag.getTagName();
                    if (!JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
                    if ("@noreference".equals(tagname)) {
                        restrictions |= 8;
                    }
                    if (node.isInterface()) {
                        if ("@noextend".equals(tagname)) {
                            restrictions |= 2;
                            continue;
                        }
                        if (!"@noimplement".equals(tagname)) continue;
                        restrictions |= 1;
                        continue;
                    }
                    int flags = node.getModifiers();
                    if ("@noextend".equals(tagname) && !Flags.isFinal((int)flags)) {
                        restrictions |= 2;
                        continue;
                    }
                    if (!"@noinstantiate".equals(tagname) || Flags.isAbstract((int)flags)) continue;
                    restrictions |= 4;
                }
                if (restrictions != 0) {
                    this.fDescription.setRestrictions(this.fType, restrictions);
                }
            }
        }

        public void endVisit(TypeDeclaration node) {
            if (!this.isNotVisible(node.getModifiers())) {
                this.exitType();
            }
        }

        public void endVisit(AnnotationTypeDeclaration node) {
            if (!this.isNotVisible(node.getModifiers())) {
                this.exitType();
            }
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            if (this.isNotVisible(node.getModifiers())) {
                return false;
            }
            this.enterType(node.getName());
            this.scanAnnotationJavaDoc(node);
            return true;
        }

        void scanAnnotationJavaDoc(AnnotationTypeDeclaration node) {
            Javadoc doc = node.getJavadoc();
            if (doc != null) {
                List tags = doc.tags();
                IApiAnnotations annots = this.fDescription.resolveAnnotations(this.fType);
                int restrictions = annots != null ? annots.getRestrictions() : 0;
                for (TagElement tag : tags) {
                    String tagname = tag.getTagName();
                    if (!JavadocTagManager.ALL_TAGS.contains(tagname) || !"@noreference".equals(tagname)) continue;
                    this.fDescription.setRestrictions(this.fType, restrictions |= 8);
                }
            }
        }

        public boolean visit(EnumDeclaration node) {
            if (this.isNotVisible(node.getModifiers())) {
                return false;
            }
            this.enterType(node.getName());
            this.scanEnumJavaDoc(node);
            return true;
        }

        void scanEnumJavaDoc(EnumDeclaration node) {
            Javadoc doc = node.getJavadoc();
            if (doc != null) {
                List tags = doc.tags();
                IApiAnnotations annots = this.fDescription.resolveAnnotations(this.fType);
                int restrictions = annots != null ? annots.getRestrictions() : 0;
                for (TagElement tag : tags) {
                    String tagname = tag.getTagName();
                    if (!JavadocTagManager.ALL_TAGS.contains(tagname) || !"@noreference".equals(tagname)) continue;
                    this.fDescription.setRestrictions(this.fType, restrictions |= 8);
                }
            }
        }

        public void endVisit(EnumDeclaration node) {
            if (!this.isNotVisible(node.getModifiers())) {
                this.exitType();
            }
        }

        public boolean visit(PackageDeclaration node) {
            Name name = node.getName();
            this.fPackage = Factory.packageDescriptor(name.getFullyQualifiedName());
            return false;
        }

        public boolean visit(MethodDeclaration node) {
            if (this.isNotVisible(node.getModifiers())) {
                ASTNode parent = node.getParent();
                if (parent instanceof TypeDeclaration) {
                    TypeDeclaration type = (TypeDeclaration)parent;
                    if (!type.isInterface()) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            this.scanMethodJavaDoc(node);
            return true;
        }

        void scanMethodJavaDoc(MethodDeclaration node) {
            String signature;
            Javadoc doc = node.getJavadoc();
            if (doc != null && (signature = Signatures.getMethodSignatureFromNode(node, true)) != null) {
                IMethodDescriptor descriptor;
                block9: {
                    String methodname = node.getName().getFullyQualifiedName();
                    if (node.isConstructor()) {
                        methodname = "<init>";
                    }
                    descriptor = this.fType.getMethod(methodname, signature);
                    try {
                        descriptor = Factory.resolveMethod(this.fContainer, descriptor);
                    }
                    catch (CoreException e) {
                        if (!ApiPlugin.DEBUG_TAG_SCANNER) break block9;
                        System.err.println(e.getLocalizedMessage());
                    }
                }
                List tags = doc.tags();
                IApiAnnotations annots = this.fDescription.resolveAnnotations(descriptor);
                int restrictions = annots != null ? annots.getRestrictions() : 0;
                for (TagElement tag : tags) {
                    String tagname = tag.getTagName();
                    if (!JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
                    if ("@noreference".equals(tagname)) {
                        restrictions |= 8;
                    }
                    if (!"@nooverride".equals(tagname) || Flags.isFinal((int)node.getModifiers()) || Flags.isStatic((int)node.getModifiers())) continue;
                    ASTNode parent = node.getParent();
                    if (parent instanceof TypeDeclaration) {
                        TypeDeclaration type = (TypeDeclaration)parent;
                        if (type.isInterface()) {
                            if (!Flags.isDefaultMethod((int)node.getModifiers())) continue;
                            restrictions |= 0x10;
                            continue;
                        }
                        if (Flags.isFinal((int)type.getModifiers())) continue;
                        restrictions |= 0x10;
                        continue;
                    }
                    if (!(parent instanceof AnonymousClassDeclaration)) continue;
                    restrictions |= 0x10;
                }
                if (restrictions != 0) {
                    this.fDescription.setRestrictions(descriptor, restrictions);
                }
            }
        }

        public boolean visit(FieldDeclaration node) {
            if (this.isNotVisible(node.getModifiers())) {
                return false;
            }
            this.scanFieldJavaDoc(node);
            return true;
        }

        void scanFieldJavaDoc(FieldDeclaration node) {
            Javadoc doc = node.getJavadoc();
            if (doc != null) {
                List fields = node.fragments();
                List tags = doc.tags();
                int flags = node.getModifiers();
                for (TagElement tag : tags) {
                    String tagname = tag.getTagName();
                    if (!JavadocTagManager.ALL_TAGS.contains(tagname) || Flags.isFinal((int)flags) || !"@noreference".equals(tagname)) continue;
                    for (VariableDeclarationFragment fragment : fields) {
                        IFieldDescriptor descriptor = this.fType.getField(fragment.getName().getFullyQualifiedName());
                        this.fDescription.setRestrictions(descriptor, 8);
                    }
                }
            }
        }

        private boolean isNotVisible(int flags) {
            return Flags.isPrivate((int)flags) || Flags.isPackageDefault((int)flags);
        }
    }
}

