/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.ICWatchpointTarget;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.FetchMoreChildrenEvent;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.Messages;
import org.eclipse.cdt.dsf.mi.service.IMIExpressions;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter2;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreePath;

public class GdbVariableVMNode
extends VariableVMNode {
    protected final VariableVMNode.VariableExpressionFactory fGdbVariableExpressionFactory = new GdbVariableExpressionFactory();
    private Map<IExpressions.IExpressionDMContext, Integer> childCountLimits = new HashMap<IExpressions.IExpressionDMContext, Integer>();

    private static boolean isConvenienceVariable(String expr) {
        return expr.matches(".*\\$\\d.*");
    }

    private static boolean isRegisterExpression(String expr) {
        return expr.matches(".*\\$\\D.*");
    }

    private static Status internalError() {
        return new Status(4, GdbUIPlugin.getUniqueIdentifier(), Messages.Internal_Error);
    }

    public GdbVariableVMNode(AbstractDMVMProvider provider, DsfSession session, SyncVariableDataAccess syncVariableDataAccess) {
        super(provider, session, syncVariableDataAccess);
    }

    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new GdbVariableExpressionVMC(dmc);
    }

    protected void updateHasElementsInSessionThread(IHasChildrenUpdate update) {
        if (update.getElement() instanceof IncompleteChildrenVMC) {
            update.setHasChilren(false);
            update.done();
            return;
        }
        super.updateHasElementsInSessionThread(update);
    }

    protected void updateElementCountInSessionThread(final IChildrenCountUpdate update) {
        final IExpressions.IExpressionDMContext expressionDMC = (IExpressions.IExpressionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IExpressions.IExpressionDMContext.class);
        if (expressionDMC != null) {
            IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
            if (expressionService == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                return;
            }
            if (expressionService instanceof IMIExpressions) {
                final IMIExpressions miExpressions = (IMIExpressions)expressionService;
                miExpressions.safeToAskForAllSubExpressions(expressionDMC, (DataRequestMonitor)new ViewerDataRequestMonitor<Boolean>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                    protected void handleCompleted() {
                        boolean limitRequired;
                        if (!this.isSuccess()) {
                            GdbVariableVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                            return;
                        }
                        boolean bl = limitRequired = (Boolean)this.getData() == false;
                        if (limitRequired) {
                            final int childCountLimit = GdbVariableVMNode.this.getOrInitChildCountLimit(expressionDMC);
                            miExpressions.getSubExpressionCount(expressionDMC, childCountLimit + 1, (DataRequestMonitor)new ViewerDataRequestMonitor<Integer>(GdbVariableVMNode.this.getExecutor(), (IViewerUpdate)update){

                                public void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        GdbVariableVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                                        return;
                                    }
                                    int childCount = (Integer)this.getData();
                                    if (childCountLimit < childCount) {
                                        childCount = childCountLimit + 1;
                                    }
                                    update.setChildCount(childCount);
                                    update.done();
                                }
                            });
                        } else {
                            GdbVariableVMNode.super.updateElementCountInSessionThread(update);
                        }
                    }
                });
                return;
            }
        }
        super.updateElementCountInSessionThread(update);
    }

    protected void fillUpdateWithVMCs(IChildrenUpdate update, IDMContext[] dmcs, int firstIndex) {
        int childCount;
        int childCountLimit;
        super.fillUpdateWithVMCs(update, dmcs, firstIndex);
        IExpressions.IExpressionDMContext expressionDMC = (IExpressions.IExpressionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IExpressions.IExpressionDMContext.class);
        if (expressionDMC != null && (childCountLimit = this.getChildCountLimit(expressionDMC)) < (childCount = firstIndex + update.getLength())) {
            update.setChild((Object)new IncompleteChildrenVMC(expressionDMC, childCountLimit), childCountLimit);
        }
    }

    public void update(IPropertiesUpdate[] updates) {
        ArrayList<IPropertiesUpdate> realExpressions = new ArrayList<IPropertiesUpdate>();
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            if (update.getElement() instanceof IncompleteChildrenVMC) {
                if (update.getProperties().contains("element_expression")) {
                    update.setProperty("element_expression", (Object)Messages.More_Children);
                }
                if (update.getProperties().contains("name")) {
                    update.setProperty("name", (Object)Messages.More_Children);
                }
                update.done();
            } else {
                realExpressions.add(update);
            }
            ++n2;
        }
        super.update(realExpressions.toArray(new IPropertiesUpdate[realExpressions.size()]));
    }

    private int getInitialChildCountLimit() {
        Object initialLimitProperty = this.getVMProvider().getPresentationContext().getProperty("initialChildCountLimitForCollections");
        return initialLimitProperty instanceof Integer ? (Integer)initialLimitProperty : 100;
    }

    protected int getOrInitChildCountLimit(IExpressions.IExpressionDMContext expressionDMC) {
        if (this.childCountLimits.containsKey(expressionDMC)) {
            return this.childCountLimits.get(expressionDMC);
        }
        int initialLimit = this.getInitialChildCountLimit();
        this.childCountLimits.put(expressionDMC, initialLimit);
        return initialLimit;
    }

    protected int getChildCountLimit(IExpressions.IExpressionDMContext expressionDMC) {
        if (this.childCountLimits.containsKey(expressionDMC)) {
            return this.childCountLimits.get(expressionDMC);
        }
        return Integer.MAX_VALUE;
    }

    private void resetChildCountLimits(IRunControl.IExecutionDMContext execCtx) {
        int initialLimit = this.getInitialChildCountLimit();
        for (IExpressions.IExpressionDMContext limitCtx : this.childCountLimits.keySet()) {
            if (!DMContexts.isAncestorOf((IDMContext)limitCtx, (IDMContext)execCtx)) continue;
            this.childCountLimits.put(limitCtx, initialLimit);
        }
    }

    private void resetAllChildCountLimits() {
        int initialLimit = this.getInitialChildCountLimit();
        for (IExpressions.IExpressionDMContext limitCtx : this.childCountLimits.keySet()) {
            this.childCountLimits.put(limitCtx, initialLimit);
        }
    }

    public void incrementChildCountLimit(IExpressions.IExpressionDMContext expressionDMC) {
        assert (this.childCountLimits.containsKey(expressionDMC));
        int childCountLimit = this.getChildCountLimit(expressionDMC);
        if (childCountLimit < 0x3FFFFFFF) {
            this.childCountLimits.put(expressionDMC, childCountLimit * 2);
        }
    }

    public int getDeltaFlags(Object e) {
        String property;
        int flags = super.getDeltaFlags(e);
        if (e instanceof FetchMoreChildrenEvent) {
            flags |= 0x400;
        } else if (e instanceof IRunControl.ISuspendedDMEvent) {
            flags |= 0x400;
        } else if (e instanceof PropertyChangeEvent && "initialChildCountLimitForCollections".equals(property = ((PropertyChangeEvent)e).getProperty())) {
            flags |= 0x400;
        }
        return flags;
    }

    public int getDeltaFlagsForExpression(IExpression expression, Object event) {
        String property;
        int flags = super.getDeltaFlagsForExpression(expression, event);
        if (event instanceof FetchMoreChildrenEvent) {
            flags |= 0x400;
        } else if (event instanceof PropertyChangeEvent && "initialChildCountLimitForCollections".equals(property = ((PropertyChangeEvent)event).getProperty())) {
            flags |= 0x400;
        }
        return flags;
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        String property;
        if (e instanceof FetchMoreChildrenEvent) {
            this.buildDeltaForFetchMoreChildrenEvent((FetchMoreChildrenEvent)((Object)e), parentDelta, rm);
            return;
        }
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            this.resetChildCountLimits((IRunControl.IExecutionDMContext)((IRunControl.ISuspendedDMEvent)e).getDMContext());
        } else if (e instanceof PropertyChangeEvent && "initialChildCountLimitForCollections".equals(property = ((PropertyChangeEvent)e).getProperty())) {
            this.resetAllChildCountLimits();
            this.buildDeltaForChildCountLimitPreferenceChangedEvent(parentDelta, rm);
            return;
        }
        super.buildDelta(e, parentDelta, nodeOffset, rm);
    }

    public void buildDeltaForExpressionElement(Object element, int elementIdx, Object event, VMDelta parentDelta, RequestMonitor rm) {
        String property;
        if (event instanceof FetchMoreChildrenEvent) {
            GdbVariableExpressionVMC topLevelExpressionVMC = (GdbVariableExpressionVMC)((Object)element);
            FetchMoreChildrenEvent fetchMoreEvent = (FetchMoreChildrenEvent)((Object)event);
            if (topLevelExpressionVMC.equals(fetchMoreEvent.getPath().getFirstSegment())) {
                this.buildDeltaForFetchMoreChildrenEvent(fetchMoreEvent, parentDelta, rm);
                return;
            }
        } else if (event instanceof IRunControl.ISuspendedDMEvent) {
            this.resetChildCountLimits((IRunControl.IExecutionDMContext)((IRunControl.ISuspendedDMEvent)event).getDMContext());
        } else if (event instanceof IRunControl.IContainerSuspendedDMEvent) {
            this.resetChildCountLimits((IRunControl.IExecutionDMContext)((IRunControl.IContainerSuspendedDMEvent)event).getDMContext());
        } else if (event instanceof PropertyChangeEvent && "initialChildCountLimitForCollections".equals(property = ((PropertyChangeEvent)event).getProperty())) {
            this.resetAllChildCountLimits();
            this.buildDeltaForChildCountLimitPreferenceChangedEvent(parentDelta, rm);
            return;
        }
        super.buildDeltaForExpressionElement(element, elementIdx, event, parentDelta, rm);
    }

    private void buildDeltaForFetchMoreChildrenEvent(FetchMoreChildrenEvent fetchMoreChidrenEvent, VMDelta parentDelta, final RequestMonitor rm) {
        TreePath path = fetchMoreChidrenEvent.getPath();
        int i = 0;
        while (i < path.getSegmentCount() - 2) {
            parentDelta = parentDelta.addNode(path.getSegment(i), 0);
            ++i;
        }
        VMDelta expressionDelta = parentDelta.addNode(path.getSegment(path.getSegmentCount() - 2), 1024);
        int offset = this.getChildCountLimit((IExpressions.IExpressionDMContext)fetchMoreChidrenEvent.getDMContext()) / 2;
        int maxLength = offset + 1;
        this.getVMProvider().updateNode((IVMNode)this, (IChildrenUpdate)new VMChildrenUpdate((IModelDelta)expressionDelta, this.getVMProvider().getPresentationContext(), offset, maxLength, (DataRequestMonitor)new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

            public void handleCompleted() {
                rm.done();
            }
        }));
    }

    private void buildDeltaForChildCountLimitPreferenceChangedEvent(VMDelta parentDelta, RequestMonitor rm) {
        parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        rm.done();
    }

    protected class GdbVariableExpressionFactory
    extends VariableVMNode.VariableExpressionFactory {
        protected GdbVariableExpressionFactory() {
            super((VariableVMNode)GdbVariableVMNode.this);
        }

        public boolean canCreateWatchExpression(Object element) {
            String expression;
            if (element instanceof VariableVMNode.VariableExpressionVMC && GdbVariableVMNode.isConvenienceVariable(expression = ((VariableVMNode.VariableExpressionVMC)element).getExpression())) {
                return false;
            }
            return super.canCreateWatchExpression(element);
        }
    }

    public class GdbVariableExpressionVMC
    extends VariableVMNode.VariableExpressionVMC
    implements ICWatchpointTarget {
        public GdbVariableExpressionVMC(IDMContext dmc) {
            super((VariableVMNode)GdbVariableVMNode.this, dmc);
        }

        public void getSize(final ICWatchpointTarget.GetSizeRequest request) {
            final IExpressions.IExpressionDMContext exprDmc = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)this.getDMContext(), IExpressions.IExpressionDMContext.class);
            if (exprDmc != null) {
                GdbVariableVMNode.this.getSession().getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        IExpressions expressionService = (IExpressions)GdbVariableVMNode.this.getServicesTracker().getService(IExpressions.class);
                        if (expressionService != null) {
                            DataRequestMonitor<IExpressions.IExpressionDMAddress> drm = new DataRequestMonitor<IExpressions.IExpressionDMAddress>((Executor)GdbVariableVMNode.this.getSession().getExecutor(), null){

                                public void handleCompleted() {
                                    if (this.isSuccess()) {
                                        request.setSize(((IExpressions.IExpressionDMAddress)this.getData()).getSize());
                                    }
                                    request.setStatus(this.getStatus());
                                    request.done();
                                }
                            };
                            expressionService.getExpressionAddressData(exprDmc, (DataRequestMonitor)drm);
                        } else {
                            request.setStatus((IStatus)GdbVariableVMNode.internalError());
                            request.done();
                        }
                    }
                });
            } else {
                request.setStatus((IStatus)GdbVariableVMNode.internalError());
                request.done();
            }
        }

        public void canSetWatchpoint(final ICWatchpointTarget.CanCreateWatchpointRequest request) {
            final IExpressions.IExpressionDMContext exprDmc = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)this.getDMContext(), IExpressions.IExpressionDMContext.class);
            if (exprDmc != null) {
                GdbVariableVMNode.this.getSession().getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        IExpressions expressionService = (IExpressions)GdbVariableVMNode.this.getServicesTracker().getService(IExpressions.class);
                        if (expressionService != null) {
                            DataRequestMonitor<IExpressions.IExpressionDMAddress> drm = new DataRequestMonitor<IExpressions.IExpressionDMAddress>((Executor)GdbVariableVMNode.this.getSession().getExecutor(), null){

                                public void handleCompleted() {
                                    if (this.isSuccess()) {
                                        request.setCanCreate(((IExpressions.IExpressionDMAddress)this.getData()).getSize() > 0);
                                    }
                                    request.setStatus(this.getStatus());
                                    request.done();
                                }
                            };
                            expressionService.getExpressionAddressData(exprDmc, (DataRequestMonitor)drm);
                        } else {
                            request.setStatus((IStatus)GdbVariableVMNode.internalError());
                            request.done();
                        }
                    }
                });
            } else {
                request.setStatus((IStatus)GdbVariableVMNode.internalError());
                request.done();
            }
        }

        public boolean canViewInMemory() {
            String expr = this.getExpression();
            if (GdbVariableVMNode.isConvenienceVariable(expr) || GdbVariableVMNode.isRegisterExpression(expr)) {
                return false;
            }
            return super.canViewInMemory();
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isAssignableFrom(IWatchExpressionFactoryAdapter2.class)) {
                return GdbVariableVMNode.this.fGdbVariableExpressionFactory;
            }
            return super.getAdapter(adapter);
        }
    }

    public class IncompleteChildrenVMC
    extends AbstractVMContext {
        private IExpressions.IExpressionDMContext parentDmc;

        public IncompleteChildrenVMC(IExpressions.IExpressionDMContext exprDmc, int childCountLimit) {
            super((IVMNode)GdbVariableVMNode.this);
            this.parentDmc = exprDmc;
        }

        public boolean equals(Object obj) {
            return obj instanceof IncompleteChildrenVMC && ((IncompleteChildrenVMC)((Object)obj)).parentDmc.equals(this.parentDmc);
        }

        public int hashCode() {
            return this.parentDmc.hashCode();
        }

        public IExpressions.IExpressionDMContext getParentDMContext() {
            return this.parentDmc;
        }
    }
}

