/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.libhover;

import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHover;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHoverLoadJob;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHoverMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class LibhoverPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.cdt.libhover";
    private static final String LOAD_JOB_TXT = "LibHover.LoadJob.txt";
    private static LibhoverPlugin plugin = new LibhoverPlugin();
    private static IPath stateLocation;
    private static IPreferenceStore preferenceStore;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ResourcesPlugin.getWorkspace().addSaveParticipant(PLUGIN_ID, new ISaveParticipant(){

            public void saving(ISaveContext saveContext) {
                LibhoverPlugin.this.save();
            }

            public void rollback(ISaveContext saveContext) {
            }

            public void prepareToSave(ISaveContext saveContext) {
            }

            public void doneSaving(ISaveContext saveContext) {
            }
        });
        IPreferenceStore ps = this.getPreferenceStore();
        if (ps == null || !ps.getBoolean("org.eclipse.linuxtools.cdt.libhover.lazyLoad")) {
            LibHoverLoadJob k = new LibHoverLoadJob(LibHoverMessages.getString(LOAD_JOB_TXT));
            k.schedule();
        }
    }

    private void save() {
        if (stateLocation == null) {
            stateLocation = this.getStateLocation();
        }
        if (preferenceStore == null) {
            preferenceStore = this.getPreferenceStore();
        }
        LibHover.saveLibraries(stateLocation, preferenceStore);
    }

    public void stop(BundleContext context) throws Exception {
        stateLocation = this.getStateLocation();
        preferenceStore = this.getPreferenceStore();
        plugin = null;
        super.stop(context);
    }

    public static LibhoverPlugin getDefault() {
        return plugin;
    }
}

