/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation.handlers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;

public abstract class AbstractDropdownHandler
extends AbstractHandler
implements IElementUpdater {
    private static final Map<String, ActionDescriptor> ACTION_DESCRIPTORS = new HashMap<String, ActionDescriptor>();
    private static final ThreadLocal<Boolean> EAGER_LOAD = new ThreadLocal();
    private final String commandID;

    public AbstractDropdownHandler(String commandID) {
        this.commandID = commandID;
    }

    public final String getCommandID() {
        return this.commandID;
    }

    public void updateElement(UIElement element, Map parameters) {
        ActionDescriptor actionDescriptor = this.getActionDescriptor();
        ImageDescriptor imageDescriptor = actionDescriptor.getImageDescriptor();
        if (imageDescriptor != null) {
            element.setIcon(imageDescriptor);
        }
        String text = actionDescriptor.getText();
        element.setText(text);
        element.setTooltip(text);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (Boolean.TRUE.equals(EAGER_LOAD.get())) {
            return null;
        }
        ActionDescriptor actionDescriptor = this.getActionDescriptor();
        Runnable runnable = actionDescriptor.getRunnable();
        if (runnable != null) {
            runnable.run();
        }
        return null;
    }

    protected abstract ActionDescriptor createActionDescriptor() throws Exception;

    private ActionDescriptor getActionDescriptor() {
        ActionDescriptor actionDescriptor = ACTION_DESCRIPTORS.get(this.commandID);
        if (actionDescriptor == null) {
            try {
                actionDescriptor = this.createActionDescriptor();
                ACTION_DESCRIPTORS.put(this.commandID, actionDescriptor);
            }
            catch (Exception ex) {
                SetupEditorPlugin.getPlugin().log(ex);
                return new ActionDescriptor(null, "Error: " + ex.getLocalizedMessage(), null);
            }
        }
        return actionDescriptor;
    }

    public static void setAction(String commandID, ImageDescriptor imageDescriptor, String text, Runnable runnable) {
        IWorkbenchWindow window;
        block5: {
            ActionDescriptor actionDescriptor = new ActionDescriptor(imageDescriptor, text, runnable);
            ACTION_DESCRIPTORS.put(commandID, actionDescriptor);
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                try {
                    EAGER_LOAD.set(Boolean.TRUE);
                    IHandlerService handlerService = (IHandlerService)UIUtil.getService((IServiceLocator)window, IHandlerService.class);
                    handlerService.executeCommand(commandID, null);
                }
                catch (Exception ex) {
                    SetupEditorPlugin.getPlugin().log(ex);
                    EAGER_LOAD.remove();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                EAGER_LOAD.remove();
                throw throwable;
            }
            EAGER_LOAD.remove();
        }
        ICommandService commandService = (ICommandService)UIUtil.getService((IServiceLocator)window, ICommandService.class);
        commandService.refreshElements(commandID, null);
    }

    public static final class ActionDescriptor {
        private final ImageDescriptor imageDescriptor;
        private final String text;
        private final Runnable runnable;

        public ActionDescriptor(ImageDescriptor imageDescriptor, String text, Runnable runnable) {
            this.imageDescriptor = imageDescriptor;
            this.text = text;
            this.runnable = runnable;
        }

        public ImageDescriptor getImageDescriptor() {
            return this.imageDescriptor;
        }

        public String getText() {
            return this.text;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }
    }
}

