/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.import_config.wizards.dbvis;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.import_config.Activator;
import org.jkiss.dbeaver.ext.import_config.wizards.ConfigImportWizardPage;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportData;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportDriverInfo;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigImportWizardPageDbvis
extends ConfigImportWizardPage {
    public static final String DBVIS_HOME_FOLDER = ".dbvis";
    public static final String DBVIS_CONFIG70_FOLDER = "config70";
    public static final String DBVIS_CONFIG_FILE = "dbvis.xml";
    private static Pattern PATTERN_PROTOCOL = Pattern.compile("<protocol>");
    private static Pattern PATTERN_HOST = Pattern.compile("<server>");
    private static Pattern PATTERN_PORT = Pattern.compile("<port([0-9]*)>");
    private static Pattern PATTERN_DATABASE = Pattern.compile("<database>|<databaseName>|<sid>|<datasource>");

    protected ConfigImportWizardPageDbvis() {
        super("DBVisualizer");
        this.setTitle("DBVisualizer");
        this.setDescription("Import DBVisualizer connections");
        this.setImageDescriptor(Activator.getImageDescriptor("icons/dbvis_big.png"));
    }

    @Override
    protected void loadConnections(ImportData importData) throws DBException {
        File homeFolder = RuntimeUtils.getUserHomeDir();
        File dbvisConfigHome = new File(homeFolder, DBVIS_HOME_FOLDER);
        if (!dbvisConfigHome.exists()) {
            throw new DBException("DBVisualizer installation not found");
        }
        File configFolder = new File(dbvisConfigHome, DBVIS_CONFIG70_FOLDER);
        if (!configFolder.exists()) {
            throw new DBException("Only DBVisualizer 7.x version is supported");
        }
        File configFile = new File(configFolder, DBVIS_CONFIG_FILE);
        if (!configFile.exists()) {
            throw new DBException("DBVisualizer configuration file not found");
        }
        try {
            Element databasesElement;
            Document configDocument = XMLUtils.parseDocument((File)configFile);
            Element driversElement = XMLUtils.getChildElement((Element)configDocument.getDocumentElement(), (String)"Drivers");
            if (driversElement != null) {
                for (Element driverElement : XMLUtils.getChildElementList((Element)driversElement, (String)"Driver")) {
                    String name = XMLUtils.getChildElementBody((Element)driverElement, (String)"Name");
                    String sampleURL = XMLUtils.getChildElementBody((Element)driverElement, (String)"URLFormat");
                    String driverClass = XMLUtils.getChildElementBody((Element)driverElement, (String)"DefaultClass");
                    String lastName = XMLUtils.getChildElementBody((Element)driverElement, (String)"LastName");
                    if (CommonUtils.isEmpty((String)name) || CommonUtils.isEmpty((String)sampleURL) || CommonUtils.isEmpty((String)driverClass)) continue;
                    ImportDriverInfo driver = new ImportDriverInfo(null, name, sampleURL, driverClass);
                    if (!CommonUtils.isEmpty((String)lastName)) {
                        driver.setDescription(lastName);
                    }
                    this.adaptSampleUrl(driver);
                    Element locationsElement = XMLUtils.getChildElement((Element)driverElement, (String)"Locations");
                    if (locationsElement != null) {
                        for (Element locationElement : XMLUtils.getChildElementList((Element)locationsElement, (String)"Location")) {
                            String path = XMLUtils.getChildElementBody((Element)locationElement, (String)"Path");
                            if (CommonUtils.isEmpty((String)path)) continue;
                            driver.addLibrary(path);
                        }
                    }
                    importData.addDriver(driver);
                }
            }
            if ((databasesElement = XMLUtils.getChildElement((Element)configDocument.getDocumentElement(), (String)"Databases")) != null) {
                for (Element dbElement : XMLUtils.getChildElementList((Element)databasesElement, (String)"Database")) {
                    ImportDriverInfo driver;
                    Element driverElement;
                    String alias = XMLUtils.getChildElementBody((Element)dbElement, (String)"Alias");
                    String url = XMLUtils.getChildElementBody((Element)dbElement, (String)"Url");
                    String driverName = XMLUtils.getChildElementBody((Element)dbElement, (String)"Driver");
                    String user = XMLUtils.getChildElementBody((Element)dbElement, (String)"Userid");
                    String password = null;
                    String passwordEncoded = XMLUtils.getChildElementBody((Element)dbElement, (String)"Password");
                    String hostName = null;
                    String port = null;
                    String database = null;
                    Element urlVarsElement = XMLUtils.getChildElement((Element)dbElement, (String)"UrlVariables");
                    if (urlVarsElement != null && (driverElement = XMLUtils.getChildElement((Element)urlVarsElement, (String)"Driver")) != null) {
                        for (Element urlVarElement : XMLUtils.getChildElementList((Element)driverElement, (String)"UrlVariable")) {
                            String varName = urlVarElement.getAttribute("UrlVariableName");
                            String varValue = XMLUtils.getElementBody((Element)urlVarElement);
                            if ("Server".equals(varName)) {
                                hostName = varValue;
                                continue;
                            }
                            if ("Port".equals(varName)) {
                                port = varValue;
                                continue;
                            }
                            if (!"Database".equals(varName)) continue;
                            database = varValue;
                        }
                    }
                    if (CommonUtils.isEmpty((String)alias) || CommonUtils.isEmpty((String)driverName) || CommonUtils.isEmpty((String)url) && CommonUtils.isEmpty(hostName) || (driver = importData.getDriver(driverName)) == null) continue;
                    ImportConnectionInfo connectionInfo = new ImportConnectionInfo(driver, dbElement.getAttribute("id"), alias, url, hostName, port, database, user, password);
                    importData.addConnection(connectionInfo);
                }
            }
        }
        catch (XMLException e) {
            throw new DBException("Configuration parse error: " + e.getMessage());
        }
    }

    private void adaptSampleUrl(ImportDriverInfo driverInfo) {
        String portString;
        String port = null;
        String sampleURL = driverInfo.getSampleURL();
        sampleURL = PATTERN_PROTOCOL.matcher(sampleURL).replaceAll("{protocol}");
        Matcher portMatcher = PATTERN_PORT.matcher(sampleURL = PATTERN_HOST.matcher(sampleURL).replaceAll("{host}"));
        if (portMatcher.find() && !CommonUtils.isEmpty((String)(portString = portMatcher.group(1)))) {
            port = portString;
        }
        sampleURL = portMatcher.replaceAll("{port}");
        sampleURL = PATTERN_DATABASE.matcher(sampleURL).replaceAll("{database}");
        driverInfo.setSampleURL(sampleURL);
        if (port != null) {
            driverInfo.setDefaultPort(port);
        }
    }
}

