/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.ui.PostgreCreateRoleDialog;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreRoleManager
extends SQLObjectEditor<PostgreRole, PostgreDatabase> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, PostgreRole> getObjectsCache(PostgreRole object) {
        return null;
    }

    protected PostgreRole createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final PostgreDatabase parent, Object copyFrom) throws DBException {
        return (PostgreRole)new UITask<PostgreRole>(){

            protected PostgreRole runTask() {
                PostgreCreateRoleDialog dialog = new PostgreCreateRoleDialog(UIUtils.getActiveWorkbenchShell(), parent);
                if (dialog.open() != 0) {
                    return null;
                }
                return new PostgreRole(parent, dialog.getName(), dialog.getPassword(), dialog.isUser());
            }
        }.execute();
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        PostgreRole role = (PostgreRole)command.getObject();
        StringBuilder script = new StringBuilder("CREATE ROLE " + DBUtils.getQuotedIdentifier((DBSObject)role));
        this.addRoleOptions(script, role, true);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create role", script.toString()));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        PostgreRole role = (PostgreRole)command.getObject();
        StringBuilder script = new StringBuilder("ALTER ROLE " + DBUtils.getQuotedIdentifier((DBSObject)role));
        this.addRoleOptions(script, role, false);
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter role", script.toString()));
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop role", "DROP ROLE " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject()))));
    }

    private void addRoleOptions(StringBuilder script, PostgreRole role, boolean create) {
        if (role.isSuperUser()) {
            script.append(" SUPERUSER");
        } else {
            script.append(" NOSUPERUSER");
        }
        if (role.isCreateDatabase()) {
            script.append(" CREATEDB");
        } else {
            script.append(" NOCREATEDB");
        }
        if (role.isCreateRole()) {
            script.append(" CREATEROLE");
        } else {
            script.append(" NOCREATEROLE");
        }
        if (role.isInherit()) {
            script.append(" INHERIT");
        } else {
            script.append(" NOINHERIT");
        }
        if (role.isCanLogin()) {
            script.append(" LOGIN");
        } else {
            script.append(" NOLOGIN");
        }
        if (create && role.isUser() && !CommonUtils.isEmpty((String)role.getPassword())) {
            script.append(" PASSWORD ").append("'").append(role.getDataSource().getSQLDialect().escapeString(role.getPassword())).append("'");
        }
    }
}

