/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PermissionData {
    private static final int PERMDATA_VERSION = 1;
    private final Map<String, String[]> locations = new HashMap<String, String[]>();
    private String[] defaultInfos;
    private String[] condPermInfos;
    private boolean dirty;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLocations() {
        Map<String, String[]> map = this.locations;
        synchronized (map) {
            String[] result = new String[this.locations.size()];
            int i = 0;
            Iterator<String> iLocs = this.locations.keySet().iterator();
            while (iLocs.hasNext()) {
                result[i] = iLocs.next();
                ++i;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPermissionData(String location) {
        if (location == null) {
            return this.defaultInfos;
        }
        Map<String, String[]> map = this.locations;
        synchronized (map) {
            block5: {
                if (this.locations.size() != 0) break block5;
                return null;
            }
            return this.locations.get(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissionData(String location, String[] data) {
        if (location == null) {
            this.defaultInfos = data;
            return;
        }
        Map<String, String[]> map = this.locations;
        synchronized (map) {
            if (data == null) {
                this.locations.remove(location);
            } else {
                this.locations.put(location, data);
            }
        }
        this.setDirty(true);
    }

    public void saveConditionalPermissionInfos(String[] infos) {
        this.condPermInfos = infos;
        this.setDirty(true);
    }

    public String[] getConditionalPermissionInfos() {
        return this.condPermInfos;
    }

    boolean isDirty() {
        return this.dirty;
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    void readPermissionData(DataInputStream in) throws IOException {
        int version = in.readInt();
        int dataSize = in.readInt();
        byte[] bytes = new byte[dataSize];
        in.readFully(bytes);
        if (1 == version) {
            DataInputStream temp = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                int numCondPerms;
                int numLocs;
                int i;
                int numPerms = temp.readInt();
                if (numPerms > 0) {
                    String[] perms = new String[numPerms];
                    i = 0;
                    while (i < numPerms) {
                        perms[i] = temp.readUTF();
                        ++i;
                    }
                    this.setPermissionData(null, perms);
                }
                if ((numLocs = temp.readInt()) > 0) {
                    i = 0;
                    while (i < numLocs) {
                        String loc = temp.readUTF();
                        numPerms = temp.readInt();
                        String[] perms = new String[numPerms];
                        int j = 0;
                        while (j < numPerms) {
                            perms[j] = temp.readUTF();
                            ++j;
                        }
                        this.setPermissionData(loc, perms);
                        ++i;
                    }
                }
                if ((numCondPerms = temp.readInt()) > 0) {
                    String[] condPerms = new String[numCondPerms];
                    int i2 = 0;
                    while (i2 < numCondPerms) {
                        condPerms[i2] = temp.readUTF();
                        ++i2;
                    }
                    this.saveConditionalPermissionInfos(condPerms);
                }
            }
            finally {
                this.setDirty(false);
                temp.close();
            }
        }
    }

    void savePermissionData(DataOutputStream out) throws IOException {
        String[] condPerms;
        String[] locs;
        out.writeInt(1);
        ByteArrayOutputStream tempBytes = new ByteArrayOutputStream();
        DataOutputStream temp = new DataOutputStream(tempBytes);
        String[] defaultPerms = this.getPermissionData(null);
        temp.writeInt(defaultPerms == null ? 0 : defaultPerms.length);
        if (defaultPerms != null) {
            int i = 0;
            while (i < defaultPerms.length) {
                temp.writeUTF(defaultPerms[i]);
                ++i;
            }
        }
        temp.writeInt((locs = this.getLocations()) == null ? 0 : locs.length);
        if (locs != null) {
            int i = 0;
            while (i < locs.length) {
                temp.writeUTF(locs[i]);
                String[] perms = this.getPermissionData(locs[i]);
                temp.writeInt(perms == null ? 0 : perms.length);
                if (perms != null) {
                    int j = 0;
                    while (j < perms.length) {
                        temp.writeUTF(perms[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        temp.writeInt((condPerms = this.getConditionalPermissionInfos()) == null ? 0 : condPerms.length);
        if (condPerms != null) {
            int i = 0;
            while (i < condPerms.length) {
                temp.writeUTF(condPerms[i]);
                ++i;
            }
        }
        temp.close();
        out.writeInt(tempBytes.size());
        out.write(tempBytes.toByteArray());
        this.setDirty(false);
    }
}

