/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.directedit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.erd.figures.NoteFigure;

public class ExtendedDirectEditManager
extends DirectEditManager {
    protected Font figureFont;
    protected VerifyListener verifyListener;
    protected IFigure figure;
    protected String originalValue;
    private boolean committing = false;
    private ICellEditorValidator validator = null;

    public ExtendedDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator, IFigure figure, ICellEditorValidator validator) {
        super(source, editorType, locator);
        this.figure = figure;
        this.originalValue = ExtendedDirectEditManager.getFigureText(figure);
        this.validator = validator;
    }

    private static String getFigureText(IFigure figure) {
        if (figure instanceof Label) {
            return ((Label)figure).getText();
        }
        if (figure instanceof NoteFigure) {
            return ((NoteFigure)figure).getText();
        }
        return "???";
    }

    protected void bringDown() {
        Font disposeFont = this.figureFont;
        this.figureFont = null;
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
    }

    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                Text text = (Text)ExtendedDirectEditManager.this.getCellEditor().getControl();
                String oldText = text.getText();
                String leftText = oldText.substring(0, event.start);
                String rightText = oldText.substring(event.end, oldText.length());
                GC gc = new GC((Drawable)text);
                String s = String.valueOf(leftText) + event.text + rightText;
                Point size = gc.textExtent(String.valueOf(leftText) + event.text + rightText);
                gc.dispose();
                if (size.x != 0) {
                    size = text.computeSize(size.x, -1);
                } else {
                    size.x = size.y;
                }
                ExtendedDirectEditManager.this.getCellEditor().getControl().setSize(size.x, size.y);
            }
        };
        text.addVerifyListener(this.verifyListener);
        this.originalValue = ExtendedDirectEditManager.getFigureText(this.figure);
        this.getCellEditor().setValue((Object)this.originalValue);
        IFigure figure = this.getEditPart().getFigure();
        this.figureFont = figure.getFont();
        FontData data = this.figureFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        this.figure.translateToAbsolute((Translatable)fontSize);
        data.setHeight(fontSize.height);
        this.figureFont = new Font(null, data);
        this.getCellEditor().setValidator(this.validator);
        text.setFont(this.figureFont);
        text.selectAll();
    }

    protected void commit() {
        if (this.committing) {
            return;
        }
        this.committing = true;
        try {
            this.getCellEditor().getControl().setVisible(false);
            if (this.isDirty()) {
                CommandStack stack = this.getEditPart().getViewer().getEditDomain().getCommandStack();
                EditPolicy editPolicy = this.getEditPart().getEditPolicy((Object)"DirectEditPolicy");
                Command command = editPolicy != null ? editPolicy.getCommand((Request)this.getDirectEditRequest()) : this.getEditPart().getCommand((Request)this.getDirectEditRequest());
                if (command != null && command.canExecute()) {
                    stack.execute(command);
                }
            }
        }
        finally {
            this.bringDown();
            this.committing = false;
        }
    }

    protected void unhookListeners() {
        super.unhookListeners();
        Text text = (Text)this.getCellEditor().getControl();
        text.removeVerifyListener(this.verifyListener);
        this.verifyListener = null;
    }
}

