"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.YAMLOMap = void 0;

var _errors = require("../errors");

var _toJSON = _interopRequireDefault(require("../toJSON"));

var _Pair = _interopRequireDefault(require("./Pair"));

var _Scalar = _interopRequireDefault(require("./Scalar"));

var _Seq = _interopRequireDefault(require("./Seq"));

var _pairs = require("./_pairs");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class YAMLOMap extends _Seq.default {
  constructor() {
    super();
    this.tag = YAMLOMap.tag;
  }

  toJSON(_, opt) {
    const map = new Map();
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = this.items[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        const pair = _step.value;
        let key, value;

        if (pair instanceof _Pair.default) {
          key = (0, _toJSON.default)(pair.key, '', opt);
          value = (0, _toJSON.default)(pair.value, key, opt);
        } else {
          key = (0, _toJSON.default)(pair, '', opt);
        }

        if (map.has(key)) throw new Error('Ordered maps must not include duplicate keys');
        map.set(key, value);
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    return map;
  }

}

exports.YAMLOMap = YAMLOMap;

_defineProperty(YAMLOMap, "tag", 'tag:yaml.org,2002:omap');

function parseOMap(doc, cst) {
  const pairs = (0, _pairs.parsePairs)(doc, cst);
  const seenKeys = [];
  var _iteratorNormalCompletion2 = true;
  var _didIteratorError2 = false;
  var _iteratorError2 = undefined;

  try {
    for (var _iterator2 = pairs.items[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
      const key = _step2.value.key;

      if (key instanceof _Scalar.default) {
        if (seenKeys.includes(key.value)) {
          const msg = 'Ordered maps must not include duplicate keys';
          throw new _errors.YAMLSemanticError(cst, msg);
        } else {
          seenKeys.push(key.value);
        }
      }
    }
  } catch (err) {
    _didIteratorError2 = true;
    _iteratorError2 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
        _iterator2.return();
      }
    } finally {
      if (_didIteratorError2) {
        throw _iteratorError2;
      }
    }
  }

  return Object.assign(new YAMLOMap(), pairs);
}

function createOMap(schema, iterable, wrapScalars) {
  const pairs = (0, _pairs.createPairs)(schema, iterable, wrapScalars);
  const omap = new YAMLOMap();
  omap.items = pairs.items;
  return omap;
}

var _default = {
  class: Map,
  nodeClass: YAMLOMap,
  default: false,
  tag: 'tag:yaml.org,2002:omap',
  resolve: parseOMap,
  createNode: createOMap,
  stringify: (value, ctx, onComment, onChompKeep) => value.toString(ctx, onComment, onChompKeep)
};
exports.default = _default;