/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompilationSubject;
import com.google.testing.compile.CompileTester;
import com.google.testing.compile.Compiler;
import com.google.testing.compile.JavaFileObjectSubject;
import com.google.testing.compile.JavaFileObjects;
import com.google.testing.compile.JavaSourcesSubjectFactory;
import com.google.testing.compile.Parser;
import com.google.testing.compile.ProcessedCompileTesterFactory;
import com.google.testing.compile.TreeContext;
import com.google.testing.compile.TreeDiffer;
import com.google.testing.compile.TreeDifference;
import com.google.testing.compile.TypeEnumerator;
import com.sun.source.tree.CompilationUnitTree;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public final class JavaSourcesSubject
extends Subject<JavaSourcesSubject, Iterable<? extends JavaFileObject>>
implements CompileTester,
ProcessedCompileTesterFactory {
    private final List<String> options = new ArrayList<String>(Arrays.asList("-Xlint"));
    @Nullable
    private ClassLoader classLoader;

    JavaSourcesSubject(FailureMetadata failureMetadata, Iterable<? extends JavaFileObject> subject) {
        super(failureMetadata, subject);
    }

    @Override
    public JavaSourcesSubject withCompilerOptions(Iterable<String> options) {
        Iterables.addAll(this.options, options);
        return this;
    }

    @Override
    public JavaSourcesSubject withCompilerOptions(String ... options) {
        this.options.addAll(Arrays.asList(options));
        return this;
    }

    @Override
    public JavaSourcesSubject withClasspathFrom(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public CompileTester processedWith(Processor first, Processor ... rest) {
        return this.processedWith(Lists.asList((Object)first, (Object[])rest));
    }

    @Override
    public CompileTester processedWith(Iterable<? extends Processor> processors) {
        return new CompilationClause(processors);
    }

    @Override
    public void parsesAs(JavaFileObject first, JavaFileObject ... rest) {
        new CompilationClause().parsesAs(first, rest);
    }

    @Override
    @CanIgnoreReturnValue
    public CompileTester.SuccessfulCompilationClause compilesWithoutError() {
        return new CompilationClause().compilesWithoutError();
    }

    @Override
    @CanIgnoreReturnValue
    public CompileTester.CleanCompilationClause compilesWithoutWarnings() {
        return new CompilationClause().compilesWithoutWarnings();
    }

    @Override
    @CanIgnoreReturnValue
    public CompileTester.UnsuccessfulCompilationClause failsToCompile() {
        return new CompilationClause().failsToCompile();
    }

    private CompilationClause newCompilationClause(Iterable<? extends Processor> processors) {
        return new CompilationClause(processors);
    }

    public static JavaSourcesSubject assertThat(JavaFileObject javaFileObject) {
        return (JavaSourcesSubject)Truth.assertAbout((Subject.Factory)JavaSourcesSubjectFactory.javaSources()).that((Object)ImmutableList.of((Object)javaFileObject));
    }

    public static JavaSourcesSubject assertThat(JavaFileObject javaFileObject, JavaFileObject ... javaFileObjects) {
        return (JavaSourcesSubject)Truth.assertAbout((Subject.Factory)JavaSourcesSubjectFactory.javaSources()).that((Object)ImmutableList.builder().add((Object)javaFileObject).add((Object[])javaFileObjects).build());
    }

    public static final class SingleSourceAdapter
    extends Subject<SingleSourceAdapter, JavaFileObject>
    implements CompileTester,
    ProcessedCompileTesterFactory {
        private final JavaSourcesSubject delegate;

        SingleSourceAdapter(FailureMetadata failureMetadata, JavaFileObject subject) {
            super(failureMetadata, (Object)subject);
            this.delegate = (JavaSourcesSubject)this.check().about((Subject.Factory)JavaSourcesSubjectFactory.javaSources()).that((Object)ImmutableList.of((Object)subject));
        }

        @Override
        public JavaSourcesSubject withCompilerOptions(Iterable<String> options) {
            return this.delegate.withCompilerOptions((Iterable)options);
        }

        @Override
        public JavaSourcesSubject withCompilerOptions(String ... options) {
            return this.delegate.withCompilerOptions(options);
        }

        @Override
        public JavaSourcesSubject withClasspathFrom(ClassLoader classLoader) {
            return this.delegate.withClasspathFrom(classLoader);
        }

        @Override
        public CompileTester processedWith(Processor first, Processor ... rest) {
            return this.delegate.newCompilationClause(Lists.asList((Object)first, (Object[])rest));
        }

        @Override
        public CompileTester processedWith(Iterable<? extends Processor> processors) {
            return this.delegate.newCompilationClause(processors);
        }

        @Override
        @CanIgnoreReturnValue
        public CompileTester.SuccessfulCompilationClause compilesWithoutError() {
            return this.delegate.compilesWithoutError();
        }

        @Override
        @CanIgnoreReturnValue
        public CompileTester.CleanCompilationClause compilesWithoutWarnings() {
            return this.delegate.compilesWithoutWarnings();
        }

        @Override
        @CanIgnoreReturnValue
        public CompileTester.UnsuccessfulCompilationClause failsToCompile() {
            return this.delegate.failsToCompile();
        }

        @Override
        public void parsesAs(JavaFileObject first, JavaFileObject ... rest) {
            this.delegate.parsesAs(first, rest);
        }
    }

    private final class CleanCompilationBuilder
    extends GeneratedCompilationBuilder<CompileTester.CleanCompilationClause>
    implements CompileTester.CleanCompilationClause {
        CleanCompilationBuilder(Compilation compilation) {
            super(compilation);
        }
    }

    private final class SuccessfulCompilationBuilder
    extends GeneratedCompilationBuilder<CompileTester.SuccessfulCompilationClause>
    implements CompileTester.SuccessfulCompilationClause {
        SuccessfulCompilationBuilder(Compilation compilation) {
            super(compilation);
        }
    }

    private final class UnsuccessfulCompilationBuilder
    extends CompilationWithWarningsBuilder<CompileTester.UnsuccessfulCompilationClause>
    implements CompileTester.UnsuccessfulCompilationClause {
        UnsuccessfulCompilationBuilder(Compilation compilation) {
            super(compilation);
        }
    }

    final class CompilationBuilder
    extends GeneratedCompilationBuilder<CompilationBuilder> {
        CompilationBuilder(Compilation compilation) {
            super(compilation);
        }
    }

    private abstract class GeneratedCompilationBuilder<T>
    extends CompilationWithWarningsBuilder<T>
    implements CompileTester.GeneratedPredicateClause<T>,
    CompileTester.ChainingClause<CompileTester.GeneratedPredicateClause<T>> {
        protected GeneratedCompilationBuilder(Compilation compilation) {
            super(compilation);
        }

        @Override
        @CanIgnoreReturnValue
        public T generatesSources(JavaFileObject first, JavaFileObject ... rest) {
            ((JavaSourcesSubject)JavaSourcesSubject.this.check().about((Subject.Factory)JavaSourcesSubjectFactory.javaSources()).that(this.compilation.generatedSourceFiles())).parsesAs(first, rest);
            return this.thisObject();
        }

        @Override
        @CanIgnoreReturnValue
        public T generatesFiles(JavaFileObject first, JavaFileObject ... rest) {
            for (JavaFileObject expected : Lists.asList((Object)first, (Object[])rest)) {
                if (this.wasGenerated(expected)) continue;
                JavaSourcesSubject.this.failWithRawMessage("Did not find a generated file corresponding to " + expected.getName(), new Object[0]);
            }
            return this.thisObject();
        }

        boolean wasGenerated(JavaFileObject expected) {
            ByteSource expectedByteSource = JavaFileObjects.asByteSource(expected);
            for (JavaFileObject generated : this.compilation.generatedFiles()) {
                try {
                    if (!generated.getKind().equals((Object)expected.getKind()) || !expectedByteSource.contentEquals(JavaFileObjects.asByteSource(generated))) continue;
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }

        @Override
        @CanIgnoreReturnValue
        public CompileTester.SuccessfulFileClause<T> generatesFileNamed(JavaFileManager.Location location, String packageName, String relativeName) {
            final JavaFileObjectSubject javaFileObjectSubject = ((CompilationSubject)JavaSourcesSubject.this.check().about(CompilationSubject.compilations()).that((Object)this.compilation)).generatedFile(location, packageName, relativeName);
            return new CompileTester.SuccessfulFileClause<T>(){

                @Override
                public CompileTester.GeneratedPredicateClause<T> and() {
                    return GeneratedCompilationBuilder.this;
                }

                @Override
                public CompileTester.SuccessfulFileClause<T> withContents(ByteSource expectedByteSource) {
                    javaFileObjectSubject.hasContents(expectedByteSource);
                    return this;
                }

                @Override
                public CompileTester.SuccessfulFileClause<T> withStringContents(Charset charset, String expectedString) {
                    javaFileObjectSubject.contentsAsString(charset).isEqualTo((Object)expectedString);
                    return this;
                }
            };
        }

        @Override
        public CompileTester.GeneratedPredicateClause<T> and() {
            return this;
        }
    }

    abstract class CompilationWithWarningsBuilder<T>
    implements CompileTester.CompilationWithWarningsClause<T> {
        protected final Compilation compilation;

        protected CompilationWithWarningsBuilder(Compilation compilation) {
            this.compilation = compilation;
        }

        @Override
        @CanIgnoreReturnValue
        public T withNoteCount(int noteCount) {
            ((CompilationSubject)JavaSourcesSubject.this.check().about(CompilationSubject.compilations()).that((Object)this.compilation)).hadNoteCount(noteCount);
            return this.thisObject();
        }

        @Override
        @CanIgnoreReturnValue
        public CompileTester.FileClause<T> withNoteContaining(String messageFragment) {
            return new FileBuilder(((CompilationSubject)JavaSourcesSubject.this.check().about(CompilationSubject.compilations()).that((Object)this.compilation)).hadNoteContaining(messageFragment));
        }

        @Override
        @CanIgnoreReturnValue
        public T withWarningCount(int warningCount) {
            ((CompilationSubject)JavaSourcesSubject.this.check().about(CompilationSubject.compilations()).that((Object)this.compilation)).hadWarningCount(warningCount);
            return this.thisObject();
        }

        @Override
        @CanIgnoreReturnValue
        public CompileTester.FileClause<T> withWarningContaining(String messageFragment) {
            return new FileBuilder(((CompilationSubject)JavaSourcesSubject.this.check().about(CompilationSubject.compilations()).that((Object)this.compilation)).hadWarningContaining(messageFragment));
        }

        @CanIgnoreReturnValue
        public T withErrorCount(int errorCount) {
            ((CompilationSubject)JavaSourcesSubject.this.check().about(CompilationSubject.compilations()).that((Object)this.compilation)).hadErrorCount(errorCount);
            return this.thisObject();
        }

        @CanIgnoreReturnValue
        public CompileTester.FileClause<T> withErrorContaining(String messageFragment) {
            return new FileBuilder(((CompilationSubject)JavaSourcesSubject.this.check().about(CompilationSubject.compilations()).that((Object)this.compilation)).hadErrorContaining(messageFragment));
        }

        protected final T thisObject() {
            return (T)this;
        }

        private final class FileBuilder
        implements CompileTester.FileClause<T> {
            private final CompilationSubject.DiagnosticInFile diagnosticInFile;

            private FileBuilder(CompilationSubject.DiagnosticInFile diagnosticInFile) {
                this.diagnosticInFile = diagnosticInFile;
            }

            @Override
            public T and() {
                return CompilationWithWarningsBuilder.this.thisObject();
            }

            @Override
            public CompileTester.LineClause<T> in(JavaFileObject file) {
                final CompilationSubject.DiagnosticOnLine diagnosticOnLine = this.diagnosticInFile.inFile(file);
                return new CompileTester.LineClause<T>(){

                    @Override
                    public T and() {
                        return CompilationWithWarningsBuilder.this.thisObject();
                    }

                    @Override
                    public CompileTester.ColumnClause<T> onLine(long lineNumber) {
                        final CompilationSubject.DiagnosticAtColumn diagnosticAtColumn = diagnosticOnLine.onLine(lineNumber);
                        return new CompileTester.ColumnClause<T>(){

                            @Override
                            public T and() {
                                return CompilationWithWarningsBuilder.this.thisObject();
                            }

                            @Override
                            public CompileTester.ChainingClause<T> atColumn(long columnNumber) {
                                diagnosticAtColumn.atColumn(columnNumber);
                                return this;
                            }
                        };
                    }
                };
            }
        }
    }

    private final class CompilationClause
    implements CompileTester {
        private final ImmutableSet<Processor> processors;

        private CompilationClause() {
            this((Iterable<? extends Processor>)ImmutableSet.of());
        }

        private CompilationClause(Iterable<? extends Processor> processors) {
            this.processors = ImmutableSet.copyOf(processors);
        }

        @Override
        public void parsesAs(JavaFileObject first, JavaFileObject ... rest) {
            if (Iterables.isEmpty((Iterable)((Iterable)JavaSourcesSubject.this.actual()))) {
                JavaSourcesSubject.this.failWithRawMessage("Compilation generated no additional source files, though some were expected.", new Object[0]);
                return;
            }
            Parser.ParseResult actualResult = Parser.parse((Iterable)JavaSourcesSubject.this.actual());
            ImmutableList errors = actualResult.diagnosticsByKind().get((Object)Diagnostic.Kind.ERROR);
            if (!errors.isEmpty()) {
                StringBuilder message = new StringBuilder("Parsing produced the following errors:\n");
                for (Diagnostic error : errors) {
                    message.append('\n');
                    message.append(error);
                }
                JavaSourcesSubject.this.failWithRawMessage(message.toString(), new Object[0]);
                return;
            }
            Parser.ParseResult expectedResult = Parser.parse(Lists.asList((Object)first, (Object[])rest));
            final FluentIterable actualTrees = FluentIterable.from(actualResult.compilationUnits());
            FluentIterable expectedTrees = FluentIterable.from(expectedResult.compilationUnits());
            Function<CompilationUnitTree, ImmutableSet<String>> getTypesFunction = new Function<CompilationUnitTree, ImmutableSet<String>>(){

                public ImmutableSet<String> apply(CompilationUnitTree compilationUnit) {
                    return TypeEnumerator.getTopLevelTypes(compilationUnit);
                }
            };
            final ImmutableMap expectedTreeTypes = Maps.toMap((Iterable)expectedTrees, (Function)getTypesFunction);
            final ImmutableMap actualTreeTypes = Maps.toMap((Iterable)actualTrees, (Function)getTypesFunction);
            ImmutableMap matchedTrees = Maps.toMap((Iterable)expectedTrees, (Function)new Function<CompilationUnitTree, Optional<? extends CompilationUnitTree>>(){

                public Optional<? extends CompilationUnitTree> apply(final CompilationUnitTree expectedTree) {
                    return Iterables.tryFind((Iterable)actualTrees, (Predicate)new Predicate<CompilationUnitTree>(){

                        public boolean apply(CompilationUnitTree actualTree) {
                            return ((ImmutableSet)expectedTreeTypes.get((Object)expectedTree)).equals(actualTreeTypes.get((Object)actualTree));
                        }
                    });
                }
            });
            for (Map.Entry matchedTreePair : matchedTrees.entrySet()) {
                CompilationUnitTree expectedTree = (CompilationUnitTree)matchedTreePair.getKey();
                if (!((Optional)matchedTreePair.getValue()).isPresent()) {
                    this.failNoCandidates((ImmutableSet<String>)((ImmutableSet)expectedTreeTypes.get((Object)expectedTree)), expectedTree, (ImmutableMap<? extends CompilationUnitTree, ImmutableSet<String>>)actualTreeTypes, (FluentIterable<? extends CompilationUnitTree>)actualTrees);
                    continue;
                }
                CompilationUnitTree actualTree = (CompilationUnitTree)((Optional)matchedTreePair.getValue()).get();
                TreeDifference treeDifference = TreeDiffer.diffCompilationUnits(expectedTree, actualTree);
                if (treeDifference.isEmpty()) continue;
                String diffReport = treeDifference.getDiffReport(new TreeContext(expectedTree, expectedResult.trees()), new TreeContext(actualTree, actualResult.trees()));
                this.failWithCandidate(expectedTree.getSourceFile(), actualTree.getSourceFile(), diffReport);
            }
        }

        private void failNoCandidates(ImmutableSet<String> expectedTypes, CompilationUnitTree expectedTree, final ImmutableMap<? extends CompilationUnitTree, ImmutableSet<String>> actualTypes, FluentIterable<? extends CompilationUnitTree> actualTrees) {
            String generatedTypesReport = Joiner.on((char)'\n').join((Iterable)actualTrees.transform((Function)new Function<CompilationUnitTree, String>(){

                public String apply(CompilationUnitTree generated) {
                    return String.format("- %s in <%s>", actualTypes.get((Object)generated), generated.getSourceFile().toUri().getPath());
                }
            }).toList());
            JavaSourcesSubject.this.failWithRawMessage(Joiner.on((char)'\n').join((Object)"", (Object)"An expected source declared one or more top-level types that were not present.", new Object[]{"", String.format("Expected top-level types: <%s>", expectedTypes), String.format("Declared by expected file: <%s>", expectedTree.getSourceFile().toUri().getPath()), "", "The top-level types that were present are as follows: ", "", generatedTypesReport, ""}), new Object[0]);
        }

        private void failWithCandidate(JavaFileObject expectedSource, JavaFileObject actualSource, String diffReport) {
            try {
                JavaSourcesSubject.this.failWithRawMessage(Joiner.on((char)'\n').join((Object)"", (Object)"Source declared the same top-level types of an expected source, but", new Object[]{"didn't match exactly.", "", String.format("Expected file: <%s>", expectedSource.toUri().getPath()), String.format("Actual file: <%s>", actualSource.toUri().getPath()), "", "Diffs:", "======", "", diffReport, "", "Expected Source: ", "================", "", expectedSource.getCharContent(false).toString(), "", "Actual Source:", "=================", "", actualSource.getCharContent(false).toString()}), new Object[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't read from JavaFileObject when it was already in memory.", e);
            }
        }

        @Override
        @CanIgnoreReturnValue
        public CompileTester.SuccessfulCompilationClause compilesWithoutError() {
            Compilation compilation = this.compilation();
            ((CompilationSubject)JavaSourcesSubject.this.check().about(CompilationSubject.compilations()).that((Object)compilation)).succeeded();
            return new SuccessfulCompilationBuilder(compilation);
        }

        @Override
        @CanIgnoreReturnValue
        public CompileTester.CleanCompilationClause compilesWithoutWarnings() {
            Compilation compilation = this.compilation();
            ((CompilationSubject)JavaSourcesSubject.this.check().about(CompilationSubject.compilations()).that((Object)compilation)).succeededWithoutWarnings();
            return new CleanCompilationBuilder(compilation);
        }

        @Override
        @CanIgnoreReturnValue
        public CompileTester.UnsuccessfulCompilationClause failsToCompile() {
            Compilation compilation = this.compilation();
            ((CompilationSubject)JavaSourcesSubject.this.check().about(CompilationSubject.compilations()).that((Object)compilation)).failed();
            return new UnsuccessfulCompilationBuilder(compilation);
        }

        private Compilation compilation() {
            Compiler compiler = Compiler.javac().withProcessors((Iterable<? extends Processor>)this.processors).withOptions(JavaSourcesSubject.this.options);
            if (JavaSourcesSubject.this.classLoader != null) {
                compiler = compiler.withClasspathFrom(JavaSourcesSubject.this.classLoader);
            }
            return compiler.compile((Iterable)JavaSourcesSubject.this.actual());
        }
    }
}

