(function() {
  var SpellCheckTask, idCounter;

  idCounter = 0;

  module.exports = SpellCheckTask = (function() {
    SpellCheckTask.handler = null;

    SpellCheckTask.jobs = [];

    function SpellCheckTask(manager) {
      this.manager = manager;
      this.id = idCounter++;
    }

    SpellCheckTask.prototype.terminate = function() {
      return this.constructor.removeFromArray(this.constructor.jobs, function(j) {
        return j.args.id === this.id;
      });
    };

    SpellCheckTask.prototype.start = function(editor, onDidSpellCheck) {
      var buffer, job, projectPath, ref, ref1, relativePath;
      buffer = editor.getBuffer();
      projectPath = null;
      relativePath = null;
      if (buffer != null ? (ref = buffer.file) != null ? ref.path : void 0 : void 0) {
        ref1 = atom.project.relativizePath(buffer.file.path), projectPath = ref1[0], relativePath = ref1[1];
      }
      this.constructor.removeFromArray(this.constructor.jobs, function(j) {
        return j.args.id === this.id;
      });
      job = {
        manager: this.manager,
        callbacks: [onDidSpellCheck],
        editorId: editor.id,
        args: {
          id: this.id,
          projectPath: projectPath,
          relativePath: relativePath,
          text: buffer.getText()
        }
      };
      if (this.constructor.piggybackExistingJob(job)) {
        return;
      }
      this.constructor.jobs.unshift(job);
      if (this.constructor.jobs.length === 1) {
        return this.constructor.startNextJob();
      }
    };

    SpellCheckTask.piggybackExistingJob = function(newJob) {
      var job, k, len, ref;
      if (this.jobs.length > 0) {
        ref = this.jobs;
        for (k = 0, len = ref.length; k < len; k++) {
          job = ref[k];
          if (this.isDuplicateRequest(job, newJob)) {
            job.callbacks = job.callbacks.concat(newJob.callbacks);
            return true;
          }
        }
      }
      return false;
    };

    SpellCheckTask.isDuplicateRequest = function(a, b) {
      return a.args.projectPath === b.args.projectPath && a.args.relativePath === b.args.relativePath;
    };

    SpellCheckTask.removeFromArray = function(array, predicate) {
      var found, i, k, ref;
      if (array.length > 0) {
        for (i = k = 0, ref = array.length - 1; 0 <= ref ? k <= ref : k >= ref; i = 0 <= ref ? ++k : --k) {
          if (predicate(array[i])) {
            found = array[i];
            array.splice(i, 1);
            return found;
          }
        }
      }
    };

    SpellCheckTask.startNextJob = function() {
      var activeEditorId, job, ref;
      activeEditorId = (ref = atom.workspace.getActiveTextEditor()) != null ? ref.id : void 0;
      job = this.jobs.find(function(j) {
        return j.editorId === activeEditorId;
      }) || this.jobs[0];
      return job.manager.check(job.args, job.args.text).then((function(_this) {
        return function(results) {
          var callback, k, len, ref1;
          _this.removeFromArray(_this.jobs, function(j) {
            return j.args.id === job.args.id;
          });
          ref1 = job.callbacks;
          for (k = 0, len = ref1.length; k < len; k++) {
            callback = ref1[k];
            callback(results.misspellings);
          }
          if (_this.jobs.length > 0) {
            return _this.startNextJob();
          }
        };
      })(this));
    };

    SpellCheckTask.clear = function() {
      return this.jobs = [];
    };

    return SpellCheckTask;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
