'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrCommitView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _nodeEmoji = require('node-emoji');

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _reactRelay = require('react-relay');

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const avatarAltText = 'committer avatar';

class PrCommitView extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.openCommitDetailItem = () => this.props.openCommit({ sha: this.props.item.sha });

    this.state = { showMessageBody: false };
    (0, _helpers.autobind)(this, 'toggleShowCommitMessageBody', 'humanizeTimeSince');
  }

  toggleShowCommitMessageBody() {
    this.setState({ showMessageBody: !this.state.showMessageBody });
  }

  humanizeTimeSince(date) {
    return (0, _moment2.default)(date).fromNow();
  }

  render() {
    const { messageHeadline, messageBody, shortSha, url } = this.props.item;
    const { avatarUrl, name, date } = this.props.item.committer;
    return _react2.default.createElement(
      'div',
      { className: 'github-PrCommitView-container' },
      _react2.default.createElement(
        'div',
        { className: 'github-PrCommitView-commit' },
        _react2.default.createElement(
          'h3',
          { className: 'github-PrCommitView-title' },
          this.props.onBranch ? _react2.default.createElement(
            'button',
            { className: 'github-PrCommitView-messageHeadline is-button', onClick: this.openCommitDetailItem },
            (0, _nodeEmoji.emojify)(messageHeadline)
          ) : _react2.default.createElement(
            'span',
            { className: 'github-PrCommitView-messageHeadline' },
            (0, _nodeEmoji.emojify)(messageHeadline)
          ),
          messageBody ? _react2.default.createElement(
            'button',
            {
              className: 'github-PrCommitView-moreButton',
              onClick: this.toggleShowCommitMessageBody },
            this.state.showMessageBody ? 'hide' : 'show',
            ' more...'
          ) : null
        ),
        _react2.default.createElement(
          'div',
          { className: 'github-PrCommitView-meta' },
          _react2.default.createElement('img', { className: 'github-PrCommitView-avatar',
            src: avatarUrl,
            alt: avatarAltText, title: avatarAltText
          }),
          _react2.default.createElement(
            'span',
            { className: 'github-PrCommitView-metaText' },
            name,
            ' committed ',
            this.humanizeTimeSince(date)
          )
        ),
        this.state.showMessageBody ? _react2.default.createElement(
          'pre',
          { className: 'github-PrCommitView-moreText' },
          (0, _nodeEmoji.emojify)(messageBody)
        ) : null
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-PrCommitView-sha' },
        _react2.default.createElement(
          'a',
          { href: url,
            title: `open commit ${shortSha} on GitHub.com` },
          shortSha
        )
      )
    );
  }
}

exports.PrCommitView = PrCommitView;
PrCommitView.propTypes = {
  item: _propTypes2.default.shape({
    committer: _propTypes2.default.shape({
      avatarUrl: _propTypes2.default.string.isRequired,
      name: _propTypes2.default.string.isRequired,
      date: _propTypes2.default.string.isRequired
    }).isRequired,
    messageBody: _propTypes2.default.string,
    messageHeadline: _propTypes2.default.string.isRequired,
    shortSha: _propTypes2.default.string.isRequired,
    sha: _propTypes2.default.string.isRequired,
    url: _propTypes2.default.string.isRequired
  }).isRequired,
  onBranch: _propTypes2.default.bool.isRequired,
  openCommit: _propTypes2.default.func.isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(PrCommitView, {
  item: function () {
    const node = require('./__generated__/prCommitView_item.graphql');

    if (node.hash && node.hash !== '2bd193bec5d758f465d9428ff3cd8a09') {
      console.error('The definition of \'prCommitView_item\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/prCommitView_item.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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