'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _atom = require('atom');

var _stagingView = require('./staging-view');

var _stagingView2 = _interopRequireDefault(_stagingView);

var _gitLogo = require('./git-logo');

var _gitLogo2 = _interopRequireDefault(_gitLogo);

var _commitController = require('../controllers/commit-controller');

var _commitController2 = _interopRequireDefault(_commitController);

var _recentCommitsController = require('../controllers/recent-commits-controller');

var _recentCommitsController2 = _interopRequireDefault(_recentCommitsController);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GitTabView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'initializeRepo', 'blur', 'advanceFocus', 'retreatFocus', 'quietlySelectItem');

    this.subscriptions = new _atom.CompositeDisposable();

    this.refCommitController = new _refHolder2.default();
    this.refRecentCommitsController = new _refHolder2.default();
  }

  componentDidMount() {
    this.props.refRoot.map(root => {
      return this.subscriptions.add(this.props.commandRegistry.add(root, {
        'tool-panel:unfocus': this.blur,
        'core:focus-next': this.advanceFocus,
        'core:focus-previous': this.retreatFocus
      }));
    });
  }

  render() {
    if (this.props.repository.isTooLarge()) {
      return _react2.default.createElement(
        'div',
        { className: 'github-Git is-empty', tabIndex: '-1', ref: this.props.refRoot.setter },
        _react2.default.createElement(
          'div',
          { ref: 'noRepoMessage', className: 'github-Git no-repository' },
          _react2.default.createElement(
            'div',
            { className: 'large-icon' },
            _react2.default.createElement(_gitLogo2.default, null)
          ),
          _react2.default.createElement(
            'h3',
            null,
            'Too many changes'
          ),
          _react2.default.createElement(
            'div',
            { className: 'initialize-repo-description' },
            'The repository at ',
            _react2.default.createElement(
              'strong',
              null,
              this.props.workingDirectoryPath
            ),
            ' has too many changed files to display in Atom. Ensure that you have set up an appropriate ',
            _react2.default.createElement(
              'code',
              null,
              '.gitignore'
            ),
            ' file.'
          )
        )
      );
    } else if (this.props.repository.hasDirectory() && !(0, _helpers.isValidWorkdir)(this.props.repository.getWorkingDirectoryPath())) {
      return _react2.default.createElement(
        'div',
        { className: 'github-Git is-empty', tabIndex: '-1', ref: this.props.refRoot.setter },
        _react2.default.createElement(
          'div',
          { ref: 'noRepoMessage', className: 'github-Git no-repository' },
          _react2.default.createElement(
            'div',
            { className: 'large-icon' },
            _react2.default.createElement(_gitLogo2.default, null)
          ),
          _react2.default.createElement(
            'h3',
            null,
            'Unsupported directory'
          ),
          _react2.default.createElement(
            'div',
            { className: 'initialize-repo-description' },
            'Atom does not support managing Git repositories in your home or root directories.'
          )
        )
      );
    } else if (this.props.repository.showGitTabInit()) {
      const inProgress = this.props.repository.showGitTabInitInProgress();
      const message = this.props.repository.hasDirectory() ? _react2.default.createElement(
        'span',
        null,
        'Initialize ',
        _react2.default.createElement(
          'strong',
          null,
          this.props.workingDirectoryPath
        ),
        ' with a Git repository'
      ) : _react2.default.createElement(
        'span',
        null,
        'Initialize a new project directory with a Git repository'
      );

      return _react2.default.createElement(
        'div',
        { className: 'github-Git is-empty', tabIndex: '-1', ref: this.props.refRoot.setter },
        _react2.default.createElement(
          'div',
          { ref: 'noRepoMessage', className: 'github-Git no-repository' },
          _react2.default.createElement(
            'div',
            { className: 'large-icon' },
            _react2.default.createElement(_gitLogo2.default, null)
          ),
          _react2.default.createElement(
            'div',
            { className: 'initialize-repo-description' },
            message
          ),
          _react2.default.createElement(
            'button',
            { onClick: this.initializeRepo, disabled: inProgress, className: 'btn btn-primary' },
            inProgress ? 'Creating repository...' : 'Create repository'
          )
        )
      );
    } else {
      const isLoading = this.props.isLoading || this.props.repository.showGitTabLoading();

      return _react2.default.createElement(
        'div',
        {
          className: (0, _classnames2.default)('github-Git', { 'is-loading': isLoading }),
          tabIndex: '-1',
          ref: this.props.refRoot.setter },
        _react2.default.createElement(_stagingView2.default, {
          ref: this.props.refStagingView.setter,
          commandRegistry: this.props.commandRegistry,
          notificationManager: this.props.notificationManager,
          workspace: this.props.workspace,
          stagedChanges: this.props.stagedChanges,
          unstagedChanges: this.props.unstagedChanges,
          mergeConflicts: this.props.mergeConflicts,
          workingDirectoryPath: this.props.workingDirectoryPath,
          resolutionProgress: this.props.resolutionProgress,
          openFiles: this.props.openFiles,
          discardWorkDirChangesForPaths: this.props.discardWorkDirChangesForPaths,
          attemptFileStageOperation: this.props.attemptFileStageOperation,
          attemptStageAllOperation: this.props.attemptStageAllOperation,
          undoLastDiscard: this.props.undoLastDiscard,
          abortMerge: this.props.abortMerge,
          resolveAsOurs: this.props.resolveAsOurs,
          resolveAsTheirs: this.props.resolveAsTheirs,
          lastCommit: this.props.lastCommit,
          isLoading: this.props.isLoading,
          hasUndoHistory: this.props.hasUndoHistory,
          isMerging: this.props.isMerging
        }),
        _react2.default.createElement(_commitController2.default, {
          ref: this.refCommitController.setter,
          tooltips: this.props.tooltips,
          config: this.props.config,
          stagedChangesExist: this.props.stagedChanges.length > 0,
          mergeConflictsExist: this.props.mergeConflicts.length > 0,
          prepareToCommit: this.props.prepareToCommit,
          commit: this.props.commit,
          abortMerge: this.props.abortMerge,
          currentBranch: this.props.currentBranch,
          workspace: this.props.workspace,
          commandRegistry: this.props.commandRegistry,
          notificationManager: this.props.notificationManager,
          grammars: this.props.grammars,
          mergeMessage: this.props.mergeMessage,
          isMerging: this.props.isMerging,
          isLoading: this.props.isLoading,
          lastCommit: this.props.lastCommit,
          repository: this.props.repository,
          userStore: this.props.userStore,
          selectedCoAuthors: this.props.selectedCoAuthors,
          updateSelectedCoAuthors: this.props.updateSelectedCoAuthors
        }),
        _react2.default.createElement(_recentCommitsController2.default, {
          ref: this.refRecentCommitsController.setter,
          commandRegistry: this.props.commandRegistry,
          commits: this.props.recentCommits,
          isLoading: this.props.isLoading,
          undoLastCommit: this.props.undoLastCommit,
          workspace: this.props.workspace,
          repository: this.props.repository
        })
      );
    }
  }

  componentWillUnmount() {
    this.subscriptions.dispose();
  }

  initializeRepo(event) {
    event.preventDefault();
    let initPath = null;
    const activeEditor = this.props.workspace.getActiveTextEditor();
    if (activeEditor) {
      const [projectPath] = this.props.project.relativizePath(activeEditor.getPath());
      if (projectPath) {
        initPath = projectPath;
      }
    }
    this.props.initializeRepo(initPath);
  }

  getFocus(element) {
    for (const ref of [this.props.refStagingView, this.refCommitController, this.refRecentCommitsController]) {
      const focus = ref.map(sub => sub.getFocus(element)).getOr(null);
      if (focus !== null) {
        return focus;
      }
    }
    return null;
  }

  setFocus(focus) {
    for (const ref of [this.props.refStagingView, this.refCommitController, this.refRecentCommitsController]) {
      if (ref.map(sub => sub.setFocus(focus)).getOr(false)) {
        return true;
      }
    }
    return false;
  }

  blur() {
    this.props.workspace.getCenter().activate();
  }

  async advanceFocus(evt) {
    const currentFocus = this.getFocus(document.activeElement);
    let nextSeen = false;

    for (const subHolder of [this.props.refStagingView, this.refCommitController, this.refRecentCommitsController]) {
      const next = await subHolder.map(sub => sub.advanceFocusFrom(currentFocus)).getOr(null);
      if (next !== null && !nextSeen) {
        nextSeen = true;
        evt.stopPropagation();
        if (next !== currentFocus) {
          this.setFocus(next);
        }
      }
    }
  }

  async retreatFocus(evt) {
    const currentFocus = this.getFocus(document.activeElement);
    let previousSeen = false;

    for (const subHolder of [this.refRecentCommitsController, this.refCommitController, this.props.refStagingView]) {
      const previous = await subHolder.map(sub => sub.retreatFocusFrom(currentFocus)).getOr(null);
      if (previous !== null && !previousSeen) {
        previousSeen = true;
        evt.stopPropagation();
        if (previous !== currentFocus) {
          this.setFocus(previous);
        }
      }
    }
  }

  async focusAndSelectStagingItem(filePath, stagingStatus) {
    await this.quietlySelectItem(filePath, stagingStatus);
    this.setFocus(GitTabView.focus.STAGING);
  }

  focusAndSelectRecentCommit() {
    this.setFocus(_recentCommitsController2.default.focus.RECENT_COMMIT);
  }

  focusAndSelectCommitPreviewButton() {
    this.setFocus(GitTabView.focus.COMMIT_PREVIEW_BUTTON);
  }

  quietlySelectItem(filePath, stagingStatus) {
    return this.props.refStagingView.map(view => view.quietlySelectItem(filePath, stagingStatus)).getOr(false);
  }

  hasFocus() {
    return this.props.refRoot.map(root => root.contains(document.activeElement)).getOr(false);
  }
}
exports.default = GitTabView;
GitTabView.focus = _extends({}, _stagingView2.default.focus, _commitController2.default.focus, _recentCommitsController2.default.focus);
GitTabView.propTypes = {
  refRoot: _propTypes3.RefHolderPropType,
  refStagingView: _propTypes3.RefHolderPropType,

  repository: _propTypes2.default.object.isRequired,
  isLoading: _propTypes2.default.bool.isRequired,

  lastCommit: _propTypes2.default.object.isRequired,
  currentBranch: _propTypes2.default.object,
  recentCommits: _propTypes2.default.arrayOf(_propTypes2.default.object).isRequired,
  isMerging: _propTypes2.default.bool,
  isRebasing: _propTypes2.default.bool,
  hasUndoHistory: _propTypes2.default.bool,
  unstagedChanges: _propTypes2.default.arrayOf(_propTypes2.default.object),
  stagedChanges: _propTypes2.default.arrayOf(_propTypes2.default.object),
  mergeConflicts: _propTypes2.default.arrayOf(_propTypes2.default.object),
  workingDirectoryPath: _propTypes2.default.string,
  mergeMessage: _propTypes2.default.string,
  userStore: _propTypes3.UserStorePropType.isRequired,
  selectedCoAuthors: _propTypes2.default.arrayOf(_propTypes3.AuthorPropType),
  updateSelectedCoAuthors: _propTypes2.default.func.isRequired,

  workspace: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  grammars: _propTypes2.default.object.isRequired,
  resolutionProgress: _propTypes2.default.object.isRequired,
  notificationManager: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,
  project: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,

  initializeRepo: _propTypes2.default.func.isRequired,
  abortMerge: _propTypes2.default.func.isRequired,
  commit: _propTypes2.default.func.isRequired,
  undoLastCommit: _propTypes2.default.func.isRequired,
  prepareToCommit: _propTypes2.default.func.isRequired,
  resolveAsOurs: _propTypes2.default.func.isRequired,
  resolveAsTheirs: _propTypes2.default.func.isRequired,
  undoLastDiscard: _propTypes2.default.func.isRequired,
  attemptStageAllOperation: _propTypes2.default.func.isRequired,
  attemptFileStageOperation: _propTypes2.default.func.isRequired,
  discardWorkDirChangesForPaths: _propTypes2.default.func.isRequired,
  openFiles: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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