'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _propTypes3 = require('../prop-types');

var _helpers = require('../helpers');

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

class FilePatchListItemView extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.refItem = new _refHolder2.default();
    this.subs = new _eventKit.CompositeDisposable(this.refItem.observe(item => this.props.registerItemElement(this.props.filePatch, item)));
  }

  render() {
    const _props = this.props,
          { filePatch, selected } = _props,
          others = _objectWithoutProperties(_props, ['filePatch', 'selected']);
    delete others.registerItemElement;
    const status = _helpers.classNameForStatus[filePatch.status];
    const className = selected ? 'is-selected' : '';

    return _react2.default.createElement(
      'div',
      _extends({ ref: this.refItem.setter }, others, { className: `github-FilePatchListView-item is-${status} ${className}` }),
      _react2.default.createElement('span', { className: `github-FilePatchListView-icon icon icon-diff-${status} status-${status}` }),
      _react2.default.createElement(
        'span',
        { className: 'github-FilePatchListView-path' },
        filePatch.filePath
      )
    );
  }

  componentWillUnmount() {
    this.subs.dispose();
  }
}
exports.default = FilePatchListItemView;
FilePatchListItemView.propTypes = {
  filePatch: _propTypes3.FilePatchItemPropType.isRequired,
  selected: _propTypes2.default.bool.isRequired,
  registerItemElement: _propTypes2.default.func
};
FilePatchListItemView.defaultProps = {
  registerItemElement: () => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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