'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

class DonutChart extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderArc');
  }

  render() {
    const _props = this.props,
          { slices, baseOffset } = _props,
          others = _objectWithoutProperties(_props, ['slices', 'baseOffset']); // eslint-disable-line no-unused-vars
    const arcs = this.calculateArcs(slices);

    return _react2.default.createElement(
      'svg',
      others,
      arcs.map(this.renderArc)
    );
  }

  calculateArcs(slices) {
    const total = slices.reduce((acc, item) => acc + item.count, 0);
    let lengthSoFar = 0;

    return slices.map((_ref) => {
      let { count } = _ref,
          others = _objectWithoutProperties(_ref, ['count']);

      const piece = _extends({
        length: count / total * 100,
        position: lengthSoFar
      }, others);
      lengthSoFar += piece.length;
      return piece;
    });
  }

  renderArc({ length, position, type, className }) {
    return _react2.default.createElement('circle', {
      key: type,
      cx: '21',
      cy: '21',
      r: '15.91549430918954',
      fill: 'transparent',
      className: `donut-ring-${type}`,
      pathLength: '100',
      strokeWidth: '3',
      strokeDasharray: `${length} ${100 - length}`,
      strokeDashoffset: `${100 - position + this.props.baseOffset}`
    });
  }
}
exports.default = DonutChart;
DonutChart.propTypes = {
  baseOffset: _propTypes2.default.number,
  slices: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    type: _propTypes2.default.string,
    className: _propTypes2.default.string,
    count: _propTypes2.default.number
  }))
};
DonutChart.defaultProps = {
  baseOffset: 25
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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