'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Accordion extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'toggle');

    this.state = {
      expanded: true
    };
  }

  render() {
    return _react2.default.createElement(
      'details',
      { className: 'github-Accordion', open: this.state.expanded },
      _react2.default.createElement(
        'summary',
        { className: 'github-Accordion-header', onClick: this.toggle },
        this.renderHeader()
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-Accordion-content' },
        this.renderContent()
      )
    );
  }

  renderHeader() {
    return _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement(
        'span',
        { className: 'github-Accordion--leftTitle' },
        this.props.leftTitle
      ),
      this.props.rightTitle && _react2.default.createElement(
        'span',
        { className: 'github-Accordion--rightTitle' },
        this.props.rightTitle
      )
    );
  }

  renderContent() {
    if (this.props.isLoading) {
      const Loading = this.props.loadingComponent;
      return _react2.default.createElement(Loading, null);
    }

    if (this.props.results.length === 0) {
      const Empty = this.props.emptyComponent;
      return _react2.default.createElement(Empty, null);
    }

    if (!this.state.expanded) {
      return null;
    }

    const More = this.props.moreComponent;

    return _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement(
        'ul',
        { className: 'github-Accordion-list' },
        this.props.results.map((item, index) => {
          const key = item.key !== undefined ? item.key : index;
          return _react2.default.createElement(
            'li',
            { className: 'github-Accordion-listItem', key: key, onClick: () => this.props.onClickItem(item) },
            this.props.children(item)
          );
        })
      ),
      this.props.results.length < this.props.total && _react2.default.createElement(More, null)
    );
  }

  toggle(e) {
    e.preventDefault();
    return new Promise(resolve => {
      this.setState(prevState => ({ expanded: !prevState.expanded }), resolve);
    });
  }
}
exports.default = Accordion;
Accordion.propTypes = {
  leftTitle: _propTypes2.default.string.isRequired,
  rightTitle: _propTypes2.default.string,
  results: _propTypes2.default.arrayOf(_propTypes2.default.any).isRequired,
  total: _propTypes2.default.number.isRequired,
  isLoading: _propTypes2.default.bool.isRequired,
  loadingComponent: _propTypes2.default.func,
  emptyComponent: _propTypes2.default.func,
  moreComponent: _propTypes2.default.func,
  onClickItem: _propTypes2.default.func,
  children: _propTypes2.default.func.isRequired
};
Accordion.defaultProps = {
  loadingComponent: () => null,
  emptyComponent: () => null,
  moreComponent: () => null,
  onClickItem: () => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFjY29yZGlvbi5qcyJdLCJuYW1lcyI6WyJBY2NvcmRpb24iLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJzdGF0ZSIsImV4cGFuZGVkIiwicmVuZGVyIiwidG9nZ2xlIiwicmVuZGVySGVhZGVyIiwicmVuZGVyQ29udGVudCIsImxlZnRUaXRsZSIsInJpZ2h0VGl0bGUiLCJpc0xvYWRpbmciLCJMb2FkaW5nIiwibG9hZGluZ0NvbXBvbmVudCIsInJlc3VsdHMiLCJsZW5ndGgiLCJFbXB0eSIsImVtcHR5Q29tcG9uZW50IiwiTW9yZSIsIm1vcmVDb21wb25lbnQiLCJtYXAiLCJpdGVtIiwiaW5kZXgiLCJrZXkiLCJ1bmRlZmluZWQiLCJvbkNsaWNrSXRlbSIsImNoaWxkcmVuIiwidG90YWwiLCJlIiwicHJldmVudERlZmF1bHQiLCJQcm9taXNlIiwicmVzb2x2ZSIsInNldFN0YXRlIiwicHJldlN0YXRlIiwicHJvcFR5cGVzIiwiUHJvcFR5cGVzIiwic3RyaW5nIiwiaXNSZXF1aXJlZCIsImFycmF5T2YiLCJhbnkiLCJudW1iZXIiLCJib29sIiwiZnVuYyIsImRlZmF1bHRQcm9wcyJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7Ozs7QUFDQTs7OztBQUVBOzs7O0FBRWUsTUFBTUEsU0FBTixTQUF3QkMsZ0JBQU1DLFNBQTlCLENBQXdDOztBQXFCckRDLGNBQVlDLEtBQVosRUFBbUI7QUFDakIsVUFBTUEsS0FBTjtBQUNBLDJCQUFTLElBQVQsRUFBZSxRQUFmOztBQUVBLFNBQUtDLEtBQUwsR0FBYTtBQUNYQyxnQkFBVTtBQURDLEtBQWI7QUFHRDs7QUFFREMsV0FBUztBQUNQLFdBQ0U7QUFBQTtBQUFBLFFBQVMsV0FBVSxrQkFBbkIsRUFBc0MsTUFBTSxLQUFLRixLQUFMLENBQVdDLFFBQXZEO0FBQ0U7QUFBQTtBQUFBLFVBQVMsV0FBVSx5QkFBbkIsRUFBNkMsU0FBUyxLQUFLRSxNQUEzRDtBQUNHLGFBQUtDLFlBQUw7QUFESCxPQURGO0FBSUU7QUFBQTtBQUFBLFVBQU0sV0FBVSwwQkFBaEI7QUFDRyxhQUFLQyxhQUFMO0FBREg7QUFKRixLQURGO0FBVUQ7O0FBRURELGlCQUFlO0FBQ2IsV0FDRTtBQUFDLHFCQUFEO0FBQUE7QUFDRTtBQUFBO0FBQUEsVUFBTSxXQUFVLDZCQUFoQjtBQUNHLGFBQUtMLEtBQUwsQ0FBV087QUFEZCxPQURGO0FBSUcsV0FBS1AsS0FBTCxDQUFXUSxVQUFYLElBQ0M7QUFBQTtBQUFBLFVBQU0sV0FBVSw4QkFBaEI7QUFDRyxhQUFLUixLQUFMLENBQVdRO0FBRGQ7QUFMSixLQURGO0FBWUQ7O0FBRURGLGtCQUFnQjtBQUNkLFFBQUksS0FBS04sS0FBTCxDQUFXUyxTQUFmLEVBQTBCO0FBQ3hCLFlBQU1DLFVBQVUsS0FBS1YsS0FBTCxDQUFXVyxnQkFBM0I7QUFDQSxhQUFPLDhCQUFDLE9BQUQsT0FBUDtBQUNEOztBQUVELFFBQUksS0FBS1gsS0FBTCxDQUFXWSxPQUFYLENBQW1CQyxNQUFuQixLQUE4QixDQUFsQyxFQUFxQztBQUNuQyxZQUFNQyxRQUFRLEtBQUtkLEtBQUwsQ0FBV2UsY0FBekI7QUFDQSxhQUFPLDhCQUFDLEtBQUQsT0FBUDtBQUNEOztBQUVELFFBQUksQ0FBQyxLQUFLZCxLQUFMLENBQVdDLFFBQWhCLEVBQTBCO0FBQ3hCLGFBQU8sSUFBUDtBQUNEOztBQUVELFVBQU1jLE9BQU8sS0FBS2hCLEtBQUwsQ0FBV2lCLGFBQXhCOztBQUVBLFdBQ0U7QUFBQyxxQkFBRDtBQUFBO0FBQ0U7QUFBQTtBQUFBLFVBQUksV0FBVSx1QkFBZDtBQUNHLGFBQUtqQixLQUFMLENBQVdZLE9BQVgsQ0FBbUJNLEdBQW5CLENBQXVCLENBQUNDLElBQUQsRUFBT0MsS0FBUCxLQUFpQjtBQUN2QyxnQkFBTUMsTUFBTUYsS0FBS0UsR0FBTCxLQUFhQyxTQUFiLEdBQXlCSCxLQUFLRSxHQUE5QixHQUFvQ0QsS0FBaEQ7QUFDQSxpQkFDRTtBQUFBO0FBQUEsY0FBSSxXQUFVLDJCQUFkLEVBQTBDLEtBQUtDLEdBQS9DLEVBQW9ELFNBQVMsTUFBTSxLQUFLckIsS0FBTCxDQUFXdUIsV0FBWCxDQUF1QkosSUFBdkIsQ0FBbkU7QUFDRyxpQkFBS25CLEtBQUwsQ0FBV3dCLFFBQVgsQ0FBb0JMLElBQXBCO0FBREgsV0FERjtBQUtELFNBUEE7QUFESCxPQURGO0FBV0csV0FBS25CLEtBQUwsQ0FBV1ksT0FBWCxDQUFtQkMsTUFBbkIsR0FBNEIsS0FBS2IsS0FBTCxDQUFXeUIsS0FBdkMsSUFBZ0QsOEJBQUMsSUFBRDtBQVhuRCxLQURGO0FBZUQ7O0FBRURyQixTQUFPc0IsQ0FBUCxFQUFVO0FBQ1JBLE1BQUVDLGNBQUY7QUFDQSxXQUFPLElBQUlDLE9BQUosQ0FBWUMsV0FBVztBQUM1QixXQUFLQyxRQUFMLENBQWNDLGNBQWMsRUFBQzdCLFVBQVUsQ0FBQzZCLFVBQVU3QixRQUF0QixFQUFkLENBQWQsRUFBOEQyQixPQUE5RDtBQUNELEtBRk0sQ0FBUDtBQUdEO0FBakdvRDtrQkFBbENqQyxTO0FBQUFBLFMsQ0FDWm9DLFMsR0FBWTtBQUNqQnpCLGFBQVcwQixvQkFBVUMsTUFBVixDQUFpQkMsVUFEWDtBQUVqQjNCLGNBQVl5QixvQkFBVUMsTUFGTDtBQUdqQnRCLFdBQVNxQixvQkFBVUcsT0FBVixDQUFrQkgsb0JBQVVJLEdBQTVCLEVBQWlDRixVQUh6QjtBQUlqQlYsU0FBT1Esb0JBQVVLLE1BQVYsQ0FBaUJILFVBSlA7QUFLakIxQixhQUFXd0Isb0JBQVVNLElBQVYsQ0FBZUosVUFMVDtBQU1qQnhCLG9CQUFrQnNCLG9CQUFVTyxJQU5YO0FBT2pCekIsa0JBQWdCa0Isb0JBQVVPLElBUFQ7QUFRakJ2QixpQkFBZWdCLG9CQUFVTyxJQVJSO0FBU2pCakIsZUFBYVUsb0JBQVVPLElBVE47QUFVakJoQixZQUFVUyxvQkFBVU8sSUFBVixDQUFlTDtBQVZSLEM7QUFEQXZDLFMsQ0FjWjZDLFksR0FBZTtBQUNwQjlCLG9CQUFrQixNQUFNLElBREo7QUFFcEJJLGtCQUFnQixNQUFNLElBRkY7QUFHcEJFLGlCQUFlLE1BQU0sSUFIRDtBQUlwQk0sZUFBYSxNQUFNLENBQUU7QUFKRCxDIiwiZmlsZSI6ImFjY29yZGlvbi5qcyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM1LjEvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViL2xpYi92aWV3cyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCwge0ZyYWdtZW50fSBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuXG5pbXBvcnQge2F1dG9iaW5kfSBmcm9tICcuLi9oZWxwZXJzJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgQWNjb3JkaW9uIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBsZWZ0VGl0bGU6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICByaWdodFRpdGxlOiBQcm9wVHlwZXMuc3RyaW5nLFxuICAgIHJlc3VsdHM6IFByb3BUeXBlcy5hcnJheU9mKFByb3BUeXBlcy5hbnkpLmlzUmVxdWlyZWQsXG4gICAgdG90YWw6IFByb3BUeXBlcy5udW1iZXIuaXNSZXF1aXJlZCxcbiAgICBpc0xvYWRpbmc6IFByb3BUeXBlcy5ib29sLmlzUmVxdWlyZWQsXG4gICAgbG9hZGluZ0NvbXBvbmVudDogUHJvcFR5cGVzLmZ1bmMsXG4gICAgZW1wdHlDb21wb25lbnQ6IFByb3BUeXBlcy5mdW5jLFxuICAgIG1vcmVDb21wb25lbnQ6IFByb3BUeXBlcy5mdW5jLFxuICAgIG9uQ2xpY2tJdGVtOiBQcm9wVHlwZXMuZnVuYyxcbiAgICBjaGlsZHJlbjogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgfTtcblxuICBzdGF0aWMgZGVmYXVsdFByb3BzID0ge1xuICAgIGxvYWRpbmdDb21wb25lbnQ6ICgpID0+IG51bGwsXG4gICAgZW1wdHlDb21wb25lbnQ6ICgpID0+IG51bGwsXG4gICAgbW9yZUNvbXBvbmVudDogKCkgPT4gbnVsbCxcbiAgICBvbkNsaWNrSXRlbTogKCkgPT4ge30sXG4gIH07XG5cbiAgY29uc3RydWN0b3IocHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG4gICAgYXV0b2JpbmQodGhpcywgJ3RvZ2dsZScpO1xuXG4gICAgdGhpcy5zdGF0ZSA9IHtcbiAgICAgIGV4cGFuZGVkOiB0cnVlLFxuICAgIH07XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxkZXRhaWxzIGNsYXNzTmFtZT1cImdpdGh1Yi1BY2NvcmRpb25cIiBvcGVuPXt0aGlzLnN0YXRlLmV4cGFuZGVkfT5cbiAgICAgICAgPHN1bW1hcnkgY2xhc3NOYW1lPVwiZ2l0aHViLUFjY29yZGlvbi1oZWFkZXJcIiBvbkNsaWNrPXt0aGlzLnRvZ2dsZX0+XG4gICAgICAgICAge3RoaXMucmVuZGVySGVhZGVyKCl9XG4gICAgICAgIDwvc3VtbWFyeT5cbiAgICAgICAgPG1haW4gY2xhc3NOYW1lPVwiZ2l0aHViLUFjY29yZGlvbi1jb250ZW50XCI+XG4gICAgICAgICAge3RoaXMucmVuZGVyQ29udGVudCgpfVxuICAgICAgICA8L21haW4+XG4gICAgICA8L2RldGFpbHM+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlckhlYWRlcigpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPEZyYWdtZW50PlxuICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJnaXRodWItQWNjb3JkaW9uLS1sZWZ0VGl0bGVcIj5cbiAgICAgICAgICB7dGhpcy5wcm9wcy5sZWZ0VGl0bGV9XG4gICAgICAgIDwvc3Bhbj5cbiAgICAgICAge3RoaXMucHJvcHMucmlnaHRUaXRsZSAmJiAoXG4gICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPVwiZ2l0aHViLUFjY29yZGlvbi0tcmlnaHRUaXRsZVwiPlxuICAgICAgICAgICAge3RoaXMucHJvcHMucmlnaHRUaXRsZX1cbiAgICAgICAgICA8L3NwYW4+XG4gICAgICAgICl9XG4gICAgICA8L0ZyYWdtZW50PlxuICAgICk7XG4gIH1cblxuICByZW5kZXJDb250ZW50KCkge1xuICAgIGlmICh0aGlzLnByb3BzLmlzTG9hZGluZykge1xuICAgICAgY29uc3QgTG9hZGluZyA9IHRoaXMucHJvcHMubG9hZGluZ0NvbXBvbmVudDtcbiAgICAgIHJldHVybiA8TG9hZGluZyAvPjtcbiAgICB9XG5cbiAgICBpZiAodGhpcy5wcm9wcy5yZXN1bHRzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgY29uc3QgRW1wdHkgPSB0aGlzLnByb3BzLmVtcHR5Q29tcG9uZW50O1xuICAgICAgcmV0dXJuIDxFbXB0eSAvPjtcbiAgICB9XG5cbiAgICBpZiAoIXRoaXMuc3RhdGUuZXhwYW5kZWQpIHtcbiAgICAgIHJldHVybiBudWxsO1xuICAgIH1cblxuICAgIGNvbnN0IE1vcmUgPSB0aGlzLnByb3BzLm1vcmVDb21wb25lbnQ7XG5cbiAgICByZXR1cm4gKFxuICAgICAgPEZyYWdtZW50PlxuICAgICAgICA8dWwgY2xhc3NOYW1lPVwiZ2l0aHViLUFjY29yZGlvbi1saXN0XCI+XG4gICAgICAgICAge3RoaXMucHJvcHMucmVzdWx0cy5tYXAoKGl0ZW0sIGluZGV4KSA9PiB7XG4gICAgICAgICAgICBjb25zdCBrZXkgPSBpdGVtLmtleSAhPT0gdW5kZWZpbmVkID8gaXRlbS5rZXkgOiBpbmRleDtcbiAgICAgICAgICAgIHJldHVybiAoXG4gICAgICAgICAgICAgIDxsaSBjbGFzc05hbWU9XCJnaXRodWItQWNjb3JkaW9uLWxpc3RJdGVtXCIga2V5PXtrZXl9IG9uQ2xpY2s9eygpID0+IHRoaXMucHJvcHMub25DbGlja0l0ZW0oaXRlbSl9PlxuICAgICAgICAgICAgICAgIHt0aGlzLnByb3BzLmNoaWxkcmVuKGl0ZW0pfVxuICAgICAgICAgICAgICA8L2xpPlxuICAgICAgICAgICAgKTtcbiAgICAgICAgICB9KX1cbiAgICAgICAgPC91bD5cbiAgICAgICAge3RoaXMucHJvcHMucmVzdWx0cy5sZW5ndGggPCB0aGlzLnByb3BzLnRvdGFsICYmIDxNb3JlIC8+fVxuICAgICAgPC9GcmFnbWVudD5cbiAgICApO1xuICB9XG5cbiAgdG9nZ2xlKGUpIHtcbiAgICBlLnByZXZlbnREZWZhdWx0KCk7XG4gICAgcmV0dXJuIG5ldyBQcm9taXNlKHJlc29sdmUgPT4ge1xuICAgICAgdGhpcy5zZXRTdGF0ZShwcmV2U3RhdGUgPT4gKHtleHBhbmRlZDogIXByZXZTdGF0ZS5leHBhbmRlZH0pLCByZXNvbHZlKTtcbiAgICB9KTtcbiAgfVxufVxuIl19