'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _remote = require('./remote');

var _helpers = require('../helpers');

class RemoteSet {
  constructor(iterable = []) {
    this.byName = new Map();
    this.byDotcomRepo = new Map();
    this.protocolCount = new Map();
    for (const remote of iterable) {
      this.add(remote);
    }
  }

  add(remote) {
    this.byName.set(remote.getName(), remote);
    if (remote.isGithubRepo()) {
      (0, _helpers.pushAtKey)(this.byDotcomRepo, remote.getSlug(), remote);
    }
    if (remote.getProtocol()) {
      const count = this.protocolCount.get(remote.getProtocol()) || 0;
      this.protocolCount.set(remote.getProtocol(), count + 1);
    }
  }

  isEmpty() {
    return this.byName.size === 0;
  }

  size() {
    return this.byName.size;
  }

  withName(name) {
    return this.byName.get(name) || _remote.nullRemote;
  }

  [Symbol.iterator]() {
    return this.byName.values();
  }

  filter(predicate) {
    return new this.constructor(Array.from(this).filter(predicate));
  }

  matchingGitHubRepository(owner, name) {
    return this.byDotcomRepo.get(`${owner}/${name}`) || [];
  }

  mostUsedProtocol(choices) {
    let best = choices[0];
    let bestCount = 0;
    for (const protocol of choices) {
      const count = this.protocolCount.get(protocol) || 0;
      if (count > bestCount) {
        bestCount = count;
        best = protocol;
      }
    }
    return best;
  }
}
exports.default = RemoteSet;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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