'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _author = require('../models/author');

var _author2 = _interopRequireDefault(_author);

var _gitTabView = require('../views/git-tab-view');

var _gitTabView2 = _interopRequireDefault(_gitTabView);

var _userStore = require('../models/user-store');

var _userStore2 = _interopRequireDefault(_userStore);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _propTypes3 = require('../prop-types');

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GitTabController extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'attemptStageAllOperation', 'attemptFileStageOperation', 'unstageFiles', 'prepareToCommit', 'commit', 'updateSelectedCoAuthors', 'undoLastCommit', 'abortMerge', 'resolveAsOurs', 'resolveAsTheirs', 'checkout', 'rememberLastFocus', 'quietlySelectItem');

    this.stagingOperationInProgress = false;
    this.lastFocus = _gitTabView2.default.focus.STAGING;

    this.refView = new _refHolder2.default();
    this.refRoot = new _refHolder2.default();
    this.refStagingView = new _refHolder2.default();

    this.state = {
      selectedCoAuthors: []
    };

    this.userStore = new _userStore2.default({
      repository: this.props.repository,
      login: this.props.loginModel,
      config: this.props.config
    });
  }

  render() {
    return _react2.default.createElement(_gitTabView2.default, {
      ref: this.refView.setter,
      refRoot: this.refRoot,
      refStagingView: this.refStagingView,

      isLoading: this.props.fetchInProgress,
      repository: this.props.repository,

      lastCommit: this.props.lastCommit,
      recentCommits: this.props.recentCommits,
      isMerging: this.props.isMerging,
      isRebasing: this.props.isRebasing,
      hasUndoHistory: this.props.hasUndoHistory,
      currentBranch: this.props.currentBranch,
      unstagedChanges: this.props.unstagedChanges,
      stagedChanges: this.props.stagedChanges,
      mergeConflicts: this.props.mergeConflicts,
      workingDirectoryPath: this.props.workingDirectoryPath,
      mergeMessage: this.props.mergeMessage,
      userStore: this.userStore,
      selectedCoAuthors: this.state.selectedCoAuthors,
      updateSelectedCoAuthors: this.updateSelectedCoAuthors,

      resolutionProgress: this.props.resolutionProgress,
      workspace: this.props.workspace,
      commandRegistry: this.props.commandRegistry,
      grammars: this.props.grammars,
      tooltips: this.props.tooltips,
      notificationManager: this.props.notificationManager,
      project: this.props.project,
      confirm: this.props.confirm,
      config: this.props.config,

      initializeRepo: this.props.initializeRepo,
      openFiles: this.props.openFiles,
      discardWorkDirChangesForPaths: this.props.discardWorkDirChangesForPaths,
      undoLastDiscard: this.props.undoLastDiscard,

      attemptFileStageOperation: this.attemptFileStageOperation,
      attemptStageAllOperation: this.attemptStageAllOperation,
      prepareToCommit: this.prepareToCommit,
      commit: this.commit,
      undoLastCommit: this.undoLastCommit,
      push: this.push,
      pull: this.pull,
      fetch: this.fetch,
      checkout: this.checkout,
      abortMerge: this.abortMerge,
      resolveAsOurs: this.resolveAsOurs,
      resolveAsTheirs: this.resolveAsTheirs
    });
  }

  componentDidMount() {
    this.refreshResolutionProgress(false, false);
    this.refRoot.map(root => root.addEventListener('focusin', this.rememberLastFocus));

    if (this.props.controllerRef) {
      this.props.controllerRef.setter(this);
    }
  }

  componentDidUpdate() {
    this.userStore.setRepository(this.props.repository);
    this.userStore.setLoginModel(this.props.loginModel);
    this.refreshResolutionProgress(false, false);
  }

  componentWillUnmount() {
    this.refRoot.map(root => root.removeEventListener('focusin', this.rememberLastFocus));
  }

  /*
   * Begin (but don't await) an async conflict-counting task for each merge conflict path that has no conflict
   * marker count yet. Omit any path that's already open in a TextEditor or that has already been counted.
   *
   * includeOpen - update marker counts for files that are currently open in TextEditors
   * includeCounted - update marker counts for files that have been counted before
   */
  refreshResolutionProgress(includeOpen, includeCounted) {
    if (this.props.fetchInProgress) {
      return;
    }

    const openPaths = new Set(this.props.workspace.getTextEditors().map(editor => editor.getPath()));

    for (let i = 0; i < this.props.mergeConflicts.length; i++) {
      const conflictPath = _path2.default.join(this.props.workingDirectoryPath, this.props.mergeConflicts[i].filePath);

      if (!includeOpen && openPaths.has(conflictPath)) {
        continue;
      }

      if (!includeCounted && this.props.resolutionProgress.getRemaining(conflictPath) !== undefined) {
        continue;
      }

      this.props.refreshResolutionProgress(conflictPath);
    }
  }

  attemptStageAllOperation(stageStatus) {
    return this.attemptFileStageOperation(['.'], stageStatus);
  }

  attemptFileStageOperation(filePaths, stageStatus) {
    if (this.stagingOperationInProgress) {
      return {
        stageOperationPromise: Promise.resolve(),
        selectionUpdatePromise: Promise.resolve()
      };
    }

    this.stagingOperationInProgress = true;

    const fileListUpdatePromise = this.refStagingView.map(view => {
      return view.getNextListUpdatePromise();
    }).getOr(Promise.resolve());
    let stageOperationPromise;
    if (stageStatus === 'staged') {
      stageOperationPromise = this.unstageFiles(filePaths);
    } else {
      stageOperationPromise = this.stageFiles(filePaths);
    }
    const selectionUpdatePromise = fileListUpdatePromise.then(() => {
      this.stagingOperationInProgress = false;
    });

    return { stageOperationPromise, selectionUpdatePromise };
  }

  async stageFiles(filePaths) {
    const pathsToStage = new Set(filePaths);

    const mergeMarkers = await Promise.all(filePaths.map(async filePath => {
      return {
        filePath,
        hasMarkers: await this.props.repository.pathHasMergeMarkers(filePath)
      };
    }));

    for (const _ref of mergeMarkers) {
      const { filePath, hasMarkers } = _ref;

      if (hasMarkers) {
        const choice = this.props.confirm({
          message: 'File contains merge markers: ',
          detailedMessage: `Do you still want to stage this file?\n${filePath}`,
          buttons: ['Stage', 'Cancel']
        });
        if (choice !== 0) {
          pathsToStage.delete(filePath);
        }
      }
    }

    return this.props.repository.stageFiles(Array.from(pathsToStage));
  }

  unstageFiles(filePaths) {
    return this.props.repository.unstageFiles(filePaths);
  }

  async prepareToCommit() {
    return !(await this.props.ensureGitTab());
  }

  commit(message, options) {
    return this.props.repository.commit(message, options);
  }

  updateSelectedCoAuthors(selectedCoAuthors, newAuthor) {
    if (newAuthor) {
      this.userStore.addUsers([newAuthor]);
      selectedCoAuthors = selectedCoAuthors.concat([newAuthor]);
    }
    this.setState({ selectedCoAuthors });
  }

  async undoLastCommit() {
    const repo = this.props.repository;
    const lastCommit = await repo.getLastCommit();
    if (lastCommit.isUnbornRef()) {
      return null;
    }

    await repo.undoLastCommit();
    repo.setCommitMessage(lastCommit.getFullMessage());

    const coAuthors = lastCommit.getCoAuthors().map(author => new _author2.default(author.email, author.name));

    this.updateSelectedCoAuthors(coAuthors);

    return null;
  }

  async abortMerge() {
    const choice = this.props.confirm({
      message: 'Abort merge',
      detailedMessage: 'Are you sure?',
      buttons: ['Abort', 'Cancel']
    });
    if (choice !== 0) {
      return;
    }

    try {
      await this.props.repository.abortMerge();
    } catch (e) {
      if (e.code === 'EDIRTYSTAGED') {
        this.props.notificationManager.addError(`Cannot abort because ${e.path} is both dirty and staged.`, { dismissable: true });
      } else {
        throw e;
      }
    }
  }

  async resolveAsOurs(paths) {
    if (this.props.fetchInProgress) {
      return;
    }

    const side = this.props.isRebasing ? 'theirs' : 'ours';
    await this.props.repository.checkoutSide(side, paths);
    this.refreshResolutionProgress(false, true);
  }

  async resolveAsTheirs(paths) {
    if (this.props.fetchInProgress) {
      return;
    }

    const side = this.props.isRebasing ? 'ours' : 'theirs';
    await this.props.repository.checkoutSide(side, paths);
    this.refreshResolutionProgress(false, true);
  }

  checkout(branchName, options) {
    return this.props.repository.checkout(branchName, options);
  }

  rememberLastFocus(event) {
    this.lastFocus = this.refView.map(view => view.getFocus(event.target)).getOr(null) || _gitTabView2.default.focus.STAGING;
  }

  restoreFocus() {
    this.refView.map(view => view.setFocus(this.lastFocus));
  }

  hasFocus() {
    return this.refRoot.map(root => root.contains(document.activeElement)).getOr(false);
  }

  wasActivated(isStillActive) {
    process.nextTick(() => {
      isStillActive() && this.restoreFocus();
    });
  }

  focusAndSelectStagingItem(filePath, stagingStatus) {
    return this.refView.map(view => view.focusAndSelectStagingItem(filePath, stagingStatus)).getOr(null);
  }

  focusAndSelectCommitPreviewButton() {
    return this.refView.map(view => view.focusAndSelectCommitPreviewButton());
  }

  focusAndSelectRecentCommit() {
    return this.refView.map(view => view.focusAndSelectRecentCommit());
  }

  quietlySelectItem(filePath, stagingStatus) {
    return this.refView.map(view => view.quietlySelectItem(filePath, stagingStatus)).getOr(null);
  }
}
exports.default = GitTabController;
GitTabController.focus = _extends({}, _gitTabView2.default.focus);
GitTabController.propTypes = {
  repository: _propTypes2.default.object.isRequired,
  loginModel: _propTypes2.default.object.isRequired,

  lastCommit: _propTypes3.CommitPropType.isRequired,
  recentCommits: _propTypes2.default.arrayOf(_propTypes3.CommitPropType).isRequired,
  isMerging: _propTypes2.default.bool.isRequired,
  isRebasing: _propTypes2.default.bool.isRequired,
  hasUndoHistory: _propTypes2.default.bool.isRequired,
  currentBranch: _propTypes3.BranchPropType.isRequired,
  unstagedChanges: _propTypes2.default.arrayOf(_propTypes3.FilePatchItemPropType).isRequired,
  stagedChanges: _propTypes2.default.arrayOf(_propTypes3.FilePatchItemPropType).isRequired,
  mergeConflicts: _propTypes2.default.arrayOf(_propTypes3.MergeConflictItemPropType).isRequired,
  workingDirectoryPath: _propTypes2.default.string,
  mergeMessage: _propTypes2.default.string,
  fetchInProgress: _propTypes2.default.bool.isRequired,

  workspace: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  grammars: _propTypes2.default.object.isRequired,
  resolutionProgress: _propTypes2.default.object.isRequired,
  notificationManager: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,
  project: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,

  confirm: _propTypes2.default.func.isRequired,
  ensureGitTab: _propTypes2.default.func.isRequired,
  refreshResolutionProgress: _propTypes2.default.func.isRequired,
  undoLastDiscard: _propTypes2.default.func.isRequired,
  discardWorkDirChangesForPaths: _propTypes2.default.func.isRequired,
  openFiles: _propTypes2.default.func.isRequired,
  initializeRepo: _propTypes2.default.func.isRequired,
  controllerRef: _propTypes3.RefHolderPropType
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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