'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _loadingView = require('../views/loading-view');

var _loadingView2 = _interopRequireDefault(_loadingView);

var _commitPreviewController = require('../controllers/commit-preview-controller');

var _commitPreviewController2 = _interopRequireDefault(_commitPreviewController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CommitPreviewContainer extends _react2.default.Component {
  constructor(...args) {
    var _temp;

    return _temp = super(...args), this.fetchData = repository => {
      return (0, _yubikiri2.default)({
        multiFilePatch: repository.getStagedChangesPatch()
      });
    }, this.renderResult = data => {
      if (this.props.repository.isLoading() || data === null) {
        return _react2.default.createElement(_loadingView2.default, null);
      }

      return _react2.default.createElement(_commitPreviewController2.default, _extends({
        stagingStatus: 'staged'
      }, data, this.props));
    }, _temp;
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.repository, fetchData: this.fetchData },
      this.renderResult
    );
  }

}
exports.default = CommitPreviewContainer;
CommitPreviewContainer.propTypes = {
  repository: _propTypes2.default.object.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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