(function() {
  var Emitter, HISTORY_MAX, History, HistoryCycler, _;

  _ = require('underscore-plus');

  Emitter = require('atom').Emitter;

  HISTORY_MAX = 25;

  History = (function() {
    function History(items) {
      this.items = items != null ? items : [];
      this.emitter = new Emitter;
      this.length = this.items.length;
    }

    History.prototype.onDidAddItem = function(callback) {
      return this.emitter.on('did-add-item', callback);
    };

    History.prototype.serialize = function() {
      return this.items.slice(-HISTORY_MAX);
    };

    History.prototype.getLast = function() {
      return _.last(this.items);
    };

    History.prototype.getAtIndex = function(index) {
      return this.items[index];
    };

    History.prototype.add = function(text) {
      this.items.push(text);
      this.length = this.items.length;
      return this.emitter.emit('did-add-item', text);
    };

    History.prototype.clear = function() {
      this.items = [];
      return this.length = 0;
    };

    return History;

  })();

  HistoryCycler = (function() {
    function HistoryCycler(buffer, history) {
      this.buffer = buffer;
      this.history = history;
      this.index = this.history.length;
      this.history.onDidAddItem((function(_this) {
        return function(text) {
          if (text !== _this.buffer.getText()) {
            return _this.buffer.setText(text);
          }
        };
      })(this));
    }

    HistoryCycler.prototype.addEditorElement = function(editorElement) {
      return atom.commands.add(editorElement, {
        'core:move-up': (function(_this) {
          return function() {
            return _this.previous();
          };
        })(this),
        'core:move-down': (function(_this) {
          return function() {
            return _this.next();
          };
        })(this)
      });
    };

    HistoryCycler.prototype.previous = function() {
      var ref;
      if (this.history.length === 0 || (this.atLastItem() && this.buffer.getText() !== this.history.getLast())) {
        this.scratch = this.buffer.getText();
      } else if (this.index > 0) {
        this.index--;
      }
      return this.buffer.setText((ref = this.history.getAtIndex(this.index)) != null ? ref : '');
    };

    HistoryCycler.prototype.next = function() {
      var item;
      if (this.index < this.history.length - 1) {
        this.index++;
        item = this.history.getAtIndex(this.index);
      } else if (this.scratch) {
        item = this.scratch;
      } else {
        item = '';
      }
      return this.buffer.setText(item);
    };

    HistoryCycler.prototype.atLastItem = function() {
      return this.index === this.history.length - 1;
    };

    HistoryCycler.prototype.store = function() {
      var text;
      text = this.buffer.getText();
      if (!text || text === this.history.getLast()) {
        return;
      }
      this.scratch = null;
      this.history.add(text);
      return this.index = this.history.length - 1;
    };

    return HistoryCycler;

  })();

  module.exports = {
    History: History,
    HistoryCycler: HistoryCycler
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
