/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.legacy.PApplet;

public class CommandlineParser {
    private final String[] args;
    private final Map<String, ACTION> actions;
    private ACTION action = ACTION.GUI;
    private boolean doVerboseBuild = false;
    private boolean doVerboseUpload = false;
    private boolean doUseProgrammer = false;
    private boolean preserveTempFiles;
    private boolean noUploadPort = false;
    private boolean forceSavePrefs = false;
    private String getPref;
    private String boardToInstall;
    private String libraryToInstall;
    private final List<String> filenames = new LinkedList<String>();

    public CommandlineParser(String[] args) {
        this.args = args;
        this.actions = new HashMap<String, ACTION>();
        this.actions.put("--verify", ACTION.VERIFY);
        this.actions.put("--upload", ACTION.UPLOAD);
        this.actions.put("--get-pref", ACTION.GET_PREF);
        this.actions.put("--install-boards", ACTION.INSTALL_BOARD);
        this.actions.put("--install-library", ACTION.INSTALL_LIBRARY);
        this.actions.put("--version", ACTION.VERSION);
    }

    public void parseArgumentsPhase1() {
        for (int i = 0; i < this.args.length; ++i) {
            ACTION a = this.actions.get(this.args[i]);
            if (a != null) {
                if (this.action != ACTION.GUI && this.action != ACTION.NOOP) {
                    Set<String> strings = this.actions.keySet();
                    String[] valid = strings.toArray(new String[strings.size()]);
                    String mess = I18n.format(I18n.tr("Can only pass one of: {0}"), PApplet.join(valid, ", "));
                    BaseNoGui.showError(null, mess, 3);
                }
                if (a == ACTION.GET_PREF && ++i < this.args.length) {
                    this.getPref = this.args[i];
                }
                if (a == ACTION.INSTALL_BOARD) {
                    if (++i >= this.args.length) {
                        BaseNoGui.showError(null, I18n.format(I18n.tr("Argument required for {0}"), a.value), 3);
                    }
                    this.boardToInstall = this.args[i];
                }
                if (a == ACTION.INSTALL_LIBRARY) {
                    if (++i >= this.args.length) {
                        BaseNoGui.showError(null, I18n.format(I18n.tr("Argument required for {0}"), a.value), 3);
                    }
                    this.libraryToInstall = this.args[i];
                }
                this.action = a;
                continue;
            }
            if (this.args[i].startsWith("-psn")) continue;
            if (this.args[i].equals("--verbose") || this.args[i].equals("-v")) {
                this.doVerboseBuild = true;
                this.doVerboseUpload = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (this.args[i].equals("--preserve-temp-files")) {
                this.preserveTempFiles = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (this.args[i].equals("--verbose-build")) {
                this.doVerboseBuild = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (this.args[i].equals("--verbose-upload")) {
                this.doVerboseUpload = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (this.args[i].equals("--useprogrammer")) {
                this.doUseProgrammer = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (this.args[i].equals("--nouploadport")) {
                this.noUploadPort = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (this.args[i].equals("--board")) {
                if (++i >= this.args.length) {
                    BaseNoGui.showError(null, I18n.tr("Argument required for --board"), 3);
                }
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (this.args[i].equals("--port")) {
                if (++i >= this.args.length) {
                    BaseNoGui.showError(null, I18n.tr("Argument required for --port"), 3);
                }
                BaseNoGui.selectSerialPort(this.args[i]);
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (this.args[i].equals("--curdir")) {
                BaseNoGui.showError(null, I18n.tr("--curdir no longer supported"), 3);
                return;
            }
            if (this.args[i].equals("--buildpath")) {
                File buildFolder;
                if (++i >= this.args.length) {
                    BaseNoGui.showError(null, "Argument required for --buildpath", 3);
                }
                if (!(buildFolder = new File(this.args[i])).exists()) {
                    BaseNoGui.showError(null, "The build path doesn't exist", 3);
                }
                if (!buildFolder.isDirectory()) {
                    BaseNoGui.showError(null, "The build path is not a folder", 3);
                }
                PreferencesData.set("build.path", buildFolder.getAbsolutePath());
                continue;
            }
            if (this.args[i].equals("--pref")) {
                if (++i >= this.args.length) {
                    BaseNoGui.showError(null, I18n.tr("Argument required for --pref"), 3);
                }
                this.processPrefArgument(this.args[i]);
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (this.args[i].equals("--save-prefs")) {
                this.forceSavePrefs = true;
                continue;
            }
            if (this.args[i].equals("--preferences-file")) {
                if (++i < this.args.length) continue;
                BaseNoGui.showError(null, I18n.tr("Argument required for --preferences-file"), 3);
                continue;
            }
            if (this.args[i].startsWith("--")) {
                BaseNoGui.showError(null, I18n.format(I18n.tr("unknown option: {0}"), this.args[i]), 3);
            }
            this.filenames.add(this.args[i]);
        }
        this.checkAction();
    }

    public void parseArgumentsPhase2() {
        for (int i = 0; i < this.args.length; ++i) {
            if (!this.args[i].equals("--board")) continue;
            if (++i >= this.args.length) {
                BaseNoGui.showError(null, I18n.tr("Argument required for --board"), 3);
            }
            this.processBoardArgument(this.args[i]);
            if (this.action != ACTION.GUI) continue;
            this.action = ACTION.NOOP;
        }
    }

    private void checkAction() {
        if ((this.action == ACTION.UPLOAD || this.action == ACTION.VERIFY) && this.filenames.size() != 1) {
            BaseNoGui.showError(null, I18n.tr("Must specify exactly one sketch file"), 3);
        }
        if ((this.action == ACTION.NOOP || this.action == ACTION.GET_PREF) && this.filenames.size() != 0) {
            BaseNoGui.showError(null, I18n.tr("Cannot specify any sketch files"), 3);
        }
        if (this.action != ACTION.UPLOAD && this.action != ACTION.VERIFY && (this.doVerboseBuild || this.doVerboseUpload)) {
            BaseNoGui.showError(null, I18n.tr("--verbose, --verbose-upload and --verbose-build can only be used together with --verify or --upload"), 3);
        }
    }

    private void processBoardArgument(String selectBoard) {
        TargetPackage targetPackage;
        if (selectBoard == null) {
            return;
        }
        String[] split = selectBoard.split(":", 4);
        if (split.length < 3) {
            BaseNoGui.showError(null, I18n.format(I18n.tr("{0}: Invalid board name, it should be of the form \"package:arch:board\" or \"package:arch:board:options\""), selectBoard), 3);
        }
        if ((targetPackage = BaseNoGui.getTargetPackage(split[0])) == null) {
            BaseNoGui.showError(null, I18n.format(I18n.tr("{0}: Unknown package"), split[0]), 3);
            return;
        }
        TargetPlatform targetPlatform = targetPackage.get(split[1]);
        if (targetPlatform == null) {
            BaseNoGui.showError(null, I18n.format(I18n.tr("{0}: Unknown architecture"), split[1]), 3);
            return;
        }
        TargetBoard targetBoard = targetPlatform.getBoard(split[2]);
        if (targetBoard == null || !targetBoard.getId().equals(split[2])) {
            BaseNoGui.showError(null, I18n.format(I18n.tr("{0}: Unknown board"), split[2]), 3);
            return;
        }
        BaseNoGui.selectBoard(targetBoard);
        BaseNoGui.onBoardOrPortChange();
        if (split.length > 3) {
            String[] options;
            for (String option : options = split[3].split(",")) {
                String[] keyValue = option.split("=", 2);
                if (keyValue.length != 2) {
                    BaseNoGui.showError(null, I18n.format(I18n.tr("{0}: Invalid option, should be of the form \"name=value\""), option, targetBoard.getId()), 3);
                }
                String key = keyValue[0].trim();
                String value = keyValue[1].trim();
                if (!targetBoard.hasMenu(key)) {
                    BaseNoGui.showError(null, I18n.format(I18n.tr("{0}: Invalid option for board \"{1}\""), key, targetBoard.getId()), 3);
                }
                if (targetBoard.getMenuLabel(key, value) == null) {
                    BaseNoGui.showError(null, I18n.format(I18n.tr("{0}: Invalid value for option \"{1}\" for board \"{2}\""), value, key, targetBoard.getId()), 3);
                }
                PreferencesData.set("custom_" + key, targetBoard.getId() + "_" + value);
            }
        }
    }

    private void processPrefArgument(String arg) {
        String[] split = arg.split("=", 2);
        if (split.length != 2 || split[0].isEmpty()) {
            BaseNoGui.showError(null, I18n.format(I18n.tr("{0}: Invalid argument to --pref, should be of the form \"pref=value\""), arg), 3);
        }
        PreferencesData.set(split[0], split[1]);
        PreferencesData.set("runtime.build_properties_custom." + split[0], split[1]);
    }

    public boolean isDoVerboseBuild() {
        return this.doVerboseBuild;
    }

    public boolean isDoVerboseUpload() {
        return this.doVerboseUpload;
    }

    public boolean isForceSavePrefs() {
        return this.forceSavePrefs;
    }

    public String getGetPref() {
        return this.getPref;
    }

    public List<String> getFilenames() {
        return this.filenames;
    }

    public boolean isGetPrefMode() {
        return this.action == ACTION.GET_PREF;
    }

    public boolean isGuiMode() {
        return this.action == ACTION.GUI;
    }

    public boolean isNoOpMode() {
        return this.action == ACTION.NOOP;
    }

    public boolean isUploadMode() {
        return this.action == ACTION.UPLOAD;
    }

    private boolean isVerifyMode() {
        return this.action == ACTION.VERIFY;
    }

    public boolean isVerifyOrUploadMode() {
        return this.isVerifyMode() || this.isUploadMode();
    }

    public boolean isDoUseProgrammer() {
        return this.doUseProgrammer;
    }

    public boolean isNoUploadPort() {
        return this.noUploadPort;
    }

    public boolean isInstallBoard() {
        return this.action == ACTION.INSTALL_BOARD;
    }

    public boolean isInstallLibrary() {
        return this.action == ACTION.INSTALL_LIBRARY;
    }

    public boolean isVersionMode() {
        return this.action == ACTION.VERSION;
    }

    public String getBoardToInstall() {
        return this.boardToInstall;
    }

    public String getLibraryToInstall() {
        return this.libraryToInstall;
    }

    public boolean isPreserveTempFiles() {
        return this.preserveTempFiles;
    }

    private static enum ACTION {
        GUI,
        NOOP,
        VERIFY("--verify"),
        UPLOAD("--upload"),
        GET_PREF("--get-pref"),
        INSTALL_BOARD("--install-boards"),
        INSTALL_LIBRARY("--install-library"),
        VERSION("--version");

        final String value;

        private ACTION() {
            this.value = null;
        }

        private ACTION(String value) {
            this.value = value;
        }
    }
}

