/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.Constants;
import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.SignatureVerificationFailedException;
import cc.arduino.contributions.SignatureVerifier;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ContributedTargetPackage;
import cc.arduino.contributions.packages.ContributedTargetPlatform;
import cc.arduino.contributions.packages.ContributedTool;
import cc.arduino.contributions.packages.ContributionsIndex;
import cc.arduino.contributions.packages.EmptyContributionIndex;
import cc.arduino.contributions.packages.PackageIndexFilenameFilter;
import cc.arduino.contributions.packages.TestPackageIndexFilenameFilter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.mrbean.MrBeanModule;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.IOUtils;
import processing.app.I18n;
import processing.app.Platform;
import processing.app.PreferencesData;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.debug.TargetPlatformException;
import processing.app.helpers.FileUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.filefilters.OnlyDirs;

public class ContributionsIndexer {
    private final File packagesFolder;
    private final File stagingFolder;
    private final File preferencesFolder;
    private final File builtInHardwareFolder;
    private final Platform platform;
    private final SignatureVerifier signatureVerifier;
    private final ContributionsIndex index;

    public ContributionsIndexer(File preferencesFolder, File builtInHardwareFolder, Platform platform, SignatureVerifier signatureVerifier) {
        this.preferencesFolder = preferencesFolder;
        this.builtInHardwareFolder = builtInHardwareFolder;
        this.platform = platform;
        this.signatureVerifier = signatureVerifier;
        this.index = new EmptyContributionIndex();
        this.packagesFolder = new File(preferencesFolder, "packages");
        this.stagingFolder = new File(preferencesFolder, "staging" + File.separator + "packages");
    }

    public void parseIndex() throws Exception {
        File bundledIndexFile = new File(this.builtInHardwareFolder, "package_index_bundled.json");
        this.mergeContributions(bundledIndexFile);
        File defaultIndexFile = this.getIndexFile("package_index.json");
        if (defaultIndexFile.exists()) {
            if (!PreferencesData.getBoolean("allow_insecure_packages") && !this.signatureVerifier.isSigned(defaultIndexFile)) {
                throw new SignatureVerificationFailedException("package_index.json");
            }
            this.mergeContributions(defaultIndexFile);
        }
        this.index.getPackages().forEach(pack -> pack.setTrusted(true));
        File[] indexFiles = this.preferencesFolder.listFiles(new TestPackageIndexFilenameFilter(new PackageIndexFilenameFilter("package_index.json")));
        if (indexFiles != null) {
            for (File indexFile : indexFiles) {
                try {
                    this.mergeContributions(indexFile);
                }
                catch (JsonProcessingException e) {
                    System.err.println(I18n.format(I18n.tr("Skipping contributed index file {0}, parsing error occured:"), indexFile));
                    System.err.println((Object)e);
                }
            }
        } else {
            System.err.println(I18n.format(I18n.tr("Error reading package indexes folder: {0}\n(maybe a permission problem?)"), this.preferencesFolder));
        }
        List<ContributedPackage> packages = this.index.getPackages();
        Collection packagesWithTools = packages.stream().filter(input -> input.getTools() != null && !input.getTools().isEmpty()).collect(Collectors.toList());
        for (ContributedPackage pack2 : packages) {
            for (ContributedTool tool : pack2.getTools()) {
                tool.setPackage(pack2);
            }
            for (ContributedPlatform plat : pack2.getPlatforms()) {
                plat.setParentPackage(pack2);
                plat.resolveToolsDependencies(packagesWithTools);
            }
        }
        this.index.fillCategories();
    }

    private void mergeContributions(File indexFile) throws IOException {
        if (!indexFile.exists()) {
            return;
        }
        ContributionsIndex contributionsIndex = this.parseIndex(indexFile);
        boolean signed = this.signatureVerifier.isSigned(indexFile);
        boolean trustall = PreferencesData.getBoolean("contributions.trust.all");
        for (ContributedPackage contributedPackage : contributionsIndex.getPackages()) {
            List<ContributedPlatform> platforms;
            ContributedPackage targetPackage;
            contributedPackage.setTrusted(signed || trustall);
            if (!contributedPackage.isTrusted()) {
                for (ContributedPlatform contributedPlatform : contributedPackage.getPlatforms()) {
                    contributedPlatform.setCategory("Contributed");
                }
            }
            if ((targetPackage = this.index.getPackage(contributedPackage.getName())) == null) {
                this.index.getPackages().add(contributedPackage);
                continue;
            }
            if (!contributedPackage.isTrusted() && this.isPackageNameProtected(contributedPackage)) continue;
            if (this.isPackageNameProtected(contributedPackage) && trustall) {
                System.err.println(I18n.format(I18n.tr("Warning: forced trusting untrusted contributions"), new Object[0]));
            }
            if ((platforms = contributedPackage.getPlatforms()) == null) {
                platforms = new LinkedList<ContributedPlatform>();
            }
            for (ContributedPlatform contributedPlatform : platforms) {
                ContributedPlatform plat = targetPackage.findPlatform(contributedPlatform.getArchitecture(), contributedPlatform.getVersion());
                if (plat != null) {
                    targetPackage.getPlatforms().remove(plat);
                }
                targetPackage.getPlatforms().add(contributedPlatform);
            }
            List<ContributedTool> tools = contributedPackage.getTools();
            if (tools == null) {
                tools = new LinkedList<ContributedTool>();
            }
            for (ContributedTool contributedTool : tools) {
                ContributedTool tool = targetPackage.findTool(contributedTool.getName(), contributedTool.getVersion());
                if (tool != null) {
                    targetPackage.getTools().remove(tool);
                }
                targetPackage.getTools().add(contributedTool);
            }
        }
    }

    private boolean isPackageNameProtected(ContributedPackage contributedPackage) {
        return Constants.PROTECTED_PACKAGE_NAMES.contains(contributedPackage.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContributionsIndex parseIndex(File indexFile) throws IOException {
        ContributionsIndex contributionsIndex;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(indexFile);
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new MrBeanModule());
            mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            mapper.configure(DeserializationFeature.EAGER_DESERIALIZER_FETCH, true);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            contributionsIndex = (ContributionsIndex)mapper.readValue((InputStream)inputStream, ContributionsIndex.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)inputStream);
        return contributionsIndex;
    }

    public void syncWithFilesystem() throws IOException {
        this.syncBuiltInHardware();
        this.syncLocalPackages();
    }

    private void syncBuiltInHardware() throws IOException {
        if (this.index == null) {
            return;
        }
        for (File folder : this.builtInHardwareFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
            ContributedPackage pack = this.index.findPackage(folder.getName());
            if (pack == null) continue;
            this.syncBuiltInPackageWithFilesystem(pack, folder);
            File toolsFolder = new File(this.builtInHardwareFolder, "tools");
            if (!toolsFolder.isDirectory()) continue;
            for (File toolFolder : toolsFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                File versionsFile = new File(toolFolder, "builtin_tools_versions.txt");
                if (!versionsFile.isFile()) continue;
                PreferencesMap toolsVersion = new PreferencesMap(versionsFile).subTree(pack.getName());
                for (String name : toolsVersion.keySet()) {
                    String version;
                    ContributedTool tool = this.syncToolWithFilesystem(pack, toolFolder, name, version = (String)toolsVersion.get(name));
                    if (tool == null) continue;
                    tool.setBuiltIn(true);
                }
            }
        }
    }

    private void syncBuiltInPackageWithFilesystem(ContributedPackage pack, File hardwareFolder) throws IOException {
        for (File platformFolder : hardwareFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
            File platformTxt = new File(platformFolder, "platform.txt");
            String version = (String)new PreferencesMap(platformTxt).get("version");
            ContributedPlatform p = this.syncHardwareWithFilesystem(pack, platformFolder, platformFolder.getName(), version);
            if (p == null) continue;
            p.setBuiltIn(true);
        }
    }

    private void syncLocalPackages() {
        if (!this.packagesFolder.isDirectory()) {
            return;
        }
        if (this.index == null) {
            return;
        }
        for (File folder : this.packagesFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
            ContributedPackage pack = this.index.findPackage(folder.getName());
            if (pack == null) continue;
            this.syncPackageWithFilesystem(pack, folder);
        }
    }

    private void syncPackageWithFilesystem(ContributedPackage pack, File root) {
        File toolsFolder;
        File hardwareFolder = new File(root, "hardware");
        if (hardwareFolder.isDirectory()) {
            for (File platformFolder : hardwareFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                for (File versionFolder : platformFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                    this.syncHardwareWithFilesystem(pack, versionFolder, platformFolder.getName(), versionFolder.getName());
                }
            }
        }
        if ((toolsFolder = new File(root, "tools")).isDirectory()) {
            for (File toolFolder : toolsFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                for (File versionFolder : toolFolder.listFiles(OnlyDirs.ONLY_DIRS)) {
                    this.syncToolWithFilesystem(pack, versionFolder, toolFolder.getName(), versionFolder.getName());
                }
            }
        }
    }

    private ContributedTool syncToolWithFilesystem(ContributedPackage pack, File installationFolder, String toolName, String version) {
        ContributedTool tool = pack.findTool(toolName, version);
        if (tool == null) {
            tool = pack.findResolvedTool(toolName, version);
        }
        if (tool == null) {
            return null;
        }
        DownloadableContribution contrib = tool.getDownloadableContribution(this.platform);
        if (contrib == null) {
            System.err.println(tool + " seems to have no downloadable contributions for your operating system, but it is installed in\n" + installationFolder);
            return null;
        }
        tool.setInstalled(true);
        tool.setInstalledFolder(installationFolder);
        tool.setBuiltIn(false);
        return tool;
    }

    private ContributedPlatform syncHardwareWithFilesystem(ContributedPackage pack, File installationFolder, String architecture, String version) {
        ContributedPlatform p = pack.findPlatform(architecture, version);
        if (p != null) {
            p.setInstalled(true);
            p.setBuiltIn(false);
            p.setInstalledFolder(installationFolder);
        }
        return p;
    }

    public String toString() {
        return this.index.toString();
    }

    public List<TargetPackage> createTargetPackages() {
        ArrayList<TargetPackage> packages = new ArrayList<TargetPackage>();
        if (this.index == null) {
            return packages;
        }
        for (ContributedPackage aPackage : this.index.getPackages()) {
            ContributedTargetPackage targetPackage = new ContributedTargetPackage(aPackage.getName());
            List platforms = aPackage.getPlatforms().stream().filter(p -> p.isInstalled()).collect(Collectors.toList());
            Collections.sort(platforms, ContributedPlatform.BUILTIN_AS_LAST);
            for (ContributedPlatform p2 : platforms) {
                String arch = p2.getArchitecture();
                File folder = p2.getInstalledFolder();
                try {
                    ContributedTargetPlatform targetPlatform = new ContributedTargetPlatform(arch, folder, targetPackage);
                    if (targetPackage.hasPlatform(targetPlatform)) continue;
                    targetPackage.addPlatform(targetPlatform);
                }
                catch (TargetPlatformException e) {
                    System.err.println(e.getMessage());
                }
            }
            if (!targetPackage.hasPlatforms()) continue;
            packages.add(targetPackage);
        }
        Collections.sort(packages, (package1, package2) -> {
            assert (package1.getId() != null && package2.getId() != null);
            return package1.getId().toLowerCase().compareTo(package2.getId().toLowerCase());
        });
        return packages;
    }

    public boolean isContributedToolUsed(ContributedPlatform platformToIgnore, ContributedTool tool) {
        for (ContributedPackage pack : this.index.getPackages()) {
            for (ContributedPlatform p : pack.getPlatforms()) {
                if (platformToIgnore.equals(p) || !p.isInstalled() || p.isBuiltIn()) continue;
                for (ContributedTool requiredTool : p.getResolvedTools()) {
                    if (!requiredTool.equals(tool)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Set<ContributedTool> getInstalledTools() {
        HashSet<ContributedTool> tools = new HashSet<ContributedTool>();
        if (this.index == null) {
            return tools;
        }
        for (ContributedPackage pack : this.index.getPackages()) {
            Collection platforms = pack.getPlatforms().stream().filter(p -> p.isInstalled()).collect(Collectors.toList());
            Map<String, List<ContributedPlatform>> platformsByName = platforms.stream().collect(Collectors.groupingBy(ContributedPlatform::getName));
            platformsByName.forEach((platformName, platformsWithName) -> {
                if (platformsWithName.size() > 1) {
                    platformsWithName = platformsWithName.stream().filter(p -> !p.isBuiltIn()).collect(Collectors.toList());
                }
                for (ContributedPlatform p2 : platformsWithName) {
                    tools.addAll(p2.getResolvedTools());
                }
            });
        }
        return tools;
    }

    public ContributionsIndex getIndex() {
        return this.index;
    }

    public File getPackagesFolder() {
        return this.packagesFolder;
    }

    public File getStagingFolder() {
        return this.stagingFolder;
    }

    public File getIndexFile(String name) {
        return new File(this.preferencesFolder, name);
    }

    public List<ContributedPackage> getPackages() {
        if (this.index == null) {
            return new LinkedList<ContributedPackage>();
        }
        return this.index.getPackages();
    }

    public List<String> getCategories() {
        if (this.index == null) {
            return new LinkedList<String>();
        }
        return this.index.getCategories();
    }

    public ContributedPlatform getInstalled(String packageName, String platformArch) {
        if (this.index == null) {
            return null;
        }
        return this.index.getInstalledPlatform(packageName, platformArch);
    }

    private List<ContributedPlatform> getInstalledPlatforms() {
        if (this.index == null) {
            return new LinkedList<ContributedPlatform>();
        }
        return this.index.getInstalledPlatforms();
    }

    public Optional<ContributedPlatform> getPlatformByFolder(File folder) {
        return this.getInstalledPlatforms().stream().filter(contributedPlatform -> {
            assert (contributedPlatform.getInstalledFolder() != null);
            return FileUtils.isSubDirectory(contributedPlatform.getInstalledFolder(), folder);
        }).findFirst();
    }

    public ContributedPlatform getContributedPlaform(TargetPlatform targetPlatform) {
        for (ContributedPlatform plat : this.getInstalledPlatforms()) {
            if (!plat.getInstalledFolder().equals(targetPlatform.getFolder())) continue;
            return plat;
        }
        return null;
    }
}

