/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.charts.xy;

import com.sun.tools.visualvm.charts.xy.XYTooltipPainter;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.Timer;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;

public class XYTooltipOverlay
extends ChartOverlay
implements ActionListener {
    private static final int TOOLTIP_OFFSET = 15;
    private static final int TOOLTIP_MARGIN = 10;
    private static final int TOOLTIP_RESPONSE = 50;
    private static final int ANIMATION_STEPS = 5;
    private XYTooltipPainter tooltipPainter;
    private Timer timer;
    private int currentStep;
    private Point mousePosition;
    private Point targetPosition;

    public XYTooltipOverlay(final ChartComponent chart, XYTooltipPainter tooltipPainter) {
        if (chart.getSelectionModel() == null) {
            throw new NullPointerException("No ChartSelectionModel set for " + chart);
        }
        if (!Utils.forceSpeed()) {
            this.timer = new Timer(10, this);
            this.timer.setInitialDelay(0);
        }
        this.setLayout(null);
        this.tooltipPainter = tooltipPainter;
        this.add(tooltipPainter);
        tooltipPainter.setVisible(false);
        chart.getSelectionModel().addSelectionListener(new ChartSelectionListener(){

            public void selectionModeChanged(int newMode, int oldMode) {
            }

            public void selectionBoundsChanged(Rectangle newBounds, Rectangle oldBounds) {
            }

            public void highlightedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
                XYTooltipOverlay.this.updateTooltip(chart);
            }

            public void selectedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
            }
        });
        chart.addConfigurationListener((ChartConfigurationListener)new ChartConfigurationListener.Adapter(){

            public void contentsUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY, int shiftX, int shiftY) {
                XYTooltipOverlay.this.updateTooltip(chart);
            }
        });
        chart.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                XYTooltipOverlay.this.mousePosition = e.getPoint();
                XYTooltipOverlay.this.updateTooltip(chart);
            }
        });
    }

    public final void setPosition(Point p) {
        if (this.tooltipPainter != null) {
            if (p == null) {
                if (this.tooltipPainter.isVisible()) {
                    this.tooltipPainter.setVisible(false);
                }
                if (this.timer != null) {
                    this.timer.stop();
                }
            } else if (!this.tooltipPainter.isVisible() || this.timer == null) {
                this.tooltipPainter.setVisible(true);
                this.tooltipPainter.setLocation(p);
            } else {
                this.currentStep = 0;
                this.targetPosition = p;
                this.timer.restart();
            }
        }
    }

    public final Point getPosition() {
        if (this.tooltipPainter == null) {
            return null;
        }
        return this.tooltipPainter.getLocation();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Point currentPosition = this.tooltipPainter.getLocation();
        currentPosition.x += (this.targetPosition.x - currentPosition.x) / (5 - this.currentStep);
        currentPosition.y += (this.targetPosition.y - currentPosition.y) / (5 - this.currentStep);
        this.tooltipPainter.setLocation(currentPosition);
        if (++this.currentStep == 5) {
            this.timer.stop();
        }
    }

    private void updateTooltip(ChartComponent chart) {
        XYItemSelection selection;
        if (this.mousePosition == null) {
            return;
        }
        List highlightedItems = chart.getSelectionModel().getHighlightedItems();
        XYItemSelection xYItemSelection = selection = highlightedItems.isEmpty() ? null : (XYItemSelection)highlightedItems.get(0);
        if (selection == null || selection.getItem().getValuesCount() <= selection.getValueIndex()) {
            this.setPosition(null);
        } else {
            this.tooltipPainter.update(highlightedItems);
            this.tooltipPainter.setSize(this.tooltipPainter.getPreferredSize());
            this.setPosition(highlightedItems, chart.getPaintersModel(), chart.getChartContext());
        }
    }

    private void setPosition(List<ItemSelection> selectedItems, PaintersModel paintersModel, ChartContext chartContext) {
        int tooltipX = -1;
        int tooltipY = this.mousePosition.y;
        for (ItemSelection selection : selectedItems) {
            ChartItem item = selection.getItem();
            ItemPainter painter = paintersModel.getPainter(item);
            Rectangle bounds = Utils.checkedRectangle((LongRect)painter.getSelectionBounds(selection, chartContext));
            if (tooltipX != -1) continue;
            tooltipX += bounds.x + bounds.width / 2;
        }
        this.setPosition(this.normalizePosition(new Point(tooltipX, tooltipY)));
    }

    private Point normalizePosition(Point basePoint) {
        int w = this.getWidth();
        int h = this.getHeight();
        int cw = this.tooltipPainter.getWidth();
        int ch = this.tooltipPainter.getHeight();
        basePoint.x += 15;
        if (basePoint.x + cw + 10 > w) {
            basePoint.x -= 15 + cw + 10;
        }
        if (basePoint.x < 15) {
            basePoint.x = 15;
        }
        basePoint.y -= ch + 10;
        if (basePoint.y + ch + 10 > h) {
            basePoint.y = h - ch - 10;
        }
        if (basePoint.y < 10) {
            basePoint.y = 10;
        }
        return basePoint;
    }

    public void paint(Graphics g) {
        if (this.tooltipPainter == null) {
            return;
        }
        Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            g.setClip(bounds);
        } else {
            g.setClip(clip.intersection(bounds));
        }
        super.paint(g);
    }
}

