/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.List;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.PointsComputer;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineXYPainter;

final class ContinuousXYPainter
extends TimelineXYPainter {
    private static final Polygon POLYGON = new Polygon();
    protected final int lineWidth;
    protected final Color lineColor;
    protected final Color fillColor;
    protected final Color definingColor;
    protected final Stroke lineStroke;
    private final PointsComputer computer;

    ContinuousXYPainter(float f, Color color, Color color2, double d, PointsComputer pointsComputer) {
        super((int)Math.ceil(f), color2 != null, d);
        if (color == null && color2 == null) {
            throw new IllegalArgumentException("lineColor or fillColor must not be null");
        }
        this.lineWidth = (int)Math.ceil(f);
        this.lineColor = Utils.checkedColor((Color)color);
        this.fillColor = Utils.checkedColor((Color)color2);
        this.definingColor = color != null ? color : color2;
        this.lineStroke = new BasicStroke(f, 1, 1);
        this.computer = pointsComputer;
    }

    @Override
    protected Color getDefiningColor() {
        return this.definingColor;
    }

    @Override
    protected void paint(XYItem xYItem, List<ItemSelection> list, List<ItemSelection> list2, Graphics2D graphics2D, Rectangle rectangle, SynchronousXYChartContext synchronousXYChartContext) {
        int n = xYItem.getValuesCount();
        int n2 = this.fillColor != null ? 2 : 0;
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.x -= this.lineWidth;
        rectangle2.width += this.lineWidth * 2;
        int[][] nArray = this.computer.getVisible(rectangle2, n, synchronousXYChartContext, 1, n2);
        if (nArray == null) {
            return;
        }
        int[] nArray2 = nArray[0];
        int n3 = nArray[1][0];
        int[][] nArray3 = this.computer.createPoints(nArray2, n3, xYItem, this.dataFactor, synchronousXYChartContext);
        if (this.fillColor != null) {
            nArray3[0][n3 - 2] = nArray3[0][n3 - 3];
            nArray3[1][n3 - 2] = this.computer.getZeroY(synchronousXYChartContext);
            nArray3[0][n3 - 1] = nArray3[0][0];
            nArray3[1][n3 - 1] = nArray3[1][n3 - 2];
            ContinuousXYPainter.POLYGON.xpoints = nArray3[0];
            ContinuousXYPainter.POLYGON.ypoints = nArray3[1];
            ContinuousXYPainter.POLYGON.npoints = n3;
            graphics2D.setPaint(this.fillColor);
            graphics2D.fill(POLYGON);
        }
        if (this.lineColor != null) {
            graphics2D.setPaint(this.lineColor);
            graphics2D.setStroke(this.lineStroke);
            graphics2D.drawPolyline(nArray3[0], nArray3[1], n3 - n2);
        }
    }
}

