/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.editor;

import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.queries.editor.PreferencesUIPage;
import net.sourceforge.glsof.queries.model.OtherPreferences;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;

class OtherPreferencesUIPage
implements PreferencesUIPage {
    private final OtherPreferences _page;
    private Button[] _idLogin;
    private Button[] _sizeOffset;
    private Control[] _timeout;
    private Control[] _links;
    private Button _avoid;
    private Button _ipFormat;
    private Button _nfs;
    private Button _ports;
    private Button _sockets;
    private Button _and;

    public OtherPreferencesUIPage(OtherPreferences page) {
        this._page = page;
    }

    @Override
    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout(new GridLayout());
        GridData data = new GridData(0, 1, false, true);
        composite.setLayoutData(data);
        this.getBoldLabel(composite, Messages.NLS("ID_or_Login"));
        Composite child = this.getCompositeWithGridLayout(composite, 2);
        this._idLogin = this.getRadioButtons(child, new String[]{Messages.NLS("Id_number"), Messages.NLS("Login_name")}, this._page.isIdNumber());
        this.getBoldLabel(composite, Messages.NLS("Offset_or_size"));
        child = this.getCompositeWithGridLayout(composite, 2);
        this._sizeOffset = this.getRadioButtons(child, new String[]{Messages.NLS("File_size"), Messages.NLS("File_offset")}, this._page.isSize());
        this.getBoldLabel(composite, Messages.NLS("Dangerous_kernel_s_functions"));
        child = this.getCompositeWithGridLayout(composite, 2);
        this._timeout = this.getCheckButtonAndSpinner(child, Messages.NLS("Timeout_s"), this._page.getTimeoutValue(), 2, this._page.isTimeout());
        this._avoid = this.getCheckButton(child, Messages.NLS("Avoid"), this._page.isAvoid());
        this.getBoldLabel(composite, Messages.NLS("Network_control"));
        child = this.getCompositeWithGridLayout(composite, 1);
        this._ipFormat = this.getCheckButton(child, Messages.NLS("Show_addresses_in_IP-format"), this._page.isIpFormat());
        this._nfs = this.getCheckButton(child, Messages.NLS("NFS_files"), this._page.isNfs());
        this._ports = this.getCheckButton(child, Messages.NLS("Show_port-numbers"), this._page.isPortNumbers());
        this._sockets = this.getCheckButton(child, Messages.NLS("UNIX_domain_socket_files"), this._page.isDomainSocket());
        this.getBoldLabel(composite, Messages.NLS("Directories_and_files"));
        child = this.getCompositeWithGridLayout(composite, 2);
        this._links = this.getCheckButtonAndSpinner(child, Messages.NLS("Max_number_of_links_for_a_file"), this._page.getLinksFileValue(), 1, this._page.isLinksFile());
        this.getBoldLabel(composite, Messages.NLS("Various"));
        child = this.getCompositeWithGridLayout(composite, 2);
        this._and = this.getCheckButton(child, Messages.NLS("AND_all_settings"), this._page.isAnd());
        return composite;
    }

    @Override
    public void performOk() {
        this._page.setIdNumber(this._idLogin[0].getSelection());
        this._page.setSize(this._sizeOffset[0].getSelection());
        this._page.setTimeout(((Button)this._timeout[0]).getSelection());
        this._page.setTimeoutValue(((Spinner)this._timeout[1]).getSelection());
        this._page.setAvoid(this._avoid.getSelection());
        this._page.setIpFormat(this._ipFormat.getSelection());
        this._page.setNfs(this._nfs.getSelection());
        this._page.setPortNumbers(this._ports.getSelection());
        this._page.setDomainSocket(this._sockets.getSelection());
        this._page.setLinksFile(((Button)this._links[0]).getSelection());
        this._page.setLinksFileValue(((Spinner)this._links[1]).getSelection());
        this._page.setAnd(this._and.getSelection());
    }

    private Composite getCompositeWithGridLayout(Composite parent, int columns) {
        Composite child = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 6;
        gridLayout.numColumns = columns;
        child.setLayout(gridLayout);
        return child;
    }

    private Button[] getRadioButtons(Composite composite, String[] texts, boolean state) {
        Button[] radios = new Button[texts.length];
        for (int i = 0; i < radios.length; ++i) {
            radios[i] = new Button(composite, 16);
            radios[i].setText(texts[i]);
        }
        radios[0].setSelection(state);
        radios[1].setSelection(!state);
        return radios;
    }

    private Control[] getCheckButtonAndSpinner(Composite composite, String text, int value, int min, boolean state) {
        final Control[] controls = new Control[2];
        controls[0] = this.getCheckButton(composite, text, state);
        controls[0].setLayoutData(new GridData(68));
        controls[1] = this.getSpinner(composite, value, min);
        controls[0].addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                controls[1].setEnabled(((Button)event.widget).getSelection());
            }
        });
        controls[1].setEnabled(state);
        return controls;
    }

    private Button getCheckButton(Composite composite, String text, boolean state) {
        Button button = new Button(composite, 32);
        button.setText(text);
        button.setSelection(state);
        return button;
    }

    private void getBoldLabel(Composite composite, String text) {
        Label label = new Label(composite, 0);
        Font boldedFont = this.getBoldedFont(label);
        label.setFont(boldedFont);
        boldedFont.dispose();
        label.setText(text);
    }

    private Font getBoldedFont(Label label) {
        int height = label.getFont().getFontData()[0].getHeight();
        FontData fontData = new FontData();
        fontData.setStyle(1);
        fontData.setHeight(height);
        return new Font((Device)Display.getDefault(), fontData);
    }

    private Spinner getSpinner(Composite composite, int value, int min) {
        Spinner spinner = new Spinner(composite, 2048);
        spinner.setMinimum(min);
        spinner.setMaximum(10000000);
        spinner.setIncrement(1);
        spinner.setSelection(value);
        return spinner;
    }
}

