/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.dialogs;

import net.sourceforge.glsof.common.about.AbstractButtonsDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TextInputDialog
extends AbstractButtonsDialog {
    private Table _table;
    private String[] _columnsNames;
    protected Text _text;
    private GridLayout _layout;

    public TextInputDialog(String dialogTitle, String[] columnsNames) {
        this(dialogTitle, new Point(600, 125), columnsNames);
    }

    public TextInputDialog(String dialogTitle, Point size, String[] columnsNames) {
        super(Display.getCurrent().getActiveShell(), size, dialogTitle);
        this._columnsNames = columnsNames;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this._layout = new GridLayout();
        this._layout.numColumns = 2;
        this._layout.makeColumnsEqualWidth = false;
        composite.setLayout(this._layout);
        composite.setLayoutData(new GridData(1808));
        return this.createDialogControls(composite);
    }

    protected Composite createDialogControls(Composite composite) {
        this._text = this.createTextEntry(composite, this.getColumnsNames()[0]);
        return composite;
    }

    public void setTable(Table table) {
        this._table = table;
    }

    public String[] getColumnsNames() {
        return this._columnsNames;
    }

    protected Text createTextEntry(Composite composite, String label) {
        new Label(composite, 0).setText(label);
        final Text text = new Text(composite, 2052);
        text.setLayoutData(new GridData(768));
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && text.getText().length() > 0) {
                    TextInputDialog.this.buttonPressed(1);
                }
            }
        });
        return text;
    }

    @Override
    protected void buttonPressed(int i) {
        if (i == 1 && this.areTableRowValuesFilled()) {
            new TableItem(this._table, 0).setText(this.getTableRowValues());
        }
        this.close();
    }

    protected boolean areTableRowValuesFilled() {
        for (String text : this.getTableRowValues()) {
            if (!this.isStringEmpty(text)) continue;
            return false;
        }
        return true;
    }

    protected boolean isStringEmpty(String text) {
        return text == null || text.length() == 0;
    }

    protected String[] getTableRowValues() {
        return new String[]{this._text.getText()};
    }

    protected void setNumberColumns(int n) {
        this._layout.numColumns = n;
    }
}

