/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.lsof;

import java.util.Observer;
import net.sourceforge.glsof.common.lsof.LsofErrorParser;
import net.sourceforge.glsof.common.lsof.LsofExecutor;
import net.sourceforge.glsof.common.lsof.LsofOutputParser;

public class LsofExecutorThread
implements Runnable {
    private final LsofOutputParser _lsofOutputParser;
    private final LsofErrorParser _lsofErrorParser;
    private final LsofExecutor _lsofExecutor = new LsofExecutor();
    private final String _parameters;

    public LsofExecutorThread(Observer observer, String parameters) {
        this._lsofOutputParser = new LsofOutputParser(observer);
        this._lsofErrorParser = new LsofErrorParser(observer);
        this._parameters = parameters;
    }

    @Override
    public void run() {
        this.setRunning(true);
        this._lsofExecutor.execute(this._parameters);
        this._lsofOutputParser.parse(this._lsofExecutor.getInputReader());
        this._lsofErrorParser.parse(this._lsofExecutor.getErrorReader());
        this.setRunning(false);
    }

    public void stop() {
        this._lsofExecutor.stop();
    }

    public boolean isRunning() {
        return this._lsofOutputParser.isRunning();
    }

    public void setRunning(boolean running) {
        this._lsofOutputParser.setRunning(running);
    }
}

