/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.about;

import net.sourceforge.glsof.common.about.AbstractButtonsDialog;
import net.sourceforge.glsof.common.about.TextDialog;
import net.sourceforge.glsof.common.i18n.Messages;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class AboutDialog
extends AbstractButtonsDialog {
    private static final String LICENSE_LABEL = Messages.NLS("License");
    private static final String LICENSE_FILE_PATH = "common/src/main/resources/COPYING";
    private String _imageFilePath;
    private String _description;

    public AboutDialog(Shell parent, String filePath, String description) {
        super(parent, Messages.NLS("About"));
        this._imageFilePath = filePath;
        this._description = description;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Image image = new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream(this._imageFilePath));
        Label imageLabel = new Label(parent, 0);
        image.setBackground(imageLabel.getBackground());
        imageLabel.setImage(image);
        image.dispose();
        Composite composite = this.createLabelContainer(parent);
        this.createLabel(composite, this._description);
        this.createLabel(composite, Messages.NLS("Copyright"));
        this.createLabel(composite, "email: <danielef@sourceforge.net>");
        return composite;
    }

    private Composite createLabelContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(576));
        return composite;
    }

    private void createLabel(Composite composite, String text) {
        Label label = new Label(composite, 0x1000100);
        label.setText(text);
        label.setLayoutData(new GridData(0x1000000, 0x1000000, false, false));
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1024, LICENSE_LABEL);
        this.createButton(parent, 0, Messages.NLS("Close"));
    }

    @Override
    protected void buttonPressed(int buttonId) {
        if (buttonId == 1024) {
            new TextDialog(this.getShell(), LICENSE_FILE_PATH).open();
        } else {
            this.close();
        }
    }
}

