#ifndef _EFL_INTERPOLATOR_BOUNCE_EO_H_
#define _EFL_INTERPOLATOR_BOUNCE_EO_H_

#ifndef _EFL_INTERPOLATOR_BOUNCE_EO_CLASS_TYPE
#define _EFL_INTERPOLATOR_BOUNCE_EO_CLASS_TYPE

typedef Eo Efl_Interpolator_Bounce;

#endif

#ifndef _EFL_INTERPOLATOR_BOUNCE_EO_TYPES
#define _EFL_INTERPOLATOR_BOUNCE_EO_TYPES


#endif
/** Efl bounce interpolator class
 *
 * @ingroup Efl_Interpolator_Bounce
 */
#define EFL_INTERPOLATOR_BOUNCE_CLASS efl_interpolator_bounce_class_get()

EWAPI const Efl_Class *efl_interpolator_bounce_class_get(void);

/**
 * @brief Factors property
 *
 * @param[in] obj The object.
 * @param[in] factor1 First factor of the interpolation function.
 * @param[in] factor2 Second factor of the interpolation function.
 *
 * @ingroup Efl_Interpolator_Bounce
 */
EOAPI void efl_interpolator_bounce_factors_set(Eo *obj, double factor1, double factor2);

/**
 * @brief Factors property
 *
 * @param[in] obj The object.
 * @param[out] factor1 First factor of the interpolation function.
 * @param[out] factor2 Second factor of the interpolation function.
 *
 * @ingroup Efl_Interpolator_Bounce
 */
EOAPI void efl_interpolator_bounce_factors_get(const Eo *obj, double *factor1, double *factor2);

#endif
